/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IEnvelope;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.ElementIdentity;
import com.sonicsw.mf.common.config.impl.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public final class EnvelopeElement
extends Element
implements IEnvelope,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 4;
    private HashMap m_properties = new HashMap(1, 1.0f);
    private IElement m_envelopedElement;

    @Override
    public int estimateSize() {
        return super.estimateSize() + ((Element)this.m_envelopedElement).estimateSize();
    }

    public EnvelopeElement(IElement element) {
        super(((ElementIdentity)element.getIdentity()).createClone());
        this.m_envelopedElement = element;
    }

    @Override
    public IElement getEnvelopedElement() {
        return this.m_envelopedElement;
    }

    @Override
    public String getProperty(String name) {
        return (String)this.m_properties.get(name);
    }

    @Override
    public void setProperty(String name, String value) {
        this.m_properties.put(name, value);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(4);
        s.writeObject(this.m_properties);
        s.writeObject(this.m_envelopedElement);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 4) {
            Util.throwSerialVersionMismatch(version, 4);
        }
        this.m_properties = (HashMap)s.readObject();
        this.m_envelopedElement = (IElement)s.readObject();
    }
}

