/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.jndi.mfcontext;

import com.sonicsw.jndi.mfcontext.MFContext;
import com.sonicsw.mx.jndi.MFNameParser;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.cache2k.CacheManager;
import org.cache2k.integration.CacheLoader;

public class MFCachedContext
implements Context {
    private static final long DEFAULT_EXPIRATION_TIMEOUT = 60L;
    private static final long NO_EXPIRATION = -1L;
    private MFContext delegate;
    private Cache<String, Object> cache;
    private Map<String, ?> cacheParams;
    private boolean closed;
    private static final CacheCleanupMonitor cacheCleanupMonitor = new CacheCleanupMonitor();

    public MFCachedContext(MFContext context, Map<String, ?> env) {
        this.delegate = context;
        this.cacheParams = env;
        this.setupCache();
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(MFNameParser.getInstance().convertToString(name));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Object cachedObj = this.cache.get((Object)name);
        if (!(cachedObj instanceof MFCachedContext) || !((MFCachedContext)cachedObj).closed) {
            return cachedObj;
        }
        this.cache.remove((Object)name);
        return this.cache.get((Object)name);
    }

    private void setupCache() {
        String cacheExpirationParam = (String)this.cacheParams.get("com.sonicsw.jndi.mfcontext.cacheExpirationTimeout");
        String cacheSizeParam = (String)this.cacheParams.get("com.sonicsw.jndi.mfcontext.cacheSize");
        String cacheName = (String)this.cacheParams.get("com.sonicsw.jndi.mfcontext.cacheName");
        Long expirationTimeout = cacheExpirationParam == null ? null : Long.valueOf(Long.parseLong(cacheExpirationParam));
        Long cacheSize = cacheSizeParam == null ? null : Long.valueOf(Long.parseLong(cacheSizeParam));
        Cache2kBuilder<String, Object> cache2kBuilder = this.createCacheBuilder();
        if (expirationTimeout == null) {
            cache2kBuilder.expireAfterWrite(60L, TimeUnit.MINUTES);
        } else if (-1L == expirationTimeout) {
            cache2kBuilder.eternal(true);
        } else {
            cache2kBuilder.expireAfterWrite(expirationTimeout.longValue(), TimeUnit.MINUTES);
        }
        if (cacheName != null) {
            cache2kBuilder.name(cacheName);
        }
        if (cacheSize != null) {
            cache2kBuilder.entryCapacity(cacheSize.longValue());
        }
        this.cache = cache2kBuilder.loader(this.createLoader()).build();
        cacheCleanupMonitor.monitorCache(this);
    }

    private CacheLoader<String, Object> createLoader() {
        return new JndiCacheLoader(this.delegate, this.cacheParams);
    }

    private Cache2kBuilder<String, Object> createCacheBuilder() {
        return new Cache2kBuilder<String, Object>(){};
    }

    Cache<String, Object> getCache() {
        return this.cache;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(MFNameParser.getInstance().convertToString(name), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.delegate.bind(name, obj);
        this.cache.put((Object)name, obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(MFNameParser.getInstance().convertToString(name), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.delegate.rebind(name, obj);
        this.cache.replace((Object)name, obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(MFNameParser.getInstance().convertToString(name));
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.cache.remove((Object)name);
        this.delegate.unbind(name);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(MFNameParser.getInstance().convertToString(oldName), MFNameParser.getInstance().convertToString(newName));
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.delegate.rename(oldName, newName);
        this.cache.put((Object)newName, this.cache.get((Object)oldName));
        this.cache.remove((Object)oldName);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.delegate.list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.delegate.list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.delegate.listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.delegate.listBindings(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(MFNameParser.getInstance().convertToString(name));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.cache.remove((Object)name);
        this.delegate.destroySubcontext(name);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(MFNameParser.getInstance().convertToString(name));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        Context nestedCachedContext = MFCachedContext.createNestedCachedContext((MFContext)this.delegate.createSubcontext(name), this.cacheParams);
        this.cache.put((Object)name, (Object)nestedCachedContext);
        return nestedCachedContext;
    }

    private static Context createNestedCachedContext(MFContext subcontext, Map<String, ?> params) {
        HashMap nestedContextParams = new HashMap(params);
        nestedContextParams.remove("com.sonicsw.jndi.mfcontext.cacheName");
        return new MFCachedContext(subcontext, nestedContextParams);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.delegate.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.delegate.getNameParser(name);
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.delegate.composeName(name, prefix);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.delegate.composeName(name, prefix);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.delegate.addToEnvironment(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.delegate.removeFromEnvironment(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.delegate.getEnvironment();
    }

    @Override
    public void close() throws NamingException {
        this.closed = true;
        this.cache.close();
        this.delegate.close();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.delegate.getNameInNamespace();
    }

    static {
        cacheCleanupMonitor.start();
    }

    private static class CacheCleanupMonitor
    extends Thread {
        private static final String THREAD_NAME = "CacheCleanupMonitor";
        private ReferenceQueue<MFCachedContext> referenceQueue = new ReferenceQueue();
        private Map<String, CacheWeakReference> weakReferenceMap = new HashMap<String, CacheWeakReference>();

        public CacheCleanupMonitor() {
            super(THREAD_NAME);
        }

        @Override
        public void run() {
            try {
                while (!Thread.interrupted()) {
                    CacheWeakReference gcObject = (CacheWeakReference)this.referenceQueue.remove();
                    try {
                        Cache cache = CacheManager.getInstance().getCache(gcObject.getName());
                        if (cache == null) continue;
                        cache.close();
                    }
                    finally {
                        this.weakReferenceMap.remove(gcObject.getName());
                        gcObject.clear();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void monitorCache(MFCachedContext cacheHolder) {
            this.weakReferenceMap.put(cacheHolder.getCache().getName(), new CacheWeakReference(cacheHolder, this.referenceQueue));
        }
    }

    private static class JndiCacheLoader
    extends CacheLoader<String, Object> {
        private MFContext delegate;
        private Map<String, ?> params;

        public JndiCacheLoader(MFContext delegate, Map<String, ?> params) {
            this.delegate = delegate;
            this.params = params;
        }

        public Object load(String key) throws Exception {
            Object jndiObject = this.delegate.lookup(key);
            if (jndiObject instanceof MFContext) {
                return MFCachedContext.createNestedCachedContext((MFContext)jndiObject, this.params);
            }
            return jndiObject;
        }
    }

    private static class CacheWeakReference
    extends WeakReference<MFCachedContext> {
        private String name;

        public CacheWeakReference(MFCachedContext referent, ReferenceQueue<MFCachedContext> q) {
            super(referent, q);
            this.name = referent.getCache().getName();
        }

        public String getName() {
            return this.name;
        }
    }
}

