/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.impl.Identity;
import com.sonicsw.mf.common.config.impl.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class ElementIdentity
extends Identity
implements IElementIdentity,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 3;
    private long m_version;
    private long m_creationTime;
    private String m_type;
    private String m_releaseVersion;

    ElementIdentity(long version, long creationTime, String type, String name, String releaseVersion) {
        super(name);
        this.m_version = version;
        this.m_creationTime = creationTime;
        this.m_type = type;
        this.m_releaseVersion = releaseVersion;
    }

    public ElementIdentity(String name, String type, String releaseVersion) {
        super(name);
        this.m_version = 0L;
        this.m_creationTime = 0L;
        this.m_type = type;
        this.m_releaseVersion = releaseVersion;
    }

    public ElementIdentity createClone() {
        return new ElementIdentity(this.m_version, this.m_creationTime, this.m_type, this.m_name, this.m_releaseVersion);
    }

    int estimateSize() {
        return 32 + Util.estimateSize(this.m_type) + Util.estimateSize(this.m_releaseVersion);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(3);
        s.writeLong(this.m_version);
        s.writeLong(this.m_creationTime);
        s.writeObject(this.m_type);
        s.writeObject(this.m_releaseVersion);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 3) {
            Util.throwSerialVersionMismatch(version, 3);
        }
        this.m_version = s.readLong();
        this.m_creationTime = s.readLong();
        this.m_type = (String)s.readObject();
        this.m_releaseVersion = (String)s.readObject();
    }

    public void setVersion(long version) {
        this.m_version = version;
    }

    public void setCreationTimestamp(long creationTime) {
        this.m_creationTime = creationTime;
    }

    public void setType(String type, String releaseVersion) {
        this.m_type = type;
        this.m_releaseVersion = releaseVersion;
    }

    @Override
    public long getCreationTimestamp() {
        return this.m_creationTime;
    }

    @Override
    public long getVersion() {
        return this.m_version;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public String getReleaseVersion() {
        return this.m_releaseVersion;
    }

    @Override
    public boolean equalVersion(IElementIdentity elementID) {
        return this.equalEntity(elementID) && elementID.getVersion() == this.m_version;
    }

    @Override
    public boolean equalEntity(IElementIdentity elementID) {
        return elementID.getName().equals(this.m_name) && elementID.getCreationTimestamp() == this.m_creationTime;
    }

    public String toString() {
        return "Element ID {" + this.m_type + "," + this.m_releaseVersion + "," + this.m_name + "," + this.m_version + "," + this.m_creationTime + "}";
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ElementIdentity) {
            return this.equalVersion((IElementIdentity)obj);
        }
        return false;
    }

    public int hashCode() {
        if (this.m_name == null) {
            return 0;
        }
        return this.m_name.hashCode();
    }
}

