/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.view.impl;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IAttributeSetType;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.INextVersionToken;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.view.IDeltaView;
import com.sonicsw.mf.common.view.IFolder;
import com.sonicsw.mf.common.view.ILink;
import com.sonicsw.mf.common.view.IView;
import com.sonicsw.mf.common.view.IViewElement;
import com.sonicsw.mf.common.view.ViewException;
import com.sonicsw.mf.common.view.impl.DeltaView;
import com.sonicsw.mf.common.view.impl.Folder;
import com.sonicsw.mf.common.view.impl.Link;
import com.sonicsw.mf.common.view.impl.ViewAttributesList;
import com.sonicsw.mf.common.view.impl.ViewConstants;
import com.sonicsw.mx.util.IEmptyArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public final class View
implements IView,
Serializable {
    private static final long serialVersionUID = 0L;
    private IDirElement m_viewDirElemnt = null;
    private transient IAttributeSet m_topAttributeSet = null;
    private transient Folder m_rootFolder = null;

    public View(IDirElement viewDirElmnt) {
        if (viewDirElmnt == null) {
            return;
        }
        this.m_viewDirElemnt = viewDirElmnt;
        this.m_topAttributeSet = this.m_viewDirElemnt.getAttributes();
    }

    public IDirElement getConfigElement() {
        return this.m_viewDirElemnt;
    }

    @Override
    public IView getNextVersion(INextVersionToken token) {
        return new View(((Element)this.m_viewDirElemnt).getNextVersion(token));
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(1);
        s.writeObject(this.m_viewDirElemnt);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException, ViewException {
        int version = s.readInt();
        if (version != 1) {
            throw new ViewException("Serialization version mismatch. Serialized object version: " + version + " class version: " + 1);
        }
        this.m_viewDirElemnt = (IDirElement)s.readObject();
        this.m_topAttributeSet = this.m_viewDirElemnt.getAttributes();
        this.m_rootFolder = null;
    }

    private void createRootFolder() throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        this.m_rootFolder = new Folder(this.m_topAttributeSet, this.getFolderAttributeSetType(), this.getLinkAttributeSetType(), ViewConstants.ROOT_FOLDER);
        this.setReadOnly();
    }

    @Override
    public IElementIdentity getIdentity() {
        return this.m_viewDirElemnt.getIdentity();
    }

    @Override
    public IFolder getRootFolder() {
        if (this.m_rootFolder == null) {
            try {
                this.createRootFolder();
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }
        return this.m_rootFolder;
    }

    @Override
    public boolean hasRootFolder() {
        return this.m_topAttributeSet.getAttribute(ViewConstants.ROOT_FOLDER) != null;
    }

    @Override
    public IAttributeSetType getFolderAttributeSetType() {
        return new ViewAttributesList(this.m_topAttributeSet, ViewConstants.FOLDER_ATTRIBUTESSETTYPE);
    }

    @Override
    public IAttributeSetType getLinkAttributeSetType() {
        return new ViewAttributesList(this.m_topAttributeSet, ViewConstants.LINK_ATTRIBUTESSETTYPE);
    }

    @Override
    public String[] lookupLink(String linkedObjectName) {
        ArrayList list = new ArrayList();
        IAttributeSet set = (IAttributeSet)this.m_topAttributeSet.getAttribute(ViewConstants.ROOT_FOLDER);
        this.traverseForLinks(set, list, "/", linkedObjectName);
        if (list.isEmpty()) {
            return IEmptyArray.EMPTY_STRING_ARRAY;
        }
        return list.toArray(new String[list.size()]);
    }

    protected void traverseForLinks(IAttributeSet set, ArrayList list, String fullName, String linkedObjName) {
        HashMap map = set.getAttributes();
        for (String name : map.keySet()) {
            Object obj = map.get(name);
            if (!(obj instanceof IAttributeSet)) continue;
            Integer type = (Integer)((IAttributeSet)obj).getAttribute(ViewConstants.TYPE_ATTR);
            if (type.intValue() == ViewConstants.LINK_TYPE.intValue()) {
                String linkedObject = (String)((IAttributeSet)obj).getAttribute(ViewConstants.ATTR_LINKOBJECT);
                if (linkedObject.compareTo(linkedObjName) != 0) continue;
                list.add(fullName + (String)((IAttributeSet)obj).getAttribute(ViewConstants.ORIGINAL_NAME));
                continue;
            }
            if (type.intValue() != ViewConstants.FOLDER_TYPE.intValue()) continue;
            this.traverseForLinks((IAttributeSet)obj, list, fullName + (String)((IAttributeSet)obj).getAttribute(ViewConstants.ORIGINAL_NAME) + '/', linkedObjName);
        }
    }

    @Override
    public IViewElement getElement(String name) throws ViewException, ConfigException {
        EntityName entity = new EntityName(name);
        if (entity.isRoot()) {
            return this.getRootFolder();
        }
        IAttributeSet parentSet = this.lookupForAttributeSet(entity.getParentComponents());
        IAttributeSet elementSet = (IAttributeSet)parentSet.getAttribute(entity.getBaseName().toLowerCase());
        if (elementSet == null && System.getProperty("MQ_UPGRADE", "false").equals("true")) {
            elementSet = (IAttributeSet)parentSet.getAttribute(entity.getBaseName());
        }
        if (elementSet == null) {
            throw new ViewException("Element or folder " + name + " doesn't exist.");
        }
        Integer type = (Integer)elementSet.getAttribute(ViewConstants.TYPE_ATTR);
        if (type.intValue() == ViewConstants.FOLDER_TYPE.intValue()) {
            return new Folder(parentSet, this.getFolderAttributeSetType(), this.getLinkAttributeSetType(), entity.getBaseName());
        }
        return new Link(parentSet, this.getLinkAttributeSetType(), entity.getBaseName(), (String)elementSet.getAttribute(ViewConstants.ATTR_LINKOBJECT), false);
    }

    @Override
    public void rename(String oldName, String newName) throws ViewException, ReadOnlyException, ConfigException {
        boolean useOriginalName = false;
        EntityName oldNameEntity = new EntityName(oldName);
        EntityName newNameEntity = new EntityName(newName);
        IAttributeSet setOld = this.lookupForAttributeSet(oldNameEntity.getParentComponents());
        IAttributeSet oldComponent = (IAttributeSet)setOld.getAttribute(oldNameEntity.getBaseName().toLowerCase());
        if (oldComponent == null && System.getProperty("MQ_UPGRADE", "false").equals("true")) {
            oldComponent = (IAttributeSet)setOld.getAttribute(oldNameEntity.getBaseName());
            useOriginalName = true;
        }
        IAttributeSet setNew = this.lookupForAttributeSet(newNameEntity.getParentComponents());
        String newBase = newNameEntity.getBaseName().toLowerCase();
        String oldBase = oldNameEntity.getBaseName().toLowerCase();
        IAttributeSet newComponent = setNew.createAttributeSet(newBase);
        this.buildViewElementSet(oldComponent, newComponent);
        newComponent.setStringAttribute(ViewConstants.ORIGINAL_NAME, newNameEntity.getBaseName());
        if (!useOriginalName && setNew == setOld && newBase.equals(oldBase)) {
            return;
        }
        if (useOriginalName) {
            setOld.deleteAttribute(oldNameEntity.getBaseName());
        } else {
            setOld.deleteAttribute(oldBase);
        }
    }

    private IAttributeSet lookupForAttributeSet(String[] nameParentComponents) throws ViewException {
        IAttributeSet set = (IAttributeSet)this.m_topAttributeSet.getAttribute(ViewConstants.ROOT_FOLDER);
        IAttributeSet previousSet = null;
        for (int i = 0; i < nameParentComponents.length; ++i) {
            if (set == null) {
                throw new ViewException("Folder " + nameParentComponents[i - 1] + " doesn't exist.");
            }
            previousSet = set;
            if ((set = (IAttributeSet)set.getAttribute(nameParentComponents[i].toLowerCase())) != null || !System.getProperty("MQ_UPGRADE", "false").equals("true")) continue;
            set = (IAttributeSet)previousSet.getAttribute(nameParentComponents[i]);
        }
        return set;
    }

    private void buildViewElementSet(IAttributeSet oldSet, IAttributeSet newSet) throws ReadOnlyException, ConfigException, AttributeSetTypeException {
        HashMap map = oldSet.getAttributes();
        for (String name : map.keySet()) {
            Object obj = map.get(name);
            if (obj instanceof IAttributeSet) {
                IAttributeSet set = newSet.createAttributeSet(name);
                this.buildViewElementSet((IAttributeSet)obj, set);
                continue;
            }
            if (obj instanceof IAttributeList) {
                IAttributeList list = newSet.createAttributeList(name);
                this.addListItems(((IAttributeList)obj).getItems(), list);
                continue;
            }
            if (obj instanceof Integer) {
                newSet.setIntegerAttribute(name, (Integer)obj);
                continue;
            }
            if (obj instanceof String) {
                newSet.setStringAttribute(name, (String)obj);
                continue;
            }
            if (!(obj instanceof Boolean)) continue;
            newSet.setBooleanAttribute(name, (Boolean)obj);
        }
    }

    private void addListItems(ArrayList items, IAttributeList newList) throws ReadOnlyException {
        for (int i = 0; i < items.size(); ++i) {
            newList.addStringItem((String)items.get(i));
        }
    }

    private void setReadOnly() throws ReadOnlyException {
        IAttributeList folderAttrs = (IAttributeList)this.m_topAttributeSet.getAttribute(ViewConstants.FOLDER_ATTRIBUTESSETTYPE);
        if (folderAttrs.getCount() > 0 && folderAttrs.getItem(folderAttrs.getCount() - 1) instanceof Boolean) {
            return;
        }
        folderAttrs.addBooleanItem(new Boolean(true));
        IAttributeList linkAttrs = (IAttributeList)this.m_topAttributeSet.getAttribute(ViewConstants.LINK_ATTRIBUTESSETTYPE);
        linkAttrs.addBooleanItem(new Boolean(true));
    }

    @Override
    public IDeltaView doneUpdate() throws ReadOnlyException {
        IBasicElement delta = this.m_viewDirElemnt.doneUpdate();
        if (delta == null) {
            return null;
        }
        return new DeltaView(delta);
    }

    @Override
    public boolean isDirty() {
        return this.m_viewDirElemnt.isDirty();
    }

    public static void validateFullName(String name) throws ConfigException {
        new EntityName(name);
    }

    public static boolean validateView(IDirElement viewElement) {
        if (viewElement.getIdentity().getType().compareTo("_MFview") != 0) {
            return false;
        }
        IAttributeSet top = viewElement.getAttributes();
        if (!View.isRootFolder(top)) {
            return false;
        }
        return View.validate(top.getAttributes(), top, true);
    }

    private static boolean isRootFolder(IAttributeSet top) {
        return top.getAttribute(ViewConstants.ROOT_FOLDER) != null;
    }

    private static boolean validate(Object collection, Object parent, boolean result) {
        block9: {
            Object item;
            block10: {
                if (!result) {
                    return false;
                }
                item = null;
                if (!(collection instanceof ArrayList)) break block10;
                for (int i = 0; i < ((ArrayList)collection).size(); ++i) {
                    item = ((ArrayList)collection).get(i);
                    if (!(item instanceof Long) && !(item instanceof Integer) && !(item instanceof BigDecimal) && !(item instanceof byte[]) && !(item instanceof Reference)) continue;
                    result = false;
                    break block9;
                }
                break block9;
            }
            if (!(collection instanceof HashMap)) break block9;
            Set set = ((HashMap)collection).keySet();
            for (String name : set) {
                item = ((HashMap)collection).get(name);
                if (item instanceof IAttributeList) {
                    if (name.compareTo(ViewConstants.FOLDER_ATTRIBUTESSETTYPE) == 0 || name.compareTo(ViewConstants.LINK_ATTRIBUTESSETTYPE) == 0 || name.compareTo(ViewConstants.ATTRS_VALUES) == 0) {
                        result = View.validate(((IAttributeList)item).getItems(), item, result);
                        continue;
                    }
                    result = false;
                } else {
                    if (item instanceof IAttributeSet) {
                        result = View.validate(((IAttributeSet)item).getAttributes(), item, result);
                        continue;
                    }
                    if (item instanceof Integer && name.compareTo(ViewConstants.TYPE_ATTR) != 0) {
                        result = false;
                    } else {
                        if (!(item instanceof Long) && !(item instanceof Boolean) && !(item instanceof BigDecimal) && !(item instanceof byte[]) && !(item instanceof Reference)) continue;
                        result = false;
                    }
                }
                break;
            }
        }
        return result;
    }

    @Override
    public void link(String name, String linkedObjectName, boolean complex) throws ConfigException, ViewException {
        EntityName nameE = new EntityName(name);
        if (nameE.isRoot()) {
            throw new ViewException("Cannot create link to the root");
        }
        IFolder parentFolder = this.getParentFolder(nameE);
        if (parentFolder == null) {
            if (complex) {
                throw new ViewException("Nested complexs configurations are not supported.");
            }
            return;
        }
        parentFolder.link(nameE.getBaseName(), linkedObjectName, complex);
    }

    @Override
    public void delete(String name) throws ConfigException, ViewException {
        EntityName nameE = new EntityName(name);
        if (nameE.isRoot()) {
            throw new ViewException("Cannot delete the root");
        }
        IFolder parentFolder = this.getParentFolder(nameE);
        if (parentFolder == null) {
            return;
        }
        IViewElement viewElement = parentFolder.getViewElement(nameE.getBaseName());
        if (viewElement == null) {
            throw new ViewException(nameE.getName() + " does not exist.");
        }
        ((Folder)parentFolder).deleteViewElement(nameE.getBaseName());
    }

    @Override
    public void createFolder(String path) throws ViewException, ReadOnlyException, ConfigException {
        EntityName pathE = new EntityName(path);
        if (pathE.isRoot()) {
            throw new ViewException("Cannot delete the root");
        }
        IFolder parentFolder = this.getParentFolder(pathE);
        if (parentFolder == null) {
            return;
        }
        parentFolder.createFolder(pathE.getBaseName());
    }

    private IFolder getParentFolder(EntityName nameE) throws ConfigException, ViewException {
        IFolder parentFolder = this.getRootFolder();
        String[] nameComponents = nameE.getNameComponents();
        for (int i = 0; i < nameComponents.length - 1; ++i) {
            IViewElement viewElement = parentFolder.getViewElement(nameComponents[i]);
            if (viewElement == null) {
                throw new ViewException(nameE.getParent() + " does not exist.");
            }
            if (viewElement instanceof ILink && ((ILink)viewElement).isComplex()) {
                return null;
            }
            if (!(viewElement instanceof IFolder)) {
                throw new ViewException(nameE.getParent() + " is not a folder.");
            }
            parentFolder = (IFolder)viewElement;
        }
        return parentFolder;
    }

    @Override
    public String[] list(String folderPath) throws ViewException, ConfigException {
        IFolder folder = null;
        folder = new EntityName(folderPath).isRoot() ? this.getRootFolder() : (IFolder)this.getElement(folderPath);
        return folder.list();
    }
}

