/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.mgmtapi.config.impl;

import com.sonicsw.ma.mgmtapi.config.AttributeNotFoundException;
import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtListBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtSubBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtAttributeMetaData;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IAttributeMetaData;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPath;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class MgmtBeanBase
implements IMgmtBeanBase,
Cloneable {
    private MgmtBeanFactory m_factory;
    private IConfigBean m_bean;

    public MgmtBeanBase(MgmtBeanFactory factory) {
        this.m_factory = factory;
        this.m_bean = null;
    }

    public void loadBean(String viewPath) throws MgmtException {
        this.loadBean(viewPath, null);
    }

    public void loadBean(String viewPath, String type) throws MgmtException {
        try {
            this.m_bean = (IConfigBean)this.m_factory.getConfigServer().loadConfigElement(viewPath);
            this.m_factory.checkBeanVersion(this.getClass(), this.m_bean.getConfigType().getVersion());
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to load configuration for " + viewPath + " - " + e.getMessage(), e);
        }
        if (this.m_bean == null) {
            throw new MgmtException("Configuration not found for " + viewPath);
        }
        if (type != null && !this.m_bean.getConfigType().getName().equals(type)) {
            throw new MgmtException("Loaded configuration '" + viewPath + "' is not of the right type '" + this.m_bean.getConfigType().getName() + "'" + " - was expecting '" + type + "'");
        }
    }

    void setBean(IConfigBean bean) {
        this.m_bean = bean;
    }

    protected void createFolderElement() throws MgmtException {
        try {
            String path = this.m_bean.getName();
            path = path.substring(0, path.lastIndexOf("/"));
            this.m_factory.createFolder(path);
            this.m_factory.setFolderMetaAttributes(path, this.m_bean.getMetaAttributes());
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to create folder element - " + e.getMessage(), e);
        }
    }

    protected void setFolderElementAttributes() throws MgmtException {
        try {
            String path = this.m_bean.getName();
            path = path.substring(0, path.lastIndexOf("/"));
            HashMap map = this.m_bean.getMetaAttributes();
            if (map != null) {
                this.m_factory.setFolderMetaAttributes(path, map);
            }
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to set folder element attributes- " + e.getMessage(), e);
        }
    }

    public void createBean(String viewPath, String type, String cVersion, String pVersion) throws MgmtException {
        this.createBean(viewPath, type, cVersion, pVersion, true);
    }

    public void createBean(String viewPath, String type, String cVersion, String pVersion, boolean setAttributes) throws MgmtException {
        try {
            this.m_bean = this.m_factory.getConfigServer().createConfigBean(viewPath, type, cVersion, false);
            if (setAttributes) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("TYPE", type);
                map.put("CONFIG_VERSION", cVersion);
                map.put("PRODUCT_VERSION", pVersion);
                this.m_bean.setMetaAttributes(map);
            }
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to create configuration for " + viewPath + " - " + e.getMessage(), e);
        }
    }

    private final List getDeleteBeanList() throws MgmtException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.m_bean.getName());
        return list;
    }

    protected void deleteBean() throws Exception {
        this.m_factory.getConfigServer().removeConfigElement(this.m_bean.getName());
    }

    protected void saveBean() throws Exception {
        this.m_factory.getConfigServer().storeConfigElement((IConfigElement)this.m_bean);
    }

    @Override
    public IAttributeMap getAttributeMap() {
        return null;
    }

    @Override
    public IAttributeList getAttributeList() {
        return null;
    }

    @Override
    public IConfigBean getConfigBean() {
        return this.m_bean;
    }

    @Override
    public String getConfigBeanName() {
        if (this.m_bean != null) {
            return this.m_bean.getName();
        }
        return null;
    }

    @Override
    public String getConfigBeanNameTail() {
        String name = this.getConfigBeanName();
        int index = name.lastIndexOf(47);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1);
    }

    public String getConfigBeanNamePrefix() {
        String name = this.getConfigBeanName();
        int index = name.lastIndexOf(47);
        if (index == -1) {
            return "/";
        }
        return name.substring(0, index);
    }

    @Override
    public IConfigPath getConfigPath() {
        return null;
    }

    @Override
    public IConfigPath getConfigPath(String name) {
        return ConfigFactory.createConfigPath((String)name);
    }

    @Override
    public IMgmtBase getParent() {
        return null;
    }

    @Override
    public MgmtBeanFactory getMgmtBeanFactory() {
        return this.m_factory;
    }

    @Override
    public boolean isNewBean() {
        return this.m_bean.isNew();
    }

    @Override
    public void removeAttribute(String name) throws MgmtException {
        try {
            this.m_bean.removeAttribute(this.getConfigPath(name));
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to remove attribute " + name + " - " + e.getMessage(), e);
        }
    }

    public Object getAttribute(String name) throws MgmtException {
        try {
            Object ret = this.m_bean.getAttribute(this.getConfigPath(name));
            if (ret instanceof IConfigBean) {
                ret = this.getMgmtBeanFactory().createBeanObject((IConfigBean)ret);
            }
            return ret;
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to get attribute " + name + " - " + e.getMessage(), e);
        }
    }

    public void setAttribute(String name, Object val) throws MgmtException {
        try {
            if (val != null) {
                this.m_bean.setAttribute(this.getConfigPath(name), val);
            } else {
                this.m_bean.removeAttribute(this.getConfigPath(name));
            }
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to set attribute " + name + " - " + e.getMessage(), e);
        }
    }

    @Override
    public void setAttribute(String name, IMgmtBase val) throws MgmtException {
        if (val == null) {
            this.setAttribute(name, (Object)val);
            return;
        }
        IConfigBean realVal = null;
        if (val instanceof IMgmtBeanBase) {
            realVal = ((IMgmtBeanBase)val).getConfigBean();
        } else if (val instanceof IMgmtListBase) {
            realVal = val.getAttributeList();
        } else if (val instanceof IMgmtSubBeanBase) {
            realVal = val.getAttributeMap();
        }
        if (realVal == null) {
            throw new MgmtException("Cannot setAttribute. Value does not contain a valid list or map");
        }
        this.setAttribute(name, realVal);
    }

    @Override
    public String getStringAttribute(String name) throws MgmtException {
        Object obj = this.getAttribute(name);
        if (obj == null) {
            throw new AttributeNotFoundException("String attribute " + name + " is not defined");
        }
        if (!(obj instanceof String)) {
            throw new AttributeNotFoundException("Attribute " + name + " is of type String");
        }
        return (String)obj;
    }

    @Override
    public void setStringAttribute(String name, String val) throws MgmtException {
        this.setAttribute(name, val);
    }

    @Override
    public boolean getBooleanAttribute(String name) throws MgmtException {
        Object obj = this.getAttribute(name);
        if (obj == null) {
            throw new AttributeNotFoundException("Boolean attribute " + name + " is not defined");
        }
        if (!(obj instanceof Boolean)) {
            throw new AttributeNotFoundException("Attribute " + name + " is of type Boolean");
        }
        return (Boolean)obj;
    }

    @Override
    public void setBooleanAttribute(String name, boolean val) throws MgmtException {
        this.setAttribute(name, new Boolean(val));
    }

    @Override
    public int getIntegerAttribute(String name) throws MgmtException {
        Object obj = this.getAttribute(name);
        if (obj == null) {
            throw new AttributeNotFoundException("Integer attribute " + name + " is not defined");
        }
        if (!(obj instanceof Integer)) {
            throw new AttributeNotFoundException("Attribute " + name + " is of type Integer");
        }
        return (Integer)obj;
    }

    @Override
    public void setIntegerAttribute(String name, int val) throws MgmtException {
        this.setAttribute(name, new Integer(val));
    }

    @Override
    public long getLongAttribute(String name) throws MgmtException {
        Object obj = this.getAttribute(name);
        if (obj == null) {
            throw new AttributeNotFoundException("Long attribute " + name + " is not defined");
        }
        if (!(obj instanceof Long)) {
            throw new AttributeNotFoundException("Attribute " + name + " is of type Long");
        }
        return (Long)obj;
    }

    @Override
    public void setLongAttribute(String name, long val) throws MgmtException {
        this.setAttribute(name, new Long(val));
    }

    @Override
    public byte[] getByteArrayAttribute(String name) throws MgmtException {
        Object obj = this.getAttribute(name);
        if (obj == null) {
            throw new AttributeNotFoundException("Byte[] attribute " + name + " is not defined");
        }
        if (!(obj instanceof byte[])) {
            throw new AttributeNotFoundException("Attribute " + name + " is of type byte[]");
        }
        return (byte[])obj;
    }

    @Override
    public void setByteArrayAttribute(String name, byte[] val) throws MgmtException {
        this.setAttribute(name, val);
    }

    @Override
    public BigDecimal getBigDecimalAttribute(String name) throws MgmtException {
        Object obj = this.getAttribute(name);
        if (obj == null) {
            throw new AttributeNotFoundException("BigDecimal attribute " + name + " is not defined");
        }
        if (!(obj instanceof BigDecimal)) {
            throw new AttributeNotFoundException("Attribute " + name + " is of type BigDecimal");
        }
        return (BigDecimal)obj;
    }

    @Override
    public void setBigDecimalAttribute(String name, BigDecimal val) throws MgmtException {
        this.setAttribute(name, val);
    }

    @Override
    public IMgmtBeanBase getReferenceAttribute(String name) throws MgmtException {
        Object obj = this.getAttribute(name);
        if (obj == null) {
            throw new AttributeNotFoundException("Reference attribute " + name + " is not defined.");
        }
        if (!(obj instanceof IMgmtBeanBase)) {
            throw new AttributeNotFoundException("Attribute " + name + " is of type Reference");
        }
        return (IMgmtBeanBase)obj;
    }

    @Override
    public void setReferenceAttribute(String name, IMgmtBeanBase val) throws MgmtException {
        this.setAttribute(name, val);
    }

    @Override
    public IMgmtAttributeMetaData getAttributeMetaData(String name) throws MgmtException {
        try {
            IAttributeMetaData ret = this.m_bean.getAttributeMetaData(this.getConfigPath(name));
            return new MgmtAttributeMetaData(ret);
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to get attribute metadata " + name + " - " + e.getMessage(), e);
        }
    }

    protected List getReferencedBeanList(List list, IAttributeMap data) {
        Iterator iter = data.keySet().iterator();
        while (iter.hasNext()) {
            String name;
            Object obj = data.get((Object)((String)iter.next()));
            if (obj instanceof IConfigBean && !list.contains(name = ((IConfigBean)obj).getName())) {
                list.add(name);
            }
            if (obj instanceof IAttributeMap) {
                this.getReferencedBeanList(list, (IAttributeMap)obj);
                continue;
            }
            if (!(obj instanceof IAttributeList)) continue;
            this.getReferencedBeanList(list, (IAttributeList)obj);
        }
        return list;
    }

    protected List getReferencedBeanList(List list, IAttributeList data) {
        for (Object obj : data) {
            String name;
            if (obj instanceof IConfigBean && !list.contains(name = ((IConfigBean)obj).getName())) {
                list.add(name);
            }
            if (obj instanceof IAttributeMap) {
                this.getReferencedBeanList(list, (IAttributeMap)obj);
                continue;
            }
            if (!(obj instanceof IAttributeList)) continue;
            this.getReferencedBeanList(list, (IAttributeList)obj);
        }
        return list;
    }

    protected String getNextName(String path, String originalName, String prefix) {
        try {
            String candidate;
            List names = this.getMgmtBeanFactory().list(path);
            HashMap<String, String> tempMap = new HashMap<String, String>();
            for (String fsPath : names) {
                String name = fsPath.substring(fsPath.lastIndexOf(47) + 1);
                tempMap.put(name, name);
            }
            String string = candidate = prefix == null ? originalName : prefix + " of " + originalName;
            if (!tempMap.containsKey(candidate)) {
                return candidate;
            }
            int i = 2;
            while (true) {
                String string2 = candidate = prefix == null ? originalName + "_" + (i - 1) : prefix + "(" + i + ") of " + originalName;
                if (!tempMap.containsKey(candidate)) {
                    return candidate;
                }
                ++i;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String createUniqueName() {
        return ConfigFactory.createGUID();
    }

    protected String createUniqueName(String name, boolean appendDefault) {
        String result = new String(name + "/" + ConfigFactory.createGUID());
        if (appendDefault) {
            result = result + "/" + "_Default";
        }
        return result;
    }

    protected String createUniqueName(boolean appendDefault) {
        return this.createUniqueName(this.getConfigBeanNamePrefix(), appendDefault);
    }

    protected Object clone() throws CloneNotSupportedException {
        return (MgmtBeanBase)super.clone();
    }

    @Override
    public IMgmtBeanBase clone(String viewName) throws MgmtException {
        MgmtBeanBase newBean = null;
        try {
            String name;
            String path;
            newBean = (MgmtBeanBase)this.clone();
            String string = path = viewName == null ? this.getConfigBean().getName() : viewName;
            if (path.endsWith("_Default")) {
                path = path.substring(0, path.lastIndexOf(47));
            }
            int index = path.lastIndexOf(47);
            String string2 = name = viewName == null ? this.getNextName(path.substring(0, index), path.substring(index + 1), "Copy") : path.substring(index + 1);
            if (viewName != null) {
                try {
                    this.m_factory.createFolder(path.substring(0, index + 1));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            path = path.substring(0, index + 1) + name;
            IConfigBean cloneBean = (IConfigBean)this.getConfigBean().clone();
            cloneBean.setName(path);
            cloneBean.setMetaAttributes(this.m_bean.getMetaAttributes());
            newBean.setBean(cloneBean);
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to clone bean - " + e.toString(), e);
        }
        return newBean;
    }

    @Override
    public Object getProperty(Object propertyId) {
        return this.m_factory.lookupValue(this.getConfigBean(), propertyId);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" (");
        sb.append(", cV").append((String)this.getProperty("_C_VERSION"));
        sb.append(", pV").append((String)this.getProperty("_P_VERSION"));
        sb.append(", ").append(this.getConfigBean().getName());
        sb.append(")");
        return sb.toString();
    }

    public void setAnnotation(String value) {
        if (this.m_bean == null) {
            return;
        }
        this.m_bean.setAnnotation(value);
    }

    public String getAnnotation() {
        if (this.m_bean == null) {
            return null;
        }
        return this.m_bean.getAnnotation();
    }
}

