/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromDirectory;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.upgrade.IMigrationProcess;
import com.sonicsw.mf.common.config.upgrade.IVersionedDomainManagerUpgrade;
import com.sonicsw.mf.common.config.upgrade.UpgradeEnv;
import com.sonicsw.mf.common.config.upgrade.UpgradeRegistry;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import java.util.HashMap;
import java.util.Set;

public class DomainManager
implements IMigrationProcess {
    UpgradeEnv m_upgradeEnv;

    public String upgrade(UpgradeEnv env) throws Exception {
        this.m_upgradeEnv = env;
        this.performVersionedUpgrade((String)env.getProp("ds.release.version"));
        this.fixDomainPoliciesAndCollections();
        this.fix_MFLibrary();
        this.upgradeDomainElement();
        return null;
    }

    public void preConnectUpgrade(UpgradeEnv env) throws Exception {
        this.m_upgradeEnv = env;
        this.performVersionedPreConnectUpgrade((String)env.getProp("ds.release.version"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fixDomainPoliciesAndCollections() throws Exception {
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("ConfigUpgrade.fixDomainPoliciesAndCollections");
        }
        this.m_upgradeEnv.m_curTransaction = this.m_upgradeEnv.dsFileSystem.createTransaction();
        try {
            String storageName;
            String nameStripped;
            String elementName;
            Query query = new Query();
            From typeFrom = new FromElementType("MF_AUTHENTICATION_DOMAIN");
            query.setFrom(typeFrom);
            IDirElement[] els = this.m_upgradeEnv.dsFileSystem.getFSElements(query, false);
            for (int domainIndex = 0; domainIndex < els.length; ++domainIndex) {
                elementName = els[domainIndex].getIdentity().getName();
                if (this.m_upgradeEnv.isDEBUG()) {
                    System.out.println("ConfigUpgrade.fixDomain...., domain logical name == " + elementName);
                }
                nameStripped = elementName.substring(0, elementName.lastIndexOf("/"));
                this.m_upgradeEnv.getUtils().fixProductAndReleaseVersion(nameStripped, "/_MFDomainDescriptor");
                try {
                    this.m_upgradeEnv.dsAdmin.setElementReleaseVersion(this.m_upgradeEnv.dsFileSystem.logicalToStorage(nameStripped) + "/_MFRefreshTime", "107");
                }
                catch (Exception e) {
                    // empty catch block
                }
                storageName = this.m_upgradeEnv.dsFileSystem.logicalToStorage(elementName);
                String usersDirectory = storageName.substring(0, storageName.lastIndexOf("/") + 1) + "_MFUsers";
                query = new Query();
                typeFrom = new FromDirectory(usersDirectory);
                query.setFrom(typeFrom);
                IDirElement[] users = this.m_upgradeEnv.dsAdmin.getElements(query, false);
                for (int usersIndex = 0; usersIndex < users.length; ++usersIndex) {
                    this.m_upgradeEnv.dsAdmin.setElementReleaseVersion(users[usersIndex].getIdentity().getName(), "107");
                }
                String groupsDirectory = storageName.substring(0, storageName.lastIndexOf("/") + 1) + "_MFGroups";
                query = new Query();
                typeFrom = new FromDirectory(groupsDirectory);
                query.setFrom(typeFrom);
                IDirElement[] groups = this.m_upgradeEnv.dsAdmin.getElements(query, false);
                for (int groupIndex = 0; groupIndex < groups.length; ++groupIndex) {
                    this.m_upgradeEnv.dsAdmin.setElementReleaseVersion(groups[groupIndex].getIdentity().getName(), "107");
                }
            }
            typeFrom = new FromElementType("MQ_AUTHORIZATION_POLICY");
            query.setFrom(typeFrom);
            els = this.m_upgradeEnv.dsFileSystem.getFSElements(query, false);
            for (int policyIndex = 0; policyIndex < els.length; ++policyIndex) {
                elementName = els[policyIndex].getIdentity().getName();
                nameStripped = elementName.substring(0, elementName.lastIndexOf(47));
                this.m_upgradeEnv.getUtils().fixProductAndReleaseVersion(nameStripped, "/_MQPolicyDescriptor");
                storageName = this.m_upgradeEnv.dsFileSystem.logicalToStorage(elementName);
                String aclsDirectory = storageName.substring(0, storageName.lastIndexOf("/") + 1) + "_MQACLs";
                query = new Query();
                typeFrom = new FromDirectory(aclsDirectory);
                query.setFrom(typeFrom);
                IDirElement[] acls = this.m_upgradeEnv.dsAdmin.getElements(query, false);
                for (int aclsIndex = 0; aclsIndex < acls.length; ++aclsIndex) {
                    this.m_upgradeEnv.dsAdmin.setElementReleaseVersion(acls[aclsIndex].getIdentity().getName(), "107");
                }
                String qopsDirectory = storageName.substring(0, storageName.lastIndexOf("/") + 1) + "_MQQoPs";
                query = new Query();
                typeFrom = new FromDirectory(qopsDirectory);
                query.setFrom(typeFrom);
                IDirElement[] qops = this.m_upgradeEnv.dsAdmin.getElements(query, false);
                for (int qopsIndex = 0; qopsIndex < qops.length; ++qopsIndex) {
                    this.m_upgradeEnv.dsAdmin.setElementReleaseVersion(qops[qopsIndex].getIdentity().getName(), "107");
                }
            }
            typeFrom = new FromElementType("MF_AUTHENTICATION_SPI");
            query.setFrom(typeFrom);
            try {
                els = this.m_upgradeEnv.dsFileSystem.getFSElements(query, false);
                for (int spiIndex = 0; spiIndex < els.length; ++spiIndex) {
                    this.m_upgradeEnv.getUtils().fixProductAndReleaseVersion(els[spiIndex].getIdentity().getName());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            typeFrom = new FromElementType("MF_MANAGEMENT_SPI");
            query.setFrom(typeFrom);
            try {
                els = this.m_upgradeEnv.dsFileSystem.getFSElements(query, false);
                for (int spiIndex = 0; spiIndex < els.length; ++spiIndex) {
                    this.m_upgradeEnv.getUtils().fixProductAndReleaseVersion(els[spiIndex].getIdentity().getName());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            typeFrom = new FromElementType("MF_CONTAINER_COLLECTION");
            query.setFrom(typeFrom);
            els = this.m_upgradeEnv.dsFileSystem.getFSElements(query, false);
            for (int containerIndex = 0; containerIndex < els.length; ++containerIndex) {
                this.m_upgradeEnv.getUtils().fixProductAndReleaseVersion(els[containerIndex].getIdentity().getName());
            }
            typeFrom = new FromElementType("MF_COMPONENT_COLLECTION");
            query.setFrom(typeFrom);
            els = this.m_upgradeEnv.dsFileSystem.getFSElements(query, false);
            for (int componentIndex = 0; componentIndex < els.length; ++componentIndex) {
                this.m_upgradeEnv.getUtils().fixProductAndReleaseVersion(els[componentIndex].getIdentity().getName());
            }
            if (this.m_upgradeEnv.isDEBUG()) {
                System.out.println("ConfigUpgrade.fixDomainPoliciesAndCollections committing transaction");
            }
            this.m_upgradeEnv.dsFileSystem.executeTransaction(this.m_upgradeEnv.m_curTransaction);
        }
        finally {
            if (this.m_upgradeEnv.isDEBUG()) {
                System.out.println("ConfigUpgrade.fixDomainPoliciesAndCollections setting m_curTransaction to null");
            }
            this.m_upgradeEnv.m_curTransaction = null;
        }
    }

    private void fix_MFLibrary() throws ConfigException, VersionOutofSyncException, DirectoryServiceException {
        String releaseVersion;
        String versionNoDots;
        String releaseVersion2;
        String versionNoDots2;
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("DomainManager.fix_MFLibary");
        }
        IDirElement mqValidator = ElementFactory.createElement("/_MFLibrary/validators/MQ_100_10.0", "MF_VALIDATOR", "100");
        IAttributeSet topSet = mqValidator.getAttributes();
        topSet.setStringAttribute("VALIDATION_CLASS", "com.sonicsw.mq.dstriggers.DeleteTrigger");
        topSet.setStringAttribute("RELEASE_VERSION", "107");
        IAttributeList archives = topSet.createAttributeList("VALIDATOR_ARCHIVES");
        archives.addStringItem("sonicfs:///System/DS/validators/MQ/10.0/MQtriggers.jar");
        this.m_upgradeEnv.dsAdmin.setElement(mqValidator.doneUpdate(), null);
        IDirElement mfValidator = ElementFactory.createElement("/_MFLibrary/validators/MF_100_3.1", "MF_VALIDATOR", "100");
        topSet = mfValidator.getAttributes();
        topSet.setStringAttribute("VALIDATION_CLASS", "com.sonicsw.mf.dstriggers.DeleteTrigger");
        topSet.setStringAttribute("RELEASE_VERSION", "107");
        archives = topSet.createAttributeList("VALIDATOR_ARCHIVES");
        archives.addStringItem("sonicfs:///System/DS/validators/MF/10.0/MFtriggers.jar");
        this.m_upgradeEnv.dsAdmin.setElement(mfValidator.doneUpdate(), null);
        Set deleteProductVersions = PRODUCT_VERSIONS_SUPPORTED_BY_EARLIEST_UPGRADE_VERSION.keySet();
        for (String version : deleteProductVersions) {
            versionNoDots2 = this.getVersionWithNoDots(version);
            releaseVersion2 = (String)PRODUCT_VERSIONS_SUPPORTED_BY_EARLIEST_UPGRADE_VERSION.get(version);
            this.m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/plugins/MQ_ROOT_" + releaseVersion2 + "_" + versionNoDots2, null);
            IDirElement mqFileElement = this.m_upgradeEnv.dsFileSystem.getFSElement("/System/SMC/Plugins/pluginMQ" + versionNoDots2 + ".jar", true);
            if (mqFileElement != null) {
                this.m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)mqFileElement.doneUpdate());
                this.m_upgradeEnv.dsFileSystem.deleteFSElement("/System/SMC/Plugins/pluginMQ" + versionNoDots2 + ".jar");
            }
            this.m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/validators/MF_100_" + version, null);
        }
        for (String version : SUPPORTED_PRODUCT_VERSIONS.keySet()) {
            versionNoDots2 = this.getVersionWithNoDots(version);
            releaseVersion2 = (String)SUPPORTED_PRODUCT_VERSIONS.get(version);
            IDirElement plugin = this.m_upgradeEnv.dsAdmin.getElement("/_MFLibrary/plugins/MQ_ROOT_" + releaseVersion2 + "_" + versionNoDots2, false);
            if (plugin != null) continue;
            plugin = ElementFactory.createElement("/_MFLibrary/plugins/MQ_ROOT_" + releaseVersion2 + "_" + versionNoDots2.replace("_", ""), "MF_PLUGIN", "100");
            topSet = plugin.getAttributes();
            topSet.setStringAttribute("CONFIG_PLUGIN_FACTORY_CLASS", "com.sonicsw.mq.gui.config.MQPluginFactory");
            topSet.setStringAttribute("RUNTIME_PLUGIN_FACTORY_CLASS", "com.sonicsw.mq.gui.runtime.MQPluginFactory");
            topSet.setStringAttribute("PLUGIN_FACTORY_CLASSPATH", "sonicfs:///System/SMC/Plugins/pluginMQ" + versionNoDots2 + ".jar");
            this.createMQPluginAttributes(topSet);
            this.m_upgradeEnv.dsAdmin.setElement(plugin.doneUpdate(), null);
        }
        String currentVersionNoDots = this.getVersionWithNoDots("10.0");
        IDirElement plugin = ElementFactory.createElement("/_MFLibrary/plugins/MQ_ROOT_107_" + currentVersionNoDots.replace("_", ""), "MF_PLUGIN", "100");
        topSet = plugin.getAttributes();
        topSet.setStringAttribute("CONFIG_PLUGIN_FACTORY_CLASS", "com.sonicsw.mq.gui.config.MQPluginFactory");
        topSet.setStringAttribute("RUNTIME_PLUGIN_FACTORY_CLASS", "com.sonicsw.mq.gui.runtime.MQPluginFactory");
        topSet.setStringAttribute("PLUGIN_FACTORY_CLASSPATH", "sonicfs:///System/SMC/Plugins/pluginMQ" + currentVersionNoDots + ".jar");
        this.createMQPluginAttributes(topSet);
        this.m_upgradeEnv.dsAdmin.setElement(plugin.doneUpdate(), null);
        Set MFDeleteProductVersions = MF_PRODUCT_VERSIONS_SUPPORTED_BY_EARLIEST_UPGRADE_VERSION.keySet();
        for (String version : MFDeleteProductVersions) {
            versionNoDots = this.getVersionWithNoDots(version);
            releaseVersion = (String)MF_PRODUCT_VERSIONS_SUPPORTED_BY_EARLIEST_UPGRADE_VERSION.get(version);
            this.m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/plugins/MF_ROOT_" + releaseVersion + "_" + versionNoDots, null);
            IDirElement mfFileElement = this.m_upgradeEnv.dsFileSystem.getFSElement("/System/SMC/Plugins/pluginMF" + versionNoDots + ".jar", true);
            if (mfFileElement != null) {
                this.m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)mfFileElement.doneUpdate());
                this.m_upgradeEnv.dsFileSystem.deleteFSElement("/System/SMC/Plugins/pluginMF" + versionNoDots + ".jar");
            }
            this.m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/validators/MQ_100_" + version, null);
        }
        for (String version : SUPPORTED_PRODUCT_VERSIONS.keySet()) {
            versionNoDots = this.getVersionWithNoDots(version);
            releaseVersion = (String)SUPPORTED_PRODUCT_VERSIONS.get(version);
            IDirElement MFPlugin = this.m_upgradeEnv.dsAdmin.getElement("/_MFLibrary/plugins/MF_ROOT_" + releaseVersion + "_" + versionNoDots, false);
            if (plugin != null) continue;
            plugin = ElementFactory.createElement("/_MFLibrary/plugins/MF_ROOT_" + releaseVersion + "_" + versionNoDots.replace("_", ""), "MF_PLUGIN", "100");
            topSet = plugin.getAttributes();
            topSet.setStringAttribute("CONFIG_PLUGIN_FACTORY_CLASS", "com.sonicsw.mf.gui.config.MFPluginFactory");
            topSet.setStringAttribute("RUNTIME_PLUGIN_FACTORY_CLASS", "com.sonicsw.mf.gui.runtime.MFPluginFactory");
            topSet.setStringAttribute("PLUGIN_FACTORY_CLASSPATH", "sonicfs:///System/SMC/Plugins/pluginMF" + versionNoDots + ".jar");
            this.m_upgradeEnv.dsAdmin.setElement(plugin.doneUpdate(), null);
        }
        plugin = ElementFactory.createElement("/_MFLibrary/plugins/MF_ROOT_107_" + currentVersionNoDots.replace("_", ""), "MF_PLUGIN", "100");
        topSet = plugin.getAttributes();
        topSet.setStringAttribute("CONFIG_PLUGIN_FACTORY_CLASS", "com.sonicsw.mf.gui.config.MFPluginFactory");
        topSet.setStringAttribute("RUNTIME_PLUGIN_FACTORY_CLASS", "com.sonicsw.mf.gui.runtime.MFPluginFactory");
        topSet.setStringAttribute("PLUGIN_FACTORY_CLASSPATH", "sonicfs:///System/SMC/Plugins/pluginMF" + currentVersionNoDots + ".jar");
        this.m_upgradeEnv.dsAdmin.setElement(plugin.doneUpdate(), null);
        IDirElement secFileElement = null;
        HashMap MADeleteVersions = new HashMap(MF_PRODUCT_VERSIONS_SUPPORTED_BY_EARLIEST_UPGRADE_VERSION);
        MADeleteVersions.putAll(SUPPORTED_PRODUCT_VERSIONS);
        for (String version : MADeleteVersions.keySet()) {
            String versionNoDots3 = this.getVersionWithNoDots(version);
            String releaseVersion3 = (String)MADeleteVersions.get(version);
            this.m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/plugins/SECURITY_ROOT_" + releaseVersion3 + "_" + versionNoDots3, null);
            secFileElement = this.m_upgradeEnv.dsFileSystem.getFSElement("/System/SMC/Plugins/pluginSecurity" + versionNoDots3 + ".jar", true);
            if (secFileElement == null) continue;
            this.m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)secFileElement.doneUpdate());
            this.m_upgradeEnv.dsFileSystem.deleteFSElement("/System/SMC/Plugins/pluginSecurity" + versionNoDots3 + ".jar");
        }
        plugin = ElementFactory.createElement("/_MFLibrary/plugins/SECURITY_ROOT_107_" + currentVersionNoDots.replace("_", ""), "MF_PLUGIN", "100");
        topSet = plugin.getAttributes();
        topSet.setStringAttribute("CONFIG_PLUGIN_FACTORY_CLASS", "com.sonicsw.security.gui.config.SecurityPluginFactory");
        topSet.setStringAttribute("PLUGIN_FACTORY_CLASSPATH", "sonicfs:///System/SMC/Plugins/pluginSecurity" + currentVersionNoDots + ".jar");
        this.m_upgradeEnv.dsAdmin.setElement(plugin.doneUpdate(), null);
        HashMap loggerDeleteVersions = new HashMap(PRODUCT_VERSIONS_SUPPORTED_BY_EARLIEST_UPGRADE_VERSION);
        loggerDeleteVersions.putAll(SUPPORTED_PRODUCT_VERSIONS);
        for (String version : loggerDeleteVersions.keySet()) {
            String versionNoDots4 = this.getVersionWithNoDots(version);
            String releaseVersion4 = (String)loggerDeleteVersions.get(version);
            this.m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/plugins/LOGGER_ROOT_" + releaseVersion4 + "_" + versionNoDots4, null);
            IDirElement loggerFileElement = this.m_upgradeEnv.dsFileSystem.getFSElement("/System/SMC/Plugins/pluginLogger" + versionNoDots4 + ".jar", true);
            if (loggerFileElement == null) continue;
            this.m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)loggerFileElement.doneUpdate());
            this.m_upgradeEnv.dsFileSystem.deleteFSElement("/System/SMC/Plugins/pluginLogger" + versionNoDots4 + ".jar");
        }
        HashMap metaAttributes = this.m_upgradeEnv.dsFileSystem.getMetaAttributes("/Security/Default Certificate Store");
        if (metaAttributes != null) {
            this.m_upgradeEnv.dsAdmin.setElementReleaseVersion(this.m_upgradeEnv.dsFileSystem.logicalToStorage("/Security/Default Certificate Store"), "107");
            metaAttributes.put("TOOL_ATTRIBUTES", "TYPE=MQ_CERTIFICATES_STORE;CONFIG_VERSION=107;PRODUCT_VERSION=10.0");
            this.m_upgradeEnv.dsFileSystem.setMetaAttributes("/Security/Default Certificate Store", metaAttributes);
        }
    }

    private String getVersionWithNoDots(String versionString) {
        int dotLocation = versionString.indexOf(".");
        StringBuilder stringWithNoDots = new StringBuilder(versionString.substring(0, dotLocation));
        if (dotLocation > 1) {
            return stringWithNoDots.append("_").append(versionString.charAt(dotLocation + 1)).toString();
        }
        return stringWithNoDots.append(versionString.charAt(dotLocation + 1)).toString();
    }

    private void performVersionedUpgrade(String releaseVersion) throws Exception {
        IVersionedDomainManagerUpgrade previousUpgrade = UpgradeRegistry.getConfigDomainUpgrade(releaseVersion);
        if (previousUpgrade == null) {
            throw new Exception("Unable to find a domain manager upgrade method for version " + releaseVersion);
        }
        previousUpgrade.upgrade(this.m_upgradeEnv);
        if (!previousUpgrade.getUpgradedReleaseVersion().equals("107")) {
            this.performVersionedUpgrade(previousUpgrade.getUpgradedReleaseVersion());
        }
    }

    private void performVersionedPreConnectUpgrade(String releaseVersion) throws Exception {
        IVersionedDomainManagerUpgrade previousUpgrade = UpgradeRegistry.getConfigDomainUpgrade(releaseVersion);
        if (previousUpgrade == null) {
            throw new Exception("Unable to find a domain manager pre-connect upgrade method for version " + releaseVersion);
        }
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("DomainManager.performVersionedPreConnectUpgrade calling " + previousUpgrade);
        }
        previousUpgrade.preConnectUpgrade(this.m_upgradeEnv);
        if (!previousUpgrade.getUpgradedReleaseVersion().equals("107")) {
            this.performVersionedPreConnectUpgrade(previousUpgrade.getUpgradedReleaseVersion());
        }
    }

    private void upgradeDomainElement() throws Exception {
        this.m_upgradeEnv.m_utils.fixProductAndReleaseVersion("/_Default");
    }

    private void createMQPluginAttributes(IAttributeSet topSet) throws ConfigException, ReadOnlyException {
        IAttributeList http_inbound = topSet.createAttributeList("HTTP_INBOUND");
        http_inbound.addStringItem("com.sonicsw.mq.gui.config.acceptors.protocols.DirectProtocolConfigFactory");
        http_inbound.addStringItem("com.sonicsw.mq.gui.config.acceptors.protocols.SOAPProtocolConfigFactory");
        http_inbound.addStringItem("com.sonicsw.mq.gui.config.acceptors.protocols.JMSProtocolConfigFactory");
        IAttributeList http_outbound = topSet.createAttributeList("HTTP_OUTBOUND");
        http_outbound.addStringItem("com.sonicsw.mq.gui.config.routes.DirectRouteConfigFactory");
        http_outbound.addStringItem("com.sonicsw.mq.gui.config.routes.SoapRouteConfigFactory");
        http_outbound.addStringItem("com.sonicsw.mq.gui.config.routes.JMSRouteConfigFactory");
        http_outbound.addStringItem("com.sonicsw.mq.gui.config.routes.WSRouteConfigFactory");
    }
}

