/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.common.IDSTransaction;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.upgrade.DirectoryService;
import com.sonicsw.mf.common.config.upgrade.IMigrationProcess;
import com.sonicsw.mf.common.config.upgrade.Utils;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.directory.IDirectoryService;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class UpgradeEnv
implements IMigrationProcess {
    IDirectoryAdminService dsAdmin = null;
    IDirectoryFileSystemService dsFileSystem = null;
    IDirectoryService dsSource = null;
    DirectoryService dsService = null;
    String connectURL = null;
    String connectUsername = null;
    String connectPassword = null;
    String mnode = null;
    String domain = null;
    Vector upgradeConfigList = new Vector();
    Vector upgradePathList = new Vector();
    String outFile = "." + System.getProperty("file.separator") + "Upgrade.txt";
    IDSTransaction m_curTransaction = null;
    Utils m_utils = null;
    Properties m_upgradeEnv = new Properties();
    HashMap m_containerProps = new HashMap();
    boolean m_debug = false;
    static boolean s_debugAll;

    public UpgradeEnv(Properties upgradeEnv) {
        this.m_upgradeEnv = upgradeEnv;
        if (this.m_upgradeEnv != null) {
            String debugPropValue = upgradeEnv.getProperty("migrate.debug");
            if (debugPropValue != null) {
                this.m_debug = new Boolean(debugPropValue);
            }
            if (this.isDEBUG()) {
                System.out.println("UpgradeEnv hashtable constructor");
            }
        }
        this.m_utils = new Utils(this);
    }

    public UpgradeEnv(Properties upgradeProps, HashMap containerProps) {
        this(upgradeProps);
        this.m_containerProps = containerProps;
    }

    void connectToNewPSEDirectoryService() throws Exception {
        if (this.isDEBUG()) {
            System.out.println("UpgradeEnv.createNewPSEDirectoryService called");
        }
        String destDir = (String)this.m_upgradeEnv.get("ds.working.dir");
        IDirElement dsElement = (IDirElement)this.m_upgradeEnv.get("dm.ds.element");
        if (this.isDEBUG()) {
            System.out.println("UpgradeEnv.createNewPSEDirectoryService for ds element " + dsElement.getIdentity().getName() + " to connect, destDir = " + destDir);
        }
        this.dsService = new DirectoryService(dsElement, null, destDir, true);
        this.dsAdmin = this.dsService.getAdminService();
        this.dsFileSystem = this.dsService.getFileSystemService();
    }

    void setDsAdmin(IDirectoryAdminService dsAdminArg) {
        this.dsAdmin = dsAdminArg;
    }

    void setDsFileSystem(IDirectoryFileSystemService dsFileService) {
        this.dsFileSystem = dsFileService;
    }

    Utils getUtils() {
        return this.m_utils;
    }

    public final boolean isDEBUG() {
        return this.m_debug || s_debugAll;
    }

    public static final boolean isDebugAll() {
        return s_debugAll;
    }

    public Object getProp(String propName) {
        return this.m_upgradeEnv.get(propName);
    }

    public void putProp(String propName, Object value) {
        this.m_upgradeEnv.put(propName, value);
    }

    public Object getContainerProp(String containerName, String prop) {
        HashMap containerMap = (HashMap)this.m_containerProps.get(containerName);
        if (containerMap != null) {
            return containerMap.get(prop);
        }
        return null;
    }

    static {
        String debugProp = System.getProperty("DebugAll.debug");
        if (debugProp != null) {
            s_debugAll = new Boolean(debugProp);
        }
    }
}

