/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.upgrade.IMigrationProcess;
import com.sonicsw.mf.common.config.upgrade.IVersionedDomainManagerUpgrade;
import com.sonicsw.mf.common.config.upgrade.UpgradeEnv;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;

public abstract class VersionedDomainManager
implements IMigrationProcess,
IVersionedDomainManagerUpgrade {
    UpgradeEnv m_upgradeEnv = null;
    private String HIERARCHICAL_DIRECTORY = "/mx/hierarchicalTypes/" + this.getUpgradedReleaseVersion() + '/';
    private String[] HIERARCHICAL_TYPES = new String[]{this.HIERARCHICAL_DIRECTORY + "MQ_BROKER", this.HIERARCHICAL_DIRECTORY + "MQ_BACKUPBROKER", this.HIERARCHICAL_DIRECTORY + "MF_DIRECTORY_SERVICE", this.HIERARCHICAL_DIRECTORY + "MF_BACKUP_DIRECTORY_SERVICE", this.HIERARCHICAL_DIRECTORY + "MF_AUTHENTICATION_DOMAIN", this.HIERARCHICAL_DIRECTORY + "MQ_AUTHORIZATION_POLICY", this.HIERARCHICAL_DIRECTORY + "MQ_CLUSTER", this.HIERARCHICAL_DIRECTORY + "MQ_WS_PROTOCOL"};

    @Override
    public void preConnectUpgrade(UpgradeEnv env) throws Exception {
    }

    @Override
    public String upgrade(UpgradeEnv env) throws Exception {
        this.m_upgradeEnv = env;
        this.fixMFLibrary();
        this.initHierarchicalTypes();
        return null;
    }

    protected void fixMFLibrary() throws DirectoryServiceException, ReadOnlyException {
        this.m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/validators/MQ_100_" + this.getProductVersion(), null);
        this.m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/validators/MF_100_3.1", null);
        this.m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/validators/ESB_" + this.getProductVersion(), null);
        this.m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/ds_handlers/ESBJndiHandler", null);
        IDirElement jarFile = this.m_upgradeEnv.dsFileSystem.getFSElement("/System/DS/Validators/MQ/" + this.getProductVersion() + "/MQtriggers.jar", true);
        if (jarFile != null) {
            this.m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)jarFile.doneUpdate());
            this.m_upgradeEnv.dsFileSystem.deleteFSElement("/System/DS/Validators/MQ/" + this.getProductVersion() + "/MQtriggers.jar");
        }
        if ((jarFile = this.m_upgradeEnv.dsFileSystem.getFSElement("/System/DS/Validators/MF/" + this.getProductVersion() + "/MFtriggers.jar", true)) != null) {
            this.m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)jarFile.doneUpdate());
            this.m_upgradeEnv.dsFileSystem.deleteFSElement("/System/DS/Validators/MF/" + this.getProductVersion() + "/MFtriggers.jar");
        }
        if ((jarFile = this.m_upgradeEnv.dsFileSystem.getFSElement("/System/SonicESB/" + this.getProductVersion() + "/lib/xq_validator.jar", true)) != null) {
            this.m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)jarFile.doneUpdate());
            this.m_upgradeEnv.dsFileSystem.deleteFSElement("/System/SonicESB/" + this.getProductVersion() + "/lib/xq_validator.jar");
        }
        this.fix75MFLibrary();
    }

    private void fix75MFLibrary() {
        try {
            this.m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/validators/ESB_7.5", null);
            IDirElement jarFile = this.m_upgradeEnv.dsFileSystem.getFSElement("/System/SonicESB/7.5/lib/xq_validator.jar", true);
            if (jarFile != null) {
                this.m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)jarFile.doneUpdate());
                this.m_upgradeEnv.dsFileSystem.deleteFSElement("/System/SonicESB/7.5/lib/xq_validator.jar");
            }
        }
        catch (DirectoryServiceException e) {
            e.printStackTrace();
        }
        catch (ReadOnlyException e) {
            e.printStackTrace();
        }
    }

    protected void initHierarchicalTypes() throws DirectoryServiceException {
        try {
            this.m_upgradeEnv.dsAdmin.createDirectory(this.HIERARCHICAL_DIRECTORY);
        }
        catch (DirectoryServiceException dirE) {
            // empty catch block
        }
        for (int i = 0; i < this.HIERARCHICAL_TYPES.length; ++i) {
            if (this.m_upgradeEnv.dsAdmin.getElement(this.HIERARCHICAL_TYPES[i], false) != null) continue;
            IDirElement type = ElementFactory.createElement(this.HIERARCHICAL_TYPES[i], "HIERARCHICAL_TYPE", this.getProductVersion());
            this.m_upgradeEnv.dsAdmin.setElement(type, null);
        }
    }
}

