/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.security.impl;

import com.sonicsw.mf.common.security.IManagementPermission;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class ManagementPermission
implements IManagementPermission,
Serializable {
    private static final long serialVersionUID = 8192287077613976467L;
    private static final short m_serialVersion = 0;
    private String m_principal;
    private short m_principalType;
    private int m_scope;
    private int m_permissions;

    public ManagementPermission(String principal, short principalType) {
        this(principal, principalType, 0, 0);
    }

    public ManagementPermission(String principal, short principalType, int scope, int permissions) {
        this.m_principal = principal;
        this.m_principalType = principalType;
        this.setScope(scope);
        this.setPermissions(permissions);
    }

    @Override
    public String getPrincipal() {
        return this.m_principal;
    }

    @Override
    public short getPrincipalType() {
        return this.m_principalType;
    }

    @Override
    public int getScope() {
        return this.m_scope;
    }

    @Override
    public final void setScope(int scope) {
        if (scope < 0) {
            throw new IllegalArgumentException("Permission scope must be >= 0");
        }
        this.m_scope = scope;
    }

    @Override
    public int getPermissions() {
        return this.m_permissions;
    }

    @Override
    public final void setPermissions(int permissions) {
        if (permissions < 0) {
            throw new IllegalArgumentException("Permissions value must be >= 0");
        }
        int testPermissions = permissions;
        int count = 0;
        while (testPermissions > 0) {
            boolean allowBitSet = false;
            boolean denyBitSet = false;
            int temp = testPermissions >> 1 << 1;
            if (testPermissions - temp > 0) {
                allowBitSet = true;
            }
            if ((testPermissions >>= 1) - (temp = testPermissions >> 1 << 1) > 0) {
                denyBitSet = true;
            }
            if (allowBitSet && denyBitSet) {
                throw new IllegalArgumentException("Permission value is invalid; it contains conflicting allow and deny bits [" + (int)Math.pow(2.0, count) + " + " + (int)Math.pow(2.0, ++count) + "]");
            }
            testPermissions >>= 1;
            count += 2;
        }
        this.m_permissions = permissions;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(4);
        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(0));
        stream.writeUTF("principal");
        stream.writeObject(this.m_principal);
        stream.writeUTF("scope");
        stream.writeObject(new Integer(this.m_scope));
        stream.writeUTF("permissions");
        stream.writeObject(new Integer(this.m_permissions));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int numValues = stream.readInt();
        HashMap<String, Object> map = new HashMap<String, Object>(numValues);
        for (int i = 0; i < numValues; ++i) {
            map.put(stream.readUTF(), stream.readObject());
        }
        switch ((Short)map.get("serialVersion")) {
            default: 
        }
        try {
            this.m_principal = (String)map.get("principal");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_scope = (Integer)map.get("scope");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_permissions = (Integer)map.get("permissions");
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

