/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.view.impl;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.view.IDeltaView;
import com.sonicsw.mf.common.view.ViewException;
import com.sonicsw.mf.common.view.impl.ViewConstants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public final class DeltaView
implements IDeltaView,
Serializable {
    private static final long serialVersionUID = 0L;
    private IBasicElement m_viewElement;
    private transient ArrayList m_deletedList;
    private transient ArrayList m_newList;
    private transient ArrayList m_modifiedAttributesList;

    public DeltaView(IBasicElement viewElement) {
        if (viewElement == null || !viewElement.getIdentity().getName().equals(ViewConstants.VIEW_ELEMENT) || !(viewElement instanceof IDeltaElement)) {
            throw new IllegalStateException(ViewConstants.VIEW_ELEMENT + " delta element must be passed to the DeltaView constructor.");
        }
        this.m_viewElement = viewElement;
    }

    public IBasicElement getElement() {
        return this.m_viewElement;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(1);
        s.writeObject(this.m_viewElement);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException, ViewException {
        int version = s.readInt();
        if (version != 1) {
            throw new ViewException("Serialization version mismatch. Serialized object version: " + version + " class version: " + 1);
        }
        this.m_viewElement = (IBasicElement)s.readObject();
    }

    @Override
    public String[] getDeleteElements() {
        if (this.m_deletedList == null) {
            this.analyzeDelta();
        }
        String[] result = new String[this.m_deletedList.size()];
        this.m_deletedList.toArray(result);
        return result;
    }

    @Override
    public String[] getNewElements() {
        if (this.m_deletedList == null) {
            this.analyzeDelta();
        }
        String[] result = new String[this.m_newList.size()];
        this.m_newList.toArray(result);
        return result;
    }

    @Override
    public String[] getAttributeModifiedElements() {
        if (this.m_deletedList == null) {
            this.analyzeDelta();
        }
        String[] result = new String[this.m_modifiedAttributesList.size()];
        this.m_modifiedAttributesList.toArray(result);
        return result;
    }

    private void analyzeDelta() {
        this.m_deletedList = new ArrayList();
        this.m_newList = new ArrayList();
        this.m_modifiedAttributesList = new ArrayList();
        IDeltaAttributeSet deltaAttributes = (IDeltaAttributeSet)((IDeltaElement)this.m_viewElement).getDeltaAttributes();
        Object modifiedRootFolder = null;
        try {
            modifiedRootFolder = deltaAttributes.getNewValue(ViewConstants.ROOT_FOLDER);
        }
        catch (NotModifiedAttException notModifiedAttException) {
            // empty catch block
        }
        if (modifiedRootFolder == null) {
            return;
        }
        if (modifiedRootFolder instanceof IAttributeSet) {
            this.m_newList.add("/");
        } else {
            this.handleModifiedDelta("", (IDeltaAttributeSet)modifiedRootFolder);
        }
    }

    private void handleModifiedDelta(String pathName, IDeltaAttributeSet delta) {
        int i;
        String[] deletedNames = delta.getDeletedAttributesNames();
        String[] newNames = delta.getNewAttributesNames();
        String[] modifiedNames = delta.getModifiedAttributesNames();
        for (i = 0; i < deletedNames.length; ++i) {
            this.m_deletedList.add(pathName + '/' + deletedNames[i]);
        }
        for (i = 0; i < newNames.length; ++i) {
            this.m_newList.add(pathName + '/' + newNames[i]);
        }
        for (i = 0; i < modifiedNames.length; ++i) {
            String childName = modifiedNames[i];
            String childPath = pathName + '/' + childName;
            Object modifiedValue = null;
            try {
                modifiedValue = delta.getNewValue(childName);
            }
            catch (NotModifiedAttException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.toString());
            }
            if (childName.equals(ViewConstants.ATTRS_VALUES)) {
                this.m_modifiedAttributesList.add(pathName.length() == 0 ? "/" : pathName);
                continue;
            }
            if (modifiedValue instanceof IDeltaAttributeSet) {
                this.handleModifiedDelta(childPath, (IDeltaAttributeSet)modifiedValue);
                continue;
            }
            if (modifiedValue instanceof IAttributeSet) {
                this.m_newList.add(childPath);
                this.m_deletedList.add(childPath);
                continue;
            }
            throw new IllegalStateException("Unrecognized modification in attribute \"" + childPath + "\".");
        }
    }
}

