/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.mgmtapi.config.impl;

import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationDomainBean;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationGroupBean;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationUserBean;
import com.sonicsw.mf.mgmtapi.config.gen.AbstractMFMgmtBeanFactory;
import com.sonicsw.mf.mgmtapi.config.gen.impl.AbstractAuthenticationUserBean;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.util.ConfigHelper;
import progress.message.zclient.ISHA;

public class AuthenticationUserBean
extends AbstractAuthenticationUserBean
implements IAuthenticationUserBean {
    public AuthenticationUserBean(MgmtBeanFactory factory) {
        super(factory);
    }

    @Override
    protected void saveBean() throws Exception {
        if (this.isNewBean()) {
            String beanName = this.getConfigBean().getName();
            int index = beanName.lastIndexOf(47);
            String path = beanName.substring(0, index);
            if (this.getMgmtBeanFactory().doesConfigurationNameExist(this.getUserName(), path)) {
                throw new MgmtException("The specified user name already exist");
            }
            try {
                IConfigBean userBean = this.getConfigBean();
                String userName = this.getUserName();
                String id = userBean.getName();
                String domainPath = id.substring(0, id.lastIndexOf("_MFUsers"));
                String groupsPath = domainPath + "_MFGroups" + '/';
                if (!ConfigHelper.isAttrValueUniqueWithinFolder((IConfigServer)this.getConfigBean().getConfigServer(), (String)groupsPath, (String)"GROUP_NAME", (String)userName)) {
                    throw new MgmtException("The specified user name '" + userName + "' already exist - clashes with existing group name");
                }
            }
            catch (MgmtException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MgmtException("Failed to verify user name uniqueness: " + e.getMessage(), e);
            }
        }
        this.propagateBean();
        super.saveBean();
    }

    private void propagateBean() throws MgmtException {
        if (this.isNewBean()) {
            String beanName = this.getConfigBean().getName();
            int index = beanName.lastIndexOf("/_MFUsers");
            String domainPath = beanName.substring(0, index);
            IAuthenticationDomainBean domainBean = ((AbstractMFMgmtBeanFactory)this.getMgmtBeanFactory()).getAuthenticationDomainBean(domainPath);
            IAuthenticationGroupBean publicGroup = null;
            try {
                publicGroup = domainBean.getGroupBean("PUBLIC");
            }
            catch (MgmtException e) {
                return;
            }
            IAuthenticationGroupBean.IGroupMembersType publicMembers = publicGroup.getGroupMembers();
            IAuthenticationGroupBean.IGroupMemberType userInPublic = publicMembers.createMember();
            userInPublic.setMemberName(this.getUserName());
            userInPublic.setMemberType("user");
            publicMembers.addMember(this.getUserName(), userInPublic);
            this.getMgmtBeanFactory().saveBean(publicGroup);
        }
    }

    @Override
    public void setUserName(String value) throws MgmtException {
        try {
            IConfigBean bean = this.getConfigBean();
            String path = bean.getName();
            int index = path.lastIndexOf(47) + 1;
            path = path.substring(0, index);
            bean.setName(path + value);
            super.setUserName(value);
        }
        catch (Throwable e) {
            throw new MgmtException("Failed setUserName - " + e.getMessage(), e);
        }
    }

    @Override
    public void setPassword(String value) throws MgmtException {
        try {
            this.setByteArrayAttribute("PASSWORD", this.doSHA(value));
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to hash password " + e.getMessage(), e);
        }
    }

    private byte[] doSHA(String in) throws Exception {
        Class<?> c = Class.forName("progress.message.crypto.SHA");
        ISHA sha = (ISHA)c.newInstance();
        sha.add(in);
        return sha.digest();
    }
}

