/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeMetaData;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IAttributeSetType;
import com.sonicsw.mf.common.config.ITypeCollection;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.AttributeList;
import com.sonicsw.mf.common.config.impl.AttributeMetaData;
import com.sonicsw.mf.common.config.impl.AttributeSetType;
import com.sonicsw.mf.common.config.impl.DeltaAttributeSet;
import com.sonicsw.mf.common.config.impl.ElementNode;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.config.impl.ICanReplaceRef;
import com.sonicsw.mf.common.config.impl.IChangeRegistration;
import com.sonicsw.mf.common.config.impl.IDelta;
import com.sonicsw.mf.common.config.impl.IDeltaBookKeeper;
import com.sonicsw.mf.common.config.impl.IDictionary;
import com.sonicsw.mf.common.config.impl.IReplaceRef;
import com.sonicsw.mf.common.config.impl.TypeCollection;
import com.sonicsw.mf.common.config.impl.TypedAttSet;
import com.sonicsw.mf.common.config.impl.UntypedAttSet;
import com.sonicsw.mf.common.config.impl.Util;
import com.sonicsw.mf.common.config.query.AttributeName;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class AttributeSet
extends ElementNode
implements IAttributeSet,
Serializable,
ICanReplaceRef {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 3;
    public static final String RESERVED_CHARACTERS = "\\";
    public static final String ATTRIBUTE_SEPARATOR = "|";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final int NO_HISTORY = 0;
    static final int DELETED_ATTRIBUTE = 1;
    static final int NEW_ATTRIBUTE = 2;
    static final int MODIFIED_ATTRIBUTE = 3;
    private TypeCollection m_typeCollection;
    private IDictionary m_dictionary;
    private String m_typeName;
    private transient HashMap m_modHistory;
    private transient HashSet m_mergeUtilHint_deletedSet;

    static Object doTypedDelta(Object thisValue, Object thatValue, TypeCollection typeCollection) {
        String thisTypeName = ((AttributeSet)thisValue).getTypeName();
        String thatTypeName = ((AttributeSet)thatValue).getTypeName();
        AttributeSetType thisType = thisTypeName == null ? null : (AttributeSetType)typeCollection.getAttributeSetType(thisTypeName);
        AttributeSetType thatType = thatTypeName == null ? null : (AttributeSetType)typeCollection.getAttributeSetType(thatTypeName);
        return Util.createDelta(thisValue, thisType, thatValue, thatType);
    }

    AttributeSet(String name, ElementNode parent, AttributeSetType type) {
        super(name, parent);
        this.m_modHistory = null;
        this.m_typeCollection = null;
        if (type == null) {
            this.m_dictionary = new UntypedAttSet();
            this.m_typeName = null;
        } else {
            this.m_dictionary = type.createTypedSet();
            this.m_typeName = type.getName();
        }
    }

    AttributeSet(String name, ElementNode parent, String user, byte[] password) {
        super(name, parent, false);
        this.m_modHistory = new HashMap();
        this.m_typeCollection = null;
        this.m_dictionary = new UntypedAttSet(user, password);
        this.m_typeName = null;
    }

    Object createDelta(AttributeSetType myType, AttributeSet attributeSet, AttributeSetType attributeSetType) {
        if (myType != null ? !myType.equals(attributeSetType) : attributeSetType != null) {
            return attributeSet;
        }
        if (!this.getTypeCollection().equals(attributeSet.getTypeCollection())) {
            return attributeSet;
        }
        HashMap<String, Integer> modHistory = new HashMap<String, Integer>();
        HashMap<String, Object> deltaValues = new HashMap<String, Object>();
        String[] myAttributes = this.m_dictionary.attributes();
        for (int i = 0; i < myAttributes.length; ++i) {
            Object thisValue = this.getAttribute(myAttributes[i]);
            Object thatValue = attributeSet.getAttribute(myAttributes[i]);
            if (thisValue != null && thatValue == null) {
                modHistory.put(myAttributes[i], new Integer(1));
                continue;
            }
            if (thisValue == null && thatValue == null || thisValue == null && thatValue != null) continue;
            Object delta = null;
            delta = thisValue instanceof AttributeSet && thatValue instanceof AttributeSet ? AttributeSet.doTypedDelta(thisValue, thatValue, this.getTypeCollection()) : Util.createDelta(thisValue, null, thatValue, null);
            if (delta == null) continue;
            modHistory.put(myAttributes[i], new Integer(3));
            deltaValues.put(myAttributes[i], delta);
        }
        String[] hisAttributes = attributeSet.m_dictionary.attributes();
        for (int i = 0; i < hisAttributes.length; ++i) {
            Object thisValue = this.getAttribute(hisAttributes[i]);
            Object thatValue = attributeSet.getAttribute(hisAttributes[i]);
            if (thisValue != null || thatValue == null) continue;
            modHistory.put(hisAttributes[i], new Integer(2));
            deltaValues.put(hisAttributes[i], thatValue);
        }
        if (!modHistory.isEmpty()) {
            return new DeltaAttributeSet(this.m_typeName, modHistory, deltaValues);
        }
        return null;
    }

    public int estimateSize() {
        int estimate = 64 + Util.estimateSize(this.m_typeName);
        if (this.m_typeCollection != null) {
            estimate += this.m_typeCollection.estimateSize();
        }
        if (this.m_dictionary != null) {
            estimate += this.m_dictionary.estimateSize();
        }
        return estimate;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(3);
        s.writeObject(this.m_typeCollection);
        s.writeObject(this.m_dictionary);
        s.writeObject(this.m_typeName);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 3) {
            Util.throwSerialVersionMismatch(version, 3);
        }
        this.m_typeCollection = (TypeCollection)s.readObject();
        this.m_dictionary = (IDictionary)s.readObject();
        this.m_typeName = (String)s.readObject();
        this.m_modHistory = new HashMap();
    }

    void createLocalTypedSet(TypeCollection typeCollection) {
        if (!this.isTyped()) {
            return;
        }
        this.m_dictionary = typeCollection.cloneInstance((TypedAttSet)this.m_dictionary);
    }

    @Override
    Object getNameFromParent(Object listItem) {
        throw new Error();
    }

    private boolean isTyped() {
        return this.m_dictionary instanceof TypedAttSet;
    }

    @Override
    public String getTypeName() {
        return this.m_typeName;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
        if (this.m_typeCollection != null) {
            this.m_typeCollection.setReadOnly(readOnly);
        }
        String[] attributes = this.m_dictionary.attributes();
        for (int i = 0; i < attributes.length; ++i) {
            Object value = null;
            try {
                value = this.m_dictionary.get(attributes[i]);
            }
            catch (AttributeSetTypeException attributeSetTypeException) {
                // empty catch block
            }
            if (value == null || !(value instanceof ElementNode)) continue;
            ((ElementNode)value).setReadOnly(readOnly);
        }
    }

    @Override
    public void removeDeltaHistory() {
        this.m_isNew = true;
        this.m_modHistory = null;
    }

    @Override
    public void applyDelta(IDelta delta) throws AttributeSetTypeException {
        String attribute;
        int i;
        if (!(delta instanceof DeltaAttributeSet)) {
            throw new Error("Not an attribute set delta.");
        }
        DeltaAttributeSet deltaAtt = (DeltaAttributeSet)delta;
        String[] newAttributes = deltaAtt.getNewAttributesNames();
        String[] deletedAttributes = deltaAtt.getDeletedAttributesNames();
        String[] modifiedAttributes = deltaAtt.getModifiedAttributesNames();
        for (i = 0; i < newAttributes.length; ++i) {
            attribute = newAttributes[i];
            Object value = deltaAtt.getValue(attribute);
            if (value instanceof AttributeSet) {
                ((AttributeSet)value).createLocalTypedSet(this.m_typeCollection);
            }
            if (value instanceof ElementNode) {
                ((ElementNode)value).setNewParent(this);
            }
            this.m_dictionary.put(attribute, value);
        }
        for (i = 0; i < deletedAttributes.length; ++i) {
            Object oldValue = this.m_dictionary.remove(deletedAttributes[i]);
            if (!(oldValue instanceof ElementNode)) continue;
            ((ElementNode)oldValue).removeFromTree();
        }
        for (i = 0; i < modifiedAttributes.length; ++i) {
            Object oldValue;
            attribute = modifiedAttributes[i];
            Object newValue = deltaAtt.getValue(attribute);
            if (newValue instanceof IDelta) {
                oldValue = this.m_dictionary.get(attribute);
                if (oldValue == null || !(oldValue instanceof IDeltaBookKeeper)) {
                    throw new Error("Cannot apply the delta to the old value.");
                }
                ((IDeltaBookKeeper)oldValue).applyDelta((IDelta)newValue);
                continue;
            }
            if (newValue instanceof AttributeSet) {
                ((AttributeSet)newValue).createLocalTypedSet(this.m_typeCollection);
            }
            if (newValue instanceof ElementNode) {
                ((ElementNode)newValue).setNewParent(this);
            }
            if ((oldValue = this.m_dictionary.put(attribute, newValue)) == null || !(oldValue instanceof ElementNode)) continue;
            ((ElementNode)oldValue).delete();
        }
    }

    @Override
    public IDelta createDelta(boolean forSubclassing) {
        if (this.isNew()) {
            throw new Error();
        }
        HashMap<String, Object> deltaVals = new HashMap<String, Object>();
        String[] attributes = this.m_dictionary.attributes();
        block7: for (int i = 0; i < attributes.length; ++i) {
            String attribute = attributes[i];
            Integer history = (Integer)this.m_modHistory.get(attribute);
            if (history == null) continue;
            Object actualValue = null;
            try {
                actualValue = this.m_dictionary.get(attribute);
            }
            catch (AttributeSetTypeException e) {
                throw new Error(e);
            }
            switch (history) {
                case 1: {
                    continue block7;
                }
                case 2: {
                    if (actualValue instanceof ElementNode) {
                        actualValue = ((ElementNode)actualValue).cloneWithoutParent();
                    }
                    deltaVals.put(attribute, actualValue);
                    continue block7;
                }
                case 3: {
                    if (actualValue instanceof IDeltaBookKeeper) {
                        IDeltaBookKeeper deltaKeeper = (IDeltaBookKeeper)actualValue;
                        if (forSubclassing && actualValue instanceof AttributeList) {
                            deltaKeeper.removeDeltaHistory();
                        }
                        if (deltaKeeper.isNew()) {
                            if (deltaKeeper instanceof ElementNode) {
                                deltaKeeper = (IDeltaBookKeeper)((ElementNode)deltaKeeper).cloneWithoutParent();
                            }
                            deltaVals.put(attribute, deltaKeeper);
                            continue block7;
                        }
                        deltaVals.put(attribute, deltaKeeper.createDelta(forSubclassing));
                        continue block7;
                    }
                    if (actualValue instanceof ElementNode) {
                        actualValue = ((ElementNode)actualValue).cloneWithoutParent();
                    }
                    deltaVals.put(attribute, actualValue);
                    continue block7;
                }
                default: {
                    throw new Error();
                }
            }
        }
        return new DeltaAttributeSet(this.m_typeName, this.m_modHistory, deltaVals);
    }

    private TypeCollection getTypeCollection() {
        if (this.m_typeCollection == null) {
            this.m_typeCollection = new TypeCollection();
        }
        return this.m_typeCollection;
    }

    private static int attributeSetHistoryTable(boolean valueExists, int previuosHistory) {
        switch (previuosHistory) {
            case 0: {
                if (valueExists) {
                    return 3;
                }
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        throw new Error();
    }

    private static int attributeDeleteHistoryTable(boolean valueExists, int previuosHistory) {
        switch (previuosHistory) {
            case 0: {
                if (valueExists) {
                    return 1;
                }
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
        }
        throw new Error();
    }

    private void verifyMod(String attributeName) throws ReadOnlyException, ConfigException {
        if (EntityName.containsAnyChar(attributeName, RESERVED_CHARACTERS)) {
            throw new ConfigException("Invalid name '" + attributeName + "'. Attribute and type names cannot contain the characters: " + RESERVED_CHARACTERS);
        }
        if (attributeName == null || attributeName.length() == 0) {
            throw new ConfigException("Attribute name cannot be null or 0 length.");
        }
        if (this.m_readOnly) {
            throw new ReadOnlyException();
        }
    }

    @Override
    void markModified(String attributeName, boolean oldValueExists, boolean deletion) {
        int newHistoryEvent;
        if (this.isNew()) {
            return;
        }
        Integer history = (Integer)this.m_modHistory.get(attributeName);
        int n = deletion ? AttributeSet.attributeDeleteHistoryTable(oldValueExists, history == null ? 0 : history) : (newHistoryEvent = AttributeSet.attributeSetHistoryTable(oldValueExists, history == null ? 0 : history));
        if (newHistoryEvent == 0) {
            this.m_modHistory.remove(attributeName);
        } else {
            this.m_modHistory.put(attributeName, new Integer(newHistoryEvent));
        }
        this.markTreeModified();
    }

    private IAttributeSetType modifyAttributeSetType(String typeName, boolean create) throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        this.verifyMod(typeName);
        IAttributeSetType type = null;
        type = create ? this.getTypeCollection().createAttributeSetType(typeName) : this.getTypeCollection().deleteAttributeSetType(typeName);
        if (this.isNew()) {
            return type;
        }
        this.markTreeModified();
        this.removeDeltaHistory();
        return type;
    }

    @Override
    void delete() {
        this.m_dictionary.delete();
    }

    @Override
    public void setObjectAttribute(String attributeName, Object value) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        this.setAttributeObject(attributeName, value, true);
    }

    void setAttributeObjectNoHistory(String attributeName, Object value) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        if (value == null) {
            throw new IllegalArgumentException("setAttributeObjectNoHistory: null value");
        }
        if (!Util.validSimpleValue(value)) {
            throw new AttributeSetTypeException(value.getClass().getName() + " is an invalid type.");
        }
        this.m_dictionary.put(attributeName, value);
    }

    void renameNoHistory(String oldName, String newName) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        Object value = this.m_dictionary.remove(oldName);
        this.m_dictionary.put(newName, value);
    }

    void setAttributeObject(String attributeName, Object value, boolean checkType) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        boolean oldValueExists;
        this.verifyMod(attributeName);
        if (value == null) {
            this.deleteAttribute(attributeName);
            return;
        }
        if (checkType && !Util.validSimpleValue(value)) {
            throw new AttributeSetTypeException(value.getClass().getName() + " is an invalid type.");
        }
        Object oldValue = this.m_dictionary.get(attributeName);
        boolean bl = oldValueExists = oldValue != null;
        if (oldValueExists && Util.atomicAndEqual(oldValue, value)) {
            return;
        }
        this.m_dictionary.put(attributeName, value);
        this.markModified(attributeName, oldValueExists, false);
    }

    @Override
    public IAttributeSet createAttributeSet(String attributeName, IAttributeSetType type) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        if (type != null) {
            this.m_typeCollection.verifyType((AttributeSetType)type, this.getFullName());
        }
        this.setAttributeObject(attributeName, "PLACE_HOLDER", false);
        AttributeSet set = new AttributeSet(attributeName, (ElementNode)this, (AttributeSetType)type);
        this.m_dictionary.put(attributeName, set);
        return set;
    }

    @Override
    public IAttributeList createAttributeList(String attributeName) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        AttributeList newList = new AttributeList(attributeName, this);
        this.setAttributeObject(attributeName, newList, false);
        return newList;
    }

    @Override
    public IAttributeSet createAttributeSet(String attributeName) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        return this.createAttributeSet(attributeName, null);
    }

    @Override
    public Object deleteAttribute(String attributeName) throws ReadOnlyException, ConfigException {
        this.verifyMod(attributeName);
        boolean oldValueExists = this.m_dictionary.get(attributeName) != null;
        Object oldValue = this.m_dictionary.remove(attributeName);
        this.markModified(attributeName, oldValueExists, true);
        if (oldValue instanceof ElementNode) {
            ((ElementNode)oldValue).removeFromTree();
        }
        return oldValue;
    }

    @Override
    public Object getAttribute(AttributeName attributeName) {
        int componentCount = attributeName.getComponentCount();
        if (componentCount == 0) {
            return null;
        }
        Object firstComponenet = attributeName.getComponent(0);
        if (firstComponenet instanceof Integer) {
            return null;
        }
        Object thisLevel = this.getAttribute((String)firstComponenet);
        if (componentCount == 1 || thisLevel == null) {
            return thisLevel;
        }
        AttributeName nextLevelsname = com.sonicsw.mf.common.config.query.impl.Util.removeFirstComponent(attributeName);
        if (thisLevel instanceof AttributeSet) {
            return ((AttributeSet)thisLevel).getAttribute(nextLevelsname);
        }
        if (thisLevel instanceof AttributeList) {
            return ((AttributeList)thisLevel).getAttribute(nextLevelsname);
        }
        return null;
    }

    @Override
    public HashMap getAttributes() {
        String[] attributes = this.m_dictionary.attributes();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < attributes.length; ++i) {
            Object value = null;
            try {
                value = this.m_dictionary.get(attributes[i]);
            }
            catch (AttributeSetTypeException e) {
                throw new Error(e);
            }
            if (value == null) continue;
            map.put(attributes[i], value);
        }
        return map;
    }

    @Override
    public IAttributeSetType createAttributeSetType(String typeName) throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        return this.modifyAttributeSetType(typeName, true);
    }

    @Override
    public IAttributeSetType deleteAttributeSetType(String typeName) throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        return this.modifyAttributeSetType(typeName, false);
    }

    @Override
    public boolean typesEqual(ITypeCollection c) {
        if (!(c instanceof AttributeSet)) {
            return false;
        }
        return this.getTypeCollection().typesEqual(((AttributeSet)c).getTypeCollection());
    }

    @Override
    public String[] getAllTypeNames() {
        return this.getTypeCollection().getAllTypeNames();
    }

    @Override
    public IAttributeSetType getAttributeSetType(String typeName) {
        return this.getTypeCollection().getAttributeSetType(typeName);
    }

    @Override
    public Object getAttribute(String attName) {
        try {
            return this.m_dictionary.get(attName);
        }
        catch (AttributeSetTypeException e) {
            return null;
        }
    }

    @Override
    public IAttributeMetaData getAttributeMetaData(String attName) {
        if (this.getAttribute(attName) == null) {
            return null;
        }
        boolean fromTamplate = this.isNew() ? false : (this.m_modHistory != null && this.m_modHistory.get(attName) != null ? false : (this.underModifiedList() ? false : this.checkSubclassingDelta(this.getCompoundName().setNextComponent(attName))));
        return new AttributeMetaData(fromTamplate);
    }

    @Override
    public String[] getDeletedAttributesInThisSubclassed() {
        return this.checkSubclassingDeletedAttributes(this.getCompoundName());
    }

    @Override
    public void setIntegerAttribute(String attributeName, Integer value) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        this.setAttributeObject(attributeName, value, false);
    }

    @Override
    public void setLongAttribute(String attributeName, Long value) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        this.setAttributeObject(attributeName, value, false);
    }

    @Override
    public void setStringAttribute(String attributeName, String value) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        this.setAttributeObject(attributeName, value, false);
    }

    @Override
    public void setDecimalAttribute(String attributeName, BigDecimal value) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        try {
            if (value != null) {
                value.toString();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.setAttributeObject(attributeName, value, false);
    }

    @Override
    public void setBytesAttribute(String attributeName, byte[] value) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        this.setAttributeObject(attributeName, value, false);
    }

    @Override
    public void setBooleanAttribute(String attributeName, Boolean value) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        this.setAttributeObject(attributeName, value, false);
    }

    @Override
    public void setDateAttribute(String attributeName, Date value) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        this.setAttributeObject(attributeName, value, false);
    }

    @Override
    public void setReferenceAttribute(String attributeName, Reference value) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        this.setAttributeObject(attributeName, value, false);
    }

    @Override
    public void registerAttributeChangeHandler(Object context, IAttributeChangeHandler handler) {
        this.validateRegistrationContext(context);
        ((IChangeRegistration)context).registerAttributeChangeHandler(this.getCompoundName(), handler);
    }

    @Override
    public void unregisterAttributeChangeHandler(Object context) {
        this.validateRegistrationContext(context);
        ((IChangeRegistration)context).unregisterAttributeChangeHandler(this.getCompoundName());
    }

    @Override
    public void registerAttributeChangeHandler(Object context, String attributeName, IAttributeChangeHandler handler) {
        this.validateRegistrationContext(context);
        if (attributeName == null) {
            throw new IllegalArgumentException("The attribute name must not be null.");
        }
        if (this.getAttribute(attributeName) == null) {
            throw new IllegalArgumentException("There is no attribute '" + attributeName + "' in this attribute set.");
        }
        ((IChangeRegistration)context).registerAttributeChangeHandler(this.getCompoundName().setNextComponent(attributeName), handler);
    }

    @Override
    public void unregisterAttributeChangeHandler(Object context, String attributeName) {
        this.validateRegistrationContext(context);
        if (attributeName == null) {
            throw new IllegalArgumentException("The attribute name must not be null.");
        }
        ((IChangeRegistration)context).unregisterAttributeChangeHandler(this.getCompoundName().setNextComponent(attributeName));
    }

    private void validateRegistrationContext(Object context) {
        if (context == null || !(context instanceof IChangeRegistration)) {
            throw new IllegalArgumentException("The context object is invalid.");
        }
    }

    @Override
    public boolean replaceReferences(boolean thisIsSystemAttributes, IReplaceRef replaceSrvc) {
        HashMap map = this.getAttributes();
        Set keys = map.keySet();
        Iterator iter = keys.iterator();
        boolean retVal = true;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = map.get(key);
            if (value instanceof ICanReplaceRef) {
                boolean ret = ((ICanReplaceRef)value).replaceReferences(false, replaceSrvc);
                if (ret) continue;
                retVal = false;
                continue;
            }
            if (value instanceof Reference) {
                try {
                    Reference newRef = replaceSrvc.replace((Reference)value);
                    if (newRef.getElementName().startsWith("/NO_STORAGE:")) {
                        retVal = false;
                    }
                    this.m_dictionary.put(key, newRef);
                    continue;
                }
                catch (AttributeSetTypeException e) {
                    e.printStackTrace();
                    throw new Error(e.toString());
                }
            }
            if (!thisIsSystemAttributes || !key.equals("SUPER_REFERENCE")) continue;
            try {
                this.m_dictionary.put(key, replaceSrvc.replace((String)value));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Error(e.toString(), e);
            }
        }
        return retVal;
    }

    @Override
    public void mergeUtilHint_markAttributeDeleted(String attName) {
        if (this.m_mergeUtilHint_deletedSet == null) {
            this.m_mergeUtilHint_deletedSet = new HashSet();
        }
        this.m_mergeUtilHint_deletedSet.add(attName);
    }

    @Override
    public String[] mergeUtilHint_getAttributesMarkedDeleted() {
        if (this.m_mergeUtilHint_deletedSet == null) {
            return new String[0];
        }
        return this.m_mergeUtilHint_deletedSet.toArray(EMPTY_STRING_ARRAY);
    }
}

