/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.jmx.client;

import com.sonicsw.mf.common.runtime.IBackupStatus;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.management.ObjectName;

public class OnlineBackup {
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMAT_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yy/MM/dd HH:mm:ss");
        }
    };

    public static void main(String[] args) throws Exception {
        String backupDir = args[0];
        String override = args[1];
        String domain = args[2];
        String url = args[3];
        String username = null;
        String password = null;
        if (args.length == 6) {
            username = args[4];
            password = args[5];
        }
        JMSConnectorClient server = new JMSConnectorClient();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("ConnectionURLs", url);
        if (username != null) {
            env.put("DefaultUser", username);
        }
        if (password != null) {
            env.put("DefaultPassword", password);
        }
        JMSConnectorAddress address = new JMSConnectorAddress(env);
        server.connect(address, 0L);
        String dsName = domain + ".DIRECTORY SERVICE:ID=DIRECTORY SERVICE";
        DirectoryServiceProxy dsService = new DirectoryServiceProxy(server, new ObjectName(dsName));
        dsService.startBackup(backupDir, new Boolean(override));
        IBackupStatus status = dsService.getBackupStatus();
        while (status.isInProgress()) {
            Thread.sleep(5000L);
            status = dsService.getBackupStatus();
        }
        if (status.getCompletionTime() == -1L) {
            System.out.println("Online backup started on " + SIMPLE_DATE_FORMAT_THREAD_LOCAL.get().format(new Date(status.getStartTime())) + " has failed. You can find more information in the container log");
        } else {
            System.out.println("Online backup finished successfuly at " + SIMPLE_DATE_FORMAT_THREAD_LOCAL.get().format(new Date(status.getCompletionTime())));
        }
        server.disconnect();
    }
}

