/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.jmx.client;

import com.sonicsw.mf.comm.ConnectTimeoutException;
import com.sonicsw.mf.comm.InvokeTimeoutCommsException;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.IBlobSource;
import com.sonicsw.mf.common.IDSTransaction;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IChunkedBlobStreamer;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementChangeHandler;
import com.sonicsw.mf.common.config.IElementDeleteNotification;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IEnvelope;
import com.sonicsw.mf.common.config.IFolderDeleteNotification;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.config.INameChangeHandler;
import com.sonicsw.mf.common.config.INamingNotification;
import com.sonicsw.mf.common.config.INextVersionToken;
import com.sonicsw.mf.common.config.IRenameNotification;
import com.sonicsw.mf.common.config.LogicalStorageNameMapper;
import com.sonicsw.mf.common.config.impl.Blob;
import com.sonicsw.mf.common.config.impl.DSTransaction;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.query.QueryBatch;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.dirconfig.InvalidXMLException;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.common.runtime.IBackupStatus;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.security.ConfigurePermissionDeniedException;
import com.sonicsw.mf.common.security.IManagementPermission;
import com.sonicsw.mf.common.security.IManagementSecurityConfigurator;
import com.sonicsw.mf.common.security.InvalidManagementPermissionException;
import com.sonicsw.mf.common.security.ManagementPermissionDeniedException;
import com.sonicsw.mf.common.util.ZipUtils;
import com.sonicsw.mf.common.view.IDeltaView;
import com.sonicsw.mf.common.view.IView;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mf.mgmtapi.runtime.ProxyRuntimeException;
import com.sonicsw.mx.util.IEmptyArray;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public final class DirectoryServiceProxy
implements IDirectoryAdminService,
IDirectoryFileSystemService,
IChunkedBlobStreamer,
IBlobSource,
IManagementSecurityConfigurator {
    private IRemoteMBeanServer m_server;
    private ObjectName m_dsName;
    private NotificationListener m_changeNotificationListener;
    private NotificationListener m_FSChangeNotificationListener;
    private NotificationListener m_namingListener;
    private HashSet m_globalChangeHandlers = new HashSet();
    private HashSet m_globalFSChangeHandlers = new HashSet();
    private HashSet m_nameChangeHandlers = new HashSet();
    private HashMap m_elementChangeHandlers = new HashMap();
    private HashMap m_FSElementChangeHandlers = new HashMap();
    private static final String CONFIG_CHANGE_NOTIFICATION_TYPE = "configuration.storage.Change";
    private static final String CONFIG_FSCHANGE_NOTIFICATION_TYPE = "configuration.storage.FSChange";
    private static final String CONFIG_NAMING_NOTIFICATION_TYPE = "configuration.storage.Naming";
    private LogicalStorageNameMapper m_logicalStorageMap = null;
    private static final String[] SET_VIEW_SIGNATURE = new String[]{IDeltaView.class.getName()};
    private static final String[] GET_ELEMENT_SIGNATURE1 = new String[]{String.class.getName(), Boolean.class.getName()};
    private static final String[] GET_ELEMENT_IFUPDATED_SIGNATURE1 = new String[]{Long.class.getName(), String.class.getName(), IElementIdentity.class.getName()};
    private static final String[] GET_ELEMENT_SIGNATURE3 = new String[]{String.class.getName(), Boolean.class.getName(), Boolean.class.getName()};
    private static final String[] GET_ELEMENTS_SIGNATURE = new String[]{Query.class.getName(), Boolean.class.getName()};
    private static final String[] GET_ELEMENTS1_SIGNATURE = new String[]{Query.class.getName(), Boolean.class.getName(), Boolean.class.getName()};
    private static final String[] LOGICAL_TO_STORAGE_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] STORAGE_TO_LOGICAL_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] GET_PARTIAL_BLOB_SIGNATURE = new String[]{String.class.getName(), Boolean.class.getName(), Integer.class.getName()};
    private static final String[] SET_BACKUP_SIGNATURE = new String[]{Boolean.class.getName()};
    private static final String[] DETACH_BLOB_SIGNATURE = new String[]{IDeltaDirElement.class.getName(), IDeltaView.class.getName()};
    private static final String[] GET_ELEMENT_SIGNATURE2 = new String[]{String.class.getName(), Boolean.class.getName(), Boolean.class.getName()};
    private static final String[] GET_ALL_ELEMENTS_SIGNATURE1 = new String[]{String.class.getName(), Boolean.class.getName()};
    private static final String[] GET_ALL_ELEMENTS_SIGNATURE2 = new String[]{String.class.getName(), Boolean.class.getName(), Boolean.class.getName()};
    private static final String[] SET_ELEMENT_SIGNATURE = new String[]{IBasicElement.class.getName(), IDeltaView.class.getName()};
    private static final String[] SET_ELEMENT_RELVERS_SIGNATURE = new String[]{String.class.getName(), String.class.getName()};
    private static final String[] SET_ELEMENTS_SIGNATURE = new String[]{IBasicElement[].class.getName(), String[].class.getName(), IDeltaView.class.getName()};
    private static final String[] UPGRADE56_SIGNATURE = new String[]{String.class.getName(), String.class.getName()};
    private static final String[] ATTACH_BLOB_SIGNATURE = new String[]{IBasicElement.class.getName(), byte[].class.getName(), IDeltaView.class.getName()};
    private static final String[] APPEND_BLOB_SIGNATURE = new String[]{IBasicElement.class.getName(), byte[].class.getName(), Integer.class.getName(), Boolean.class.getName(), IDeltaView.class.getName()};
    private static final String[] DELETE_ELEMENT_SIGNATURE = new String[]{String.class.getName(), IDeltaView.class.getName()};
    private static final String[] CLONE_ELEMENT_SIGNATURE = new String[]{String.class.getName(), String.class.getName(), IDeltaView.class.getName()};
    private static final String[] CLONE_ELEMENT1_SIGNATURE = new String[]{IBasicElement.class.getName(), String.class.getName(), IDeltaView.class.getName()};
    private static final String[] CLONE_ELEMENT2_SIGNATURE = new String[]{String.class.getName(), String.class.getName(), Boolean.class.getName(), IDeltaView.class.getName()};
    private static final String[] CLONE_ELEMENT3_SIGNATURE = new String[]{IBasicElement.class.getName(), String.class.getName(), Boolean.class.getName(), IDeltaView.class.getName()};
    private static final String[] GET_IDENTITY_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] LOOKUP_IDENTITY_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] LIST_ALL_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] LIST_DIRECTORIES_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] LIST_ELEMENTS_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] CREATE_DIRECTORY_SIGNATURE1 = new String[]{String.class.getName()};
    private static final String[] DELETE_DIRECTORY_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] DELETE_DIRECTORY1_SIGNATURE = new String[]{String.class.getName(), IDeltaView.class.getName()};
    private static final String[] EXPORT_ELEMENT_TO_XML_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] EXPORT_DIRECTORY_TO_XML_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] IMPORT_FROM_XML_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] DEFINE_FOLDER_META_ATTRIBUTES_SIGNATURE = new String[]{String[].class.getName()};
    private static final String[] DEFINE_ELEMENT_META_ATTRIBUTES_SIGNATURE = new String[]{String[].class.getName()};
    private static final String[] RENAME_SIGNATURE = new String[]{String.class.getName(), String.class.getName()};
    private static final String[] CREATE_FOLDER_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] COPY_FILES_SIGNATURE = new String[]{String.class.getName(), String.class.getName()};
    private static final String[] CREATE_FOLDER_EXISTING_SIGNATURE = new String[]{String.class.getName(), Boolean.class.getName()};
    private static final String[] DELETE_FOLDER_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] LIST_FOLDERS_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] LIST_FS_ALL_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] LIST_FS_ALL_FOLDERS_EXT_SIGNATURE = new String[]{String.class.getName(), Boolean.class.getName(), String.class.getName()};
    private static final String[] RECURSIVE_LIST_SIGNATURE = new String[]{String.class.getName(), Boolean.class.getName(), Boolean.class.getName(), String.class.getName()};
    private static final String[] LIST_FS_ELEMENTS_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] SET_META_ATTRIBUTES_SIGNATURE = new String[]{String.class.getName(), HashMap.class.getName()};
    private static final String[] GET_META_ATTRIBUTES_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] SET_STORAGE_HINT_SIGNATURE = new String[]{String.class.getName(), String.class.getName()};
    private static final String[] SET_STORAGE_HINT_POSTFIX_SIGNATURE = new String[]{String.class.getName(), String.class.getName(), String.class.getName()};
    private static final String[] SET_COMPLEX_STORAGE_HINT_SIGNATURE = new String[]{String.class.getName(), String.class.getName()};
    private static final String[] GET_FS_ELEMENTS_DELTA_SIGNATURE = new String[]{Query.class.getName(), Boolean.class.getName(), Boolean.class.getName()};
    private static final String[] GET_FS_ELEMENTS_BATCH_SIGNATURE = new String[]{Query.class.getName(), Boolean.class.getName(), Boolean.class.getName(), QueryBatch.class.getName()};
    private static final String[] GET_FS_ELEMENTS_SIGNATURE = new String[]{Query.class.getName(), Boolean.class.getName()};
    private static final String[] GET_FS_ELEMENT_SIGNATURE = new String[]{String.class.getName(), Boolean.class.getName()};
    private static final String[] GET_CREATE_CONTAINER_SIGNATURE = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), Hashtable.class.getName(), Hashtable.class.getName()};
    private static final String[] GET_FS_ELEMENTS_STRING_SIGNATURE = new String[]{String.class.getName(), Boolean.class.getName()};
    private static final String[] GET_FS_ELEMENT_DELTA_STRING_SIGNATURE = new String[]{String.class.getName(), Boolean.class.getName(), Boolean.class.getName()};
    private static final String[] GET_FS_IDENTITY_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] DELETE_FS_ELEMENT_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] CREATE_FS_ELEMENT_SIGNATURE = new String[]{IDirElement.class.getName()};
    private static final String[] UPDATE_FS_ELEMENT_SIGNATURE = new String[]{IDeltaDirElement.class.getName()};
    private static final String[] REVERT_TO_TEMPLATE_SIGNATURE = new String[]{String.class.getName(), AttributeName[].class.getName()};
    private static final String[] CLONE_FS_ELEMENT_SIGNATURE = new String[]{String.class.getName(), String.class.getName()};
    private static final String[] CLONE_FS_BLOB_SIGNATURE = new String[]{String.class.getName(), String.class.getName()};
    private static final String[] CLONE_FS_ELEMENT_DELTA_SIGNATURE = new String[]{IBasicElement.class.getName(), String.class.getName()};
    private static final String[] CLONE_FS_ELEMENT_TEMPLATE_SIGNATURE = new String[]{String.class.getName(), String.class.getName(), Boolean.class.getName()};
    private static final String[] CLONE_FS_ELEMENT_DELTA_TEMPLATE_SIGNATURE = new String[]{IBasicElement.class.getName(), String.class.getName(), Boolean.class.getName()};
    private static final String[] ATTACH_FS_BLOB_SIGNATURE = new String[]{IBasicElement.class.getName(), byte[].class.getName()};
    private static final String[] APPEND_FS_BLOB_SIGNATURE = new String[]{IBasicElement.class.getName(), byte[].class.getName(), Integer.class.getName(), Boolean.class.getName()};
    private static final String[] GET_FS_BLOB_SIGNATURE = new String[]{String.class.getName(), Boolean.class.getName()};
    private static final String[] GET_FILES_SIGNATURE = new String[]{String[].class.getName()};
    private static final String[] GET_FILES_EXT_SIGNATURE = new String[]{String.class.getName(), Boolean.class.getName(), String.class.getName()};
    private static final String[] GET_FS_BLOB_PARTIAL_SIGNATURE = new String[]{String.class.getName(), Boolean.class.getName(), Integer.class.getName()};
    private static final String[] DETACH_FS_BLOB_SIGNATURE = new String[]{IDeltaDirElement.class.getName()};
    private static final String[] SUBCLASS_FS_ELEMENT_SIGNATURE = new String[]{IBasicElement.class.getName(), String.class.getName()};
    private static final String[] UN_SUBCLASS_FS_ELEMENT_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] EXECUTE_TRANSACTION_SIGNATURE = new String[]{IDSTransaction.class.getName()};
    private static final String[] REGISTER_FS_ELEMENT_CHANGE_HANDLER_SIGNATURE = new String[]{IElementChangeHandler.class.getName()};
    private static final String[] REGISTER_NAME_CHANGE_HANDLER_SIGNATURE = new String[]{INameChangeHandler.class.getName()};
    private static final String[] REGISTER_FS_ELEMENT_CHANGE_HANDLER_PATH_SIGNATURE = new String[]{String.class.getName(), IElementChangeHandler.class.getName()};
    private static final String[] UNREGISTER_FS_ELEMENT_CHANGE_HANDLER_SIGNATURE = new String[]{IElementChangeHandler.class.getName()};
    private static final String[] UNREGISTER_NAME_CHANGE_HANDLER_SIGNATURE = new String[]{INameChangeHandler.class.getName()};
    private static final String[] UNREGISTER_FS_ELEMENT_CHANGE_HANDLER_PATH_SIGNATURE = new String[]{String.class.getName(), IElementChangeHandler.class.getName()};
    private static final String[] GET_REFERENCES_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] REPAIR_REFERENCES_SIGNATURE = new String[]{String[].class.getName()};
    private static final String[] SET_BACK_REFERENCE_TYPES_SIGNATURE = new String[]{String[].class.getName()};
    private static final String[] ONLINE_BACKUP_SIGNATURE = new String[]{String.class.getName(), Boolean.class.getName()};
    private static final String[] GET_DOMAIN_ELEMENT_SIGNATURE = new String[]{Boolean.class.getName()};
    private static final String[] SET_DOMAIN_ELEMENT_SIGNATURE = new String[]{IDeltaDirElement.class.getName()};
    private static final String[] SUSPEND_CHANGE_NOTIFICATIONS_SIGNATURE = new String[]{String.class.getName(), String[].class.getName()};
    private static final String[] RESUME_CHANGE_NOTIFICATIONS_SIGNATURE = new String[]{String.class.getName()};

    public DirectoryServiceProxy(IRemoteMBeanServer server, ObjectName dsName) {
        this.m_server = server;
        this.m_dsName = dsName;
    }

    private synchronized void createChangeNotificationListener() {
        if (this.m_changeNotificationListener != null) {
            return;
        }
        this.m_changeNotificationListener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                if (notification.getType().equals(DirectoryServiceProxy.CONFIG_CHANGE_NOTIFICATION_TYPE)) {
                    INotification mfNotification = (INotification)((Object)notification);
                    IBasicElement[] elements = (IBasicElement[])mfNotification.getAttributes().get("Elements");
                    DirectoryServiceProxy.this.handleElementChange(elements);
                }
            }
        };
        this.addNotificationListener(CONFIG_CHANGE_NOTIFICATION_TYPE, this.m_changeNotificationListener);
    }

    private synchronized void createFSChangeNotificationListener() {
        if (this.m_FSChangeNotificationListener != null) {
            return;
        }
        this.m_FSChangeNotificationListener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                if (notification.getType().equals(DirectoryServiceProxy.CONFIG_FSCHANGE_NOTIFICATION_TYPE)) {
                    INotification mfNotification = (INotification)((Object)notification);
                    IBasicElement[] elements = (IBasicElement[])mfNotification.getAttributes().get("Elements");
                    DirectoryServiceProxy.this.handleFSElementChange(elements);
                }
            }
        };
        this.addNotificationListener(CONFIG_FSCHANGE_NOTIFICATION_TYPE, this.m_FSChangeNotificationListener);
    }

    private synchronized void createNamingNotificationListener() {
        if (this.m_namingListener != null) {
            return;
        }
        this.m_namingListener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                if (notification.getType().equals(DirectoryServiceProxy.CONFIG_NAMING_NOTIFICATION_TYPE)) {
                    INotification mfNotification = (INotification)((Object)notification);
                    ArrayList notifications = (ArrayList)mfNotification.getAttributes().get("Elements");
                    DirectoryServiceProxy.this.handleNamingChange(notifications);
                }
            }
        };
        this.addNotificationListener(CONFIG_NAMING_NOTIFICATION_TYPE, this.m_namingListener);
    }

    private void addNotificationListener(String CONFIG_FSCHANGE_NOTIFICATION_TYPE, NotificationListener m_FSChangeNotificationListener) {
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(CONFIG_FSCHANGE_NOTIFICATION_TYPE);
        try {
            this.m_server.addNotificationListener(this.m_dsName, m_FSChangeNotificationListener, (NotificationFilter)filter, null);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    private synchronized void destroyChangeNotificationListener() {
        if (this.m_changeNotificationListener == null) {
            return;
        }
        try {
            this.m_server.removeNotificationListener(this.m_dsName, this.m_changeNotificationListener);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
    }

    private synchronized void destroyFSChangeNotificationListener() {
        if (this.m_FSChangeNotificationListener == null) {
            return;
        }
        try {
            this.m_server.removeNotificationListener(this.m_dsName, this.m_FSChangeNotificationListener);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
    }

    private synchronized void destroyNameChangeNotificationListener() {
        if (this.m_namingListener == null) {
            return;
        }
        try {
            this.m_server.removeNotificationListener(this.m_dsName, this.m_namingListener);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerElementChangeHandler(IElementChangeHandler handler) {
        HashSet hashSet = this.m_globalChangeHandlers;
        synchronized (hashSet) {
            this.m_globalChangeHandlers.add(handler);
            this.createChangeNotificationListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerElementChangeHandler(String elementName, IElementChangeHandler handler) {
        HashMap hashMap = this.m_elementChangeHandlers;
        synchronized (hashMap) {
            HashSet<IElementChangeHandler> handlers = (HashSet<IElementChangeHandler>)this.m_elementChangeHandlers.get(elementName);
            if (handlers == null) {
                handlers = new HashSet<IElementChangeHandler>();
            }
            handlers.add(handler);
            this.m_elementChangeHandlers.put(elementName, handlers);
            this.createChangeNotificationListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterElementChangeHandler(IElementChangeHandler handler) {
        HashSet hashSet = this.m_globalChangeHandlers;
        synchronized (hashSet) {
            this.m_globalChangeHandlers.remove(handler);
            DirectoryServiceProxy directoryServiceProxy = this;
            synchronized (directoryServiceProxy) {
                this.destroyChangeNotificationListenerCheckingHandlers();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterElementChangeHandler(String elementName, IElementChangeHandler handler) {
        HashMap hashMap = this.m_elementChangeHandlers;
        synchronized (hashMap) {
            HashSet handlers = (HashSet)this.m_elementChangeHandlers.get(elementName);
            if (handlers == null) {
                return;
            }
            handlers.remove(handler);
            if (handlers.isEmpty()) {
                this.m_elementChangeHandlers.remove(elementName);
            } else {
                this.m_elementChangeHandlers.put(elementName, handlers);
            }
            DirectoryServiceProxy directoryServiceProxy = this;
            synchronized (directoryServiceProxy) {
                this.destroyChangeNotificationListenerCheckingHandlers();
            }
        }
    }

    private void destroyChangeNotificationListenerCheckingHandlers() {
        if (this.m_globalChangeHandlers.isEmpty() && this.m_elementChangeHandlers.isEmpty()) {
            this.destroyChangeNotificationListener();
        }
    }

    public void handleElementChange(IBasicElement[] elements) {
        this.handleGenericEelementChange(this.m_globalChangeHandlers, this.m_elementChangeHandlers, elements);
    }

    public void handleFSElementChange(IBasicElement[] elements) {
        this.handleGenericEelementChange(this.m_globalFSChangeHandlers, this.m_FSElementChangeHandlers, elements);
    }

    private void handleGenericEelementChange(HashSet m_globalFSChangeHandlers, HashMap m_FSElementChangeHandlers, IBasicElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            boolean reportChange = true;
            boolean replacement = false;
            IBasicElement currentElement = elements[i];
            if (currentElement instanceof IEnvelope) {
                IEnvelope envelope = (IEnvelope)((Object)currentElement);
                reportChange = envelope.getProperty("DRE") == null;
                replacement = envelope.getProperty("R") != null;
                currentElement = envelope.getEnvelopedElement();
            }
            if (!reportChange) continue;
            ElementChange elementChange = new ElementChange(currentElement, replacement);
            HashSet handlers = (HashSet)m_globalFSChangeHandlers.clone();
            String elementName = currentElement.getIdentity().getName();
            HashSet elementHandlers = (HashSet)m_FSElementChangeHandlers.get(elementName);
            DirectoryServiceProxy.findElementHandlersAndAdd(elementChange, elementHandlers, handlers);
        }
    }

    private static void findElementHandlersAndAdd(IElementChange elementChange, HashSet elementHandlers, HashSet handlers) {
        if (elementHandlers != null) {
            Iterator iterator = elementHandlers.iterator();
            while (iterator.hasNext()) {
                handlers.add(iterator.next());
            }
        }
        for (IElementChangeHandler handler : handlers) {
            handler.handleElementChange(elementChange);
        }
    }

    public void handleNamingChange(ArrayList notifications) {
        for (int i = 0; i < notifications.size(); ++i) {
            INamingNotification currentNotification = (INamingNotification)notifications.get(i);
            HashSet handlers = (HashSet)this.m_nameChangeHandlers.clone();
            for (INameChangeHandler handler : handlers) {
                handler.onNamingNotification(currentNotification);
            }
        }
    }

    @Override
    public String getDomain() {
        try {
            StringTokenizer st = new StringTokenizer(this.m_dsName.getDomain(), ".");
            return st.nextToken();
        }
        catch (Exception e) {
            Exception mappedException = this.mapException(e);
            this.checkIsManagementPermissionDeniedException(mappedException);
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getDomain failed: " + mappedException.toString());
        }
    }

    public int retryGetDirectoryServiceVersion() throws DirectoryServiceException {
        Integer version = (Integer)this.invokeContinuously("getDirectoryServiceVersion", new Object[0], new String[0]);
        return version;
    }

    public boolean isEnterpriseEnabled() {
        return this.m_server instanceof JMSConnectorClient && ((JMSConnectorClient)this.m_server).isEnterpriseEnabled();
    }

    @Override
    public int getDirectoryServiceVersion() {
        try {
            return (Integer)this.m_server.invoke(this.m_dsName, "getDirectoryServiceVersion", new Object[0], new String[0]);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(this.mapException(e), "DirectoryServiceProxy.getDirectoryServiceVersion failed: " + e.toString());
        }
    }

    @Override
    public String getDirectoryServiceReleaseVersion() {
        try {
            return (String)this.m_server.invoke(this.m_dsName, "getDirectoryServiceReleaseVersion", new Object[0], new String[0]);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(this.mapException(e), "DirectoryServiceProxy.getDirectoryServiceReleaseVersion failed: " + e.toString());
        }
    }

    @Override
    public IView getView() throws DirectoryServiceException {
        try {
            return (IView)this.m_server.invoke(this.m_dsName, "getView", new Object[0], new String[0]);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getView failed: " + mappedException.toString());
        }
    }

    @Override
    public IView setView(IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (IView)this.m_server.invoke(this.m_dsName, "setView", new Object[]{view}, SET_VIEW_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.setView failed: " + mappedException.toString());
        }
    }

    @Override
    public INextVersionToken setViewGetToken(IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (INextVersionToken)this.m_server.invoke(this.m_dsName, "setViewGetToken", new Object[]{view}, SET_VIEW_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.setViewGetToken failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement getElement(String elementName, boolean forUpdate) throws DirectoryServiceException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "getElement", new Object[]{elementName, new Boolean(forUpdate)}, GET_ELEMENT_SIGNATURE1);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getElement failed: " + mappedException.toString());
        }
    }

    public IDirElement[] retryGetElementIfUpdated(long callerBackupVersion, String elementName, IElementIdentity id) throws DirectoryServiceException {
        return (IDirElement[])this.invokeContinuously("getElementIfUpdated", new Object[]{new Long(callerBackupVersion), elementName, id}, GET_ELEMENT_IFUPDATED_SIGNATURE1);
    }

    @Override
    public IDirElement[] getElementIfUpdated(long callerBackupVersion, String elementName, IElementIdentity id) throws DirectoryServiceException {
        try {
            return (IDirElement[])this.m_server.invoke(this.m_dsName, "getElementIfUpdated", new Object[]{new Long(callerBackupVersion), elementName, id}, GET_ELEMENT_IFUPDATED_SIGNATURE1);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getElementIfUpdated failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement getElement(String elementName, boolean forUpdate, boolean getSubclassingDelta) throws DirectoryServiceException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "getElement", new Object[]{elementName, new Boolean(forUpdate), new Boolean(getSubclassingDelta)}, GET_ELEMENT_SIGNATURE3);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getElement failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement[] getElements(Query query, boolean forUpdate) throws DirectoryServiceException {
        try {
            return (IDirElement[])this.m_server.invoke(this.m_dsName, "getElements", new Object[]{query, new Boolean(forUpdate)}, GET_ELEMENTS_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getElements failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement[] getElements(Query query, boolean forUpdate, boolean getSubclassingDelta) throws DirectoryServiceException {
        try {
            return (IDirElement[])this.m_server.invoke(this.m_dsName, "getElements", new Object[]{query, new Boolean(forUpdate), new Boolean(getSubclassingDelta)}, GET_ELEMENTS1_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getElements failed: " + mappedException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String logicalToStorage(String logicalPath) throws DirectoryServiceException {
        try {
            HashSet hashSet = this.m_nameChangeHandlers;
            synchronized (hashSet) {
                this.setupNamingCache();
                String storageName = this.m_logicalStorageMap.logicalToStorage(logicalPath);
                if (storageName == null) {
                    storageName = (String)this.m_server.invoke(this.m_dsName, "logicalToStorage", new Object[]{logicalPath}, LOGICAL_TO_STORAGE_SIGNATURE);
                    this.m_logicalStorageMap.set(logicalPath, storageName);
                }
                return storageName;
            }
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.logicalToStorage failed: " + mappedException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String storageToLogical(String storageName) throws DirectoryServiceException {
        try {
            HashSet hashSet = this.m_nameChangeHandlers;
            synchronized (hashSet) {
                this.setupNamingCache();
                String logicalPath = this.m_logicalStorageMap.storageToLogical(storageName);
                if (logicalPath == null) {
                    logicalPath = (String)this.m_server.invoke(this.m_dsName, "storageToLogical", new Object[]{storageName}, STORAGE_TO_LOGICAL_SIGNATURE);
                    this.m_logicalStorageMap.set(logicalPath, storageName);
                }
                return logicalPath;
            }
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.storageToLogical failed: " + mappedException.toString());
        }
    }

    @Override
    public IBlob getBlob(String elementName, boolean forUpdate) throws DirectoryServiceException {
        try {
            IBlob blob = (IBlob)this.m_server.invoke(this.m_dsName, "getBlob", new Object[]{elementName, new Boolean(forUpdate)}, GET_ELEMENT_SIGNATURE1);
            return this.createBlob(blob);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getBlob failed: " + mappedException.toString());
        }
    }

    public void setBackupState(boolean setBackup) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "setBackupState", new Object[]{new Boolean(setBackup)}, SET_BACKUP_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.setBackupState failed: " + mappedException.toString());
        }
    }

    @Override
    public void detachBlob(IDeltaDirElement delta, IDeltaView view) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "detachBlob", new Object[]{delta, view}, DETACH_BLOB_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.detachBlob failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement[] getAllElements(String dirName, boolean forUpdate) throws DirectoryServiceException {
        try {
            return (IDirElement[])this.m_server.invoke(this.m_dsName, "getAllElements", new Object[]{dirName, new Boolean(forUpdate)}, GET_ALL_ELEMENTS_SIGNATURE1);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getAllElements failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement[] getAllElementsCompressed(String dirName, boolean forUpdate) throws DirectoryServiceException {
        try {
            byte[] bytes = (byte[])this.m_server.invoke(this.m_dsName, "getAllElementsCompressed", new Object[]{dirName, new Boolean(forUpdate)}, GET_ALL_ELEMENTS_SIGNATURE1);
            return ZipUtils.fromZippedBytes(bytes);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getAllElementsCompressed failed: " + mappedException.toString());
        }
    }

    @Override
    public INextVersionToken setElement(IBasicElement element, IDeltaView view) throws DirectoryServiceException {
        try {
            return (INextVersionToken)this.m_server.invoke(this.m_dsName, "setElement", new Object[]{element, view}, SET_ELEMENT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.setElement failed: " + mappedException.toString());
        }
    }

    @Override
    public void setElementReleaseVersion(String elementName, String newVersion) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "setElementReleaseVersion", new Object[]{elementName, newVersion}, SET_ELEMENT_RELVERS_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.setElementReleaseVersion failed: " + mappedException.toString());
        }
    }

    @Override
    public INextVersionToken setElements(IBasicElement[] elements, String[] deleteList, IDeltaView view) throws DirectoryServiceException {
        try {
            return (INextVersionToken)this.m_server.invoke(this.m_dsName, "setElements", new Object[]{elements, deleteList, view}, SET_ELEMENTS_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.setElements failed: " + mappedException.toString());
        }
    }

    @Override
    public void upgrade5to6(String configType, String configLogicalPath) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "upgrade5to6", new Object[]{configType, configLogicalPath}, UPGRADE56_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.upgrade5to6 failed: " + mappedException.toString());
        }
    }

    @Override
    public void attachBlob(IBasicElement element, InputStream blobStream, IDeltaView view) throws DirectoryServiceException {
        if (blobStream == null) {
            throw new DirectoryServiceException("The blob stream object cannot be null.");
        }
        try {
            BufferedInputStream bStream = new BufferedInputStream(blobStream, 1000000);
            int src = 0;
            int readIn = 0;
            while (readIn != -1) {
                int chunkIndex = 0;
                ByteArrayOutputStream oStream = new ByteArrayOutputStream();
                while (chunkIndex < 1000000 && readIn != -1) {
                    readIn = bStream.read();
                    if (readIn == -1) continue;
                    oStream.write(readIn);
                    ++chunkIndex;
                }
                oStream.close();
                byte[] blobPiece = oStream.toByteArray();
                this.m_server.invoke(this.m_dsName, "appendBlob", new Object[]{element, blobPiece, new Integer(src), new Boolean(readIn == -1), view}, APPEND_BLOB_SIGNATURE);
                src += blobPiece.length;
            }
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.attachBlob failed: " + mappedException.toString());
        }
    }

    @Override
    public void attachBlob(IBasicElement element, byte[] blob, IDeltaView view) throws DirectoryServiceException {
        if (blob == null) {
            throw new DirectoryServiceException("The blob object cannot be null.");
        }
        try {
            this.m_server.invoke(this.m_dsName, "attachBlob", new Object[]{element, blob, view}, ATTACH_BLOB_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.attachBlob failed: " + mappedException.toString());
        }
    }

    @Override
    public IElementIdentity deleteElement(String elementName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (IElementIdentity)this.m_server.invoke(this.m_dsName, "deleteElement", new Object[]{elementName, view}, DELETE_ELEMENT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.deleteElement failed: " + mappedException.toString());
        }
    }

    @Override
    public void unSubclassElement(String elementName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            this.m_server.invoke(this.m_dsName, "unSubclassElement", new Object[]{elementName, view}, DELETE_ELEMENT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.unsubclassElement failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement cloneElement(String elementName, String newName, IDeltaView view) throws DirectoryServiceException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "cloneElement", new Object[]{elementName, newName, view}, CLONE_ELEMENT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.cloneElement failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement cloneElement(IBasicElement delta, String newName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "cloneElement", new Object[]{delta, newName, view}, CLONE_ELEMENT1_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.cloneElement failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement cloneElement(String elementName, String newName, boolean createTemplate, IDeltaView view) throws DirectoryServiceException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "cloneElement", new Object[]{elementName, newName, new Boolean(createTemplate), view}, CLONE_ELEMENT2_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.cloneElement failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement cloneElement(IBasicElement delta, String newName, boolean createTemplate, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "cloneElement", new Object[]{delta, newName, new Boolean(createTemplate), view}, CLONE_ELEMENT3_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.cloneElement failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement subclassElement(IBasicElement delta, String newName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "subclassElement", new Object[]{delta, newName, view}, CLONE_ELEMENT1_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.subclassElement failed: " + mappedException.toString());
        }
    }

    @Override
    public IIdentity getIdentity(String name) throws DirectoryServiceException {
        try {
            return (IIdentity)this.m_server.invoke(this.m_dsName, "getIdentity", new Object[]{name}, GET_IDENTITY_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getIdentity failed: " + mappedException.toString());
        }
    }

    @Override
    public IIdentity lookupIdentity(String name) throws DirectoryServiceException {
        try {
            return (IIdentity)this.m_server.invoke(this.m_dsName, "lookupIdentity", new Object[]{name}, LOOKUP_IDENTITY_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.lookupIdentity failed: " + mappedException.toString());
        }
    }

    @Override
    public IIdentity[] listAll(String dirName) throws DirectoryServiceException {
        try {
            return (IIdentity[])this.m_server.invoke(this.m_dsName, "listAll", new Object[]{dirName}, LIST_ALL_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.listAll failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirIdentity[] listDirectories(String dirName) throws DirectoryServiceException {
        try {
            return (IDirIdentity[])this.m_server.invoke(this.m_dsName, "listDirectories", new Object[]{dirName}, LIST_DIRECTORIES_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.listDirectories failed: " + mappedException.toString());
        }
    }

    @Override
    public IElementIdentity[] listElements(String dirName) throws DirectoryServiceException {
        try {
            return (IElementIdentity[])this.m_server.invoke(this.m_dsName, "listElements", new Object[]{dirName}, LIST_ELEMENTS_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.listElements failed: " + mappedException.toString());
        }
    }

    @Override
    public void createDirectory(String dirName) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "createDirectory", new Object[]{dirName}, CREATE_DIRECTORY_SIGNATURE1);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.createDirectory failed: " + mappedException.toString());
        }
    }

    @Override
    public void deleteDirectory(String dirName) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "deleteDirectory", new Object[]{dirName}, DELETE_DIRECTORY_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.deleteDirectory failed: " + mappedException.toString());
        }
    }

    @Override
    public void deleteDirectory(String dirName, IDeltaView view) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "deleteDirectory", new Object[]{dirName, view}, DELETE_DIRECTORY1_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.deleteDirectory failed: " + mappedException.toString());
        }
    }

    @Override
    public String exportElementToXML(String elementName) throws DirectoryServiceException {
        try {
            return (String)this.m_server.invoke(this.m_dsName, "exportElementToXML", new Object[]{elementName}, EXPORT_ELEMENT_TO_XML_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.exportElementToXML failed: " + mappedException.toString());
        }
    }

    @Override
    public String exportDSBootFileString(String elementName) throws DirectoryServiceException {
        try {
            return (String)this.m_server.invoke(this.m_dsName, "exportDSBootFileString", new Object[]{elementName}, EXPORT_ELEMENT_TO_XML_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.exportDSBootFileString failed: " + mappedException.toString());
        }
    }

    @Override
    public String exportDirectoryToXML(String directoryName) throws DirectoryServiceException {
        try {
            return (String)this.m_server.invoke(this.m_dsName, "exportDirectoryToXML", new Object[]{directoryName}, EXPORT_DIRECTORY_TO_XML_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            this.checkIsManagementPermissionDeniedException(mappedException);
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.exportDirectoryToXML failed: " + mappedException.toString());
        }
    }

    @Override
    public void dumpContentsToXML() {
        try {
            this.m_server.invoke(this.m_dsName, "dumpContentsToXML", IEmptyArray.EMPTY_OBJECT_ARRAY, IEmptyArray.EMPTY_STRING_ARRAY);
        }
        catch (Exception e) {
            Exception mappedException = this.mapException(e);
            this.checkIsManagementPermissionDeniedException(mappedException);
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.dumpContentsToXML failed: " + mappedException.toString());
        }
    }

    @Override
    public void importFromXML(String XMLDocument) throws DirectoryServiceException, InvalidXMLException {
        try {
            this.m_server.invoke(this.m_dsName, "importFromXML", new Object[]{XMLDocument}, IMPORT_FROM_XML_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof InvalidXMLException) {
                throw (InvalidXMLException)mappedException;
            }
            this.checkIsManagementPermissionDeniedException(mappedException);
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.importFromXML failed: " + mappedException.toString());
        }
    }

    private Exception mapException(Exception exception) {
        Class<?> exceptionClass = exception.getClass();
        Method getTargetExceptionMethod = null;
        try {
            getTargetExceptionMethod = exceptionClass.getMethod("getTargetException", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            return exception;
        }
        Object exceptionObject = null;
        try {
            exceptionObject = getTargetExceptionMethod.invoke((Object)exception, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error extracting target exception");
        }
        if (exceptionObject == null) {
            return exception;
        }
        return this.mapException((Exception)exceptionObject);
    }

    @Override
    public void defineFolderMetaAttributes(String[] attributeNames) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "defineFolderMetaAttributes", new Object[]{attributeNames}, DEFINE_FOLDER_META_ATTRIBUTES_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.defineFolderMetaAttributes failed: " + mappedException.toString());
        }
    }

    @Override
    public String[] getDefinedFolderMetaAttributes() throws DirectoryServiceException {
        try {
            return (String[])this.m_server.invoke(this.m_dsName, "getDefinedFolderMetaAttributes", new Object[0], new String[0]);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getDefinedFolderMetaAttributes failed: " + mappedException.toString());
        }
    }

    @Override
    public void defineElementMetaAttributes(String[] attributeNames) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "defineElementMetaAttributes", new Object[]{attributeNames}, DEFINE_ELEMENT_META_ATTRIBUTES_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.defineElementsMetaAttributes failed: " + mappedException.toString());
        }
    }

    @Override
    public String[] getDefinedElementMetaAttributes() throws DirectoryServiceException {
        try {
            return (String[])this.m_server.invoke(this.m_dsName, "getDefinedElementMetaAttributes", new Object[0], new String[0]);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getDefinedElementMetaAttributes failed: " + mappedException.toString());
        }
    }

    @Override
    public void rename(String oldPath, String newPath) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "rename", new Object[]{oldPath, newPath}, RENAME_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.rename failed: " + mappedException.toString());
        }
    }

    @Override
    public void renameFolder(String oldPath, String newPath) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "renameFolder", new Object[]{oldPath, newPath}, RENAME_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.renameFolder failed: " + mappedException.toString());
        }
    }

    @Override
    public void renameFile(String oldPath, String newPath) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "renameFile", new Object[]{oldPath, newPath}, RENAME_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.renameFile failed: " + mappedException.toString());
        }
    }

    @Override
    public void createFolder(String folderPath) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "createFolder", new Object[]{folderPath}, CREATE_FOLDER_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.createFolder failed: " + mappedException.toString());
        }
    }

    @Override
    public void copyFiles(String fromPath, String toPath) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "copyFiles", new Object[]{fromPath, toPath}, COPY_FILES_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.copyFiles failed: " + mappedException.toString());
        }
    }

    @Override
    public void createFolder(String folderPath, boolean existingOk) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "createFolder", new Object[]{folderPath, new Boolean(existingOk)}, CREATE_FOLDER_EXISTING_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.createFolder failed: " + mappedException.toString());
        }
    }

    @Override
    public void deleteFolder(String folderPath) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "deleteFolder", new Object[]{folderPath}, DELETE_FOLDER_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.deleteFolder failed: " + mappedException.toString());
        }
    }

    @Override
    public HashMap[] listAllFolders() throws DirectoryServiceException {
        try {
            return (HashMap[])this.m_server.invoke(this.m_dsName, "listAllFolders", IEmptyArray.EMPTY_OBJECT_ARRAY, IEmptyArray.EMPTY_STRING_ARRAY);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.listAllFolders failed: " + mappedException.toString());
        }
    }

    @Override
    public HashMap[] listFolders(String folderPath) throws DirectoryServiceException {
        try {
            return (HashMap[])this.m_server.invoke(this.m_dsName, "listFolders", new Object[]{folderPath}, LIST_FOLDERS_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.listFolders failed: " + mappedException.toString());
        }
    }

    @Override
    public HashMap[] listFSAll(String path) throws DirectoryServiceException {
        try {
            return (HashMap[])this.m_server.invoke(this.m_dsName, "listFSAll", new Object[]{path}, LIST_FS_ALL_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.listFSAll failed: " + mappedException.toString());
        }
    }

    @Override
    public HashMap[] listFSAll(String path, boolean getFolders, String extension) throws DirectoryServiceException {
        try {
            return (HashMap[])this.m_server.invoke(this.m_dsName, "listFSAll", new Object[]{path, new Boolean(getFolders), extension}, LIST_FS_ALL_FOLDERS_EXT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.listFSAll failed: " + mappedException.toString());
        }
    }

    @Override
    public ArrayList<HashMap> recursiveList(String path, boolean getFolders, boolean getElements, String extension) throws DirectoryServiceException {
        try {
            return (ArrayList)this.m_server.invoke(this.m_dsName, "recursiveList", new Object[]{path, new Boolean(getFolders), new Boolean(getElements), extension}, RECURSIVE_LIST_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.recursiveList failed: " + mappedException.toString());
        }
    }

    @Override
    public HashMap[] listFSElements(String folderPath) throws DirectoryServiceException {
        try {
            return (HashMap[])this.m_server.invoke(this.m_dsName, "listFSElements", new Object[]{folderPath}, LIST_FS_ELEMENTS_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.listFSElements failed: " + mappedException.toString());
        }
    }

    @Override
    public void setMetaAttributes(String path, HashMap attributes) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "setMetaAttributes", new Object[]{path, attributes}, SET_META_ATTRIBUTES_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.setMetaAttributes failed: " + mappedException.toString());
        }
    }

    @Override
    public HashMap getMetaAttributes(String path) throws DirectoryServiceException {
        try {
            return (HashMap)this.m_server.invoke(this.m_dsName, "getMetaAttributes", new Object[]{path}, GET_META_ATTRIBUTES_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getMetaAttributes failed: " + mappedException.toString());
        }
    }

    @Override
    public void setStorageHint(String elementType, String directoryPath) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "setStorageHint", new Object[]{elementType, directoryPath}, SET_STORAGE_HINT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.setStorageHint failed: " + mappedException.toString());
        }
    }

    @Override
    public void setStorageHint(String elementType, String postfix, String directoryPath) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "setStorageHint", new Object[]{elementType, postfix, directoryPath}, SET_STORAGE_HINT_POSTFIX_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.setStorageHint failed: " + mappedException.toString());
        }
    }

    @Override
    public void setComplexStorageHint(String elementType, String directoryPath) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "setComplexStorageHint", new Object[]{elementType, directoryPath}, SET_COMPLEX_STORAGE_HINT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.setComplexStorageHint failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement[] getFSElements(Query query, boolean forUpdate, boolean getSubclassingDelta) throws DirectoryServiceException {
        try {
            return (IDirElement[])this.m_server.invoke(this.m_dsName, "getFSElements", new Object[]{query, new Boolean(forUpdate), new Boolean(getSubclassingDelta)}, GET_FS_ELEMENTS_DELTA_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.mapException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            if (mappedException instanceof DirectoryServiceException) {
                throw (DirectoryServiceException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getFSElements failed: " + mappedException.toString());
        }
    }

    @Override
    public QueryBatch getFSElements(Query query, boolean forUpdate, boolean getSubclassingDelta, QueryBatch batch) throws DirectoryServiceException {
        try {
            return (QueryBatch)this.m_server.invoke(this.m_dsName, "getFSElements", new Object[]{query, new Boolean(forUpdate), new Boolean(getSubclassingDelta), batch}, GET_FS_ELEMENTS_BATCH_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.mapException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            if (mappedException instanceof DirectoryServiceException) {
                throw (DirectoryServiceException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getFSElements failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement[] getFSElements(Query query, boolean forUpdate) throws DirectoryServiceException {
        try {
            return (IDirElement[])this.m_server.invoke(this.m_dsName, "getFSElements", new Object[]{query, new Boolean(forUpdate)}, GET_FS_ELEMENTS_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getFSElements failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement getFSElement(String elementPath, boolean forUpdate) throws DirectoryServiceException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "getFSElement", new Object[]{elementPath, new Boolean(forUpdate)}, GET_FS_ELEMENT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getFSElement failed: " + mappedException.toString());
        }
    }

    public IElement[] getCreateContainerConfiguration(String containerPath, String adPath, String hmPath, Hashtable defaultContainerParams, Hashtable defaultConnectionParams) throws DirectoryServiceException {
        try {
            return (IElement[])this.m_server.invoke(this.m_dsName, "getCreateContainerConfiguration", new Object[]{containerPath, adPath, hmPath, defaultContainerParams, defaultConnectionParams}, GET_CREATE_CONTAINER_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getCreateContainerConfiguration failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement[] getFSElements(String folderPath, boolean forUpdate) throws DirectoryServiceException {
        try {
            return (IDirElement[])this.m_server.invoke(this.m_dsName, "getFSElements", new Object[]{folderPath, new Boolean(forUpdate)}, GET_FS_ELEMENTS_STRING_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getFSElements failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement getFSElement(String elementPath, boolean forUpdate, boolean getSubclassingDelta) throws DirectoryServiceException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "getFSElement", new Object[]{elementPath, new Boolean(forUpdate), new Boolean(getSubclassingDelta)}, GET_FS_ELEMENT_DELTA_STRING_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getFSElement failed: " + mappedException.toString());
        }
    }

    @Override
    public IElementIdentity getFSIdentity(String elementPath) throws DirectoryServiceException {
        try {
            return (IElementIdentity)this.m_server.invoke(this.m_dsName, "getFSIdentity", new Object[]{elementPath}, GET_FS_IDENTITY_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getFSIdentity failed: " + mappedException.toString());
        }
    }

    @Override
    public IElementIdentity deleteFSElement(String elementName) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (IElementIdentity)this.m_server.invoke(this.m_dsName, "deleteFSElement", new Object[]{elementName}, DELETE_FS_ELEMENT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.deleteFSElement failed: " + mappedException.toString());
        }
    }

    @Override
    public INextVersionToken createFSElement(IDirElement element) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (INextVersionToken)this.m_server.invoke(this.m_dsName, "createFSElement", new Object[]{element}, CREATE_FS_ELEMENT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.createFSElement failed: " + mappedException.toString());
        }
    }

    @Override
    public INextVersionToken updateFSElement(IDeltaDirElement element) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (INextVersionToken)this.m_server.invoke(this.m_dsName, "updateFSElement", new Object[]{element}, UPDATE_FS_ELEMENT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.updateFSElement failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement revertToTemplate(String elementName, AttributeName[] attributes) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "revertToTemplate", new Object[]{elementName, attributes}, REVERT_TO_TEMPLATE_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.revertToTemplate failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement cloneFSElement(String elementPath, String newElementPath) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "cloneFSElement", new Object[]{elementPath, newElementPath}, CLONE_FS_ELEMENT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.cloneFSElement failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement cloneFSBlob(String fromElementName, String toElementName) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "cloneFSBlob", new Object[]{fromElementName, toElementName}, CLONE_FS_BLOB_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.cloneFSBlob failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement cloneFSElement(IBasicElement delta, String newElementPath) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "cloneFSElement", new Object[]{delta, newElementPath}, CLONE_FS_ELEMENT_DELTA_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.cloneFSElement failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement cloneFSElement(String elementPath, String newElementPath, boolean createTemplate) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "cloneFSElement", new Object[]{elementPath, newElementPath, new Boolean(createTemplate)}, CLONE_FS_ELEMENT_TEMPLATE_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.cloneFSElement failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement cloneFSElement(IBasicElement delta, String newElementPath, boolean createTemplate) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "cloneFSElement", new Object[]{delta, newElementPath, new Boolean(createTemplate)}, CLONE_FS_ELEMENT_DELTA_TEMPLATE_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.cloneFSElement failed: " + mappedException.toString());
        }
    }

    @Override
    public void attachFSBlob(IBasicElement element, InputStream blobStream) throws DirectoryServiceException, VersionOutofSyncException {
        if (blobStream == null) {
            throw new DirectoryServiceException("The blob stream object cannot be null.");
        }
        try {
            BufferedInputStream bStream = new BufferedInputStream(blobStream, 1000000);
            int src = 0;
            int readIn = 0;
            while (readIn != -1) {
                int chunkIndex = 0;
                ByteArrayOutputStream oStream = new ByteArrayOutputStream();
                while (chunkIndex < 1000000 && readIn != -1) {
                    readIn = bStream.read();
                    if (readIn == -1) continue;
                    oStream.write(readIn);
                    ++chunkIndex;
                }
                oStream.close();
                byte[] blobPiece = oStream.toByteArray();
                this.m_server.invoke(this.m_dsName, "appendFSBlob", new Object[]{element, blobPiece, new Integer(src), new Boolean(readIn == -1)}, APPEND_FS_BLOB_SIGNATURE);
                src += blobPiece.length;
            }
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.appendFSBlob failed: " + mappedException.toString());
        }
    }

    @Override
    public void attachFSBlob(IBasicElement element, byte[] blob) throws DirectoryServiceException, VersionOutofSyncException {
        if (blob == null) {
            throw new DirectoryServiceException("The blob object cannot be null.");
        }
        try {
            this.m_server.invoke(this.m_dsName, "attachFSBlob", new Object[]{element, blob}, ATTACH_FS_BLOB_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.attachFSBlob failed: " + mappedException.toString());
        }
    }

    @Override
    public IBlob getFSBlob(String elementPath, boolean forUpdate) throws DirectoryServiceException {
        try {
            IBlob blob = (IBlob)this.m_server.invoke(this.m_dsName, "getFSBlob", new Object[]{elementPath, new Boolean(forUpdate)}, GET_FS_BLOB_SIGNATURE);
            return this.createBlobWithLogical(blob);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getFSBlob failed: " + mappedException.toString());
        }
    }

    @Override
    public IBlob getFiles(String[] fileNames) throws DirectoryServiceException {
        try {
            IBlob stream = (IBlob)this.m_server.invoke(this.m_dsName, "getFiles", new Object[]{fileNames}, GET_FILES_SIGNATURE);
            return this.createClientBlob(stream);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getFiles failed: " + mappedException.toString());
        }
    }

    @Override
    public IBlob getFiles(String path, boolean recurse, String extension) throws DirectoryServiceException {
        try {
            IBlob stream = (IBlob)this.m_server.invoke(this.m_dsName, "getFiles", new Object[]{path, new Boolean(recurse), extension}, GET_FILES_EXT_SIGNATURE);
            return this.createClientBlob(stream);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getFiles failed: " + mappedException.toString());
        }
    }

    private IBlob createClientBlob(IBlob stream) {
        if (stream != null) {
            Blob clientBlob = new Blob(stream.getElement(), stream.getBlobBytes(), this);
            clientBlob.setLogical(true);
            return clientBlob;
        }
        return null;
    }

    @Override
    public IBlob getFSBlob(String elementPath, boolean forUpdate, int offset) throws DirectoryServiceException {
        try {
            IBlob blob = (IBlob)this.m_server.invoke(this.m_dsName, "getFSBlob", new Object[]{elementPath, new Boolean(forUpdate), new Integer(offset)}, GET_FS_BLOB_PARTIAL_SIGNATURE);
            return this.createBlobWithLogical(blob);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getFSBlob failed: " + mappedException.toString());
        }
    }

    private IBlob createBlobWithLogical(IBlob blobParam) {
        IBlob blob = blobParam;
        if (blob == null) {
            return null;
        }
        blob = new Blob(blob.getElement(), blob.getBlobBytes(), this);
        blob.setLogical(true);
        return blob;
    }

    @Override
    public IBlob getBlob(String elementName, boolean forUpdate, int offset) throws DirectoryServiceException {
        try {
            IBlob blob = (IBlob)this.m_server.invoke(this.m_dsName, "getBlob", new Object[]{elementName, new Boolean(forUpdate), new Integer(offset)}, GET_PARTIAL_BLOB_SIGNATURE);
            return this.createBlob(blob);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getBlob failed: " + mappedException.toString());
        }
    }

    private IBlob createBlob(IBlob blob) {
        if (blob == null) {
            return null;
        }
        return new Blob(blob.getElement(), blob.getBlobBytes(), this);
    }

    @Override
    public void detachFSBlob(IDeltaDirElement delta) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            this.m_server.invoke(this.m_dsName, "detachFSBlob", new Object[]{delta}, DETACH_FS_BLOB_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.detachFSBlob failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement subclassFSElement(IBasicElement delta, String newElementPath) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "subclassFSElement", new Object[]{delta, newElementPath}, SUBCLASS_FS_ELEMENT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.subclassFSElement failed: " + mappedException.toString());
        }
    }

    @Override
    public void unSubclassFSElement(String elementPath) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            this.m_server.invoke(this.m_dsName, "unSubclassFSElement", new Object[]{elementPath}, UN_SUBCLASS_FS_ELEMENT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.unsubclassFSElement failed: " + mappedException.toString());
        }
    }

    @Override
    public IDSTransaction createTransaction() {
        return new DSTransaction();
    }

    @Override
    public INextVersionToken executeTransaction(IDSTransaction transaction) throws DirectoryServiceException, VersionOutofSyncException {
        String actionName = null;
        try {
            int i;
            ArrayList actions = ((DSTransaction)transaction).getActions();
            Vector removeAttachActions = new Vector();
            Vector<AppendBlob> addAppendActions = new Vector<AppendBlob>();
            for (i = 0; i < actions.size(); ++i) {
                Object action = actions.get(i);
                if (!(action instanceof DSTransaction.AttachBlob)) continue;
                actionName = "AttachBlob";
                removeAttachActions.add(action);
                DSTransaction.AttachBlob attach = (DSTransaction.AttachBlob)action;
                InputStream blobStream = attach.m_stream;
                IBasicElement blobElement = attach.m_element;
                BufferedInputStream bStream = new BufferedInputStream(blobStream, 1000000);
                int src = 0;
                int readIn = 0;
                while (readIn != -1) {
                    int chunkIndex = 0;
                    ByteArrayOutputStream oStream = new ByteArrayOutputStream();
                    while (chunkIndex < 1000000 && readIn != -1) {
                        readIn = bStream.read();
                        if (readIn == -1) continue;
                        oStream.write(readIn);
                        ++chunkIndex;
                    }
                    oStream.close();
                    byte[] blobPiece = oStream.toByteArray();
                    if (readIn == -1) {
                        addAppendActions.add(new AppendBlob(blobElement, blobPiece, src));
                    } else {
                        actionName = "appendFSBlob during AttachBlob";
                        this.m_server.invoke(this.m_dsName, "appendFSBlob", new Object[]{blobElement, blobPiece, new Integer(src), Boolean.FALSE}, APPEND_FS_BLOB_SIGNATURE);
                    }
                    src += blobPiece.length;
                }
            }
            actionName = null;
            for (i = 0; i < removeAttachActions.size(); ++i) {
                AppendBlob addAppendAction = (AppendBlob)addAppendActions.get(i);
                ((DSTransaction)transaction).addAppendBlob((DSTransaction.AttachBlob)removeAttachActions.get(i), addAppendAction.m_blob, addAppendAction.m_src);
            }
            return (INextVersionToken)this.m_server.invoke(this.m_dsName, "executeTransaction", new Object[]{transaction}, EXECUTE_TRANSACTION_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            String message = "";
            if (actionName != null) {
                message = actionName + " in DirectoryServiceProxy.executeTransaction failed: ";
            }
            throw new ProxyRuntimeException(mappedException, message + mappedException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFSElementChangeHandler(IElementChangeHandler handler) {
        HashSet hashSet = this.m_globalFSChangeHandlers;
        synchronized (hashSet) {
            this.m_globalFSChangeHandlers.add(handler);
            this.createFSChangeNotificationListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNameChangeHandler(INameChangeHandler handler) {
        HashSet hashSet = this.m_nameChangeHandlers;
        synchronized (hashSet) {
            this.m_nameChangeHandlers.add(handler);
            this.createNamingNotificationListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFSElementChangeHandler(String elementPath, IElementChangeHandler handler) {
        HashMap hashMap = this.m_FSElementChangeHandlers;
        synchronized (hashMap) {
            HashSet<IElementChangeHandler> handlers = (HashSet<IElementChangeHandler>)this.m_FSElementChangeHandlers.get(elementPath);
            if (handlers == null) {
                handlers = new HashSet<IElementChangeHandler>();
            }
            handlers.add(handler);
            this.m_FSElementChangeHandlers.put(elementPath, handlers);
            this.createFSChangeNotificationListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterFSElementChangeHandler(IElementChangeHandler handler) {
        HashSet hashSet = this.m_globalFSChangeHandlers;
        synchronized (hashSet) {
            this.m_globalFSChangeHandlers.remove(handler);
            DirectoryServiceProxy directoryServiceProxy = this;
            synchronized (directoryServiceProxy) {
                this.destroyFSChangeNotificationListenerCheckingHandlers();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterNameChangeHandler(INameChangeHandler handler) {
        HashSet hashSet = this.m_nameChangeHandlers;
        synchronized (hashSet) {
            this.m_nameChangeHandlers.remove(handler);
            DirectoryServiceProxy directoryServiceProxy = this;
            synchronized (directoryServiceProxy) {
                if (this.m_nameChangeHandlers.isEmpty()) {
                    this.destroyNameChangeNotificationListener();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterFSElementChangeHandler(String elementPath, IElementChangeHandler handler) {
        HashMap hashMap = this.m_FSElementChangeHandlers;
        synchronized (hashMap) {
            HashSet handlers = (HashSet)this.m_FSElementChangeHandlers.get(elementPath);
            if (handlers == null) {
                return;
            }
            handlers.remove(handler);
            if (handlers.isEmpty()) {
                this.m_FSElementChangeHandlers.remove(elementPath);
            } else {
                this.m_FSElementChangeHandlers.put(elementPath, handlers);
            }
            DirectoryServiceProxy directoryServiceProxy = this;
            synchronized (directoryServiceProxy) {
                this.destroyFSChangeNotificationListenerCheckingHandlers();
            }
        }
    }

    private void destroyFSChangeNotificationListenerCheckingHandlers() {
        if (this.m_globalFSChangeHandlers.isEmpty() && this.m_FSElementChangeHandlers.isEmpty()) {
            this.destroyFSChangeNotificationListener();
        }
    }

    @Override
    public AttributeName[] getReferences(String elementPath) throws DirectoryServiceException {
        try {
            return (AttributeName[])this.m_server.invoke(this.m_dsName, "getReferences", new Object[]{elementPath}, GET_REFERENCES_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getReferences failed: " + mappedException.toString());
        }
    }

    @Override
    public void repairReferences(String[] exclusions) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "repairReferences", new Object[]{exclusions}, REPAIR_REFERENCES_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.repairReferences failed: " + mappedException.toString());
        }
    }

    @Override
    public void rebuildBackReferences() throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "rebuildBackReferences", new Object[0], new String[0]);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.rebuildBackReferences failed: " + mappedException.toString());
        }
    }

    @Override
    public void resetBackReferences() throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "resetBackReferences", new Object[0], new String[0]);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.resetBackReferences failed: " + mappedException.toString());
        }
    }

    @Override
    public String[] getBackReferenceTypes() throws DirectoryServiceException {
        try {
            return (String[])this.m_server.invoke(this.m_dsName, "getBackReferenceTypes", new Object[0], new String[0]);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getBackReferenceTypes failed: " + mappedException.toString());
        }
    }

    @Override
    public void setBackReferenceTypes(String[] typeList) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "setBackReferenceTypes", new Object[]{typeList}, SET_BACK_REFERENCE_TYPES_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.setBackReferenceTypes failed: " + mappedException.toString());
        }
    }

    @Override
    public String[] listExternalDomainWithManagementSPI() throws DirectoryServiceException {
        try {
            return (String[])this.m_server.invoke(this.m_dsName, "listExternalDomainWithManagementSPI", new Object[0], new String[0]);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.listExternalDomainWithManagementSPI failed: " + mappedException.toString());
        }
    }

    @Override
    public Boolean reloadExternalAuthenticationDomain(String mfDomainDescriptor) throws DirectoryServiceException {
        try {
            return (Boolean)this.m_server.invoke(this.m_dsName, "reloadExternalAuthenticationDomain", new Object[]{mfDomainDescriptor}, new String[]{String.class.getName()});
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            this.checkIsManagementPermissionDeniedException(mappedException);
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.reloadExtenralAuthenticationDomain failed: " + mappedException.toString());
        }
    }

    public IElement[] retryGetElementsByLogicalNames(String[] logicalNames) throws DirectoryServiceException {
        return (IElement[])this.invokeContinuously("getElementsByLogicalNames", new Object[]{logicalNames}, new String[]{logicalNames.getClass().getName()});
    }

    @Override
    public IElement[] getElementsByLogicalNames(String[] logicalNames) throws DirectoryServiceException {
        try {
            return (IElement[])this.m_server.invoke(this.m_dsName, "getElementsByLogicalNames", new Object[]{logicalNames}, new String[]{logicalNames.getClass().getName()});
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getElementsByLogicalNames failed: " + mappedException.toString());
        }
    }

    @Override
    public IBlob getBlobByLogicalName(String subscriber, String logicalName) throws DirectoryServiceException {
        return this.getBlobByLogicalName(logicalName);
    }

    @Override
    public IBlob getBlobByLogicalName(String logicalName) throws DirectoryServiceException {
        try {
            Blob blob = (Blob)this.m_server.invoke(this.m_dsName, "getBlobByLogicalName", new Object[]{logicalName}, new String[]{String.class.getName()});
            if (blob != null) {
                return new Blob(blob.getElement(), blob.getBlobBytes(), this);
            }
            return null;
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getBlobByLogicalName failed: " + mappedException.toString());
        }
    }

    private void setupNamingCache() {
        if (this.m_logicalStorageMap == null) {
            this.m_logicalStorageMap = new LogicalStorageNameMapper();
            this.m_logicalStorageMap.applyCorrections(this.getStorageToLogicalMap());
            this.registerNameChangeHandler(new StorageLogicalMapHandler());
        }
    }

    private HashMap getStorageToLogicalMap() {
        try {
            return (HashMap)this.m_server.invoke(this.m_dsName, "getStorageToLogicalMap", new Object[0], new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    public void startBackup(String backupDir, boolean overwrite) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "startBackup", new Object[]{backupDir, new Boolean(overwrite)}, ONLINE_BACKUP_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            this.checkIsManagementPermissionDeniedException(mappedException);
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.startBackup failed: " + mappedException.toString());
        }
    }

    @Override
    public IBackupStatus getBackupStatus() throws DirectoryServiceException {
        try {
            return (IBackupStatus)this.m_server.invoke(this.m_dsName, "getBackupStatus", new Object[0], new String[0]);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            this.checkIsManagementPermissionDeniedException(mappedException);
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getBackupStatus failed: " + mappedException.toString());
        }
    }

    private void checkIsManagementPermissionDeniedException(Exception mappedException) {
        if (mappedException instanceof ManagementPermissionDeniedException) {
            throw (ManagementPermissionDeniedException)mappedException;
        }
    }

    @Override
    public void removeManagementPermissions(String[] paths, String type, String[][] principals) throws DirectoryServiceException, InvalidManagementPermissionException {
        try {
            this.m_server.invoke(this.m_dsName, "removeManagementPermissions", new Object[]{paths, type, principals}, new String[]{String[].class.getName(), String.class.getName(), String[][].class.getName()});
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.removeManagementPermissions failed: " + mappedException.toString());
        }
    }

    @Override
    public void removeManagementPermissions(String[] paths, String type) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "removeManagementPermissions", new Object[]{paths, type}, new String[]{String[].class.getName(), String.class.getName()});
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.removeManagementPermissions failed: " + mappedException.toString());
        }
    }

    @Override
    public IManagementPermission[][] getManagementPermissions(String[] paths, String type) throws DirectoryServiceException {
        try {
            return (IManagementPermission[][])this.m_server.invoke(this.m_dsName, "getManagementPermissions", new Object[]{paths, type}, new String[]{String[].class.getName(), String.class.getName()});
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getManagementPermissions failed: " + mappedException.toString());
        }
    }

    @Override
    public void removeAllManagementPermissions() throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "removeAllManagementPermissions", new Object[0], new String[0]);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.removeAllManagementPermissions failed: " + mappedException.toString());
        }
    }

    @Override
    public void setDefaultManagementPermissions() throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "setDefaultManagementPermissions", new Object[0], new String[0]);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.setDefaultManagementPermissions failed: " + mappedException.toString());
        }
    }

    @Override
    public void setManagementPermissions(String[] paths, String type, IManagementPermission[][] permissions) throws DirectoryServiceException, InvalidManagementPermissionException {
        try {
            this.m_server.invoke(this.m_dsName, "setManagementPermissions", new Object[]{paths, type, permissions}, new String[]{String[].class.getName(), String.class.getName(), IManagementPermission[][].class.getName()});
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof InvalidManagementPermissionException) {
                throw (InvalidManagementPermissionException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.setManagementPermissions failed: " + mappedException.toString());
        }
    }

    @Override
    public IDirElement getDomainElement(boolean forUpdate) throws DirectoryServiceException {
        try {
            return (IDirElement)this.m_server.invoke(this.m_dsName, "getDomainElement", new Object[]{new Boolean(forUpdate)}, GET_DOMAIN_ELEMENT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.getDomainElement failed: " + mappedException.toString());
        }
    }

    @Override
    public void setDomainElement(IDeltaDirElement element) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "setDomainElement", new Object[]{element}, SET_DOMAIN_ELEMENT_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.setDomainElement failed: " + mappedException.toString());
        }
    }

    @Override
    public void suspendChangeNotifications(String containerID, String[] allowTypes) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "suspendChangeNotifications", new Object[]{containerID, allowTypes}, SUSPEND_CHANGE_NOTIFICATIONS_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.suspendChangeNotifications failed: " + mappedException.toString());
        }
    }

    @Override
    public void resumeChangeNotifications(String containerID) throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "resumeChangeNotifications", new Object[]{containerID}, RESUME_CHANGE_NOTIFICATIONS_SIGNATURE);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.resumeChangeNotifications failed: " + mappedException.toString());
        }
    }

    @Override
    public void resumeAllChangeNotifications() throws DirectoryServiceException {
        try {
            this.m_server.invoke(this.m_dsName, "resumeAllChangeNotifications", new Object[0], new String[0]);
        }
        catch (Exception e) {
            Exception mappedException = this.handleException(e);
            if (mappedException instanceof VersionOutofSyncException) {
                throw (VersionOutofSyncException)mappedException;
            }
            if (mappedException instanceof ConfigurePermissionDeniedException) {
                throw (ConfigurePermissionDeniedException)mappedException;
            }
            throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy.resumeAllChangeNotifications failed: " + mappedException.toString());
        }
    }

    @Override
    public void close() throws DirectoryServiceException {
    }

    private Object invokeContinuously(String methodName, Object[] parameters, String[] classNames) throws DirectoryServiceException {
        Exception priorException = null;
        while (true) {
            try {
                Object returnValue = this.m_server.invoke(this.m_dsName, methodName, parameters, classNames);
                if (priorException != null) {
                    this.logMessage("...retry successful", 3);
                }
                return returnValue;
            }
            catch (Exception e) {
                if (DirectoryServiceProxy.isCausedByTimeout(e)) {
                    Class<?> serverClass = this.m_server.getClass();
                    int traceMask = 0;
                    try {
                        Method getTraceMaskMethod = serverClass.getMethod("getTraceMask", IEmptyArray.EMPTY_CLASS_ARRAY);
                        traceMask = (Integer)getTraceMaskMethod.invoke((Object)this.m_server, IEmptyArray.EMPTY_OBJECT_ARRAY);
                    }
                    catch (Exception getTraceMaskMethod) {
                        // empty catch block
                    }
                    if ((traceMask & 0x20) > 0) {
                        if ((traceMask & 1) > 0) {
                            this.logMessage("Timeout while communicating with the Directory Service, retrying...", e, 7);
                        } else {
                            this.logMessage("Timeout while communicating with the Directory Service, retrying...", 7);
                        }
                    } else {
                        boolean log = false;
                        if (priorException == null) {
                            log = true;
                        } else if (!e.getClass().isInstance(priorException)) {
                            log = true;
                        } else if (priorException.getMessage() != null && !priorException.getMessage().equals(e.getMessage())) {
                            log = true;
                        } else if (e.getMessage() != null && !e.getMessage().equals(priorException.getMessage())) {
                            log = true;
                        }
                        if (log) {
                            this.logMessage("Timeout while communicating with the Directory Service, retrying...", 2);
                        }
                    }
                    priorException = e;
                    continue;
                }
                Exception mappedException = this.handleException(e);
                if (mappedException instanceof ConfigurePermissionDeniedException) {
                    throw (ConfigurePermissionDeniedException)mappedException;
                }
                throw new ProxyRuntimeException(mappedException, "DirectoryServiceProxy." + methodName + " continuous failed: " + mappedException.toString());
            }
            break;
        }
    }

    private Exception handleException(Exception e) throws DirectoryServiceException {
        Exception mappedException = this.mapException(e);
        if (mappedException instanceof DirectoryServiceException) {
            throw (DirectoryServiceException)mappedException;
        }
        return mappedException;
    }

    private void logMessage(String message, int severityLevel) {
        Class<?> serverClass = this.m_server.getClass();
        try {
            Method logMessageMethod = serverClass.getMethod("logMessage", String.class, Integer.TYPE);
            logMessageMethod.invoke((Object)this.m_server, message, new Integer(severityLevel));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logMessage(String message, Throwable exception, int severityLevel) {
        Class<?> serverClass = this.m_server.getClass();
        try {
            Method logMessageMethod = serverClass.getMethod("logMessage", String.class, Throwable.class, Integer.TYPE);
            logMessageMethod.invoke((Object)this.m_server, message, exception, new Integer(severityLevel));
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    private static boolean isCausedByTimeout(Throwable exception) {
        Throwable cause;
        if (exception instanceof ConnectTimeoutException || exception instanceof InvokeTimeoutCommsException || exception instanceof InvokeTimeoutException) {
            return true;
        }
        Class<?> exceptionClass = exception.getClass();
        try {
            Method getTargetExceptionMethod = exceptionClass.getMethod("getTargetException", IEmptyArray.EMPTY_CLASS_ARRAY);
            Throwable targetException = (Throwable)getTargetExceptionMethod.invoke((Object)exception, IEmptyArray.EMPTY_OBJECT_ARRAY);
            if (targetException != null) {
                return DirectoryServiceProxy.isCausedByTimeout(targetException);
            }
        }
        catch (NoSuchMethodException getTargetExceptionMethod) {
        }
        catch (IllegalAccessException getTargetExceptionMethod) {
        }
        catch (InvocationTargetException getTargetExceptionMethod) {
            // empty catch block
        }
        try {
            Method getTargetErrorMethod = exceptionClass.getMethod("getTargetError", IEmptyArray.EMPTY_CLASS_ARRAY);
            Throwable targetError = (Throwable)getTargetErrorMethod.invoke((Object)exception, IEmptyArray.EMPTY_OBJECT_ARRAY);
            if (targetError != null) {
                return DirectoryServiceProxy.isCausedByTimeout(targetError);
            }
        }
        catch (NoSuchMethodException getTargetErrorMethod) {
        }
        catch (IllegalAccessException getTargetErrorMethod) {
        }
        catch (InvocationTargetException getTargetErrorMethod) {
            // empty catch block
        }
        try {
            Method getLinkedExceptionMethod = exceptionClass.getMethod("getLinkedException", IEmptyArray.EMPTY_CLASS_ARRAY);
            Throwable linkedException = (Throwable)getLinkedExceptionMethod.invoke((Object)exception, IEmptyArray.EMPTY_OBJECT_ARRAY);
            if (linkedException != null) {
                return DirectoryServiceProxy.isCausedByTimeout(linkedException);
            }
        }
        catch (NoSuchMethodException getLinkedExceptionMethod) {
        }
        catch (IllegalAccessException getLinkedExceptionMethod) {
        }
        catch (InvocationTargetException getLinkedExceptionMethod) {
            // empty catch block
        }
        try {
            Method getCauseMethod = exceptionClass.getMethod("getCause", IEmptyArray.EMPTY_CLASS_ARRAY);
            cause = (Throwable)getCauseMethod.invoke((Object)exception, IEmptyArray.EMPTY_OBJECT_ARRAY);
            if (cause != null) {
                return DirectoryServiceProxy.isCausedByTimeout(cause);
            }
        }
        catch (NoSuchMethodException getCauseMethod) {
        }
        catch (IllegalAccessException getCauseMethod) {
        }
        catch (InvocationTargetException getCauseMethod) {
            // empty catch block
        }
        try {
            Method getActualExceptionMethod = exceptionClass.getMethod("getActualException", IEmptyArray.EMPTY_CLASS_ARRAY);
            cause = (Throwable)getActualExceptionMethod.invoke((Object)exception, IEmptyArray.EMPTY_OBJECT_ARRAY);
            if (cause != null) {
                return DirectoryServiceProxy.isCausedByTimeout(cause);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    private class AppendBlob {
        IBasicElement m_element;
        byte[] m_blob;
        int m_src;

        AppendBlob(IBasicElement element, byte[] blob, int src) {
            this.m_element = element;
            this.m_blob = blob;
            this.m_src = src;
        }
    }

    private class StorageLogicalMapHandler
    implements INameChangeHandler {
        private StorageLogicalMapHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNamingNotification(INamingNotification notification) {
            HashSet hashSet = DirectoryServiceProxy.this.m_nameChangeHandlers;
            synchronized (hashSet) {
                if (notification instanceof IRenameNotification) {
                    DirectoryServiceProxy.this.m_logicalStorageMap.rename(((IRenameNotification)notification).getName(), ((IRenameNotification)notification).getNewName());
                } else if (notification instanceof IFolderDeleteNotification || notification instanceof IElementDeleteNotification) {
                    DirectoryServiceProxy.this.m_logicalStorageMap.deleteByLogicalName(notification.getName());
                }
            }
        }
    }

    private final class ElementChange
    implements IElementChange {
        IBasicElement m_element;
        boolean m_replacement;

        ElementChange(IBasicElement element, boolean replacement) {
            this.m_element = element;
            this.m_replacement = replacement;
        }

        @Override
        public IBasicElement getElement() {
            return this.m_element;
        }

        @Override
        public short getChangeType() {
            if (this.m_element instanceof IDeltaElement) {
                return 1;
            }
            if (((IElement)this.m_element).isDeleted()) {
                return 2;
            }
            if (this.m_replacement) {
                return 3;
            }
            return 0;
        }
    }
}

