/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.jmx.client;

import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.impl.ComponentIdentity;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;

public class MFNotification
extends Notification
implements INotification {
    private static final long serialVersionUID = 6407583935938698016L;
    private static final short m_serialVersion = 0;
    private short m_category;
    private String m_subCategory;
    private String m_eventName;
    private int m_severityLevel;
    private short m_logType;
    private IComponentIdentity m_sourceIdentity;
    public static final String HOST = MFNotification.getHostIP();
    private String m_sourceHost;
    private HashMap m_attributes;
    private String m_localizedTimestamp;

    private static String getHostIP() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    public static String getType(String[] notificationTypes) {
        StringBuffer sb = new StringBuffer(notificationTypes[0]);
        if (notificationTypes.length > 1) {
            for (int i = 1; i < notificationTypes.length; ++i) {
                sb.append('.').append(notificationTypes[i]);
            }
        }
        return sb.toString();
    }

    public MFNotification(ObjectName source, short category, String subCategory, String eventName, int severityLevel) {
        super(INotification.CATEGORY_TEXT[category] + '.' + subCategory + '.' + eventName, source, 0L);
        switch (severityLevel) {
            case 1: {
                this.m_logType = (short)2;
                break;
            }
            case 2: {
                this.m_logType = 1;
                break;
            }
            default: {
                this.m_logType = 0;
            }
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
        this.m_category = category;
        this.m_subCategory = subCategory;
        this.m_eventName = eventName;
        this.m_severityLevel = severityLevel;
        this.m_sourceHost = HOST;
        this.m_localizedTimestamp = dateFormat.format(this.getTimeStamp());
    }

    public MFNotification(MFNotification notification) {
        super(INotification.CATEGORY_TEXT[notification.getCategory()] + '.' + notification.getSubCategory() + '.' + notification.getEventName(), (ObjectName)notification.getSource(), 0L);
        switch (notification.getSeverity()) {
            case 1: {
                this.m_logType = (short)2;
                break;
            }
            case 2: {
                this.m_logType = 1;
                break;
            }
            default: {
                this.m_logType = 0;
            }
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
        this.m_category = notification.getCategory();
        this.m_subCategory = notification.getSubCategory();
        this.m_eventName = notification.getEventName();
        this.m_severityLevel = notification.getSeverity();
        this.m_sourceHost = notification.getSourceHost();
        this.m_localizedTimestamp = dateFormat.format(this.getTimeStamp());
        IComponentIdentity cid = notification.getSourceIdentity();
        if (cid != null) {
            if (cid instanceof ComponentIdentity) {
                this.m_sourceIdentity = cid;
            } else {
                throw new MFRuntimeException("Attempt to set notification source ID reference of cloned notification to something other than an instance of ComponentIdentity");
            }
        }
        this.setSequenceNumber(notification);
        HashMap attributes = notification.getAttributes();
        if (attributes != null) {
            this.initMAttributes();
            Set entries = attributes.entrySet();
            if (entries != null) {
                for (Map.Entry entry : entries) {
                    if (entry == null) continue;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    this.m_attributes.put(key, value);
                }
            }
        }
    }

    private void setSequenceNumber(MFNotification notification) {
        super.setSequenceNumber(notification.getSequenceNumber());
    }

    @Override
    public String getType() {
        return INotification.CATEGORY_TEXT[this.m_category] + '.' + this.m_subCategory + '.' + this.m_eventName;
    }

    @Override
    public short getCategory() {
        return this.m_category;
    }

    @Override
    public String getSubCategory() {
        return this.m_subCategory;
    }

    @Override
    public String getEventName() {
        return this.m_eventName;
    }

    @Override
    public int getSeverity() {
        return this.m_severityLevel;
    }

    @Override
    public void setLogType(short logType) {
        if (this.m_logType < 0 || this.m_logType > 4) {
            throw new IllegalArgumentException();
        }
        this.m_logType = logType;
    }

    @Override
    public short getLogType() {
        return this.m_logType;
    }

    @Override
    public Object getSource() {
        ObjectName source = null;
        try {
            source = new ObjectName(this.m_sourceIdentity.getCanonicalName());
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
        }
        return source;
    }

    @Override
    public IComponentIdentity getSourceIdentity() {
        return this.m_sourceIdentity;
    }

    @Override
    public void setSourceIdentity(IComponentIdentity sourceIdentity) {
        this.m_sourceIdentity = sourceIdentity;
    }

    @Override
    public String getSourceHost() {
        return this.m_sourceHost;
    }

    @Override
    public long getSequenceNumber() {
        return super.getSequenceNumber();
    }

    @Override
    public long getTimeStamp() {
        return super.getTimeStamp();
    }

    @Override
    public synchronized void setAttribute(String name, Object value) {
        this.initMAttributes();
        this.m_attributes.put(name, value);
    }

    private void initMAttributes() {
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap();
        }
    }

    @Override
    public synchronized HashMap getAttributes() {
        HashMap copy = null;
        if (this.m_attributes != null) {
            copy = (HashMap)this.m_attributes.clone();
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(12);
        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(0));
        stream.writeUTF("category");
        stream.writeObject(new Short(this.m_category));
        stream.writeUTF("subCategory");
        stream.writeObject(this.m_subCategory);
        stream.writeUTF("eventName");
        stream.writeObject(this.m_eventName);
        stream.writeUTF("severityLevel");
        stream.writeObject(new Integer(this.m_severityLevel));
        stream.writeUTF("logType");
        stream.writeObject(new Short(this.m_logType));
        stream.writeUTF("sourceIdentity");
        stream.writeObject(this.m_sourceIdentity);
        stream.writeUTF("sourceHost");
        stream.writeObject(this.m_sourceHost);
        stream.writeUTF("attributes");
        MFNotification mFNotification = this;
        synchronized (mFNotification) {
            stream.writeObject(this.m_attributes);
        }
        stream.writeUTF("source");
        stream.writeObject(super.getSource());
        stream.writeUTF("sequenceNumber");
        stream.writeObject(new Long(super.getSequenceNumber()));
        stream.writeUTF("timeStamp");
        stream.writeObject(new Long(super.getTimeStamp()));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int numValues = stream.readInt();
        HashMap<String, Object> map = new HashMap<String, Object>(numValues);
        for (int i = 0; i < numValues; ++i) {
            map.put(stream.readUTF(), stream.readObject());
        }
        switch ((Short)map.get("serialVersion")) {
            default: 
        }
        try {
            this.m_category = (Short)map.get("category");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_subCategory = (String)map.get("subCategory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_eventName = (String)map.get("eventName");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_severityLevel = (Integer)map.get("severityLevel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_logType = (Short)map.get("logType");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_sourceIdentity = (IComponentIdentity)map.get("sourceIdentity");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_sourceHost = (String)map.get("sourceHost");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_attributes = (HashMap)map.get("attributes");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            super.setSource(map.get("source"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            super.setSequenceNumber((Long)map.get("sequenceNumber"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            super.setTimeStamp((Long)map.get("timeStamp"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getLocalizedTimestamp() {
        return this.m_localizedTimestamp;
    }
}

