/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.upgrade.IMigrationProcess;
import com.sonicsw.mf.common.config.upgrade.MigrationException;
import com.sonicsw.mf.common.config.upgrade.Utils;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.InvalidXMLException;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.framework.directory.DirectoryServiceFactory;
import com.sonicsw.mf.framework.directory.IContainerlessDS;
import com.sonicsw.mf.framework.directory.IDirectoryService;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mf.mgmtapi.runtime.ProxyRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class DirectoryService
implements IMigrationProcess {
    IDirectoryAdminService m_dsAdmin = null;
    IDirectoryFileSystemService m_dsFileSystem = null;
    IDirectoryService m_ds = null;
    JMSConnectorClient m_connector = null;
    static boolean DEBUG = System.getProperty("DebugAll.debug", "false").equals("true");

    public DirectoryService(IDirElement dsElement, String absParent, String absHostDir, boolean newPSE) throws Exception {
        this.openStorage(dsElement, absParent, absHostDir, newPSE);
    }

    public DirectoryService(String dsXmlFile) throws Exception {
        this(dsXmlFile, null, null, false);
    }

    public DirectoryService(String dsXmlFile, boolean copyStorage) throws Exception {
        if (copyStorage) {
            File dsXmlParentDir;
            IDirElement dsElement = DirectoryService.getDSElement(dsXmlFile);
            IAttributeSet dsAttributes = dsElement.getAttributes();
            String domainName = DirectoryService.retrieveDomainName(dsAttributes);
            String directory = null;
            String dirFromDsXml = (String)dsAttributes.getAttribute("HOST_DIRECTORY");
            directory = DirectoryService.getDomainDirectory(dirFromDsXml, null, null);
            File copyFolderFrom = new File(directory, domainName);
            if (!(copyFolderFrom.exists() || copyFolderFrom.isAbsolute() || (copyFolderFrom = new File(dsXmlParentDir = new File(dsXmlFile).getParentFile(), copyFolderFrom.getPath())).exists())) {
                throw new Exception("Unable to find " + copyFolderFrom.getCanonicalPath() + " to copy it before opening it. Make sure the HOST_DIRECTORY attribute is set to an absolute file path on this host.");
            }
            String sonicHome = System.getProperty("sonic.home");
            File copyTo = new File(sonicHome, "MigrationTemp");
            File copyFolderTo = new File(copyTo, domainName);
            if (copyFolderTo.exists()) {
                Utils.recursiveDeleteDirectory(copyFolderTo);
            }
            copyFolderTo.mkdirs();
            if (!copyFolderTo.exists()) {
                throw new Exception("Unable to make directory " + copyFolderTo + " to copy the DS storage");
            }
            Utils.copyAll(copyFolderFrom, copyFolderTo);
            this.openStorage(dsElement, null, copyTo.getCanonicalPath(), false);
        }
    }

    public DirectoryService(String dsXmlFile, String absParent, String absHostDir, boolean newPSE) throws Exception {
        this.openStorage(DirectoryService.getDSElement(dsXmlFile), absParent, absHostDir, newPSE);
    }

    public DirectoryService(String url, String username, String password, String domain, String mnode, int rt) throws Exception {
        if (DEBUG) {
            System.out.println("DirectoryService constructor for remote connection to URLs " + url);
        }
        this.m_connector = new JMSConnectorClient();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("ConnectionURLs", url);
        env.put("DefaultUser", username);
        if (password != null) {
            env.put("DefaultPassword", password);
        }
        this.m_connector.setRequestTimeout(rt * 1000);
        JMSConnectorAddress address = new JMSConnectorAddress(env);
        if (DEBUG) {
            System.out.println("DirectoryService constructor, mnode == " + mnode);
        }
        if (mnode != null) {
            address.setManagementNode(mnode);
        }
        String connectString = this.m_connector.connect(address, 40000L);
        if (DEBUG) {
            System.out.println("DirectoryService constructor, connect result == " + connectString);
        }
        String dsName = domain + ".DIRECTORY SERVICE:ID=DIRECTORY SERVICE";
        DirectoryServiceProxy proxy = new DirectoryServiceProxy(this.m_connector, new ObjectName(dsName));
        this.m_dsFileSystem = proxy;
        if (DEBUG) {
            System.out.println("DirectoryService constructor, testing domain name with m_dsFileSystem.getDirectoryServiceVersion");
        }
        try {
            this.m_dsFileSystem.getDirectoryServiceVersion();
        }
        catch (ProxyRuntimeException proxyE) {
            this.m_connector.disconnect();
            Throwable cause = proxyE.getCause();
            if (cause instanceof InvokeTimeoutException) {
                MigrationException migrationE = new MigrationException("The Directory Service could not be reached. Check that you have used the correct domain name.");
                migrationE.initCause(proxyE);
                throw migrationE;
            }
            throw proxyE;
        }
        this.m_dsAdmin = proxy;
        if (DEBUG) {
            System.out.println("Finished with remote connection");
        }
    }

    public DirectoryService(String url, String username, String password, String domain, String mnode) throws Exception {
        this(url, username, password, domain, mnode, 60);
    }

    public DirectoryService(String url, String username, String password, String domain) throws Exception {
        this(url, username, password, domain, null);
    }

    private void openStorage(IDirElement dsElement, String absParent, String absHostDir, boolean newPSE) throws Exception {
        Object tmp;
        String storageType = "PSE_STORAGE";
        IAttributeSet dsAttributes = dsElement.getAttributes();
        if (DEBUG) {
            System.out.println("upgrade.DirectoryService constructor for DS Element " + dsElement.getIdentity().getName() + " absParent = " + absParent + ", absHostDir = " + absHostDir + ", working directory == " + new File(".").getCanonicalPath());
        }
        String domainName = DirectoryService.retrieveDomainName(dsAttributes);
        String directory = null;
        String dirFromDsXml = (String)dsAttributes.getAttribute("HOST_DIRECTORY");
        directory = DirectoryService.getDomainDirectory(dirFromDsXml, absParent, absHostDir);
        if (!newPSE && dsElement.getIdentity().getReleaseVersion().equals("101")) {
            storageType = "FS_STORAGE";
        }
        if ((tmp = dsAttributes.getAttribute("FILE_SYSTEM_STORAGE")) == null) {
            throw new MFRuntimeException("Bad Directory Service Configuration - must contain FILE_SYSTEM_STORAGE.");
        }
        String password = (String)((IAttributeSet)tmp).getAttribute("PASSWORD");
        if (!(tmp instanceof IAttributeSet)) {
            throw new MFRuntimeException("Bad Directory Service Configuration - FILE_SYSTEM_STORAGE must be an attribute set.");
        }
        Hashtable<String, String> directoryEnv = new Hashtable<String, String>();
        directoryEnv.put("STORAGE_TYPE_ATTRIBUTE", storageType);
        if (DEBUG) {
            System.out.println("DirectoryService constructor connecting to storage in " + directory);
        }
        directoryEnv.put("HOST_DIRECTORY_ATTRIBUTE", directory);
        if (password != null && password.length() != 0) {
            directoryEnv.put("PASSWORD", password);
        }
        DirectoryServiceFactory factory = new DirectoryServiceFactory(directoryEnv);
        this.m_ds = factory.createDirectoryService(domainName);
        this.m_dsFileSystem = this.m_ds;
        this.m_dsAdmin = this.m_ds;
        if (DEBUG) {
            System.out.println("upgrade.DirectoryService constructor end");
        }
    }

    private static String retrieveDomainName(IAttributeSet dsAttributes) {
        String domainName = (String)dsAttributes.getAttribute("DOMAIN_NAME");
        if (domainName == null || domainName.length() == 0) {
            domainName = "Domain1";
        }
        return domainName;
    }

    public IDirectoryFileSystemService getFileSystemService() {
        return this.m_dsFileSystem;
    }

    public IDirectoryAdminService getAdminService() {
        return this.m_dsAdmin;
    }

    public IDirectoryService getDirectoryService() {
        return this.m_ds;
    }

    public void closeDS() throws Exception {
        if (this.m_connector != null) {
            System.out.println("DirectoryService closing the connector");
            this.m_connector.disconnect();
            this.m_connector = null;
        } else {
            ((IContainerlessDS)this.m_dsAdmin).close();
        }
    }

    public static String getDomainDirectory(String host_directoryParam, String absParent, String absHostDir) throws Exception {
        File hostDirFile;
        String host_directory = host_directoryParam;
        if (absHostDir != null) {
            return absHostDir;
        }
        if (host_directory == null || host_directory.length() == 0) {
            host_directory = ".";
        }
        if (!(hostDirFile = new File(host_directory)).isAbsolute() && absParent != null) {
            return new File(absParent, hostDirFile.getName()).getCanonicalPath();
        }
        return host_directory;
    }

    static IDirElement getDSElement(String dsXml) throws Exception {
        String xmlString = DirectoryService.getXMLStringFromFile(dsXml);
        IDirElement dsConfig = ElementFactory.importElementFromXML(xmlString, null, "MF_DIRECTORY_SERVICE");
        return dsConfig;
    }

    static String getDSVersion(String dsXml) throws Exception {
        String xmlString = DirectoryService.getXMLStringFromFile(dsXml);
        IDirElement dsConfig = DirectoryService.retrieveDsConfig(xmlString);
        return dsConfig.getIdentity().getReleaseVersion();
    }

    static String getHostDirectory(String dsXml) throws Exception {
        String xmlString = DirectoryService.getXMLStringFromFile(dsXml);
        IDirElement dsConfig = DirectoryService.retrieveDsConfig(xmlString);
        IAttributeSet topSet = dsConfig.getAttributes();
        return (String)topSet.getAttribute("HOST_DIRECTORY");
    }

    public boolean shutdownContainer(String containerObjectName, long howLong) throws Exception {
        if (DEBUG) {
            System.out.println("DirectoryService.shutdownContainer Invoking shutdown for " + containerObjectName);
        }
        ObjectName containerObject = new ObjectName(containerObjectName);
        this.m_connector.invoke(containerObject, "shutdown", new Object[0], new String[0]);
        long originalTime = System.currentTimeMillis();
        boolean shutdown = !this.pingContainer(containerObjectName);
        long counter = System.currentTimeMillis() - originalTime;
        while (!shutdown && counter < 180000L) {
            if (DEBUG) {
                System.out.println("DirectoryService.shutdownContainer Waiting for the container to completely shutdown");
            }
            Thread.sleep(5000L);
            shutdown = !this.pingContainer(containerObjectName);
            counter = System.currentTimeMillis() - originalTime;
        }
        if (!shutdown) {
            return false;
        }
        if (containerObjectName.indexOf("DIRECTORY SERVICE") > -1) {
            this.closeDS();
        }
        return true;
    }

    public void restartContainer(String containerObjectName, String AMObjectName) throws Exception {
        if (DEBUG) {
            System.out.println("Invoking restart for " + containerObjectName);
        }
        ObjectName containerObject = new ObjectName(containerObjectName);
        StartupListener listener = this.subscribeToStartup(containerObjectName, AMObjectName);
        this.m_connector.invoke(containerObject, "restart", new Object[0], new String[0]);
        while (!listener.isStarted()) {
            if (DEBUG) {
                System.out.println("restartContainer waiting for notification .....");
            }
            Thread.sleep(3000L);
        }
    }

    public boolean pingContainer(String containerObjectName) throws Exception {
        System.out.println("Pinging container " + containerObjectName + "...");
        if (this.m_connector == null) {
            System.out.println("Pinging container " + containerObjectName + "...done, because the DM is not running");
            return false;
        }
        String pingString = "Are you there";
        ObjectName containerObject = new ObjectName(containerObjectName);
        try {
            String result = (String)this.m_connector.invoke(containerObject, "ping", new Object[]{pingString}, new String[]{String.class.getCanonicalName()});
            if (result.equals(pingString)) {
                System.out.println("Pinging container " + containerObjectName + "...done; container is running");
                return true;
            }
        }
        catch (Exception e) {
            System.out.println("Pinging container " + containerObjectName + "...done; container is not running");
            return false;
        }
        System.out.println("Pinging container " + containerObjectName + "...done; container is not running");
        return false;
    }

    public static IAttributeSet getDSAttributes(String dsXmlFileName) throws Exception {
        String xmlString = DirectoryService.getXMLStringFromFile(dsXmlFileName);
        IDirElement dsConfig = DirectoryService.retrieveDsConfig(xmlString);
        IAttributeSet dsAttributes = dsConfig.getAttributes();
        return dsAttributes;
    }

    private static IDirElement retrieveDsConfig(String xmlString) throws InvalidXMLException {
        IDirElement dsConfig = ElementFactory.importElementFromXML(xmlString, null, "MF_DIRECTORY_SERVICE");
        if (dsConfig == null) {
            dsConfig = ElementFactory.importElementFromXML(xmlString, null, "MF_BACKUP_DIRECTORY_SERVICE");
        }
        return dsConfig;
    }

    public static String getXMLStringFromFile(String xmlFile) throws Exception {
        FileInputStream fis = new FileInputStream(xmlFile);
        byte[] bytes = new byte[fis.available()];
        fis.read(bytes);
        fis.close();
        return new String(bytes);
    }

    public StartupListener subscribeToStartup(String containerOName, String AMObjectName) throws Exception {
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("system.state.Startup");
        ObjectName name = new ObjectName(AMObjectName);
        StartupListener listener = new StartupListener(containerOName);
        this.m_connector.addNotificationListener(name, listener, (NotificationFilter)filter, (Object)"");
        if (DEBUG) {
            System.out.println("subscribeToSTartup added notification listener on object " + name.getCanonicalName());
        }
        return listener;
    }

    private static final class StartupListener
    implements NotificationListener {
        private String m_containerName;
        private boolean m_started = false;

        public StartupListener(String containerOName) {
            if (DEBUG) {
                System.out.println("StartupListener will be looking for container " + containerOName + " in the notification");
            }
            this.m_containerName = containerOName;
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (DEBUG) {
                System.out.println("StartupListener.handleNotification called");
            }
            if (notification.getType().equals("system.state.Startup")) {
                if (DEBUG) {
                    System.out.println("StartupListener.handleNotification got system.state.Startup");
                }
                String containerName = (String)((INotification)((Object)notification)).getAttributes().get("Container");
                if (DEBUG) {
                    System.out.println("StartupListener.handleNotification containerName == " + containerName + " will compare to " + this.m_containerName);
                }
                if (this.m_containerName.startsWith(containerName)) {
                    this.m_started = true;
                }
            }
        }

        public boolean isStarted() {
            return this.m_started;
        }
    }
}

