/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.xml;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryCacheService;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.xml.ElementBuilder;
import com.sonicsw.mf.common.xml.XMLStringWriter;
import java.util.HashMap;

public class DirectoryBuilder {
    XMLStringWriter m_xmlWriter = null;
    String m_dirName = null;
    IDirectoryAdminService m_dirService = null;

    public DirectoryBuilder(String dirName) {
        this.m_dirName = dirName;
        this.m_xmlWriter = new XMLStringWriter();
    }

    public void setDirectoryService(IDirectoryAdminService dirService) {
        this.m_dirService = dirService;
    }

    public String getXMLString() {
        return this.m_xmlWriter.getXMLString().toString();
    }

    public void init() throws DirectoryServiceException {
        if (this.m_dirService == null) {
            return;
        }
        this.m_xmlWriter.setProcInstruction("1.0", "UTF-8");
        this.createDomainElement();
    }

    private void traverseBranch(IIdentity[] list) throws DirectoryServiceException {
        HashMap<String, Boolean> alreadyExportedTable = new HashMap<String, Boolean>();
        for (int i = 0; i < list.length; ++i) {
            String entityName = list[i].getName();
            if (alreadyExportedTable.get(entityName) != null) continue;
            if (list[i] instanceof IElementIdentity) {
                IDirElement[] elements = ((IDirectoryCacheService)((Object)this.m_dirService)).getElements(entityName, false);
                for (int j = 0; j < elements.length; ++j) {
                    String elementName = elements[j].getIdentity().getName();
                    if (elementName.endsWith("_MFRefreshTime")) continue;
                    alreadyExportedTable.put(elementName, Boolean.TRUE);
                    ElementBuilder builder = new ElementBuilder(elements[j], this.m_xmlWriter);
                    builder.setDirectoryService(this.m_dirService);
                    builder.init();
                }
                continue;
            }
            if (!(list[i] instanceof IDirIdentity) || this.isSystemFolder(list[i].getName())) continue;
            this.m_xmlWriter.setTabCounter();
            this.createDirectoryElement(list[i].getName());
            IIdentity[] subList = this.m_dirService.listAll(list[i].getName());
            this.traverseAddEndElementAndResetTab(subList);
        }
    }

    private void createDirectoryElement(String dirName) {
        HashMap<String, String> attrPair = new HashMap<String, String>();
        attrPair.put("name", dirName);
        this.m_xmlWriter.startElement("Directory", attrPair, false);
    }

    private void createDomainElement() throws DirectoryServiceException {
        HashMap<String, String> attrPair = new HashMap<String, String>();
        attrPair.put("xmlns", "http://www.sonicsw.com/mf");
        attrPair.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        attrPair.put("xsi:schemaLocation", "http://www.sonicsw.com/mf MFConfigurationElements.xsd");
        attrPair.put("name", this.m_dirService.getDomain());
        this.m_xmlWriter.startElement("Domain", attrPair, false);
        this.processDirBranch(this.m_dirName);
        this.m_xmlWriter.endElement("Domain");
    }

    private void processDirBranch(String dirName) throws DirectoryServiceException {
        this.m_xmlWriter.setTabCounter();
        this.createDirectoryElement(dirName);
        IIdentity[] listBranch = this.m_dirService.listAll(dirName);
        this.traverseAddEndElementAndResetTab(listBranch);
    }

    private void traverseAddEndElementAndResetTab(IIdentity[] listBranch) throws DirectoryServiceException {
        if (listBranch.length > 0) {
            this.traverseBranch(listBranch);
        }
        this.m_xmlWriter.endElement("Directory");
        this.m_xmlWriter.resetTabCounter();
    }

    private boolean isSystemFolder(String name) {
        boolean ret = false;
        if (name.compareTo("/_MFSystem") == 0) {
            ret = true;
        }
        return ret;
    }
}

