/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.query;

import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.BooleanExpression;
import com.sonicsw.mf.common.config.query.IDualOperandExpression;
import com.sonicsw.mf.common.config.query.impl.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public final class StartsWithExpression
extends BooleanExpression
implements Serializable,
IDualOperandExpression {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 3;
    private AttributeName m_op1;
    private String m_op2;

    public StartsWithExpression(AttributeName name, String value) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.m_op1 = name;
        this.m_op2 = value;
    }

    @Override
    public Object getFirstOperand() {
        return this.m_op1;
    }

    @Override
    public Object getSecondOperand() {
        return this.m_op2;
    }

    public String toString() {
        return this.m_op1 + " startsWith " + this.m_op2;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(3);
        HashMap<String, Object> table = new HashMap<String, Object>(2, 1.0f);
        table.put("op1", this.m_op1);
        table.put("op2", this.m_op2);
        s.writeObject(table);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 3) {
            Util.throwSerialVersionMismatch(version, 3);
        }
        HashMap table = (HashMap)s.readObject();
        this.m_op1 = (AttributeName)table.get("op1");
        this.m_op2 = (String)table.get("op2");
    }
}

