/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.metrics.impl;

import com.sonicsw.mf.common.metrics.IMetricIdentity;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.StringTokenizer;

public final class MetricIdentity
implements IMetricIdentity {
    static final long serialVersionUID = 619761350679132533L;
    private static final short m_serialVersion = 0;
    private String[] m_nameComponents;
    private long m_hash;
    private static final short ID_HASH_FIELD = 0;
    private static final short ID_NAME_FIELD = 1;

    public MetricIdentity(String[] nameComponents) {
        this.m_nameComponents = nameComponents;
    }

    @Override
    public String[] getNameComponents() {
        return this.m_nameComponents;
    }

    @Override
    public String getName() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_nameComponents.length; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(this.m_nameComponents[i]);
        }
        return sb.toString();
    }

    @Override
    public String getAbsoluteName() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_nameComponents.length; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            StringTokenizer st = new StringTokenizer(this.m_nameComponents[i], ".%", true);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equals(".") || token.equals("%")) {
                    sb.append('%');
                }
                sb.append(token);
            }
        }
        return sb.toString();
    }

    public long getHash() {
        return this.m_hash;
    }

    public void setHash(long hash) {
        this.m_hash = hash;
    }

    public boolean equals(Object id) {
        if (!(id instanceof IMetricIdentity)) {
            return false;
        }
        String[] nameComponents = ((IMetricIdentity)id).getNameComponents();
        if (nameComponents.length != this.m_nameComponents.length) {
            return false;
        }
        for (int i = 0; i < nameComponents.length; ++i) {
            if (this.m_nameComponents[i].equals(nameComponents[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equalsHash(MetricIdentity id) {
        return id.getHash() == this.m_hash;
    }

    @Override
    public boolean isInstanceOf(IMetricIdentity id) {
        String[] nameComponents = id.getNameComponents();
        if (nameComponents.length > this.m_nameComponents.length) {
            return false;
        }
        for (int i = 0; i < nameComponents.length; ++i) {
            if (i > 0 && i == nameComponents.length - 1 && nameComponents[i].indexOf(42) > -1) {
                return MetricIdentity.isPatternMatch(this.m_nameComponents[i], nameComponents[i]);
            }
            if (this.m_nameComponents[i].equals(nameComponents[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isPatternMatch(String matcher, String pattern) {
        if (pattern.length() == 0) {
            return false;
        }
        String inclusionPattern = pattern;
        String[] exclusionPatterns = new String[]{};
        int exclusionPatternIndex = pattern.indexOf("!(");
        if (exclusionPatternIndex > -1 && pattern.endsWith(")")) {
            inclusionPattern = pattern.substring(0, exclusionPatternIndex);
            exclusionPatterns = pattern.substring(exclusionPatternIndex + 2, pattern.length() - 1).split("\\|");
        }
        for (String exclusionPattern : exclusionPatterns) {
            if (!MetricIdentity.matchPattern(matcher, exclusionPattern)) continue;
            return false;
        }
        return MetricIdentity.matchPattern(matcher, inclusionPattern);
    }

    private static boolean matchPattern(String matcherParam, String pattern) {
        String matcher = matcherParam;
        if (pattern.length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(pattern, "*");
        if (st.countTokens() == 0) {
            return true;
        }
        boolean startsWithWild = pattern.startsWith("*");
        boolean endsWithWild = pattern.endsWith("*");
        boolean first = true;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (first && !startsWithWild) {
                if (!matcher.startsWith(token)) {
                    return false;
                }
                matcher = matcher.substring(token.length());
                first = false;
                continue;
            }
            int index = matcher.indexOf(token);
            if (index < 0) {
                return false;
            }
            matcher = matcher.substring(index + token.length());
        }
        if (matcher.length() == 0) {
            return true;
        }
        return endsWithWild;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        int fieldCount = 2;
        stream.writeShort(fieldCount);
        stream.writeShort(0);
        stream.writeShort(0);
        stream.writeLong(this.m_hash);
        stream.writeShort(1);
        stream.writeObject(this.m_nameComponents);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int numFields = stream.readShort();
        short serialVer = stream.readShort();
        for (int i = 0; i < numFields; ++i) {
            short field = stream.readShort();
            switch (serialVer) {
                default: 
            }
            if (field == 0) {
                this.m_hash = stream.readLong();
                continue;
            }
            if (field != 1) continue;
            this.m_nameComponents = (String[])stream.readObject();
        }
    }
}

