/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.jmx.client;

import com.sonicsw.mf.common.runtime.INotification;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.management.Notification;
import javax.management.NotificationFilter;

public class ExpressionBasedNotificationFilter
implements NotificationFilter,
Serializable {
    private static final long serialVersionUID = 0L;
    private String m_typeExpression;
    private HashMap m_attributeExpressions = new HashMap();
    private static boolean m_TestedForRegExParser = false;
    private static boolean m_useJavaRegEx = true;
    private static boolean m_useGNURegEx = true;
    private static volatile Constructor m_reConstructor;
    private static volatile Method m_matchTestMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isNotificationEnabled(Notification notification) {
        if (this.m_typeExpression != null && !this.isMatch(this.m_typeExpression, notification.getType())) {
            return false;
        }
        HashMap hashMap = this.m_attributeExpressions;
        synchronized (hashMap) {
            if (this.m_attributeExpressions.isEmpty()) {
                return true;
            }
            if (!(notification instanceof INotification)) {
                return false;
            }
            HashMap attributes = ((INotification)((Object)notification)).getAttributes();
            for (Map.Entry entry : this.m_attributeExpressions.entrySet()) {
                String attributeName = (String)entry.getKey();
                if (!attributes.containsKey(attributeName)) {
                    return false;
                }
                Object attributeValue = attributes.get(attributeName);
                if (attributeValue == null) {
                    return false;
                }
                if (this.isMatch((String)entry.getValue(), attributeValue.toString())) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized void setTypeExpression(String expression) {
        this.m_typeExpression = expression;
    }

    public synchronized String getTypeExpression() {
        return this.m_typeExpression;
    }

    public synchronized void setAttributeExpression(String attributeName, String expression) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Attribute name null or zero length");
        }
        if (expression == null) {
            this.m_attributeExpressions.remove(attributeName);
        } else {
            this.m_attributeExpressions.put(attributeName, expression);
        }
    }

    public synchronized Map getAttributeExpressions() {
        return (Map)this.m_attributeExpressions.clone();
    }

    public synchronized void clearAllAttributeExpressions() {
        this.m_attributeExpressions.clear();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionBasedNotificationFilter otherFilter = (ExpressionBasedNotificationFilter)obj;
        if (otherFilter.m_typeExpression == null && this.m_typeExpression != null) {
            return false;
        }
        if (otherFilter.m_typeExpression != null && this.m_typeExpression == null) {
            return false;
        }
        if (otherFilter.m_attributeExpressions.size() != this.m_attributeExpressions.size()) {
            return false;
        }
        for (Map.Entry attributeExpressionEntry : otherFilter.m_attributeExpressions.entrySet()) {
            Object expression = this.m_attributeExpressions.get(attributeExpressionEntry.getKey());
            if (expression == null) {
                return false;
            }
            if (attributeExpressionEntry.getValue().equals(expression)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.m_typeExpression);
        if (this.m_attributeExpressions != null && !this.m_attributeExpressions.isEmpty()) {
            values.addAll(this.m_attributeExpressions.values());
        }
        return Objects.hash(values.toArray());
    }

    private boolean isMatch(String regex, String input) {
        if (!m_TestedForRegExParser) {
            this.testForRegExParser();
        }
        if (m_useJavaRegEx) {
            return this.isJavaRegexMatch(regex, input);
        }
        if (m_useGNURegEx) {
            return this.isGNURegexMatch(regex, input);
        }
        throw new IllegalStateException("Regular expression parser (Java or GNU) not available on classpath");
    }

    private boolean isJavaRegexMatch(String regex, String input) {
        try {
            Boolean isMatch = (Boolean)m_matchTestMethod.invoke(null, regex, input);
            return isMatch;
        }
        catch (InvocationTargetException e) {
            this.handleException(e);
            return false;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isGNURegexMatch(String regex, String input) {
        try {
            Object re = m_reConstructor.newInstance(regex);
            Boolean isMatch = (Boolean)m_matchTestMethod.invoke(re, input);
            return isMatch;
        }
        catch (InvocationTargetException e) {
            this.handleException(e);
            return false;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void handleException(InvocationTargetException e) {
        Throwable target = e.getTargetException();
        if (target instanceof RuntimeException) {
            throw (RuntimeException)target;
        }
        e.printStackTrace();
    }

    private void testForRegExParser() {
        try {
            Class<?> patternClass = Class.forName("java.util.regex.Pattern");
            Class<?> charSequenceClass = Class.forName("java.lang.CharSequence");
            m_matchTestMethod = patternClass.getMethod("matches", String.class, charSequenceClass);
        }
        catch (ClassNotFoundException e) {
            m_useJavaRegEx = false;
        }
        catch (NoSuchMethodException e) {
            m_useJavaRegEx = false;
        }
        if (!m_useJavaRegEx) {
            try {
                Class<?> reClass = Class.forName("gnu.regexp.RE");
                m_reConstructor = reClass.getConstructor(Object.class);
                m_matchTestMethod = reClass.getMethod("isMatch", Object.class);
            }
            catch (ClassNotFoundException e) {
                m_useGNURegEx = false;
            }
            catch (NoSuchMethodException e) {
                m_useGNURegEx = false;
            }
        }
        m_TestedForRegExParser = true;
    }
}

