/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SonicArchive {
    private String m_name;

    public SonicArchive(File archive) throws ParserConfigurationException, SAXException, IOException {
        if (!archive.exists()) {
            throw new IOException("Archive path does not exist: " + archive);
        }
        InputStream sonicXML = null;
        if (archive.isDirectory()) {
            File descriptor = new File(archive, "META-INF/sonic.xml");
            if (!descriptor.exists()) {
                throw new IOException("Archive descriptor does not exist: " + descriptor.toString());
            }
            sonicXML = new FileInputStream(descriptor);
        } else {
            JarFile jar = new JarFile(archive);
            ZipEntry descriptor = jar.getEntry("META-INF/sonic.xml");
            if (descriptor == null) {
                throw new IOException("Archive descriptor does not exist: META-INF/sonic.xml");
            }
            sonicXML = jar.getInputStream(descriptor);
        }
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.parse(sonicXML);
        NodeList nodes = document.getDocumentElement().getChildNodes();
        for (int i = nodes.getLength() - 1; i >= 0; --i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equals("name")) continue;
            this.m_name = node.getFirstChild().getNodeValue();
            if (this.m_name != null && this.m_name.length() >= 1) continue;
            throw new IOException("Invalid name name");
        }
    }

    public String getName() {
        return this.m_name;
    }
}

