/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeMetaData;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.upgrade.IMigrationProcess;
import com.sonicsw.mf.common.config.upgrade.IVersionedConfigUpgrade;
import com.sonicsw.mf.common.config.upgrade.UpgradeEnv;
import com.sonicsw.mf.common.dirconfig.DirectoryDoesNotExistException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.security.ssl.CipherSuiteUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class TypedConfigUpgrade76
implements IVersionedConfigUpgrade,
IMigrationProcess {
    private UpgradeEnv m_upgradeEnv = null;

    @Override
    public String basicConfigUpgrade(IDirElement el, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String getUpgradedReleaseVersion() {
        return "104";
    }

    @Override
    public String upgradeMF_ACTIVATION_DAEMON(IDirElement daemon, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String upgradeMF_AGENT_MANAGER(IDirElement agentManager, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String upgradeMF_COLLECTION_MONITOR(IDirElement monitor, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String upgradeMF_HOST_MANAGER(IDirElement hostmanager, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String upgradeMF_CONTAINER(IDirElement container, UpgradeEnv env) throws Exception {
        IAttributeSet topSet = container.getAttributes();
        String containerName = (String)topSet.getAttribute("CONTAINER_NAME");
        IAttributeSet newEnabledMetrics = (IAttributeSet)topSet.getAttribute("ENABLED_METRICS");
        IAttributeSet newCentralConnection = (IAttributeSet)topSet.getAttribute("CENTRAL_CONNECTION");
        IAttributeMetaData metaData = topSet.getAttributeMetaData("WORKING_DIRECTORY");
        if (metaData == null || !metaData.isFromTemplate() && topSet.getAttribute("WORKING_DIRECTORY") != null) {
            topSet.deleteAttribute("WORKING_DIRECTORY");
        }
        String containerCanonicalName = env.getProp("ds.domain") + "." + topSet.getAttribute("CONTAINER_NAME");
        String containerMetricsDir = "/_MFRuntime/" + containerCanonicalName;
        IDirIdentity[] directories = null;
        try {
            directories = env.dsAdmin.listDirectories(containerMetricsDir);
        }
        catch (DirectoryDoesNotExistException notThere) {
            return null;
        }
        HashMap metricsAndAlerts = new HashMap();
        for (int i = 0; i < directories.length; ++i) {
            IDirIdentity dirID = directories[i];
            String component = dirID.getName().substring(dirID.getName().lastIndexOf(47) + 1);
            HashMap compMetricsAndAlerts = new HashMap();
            IDirElement[] compSettings = env.dsAdmin.getAllElements(dirID.getName(), true);
            for (int j = 0; j < 2; ++j) {
                if (compSettings.length <= j) continue;
                IDirElement indivMetricOrAlerts = compSettings[j];
                IAttributeSet indivTop = indivMetricOrAlerts.getAttributes();
                HashMap topMap = indivTop.getAttributes();
                Set topMapKeys = topMap.keySet();
                for (String metricOrAlertName : topMapKeys) {
                    IAttributeSet metricOrAlertSet = (IAttributeSet)indivTop.getAttribute(metricOrAlertName);
                    HashMap alertSettings = metricOrAlertSet.getAttributes();
                    HashMap<String, ArrayList> collectedMetricsAndAlerts = (HashMap<String, ArrayList>)compMetricsAndAlerts.get(metricOrAlertName);
                    if (collectedMetricsAndAlerts == null) {
                        collectedMetricsAndAlerts = new HashMap<String, ArrayList>();
                    }
                    if (!alertSettings.isEmpty()) {
                        IAttributeList low;
                        IAttributeList high = (IAttributeList)alertSettings.get("highThresholds");
                        if (high != null && high.getCount() > 0) {
                            ArrayList colItems = this.createItems(high);
                            collectedMetricsAndAlerts.put("highThresholds", colItems);
                        }
                        if ((low = (IAttributeList)alertSettings.get("lowThresholds")) != null && low.getCount() > 0) {
                            ArrayList colItems = this.createItems(low);
                            collectedMetricsAndAlerts.put("lowThresholds", colItems);
                        }
                    }
                    compMetricsAndAlerts.put(metricOrAlertName, collectedMetricsAndAlerts);
                }
            }
            metricsAndAlerts.put(component, compMetricsAndAlerts);
        }
        Iterator componentNames = metricsAndAlerts.keySet().iterator();
        IAttributeSet components = (IAttributeSet)topSet.getAttribute("COMPONENTS");
        while (componentNames.hasNext()) {
            String componentName = (String)componentNames.next();
            HashMap compMetrics = (HashMap)metricsAndAlerts.get(componentName);
            if (componentName.equals("AGENT")) {
                if (compMetrics != null && newEnabledMetrics == null) {
                    newEnabledMetrics = topSet.createAttributeSet("ENABLED_METRICS");
                }
                this.transferMetrics(compMetrics, newEnabledMetrics);
                continue;
            }
            IAttributeSet compSet = (IAttributeSet)components.getAttribute(componentName);
            if (compMetrics == null || compSet == null) continue;
            IAttributeSet enabledMetricsSet = compSet.createAttributeSet("ENABLED_METRICS");
            this.transferMetrics(compMetrics, enabledMetricsSet);
        }
        String centralProp = (String)env.getContainerProp(containerName, "central.connection.url");
        if (centralProp != null) {
            newCentralConnection = TypedConfigUpgrade76.retrieveNewCentralConnection(newCentralConnection, topSet);
            newCentralConnection.setStringAttribute("ConnectionURLs", centralProp);
        }
        if ((centralProp = (String)env.getContainerProp(containerName, "central.connection.username")) != null) {
            newCentralConnection = TypedConfigUpgrade76.retrieveNewCentralConnection(newCentralConnection, topSet);
            newCentralConnection.setStringAttribute("DefaultUser", centralProp);
        }
        if ((centralProp = (String)env.getContainerProp(containerName, "central.connection.password")) != null) {
            newCentralConnection = TypedConfigUpgrade76.retrieveNewCentralConnection(newCentralConnection, topSet);
            newCentralConnection.setStringAttribute("DefaultPassword", centralProp);
        }
        if ((centralProp = (String)env.getContainerProp(containerName, "central.connection.request.timeout")) != null) {
            newCentralConnection = TypedConfigUpgrade76.retrieveNewCentralConnection(newCentralConnection, topSet);
            newCentralConnection.setIntegerAttribute("REQUEST_TIMEOUT", new Integer(centralProp));
        }
        if ((centralProp = (String)env.getContainerProp(containerName, "central.connection.connect.timeout")) != null) {
            newCentralConnection = TypedConfigUpgrade76.retrieveNewCentralConnection(newCentralConnection, topSet);
            newCentralConnection.setIntegerAttribute("CONNECT_TIMEOUT", new Integer(centralProp));
        }
        if ((centralProp = (String)env.getContainerProp(containerName, "central.connection.socket.connect")) != null) {
            newCentralConnection = TypedConfigUpgrade76.retrieveNewCentralConnection(newCentralConnection, topSet);
            newCentralConnection.setIntegerAttribute("SOCKET_CONNECT_TIMEOUT", new Integer(centralProp));
        }
        if ((centralProp = (String)env.getContainerProp(containerName, "central.connection.load.balancing")) != null) {
            newCentralConnection = TypedConfigUpgrade76.retrieveNewCentralConnection(newCentralConnection, topSet);
            newCentralConnection.setBooleanAttribute("LoadBalancing", new Boolean(centralProp));
        }
        if ((centralProp = (String)env.getContainerProp(containerName, "central.connection.system.properties")) != null) {
            IAttributeSet sysProps = (IAttributeSet)topSet.getAttribute("SYSTEM_PROPERTIES");
            if (sysProps == null) {
                sysProps = topSet.createAttributeSet("SYSTEM_PROPERTIES");
            }
            StringTokenizer propsTokenizer = new StringTokenizer(centralProp, ",=", false);
            while (propsTokenizer.hasMoreTokens()) {
                String prop = propsTokenizer.nextToken();
                String value = propsTokenizer.nextToken();
                sysProps.setStringAttribute(prop, value);
            }
        }
        return null;
    }

    private ArrayList createItems(IAttributeList list) {
        ArrayList lowItems = list.getItems();
        ArrayList<Long> colItems = new ArrayList<Long>();
        Iterator lowIT = lowItems.iterator();
        while (lowIT.hasNext()) {
            long value = (Long)lowIT.next();
            colItems.add(value);
        }
        return colItems;
    }

    private static IAttributeSet retrieveNewCentralConnection(IAttributeSet newCentralConnectionParam, IAttributeSet topSet) throws ConfigException {
        IAttributeSet newCentralConnection = newCentralConnectionParam;
        if (newCentralConnection == null) {
            newCentralConnection = topSet.createAttributeSet("CENTRAL_CONNECTION");
        }
        return newCentralConnection;
    }

    @Override
    public String upgradeMF_DIRECTORY_SERVICE(IDirElement dsElement, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String upgradeMF_BACKUP_DIRECTORY_SERVICE(IDirElement dsElement, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String upgradeMF_LOGGER(IDirElement logger, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String upgradeMQ_BROKER(IDirElement broker, UpgradeEnv env) throws Exception {
        this.m_upgradeEnv = env;
        IAttributeSet topSet = broker.getAttributes();
        IAttributeSet dbSet = (IAttributeSet)topSet.getAttribute("BROKER_DATABASE_PARAMETERS");
        IAttributeMetaData metaData = topSet.getAttributeMetaData("BROKER_DATABASE_PARAMETERS");
        if (metaData == null || !metaData.isFromTemplate() && dbSet != null) {
            String jdbcDriver = (String)dbSet.getAttribute("JDBC_DRIVER");
            metaData = topSet.getAttributeMetaData("JDBC_DRIVER");
            if (metaData == null || !metaData.isFromTemplate() && jdbcDriver != null) {
                dbSet.deleteAttribute("JDBC_DRIVER");
            }
            String dbUser = (String)dbSet.getAttribute("DB_USER");
            metaData = topSet.getAttributeMetaData("DB_USER");
            if (metaData == null || !metaData.isFromTemplate() && dbUser != null) {
                dbSet.deleteAttribute("DB_USER");
            }
            String dbPwd = (String)dbSet.getAttribute("DB_PASSWORD");
            metaData = topSet.getAttributeMetaData("DB_PASSWORD");
            if (metaData == null || !metaData.isFromTemplate() && dbPwd != null) {
                dbSet.deleteAttribute("DB_PASSWORD");
            }
            String dbConnect = (String)dbSet.getAttribute("DB_CONNECT");
            metaData = topSet.getAttributeMetaData("DB_CONNECT");
            if (metaData == null || !metaData.isFromTemplate() && dbConnect != null) {
                dbSet.deleteAttribute("DB_CONNECT");
            }
            String dbProps = (String)dbSet.getAttribute("DB_PROPERTIES");
            metaData = topSet.getAttributeMetaData("DB_PROPERTIES");
            if (metaData == null || !metaData.isFromTemplate() && dbProps != null) {
                dbSet.deleteAttribute("DB_PROPERTIES");
            }
            String dbCheck = (String)dbSet.getAttribute("DB_CHECK_INTERVAL");
            metaData = topSet.getAttributeMetaData("DB_CHECK_INTERVAL");
            if (metaData == null || !metaData.isFromTemplate() && dbCheck != null) {
                dbSet.deleteAttribute("DB_CHECK_INTERVAL");
            }
        }
        this.migrateToJSSE(topSet, broker.getIdentity().getType());
        return null;
    }

    private void migrateToJSSE(IAttributeSet topSet, String brokerType) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        HashMap values;
        IAttributeSet CRLSet;
        IAttributeSet sslSet = (IAttributeSet)topSet.getAttribute("BROKER_SSL_PARAMETERS");
        IAttributeMetaData sslMetaData = topSet.getAttributeMetaData("BROKER_SSL_PARAMETERS");
        if (sslSet != null && (CRLSet = (IAttributeSet)sslSet.getAttribute("CA_LIST")) != null && !(values = CRLSet.getAttributes()).isEmpty()) {
            return;
        }
        if (!(sslMetaData != null && sslMetaData.isFromTemplate() || sslSet == null)) {
            String ciphersSet = this.retrieveCiphersSet(brokerType, sslSet);
            IAttributeMetaData cipherMeta = sslSet.getAttributeMetaData("SSL_CIPHER_SUITES");
            if (!(cipherMeta != null && cipherMeta.isFromTemplate() || ciphersSet == null)) {
                if (this.m_upgradeEnv.isDEBUG()) {
                    System.out.println("TypesConfigUpgrade76.migrateToJSSE original ciphers " + ciphersSet);
                }
                this.populateCiphers(ciphersSet, sslSet);
            }
        }
    }

    private void populateCiphers(String ciphersSet, IAttributeSet sslSet) throws ConfigException {
        String newCiphers = "";
        StringTokenizer parseIt = new StringTokenizer(ciphersSet, ",", false);
        while (parseIt.hasMoreTokens()) {
            String cipher = parseIt.nextToken();
            String substitute = CipherSuiteUtil.getJSSECipherSuiteFromRSA((String)cipher);
            newCiphers = substitute == null ? newCiphers + cipher : newCiphers + substitute;
            if (!parseIt.hasMoreTokens()) continue;
            newCiphers = newCiphers + ",";
        }
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("TypesConfigUpgrade76.migrateToJSSE new ciphers " + newCiphers);
        }
        sslSet.setStringAttribute("SSL_CIPHER_SUITES", newCiphers);
    }

    private String retrieveCiphersSet(String brokerType, IAttributeSet sslSet) throws ConfigException {
        IAttributeMetaData providerClassMD = sslSet.getAttributeMetaData("SSL_PROVIDER_CLASS");
        if (brokerType.equals("MQ_BROKER") && (providerClassMD == null || !providerClassMD.isFromTemplate())) {
            sslSet.setStringAttribute("SSL_PROVIDER_CLASS", "progress.message.net.ssl.jsse.jsseSSLImpl");
        }
        String ciphersSet = (String)sslSet.getAttribute("SSL_CIPHER_SUITES");
        return ciphersSet;
    }

    private void transferMetrics(HashMap compMetrics, IAttributeSet newEnabledMetrics) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        Set agentMetricNames = compMetrics.keySet();
        for (String metric : agentMetricNames) {
            IAttributeSet newMetricSet = newEnabledMetrics.createAttributeSet(metric);
            HashMap thresholds = (HashMap)compMetrics.get(metric);
            for (String lowOrHigh : thresholds.keySet()) {
                ArrayList value = (ArrayList)thresholds.get(lowOrHigh);
                if (lowOrHigh.equals("highThresholds")) {
                    newMetricSet.setStringAttribute("HIGH_THRESHOLDS", ((Long)value.get(0)).toString());
                    continue;
                }
                if (!lowOrHigh.equals("lowThresholds")) continue;
                newMetricSet.setStringAttribute("LOW_THRESHOLDS", ((Long)value.get(0)).toString());
            }
        }
    }

    @Override
    public String upgradeMQ_CLUSTER(IDirElement cluster, UpgradeEnv env) throws Exception {
        return null;
    }

    @Override
    public String upgradeXQ_CONTAINER(IDirElement xqContainer, UpgradeEnv env) throws Exception {
        return null;
    }
}

