/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.view.impl;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.view.IViewElementAttributes;
import java.util.HashMap;

public class ViewElementAttributes
implements IViewElementAttributes {
    private String[] m_attrNames = null;
    private HashMap m_attributes = new HashMap();
    private IAttributeList m_attrValues = null;

    ViewElementAttributes() {
    }

    @Override
    public String getAttribute(String attributeName) {
        return (String)this.m_attributes.get(attributeName);
    }

    @Override
    public void setAttribute(String attributeName, String value) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        int position = this.getPosition(attributeName);
        if (position == -1) {
            throw new AttributeSetTypeException("Attribute name is not defined");
        }
        this.m_attributes.put(attributeName, value);
        this.m_attrValues.setNewStringItem(position, value);
    }

    @Override
    public void resetAttributeValue(String attributeName) throws ConfigException {
        int position = this.getPosition(attributeName);
        if (position == -1) {
            throw new ConfigException("Attribute name is not defined");
        }
        this.m_attributes.put(attributeName, "");
        this.m_attrValues.setNewStringItem(position, "");
    }

    @Override
    public HashMap getAttributes() {
        return this.m_attributes;
    }

    void setAttributeNamesList(String[] listNames) {
        this.m_attrNames = listNames;
    }

    void setAttributeValuesList(IAttributeList listValues) {
        this.m_attrValues = listValues;
        if (this.m_attrValues.getCount() == 0) {
            this.createEmptyListItems();
        }
        for (int i = 0; i < this.m_attrNames.length; ++i) {
            this.m_attributes.put(this.m_attrNames[i], (String)this.m_attrValues.getItem(i));
        }
    }

    private int getPosition(String attributeName) {
        int pos = -1;
        for (int i = 0; i < this.m_attrNames.length; ++i) {
            if (attributeName.compareTo(this.m_attrNames[i]) != 0) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private void createEmptyListItems() {
        try {
            for (int i = 0; i < this.m_attrNames.length; ++i) {
                this.m_attrValues.addStringItem("");
            }
        }
        catch (ReadOnlyException readOnlyException) {
            // empty catch block
        }
    }
}

