/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeList;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.AttributeList;
import com.sonicsw.mf.common.config.impl.AttributeSet;
import com.sonicsw.mf.common.config.impl.CannotAdjustToSuperModificationException;
import com.sonicsw.mf.common.config.impl.DeltaAttributeList;
import com.sonicsw.mf.common.config.impl.ICanReplaceRef;
import com.sonicsw.mf.common.config.impl.IDelta;
import com.sonicsw.mf.common.config.impl.IReplaceRef;
import com.sonicsw.mf.common.config.impl.Util;
import com.sonicsw.mf.common.config.query.AttributeName;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

final class DeltaAttributeSet
implements IDeltaAttributeSet,
IDelta,
Serializable,
ICanReplaceRef {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 3;
    private String m_typeName;
    private HashMap m_deltaValues;
    private String[] m_deletedAttributes;
    private String[] m_modifiedAttributes;
    private String[] m_newAttributes;

    DeltaAttributeSet(String typeName, HashMap modHistory, HashMap deltaValues) {
        this.m_typeName = typeName;
        this.m_deltaValues = deltaValues;
        Set set = modHistory.keySet();
        int deletedCount = 0;
        int newCount = 0;
        int modifiedCount = 0;
        for (String attribute : set) {
            switch ((Integer)modHistory.get(attribute)) {
                case 1: {
                    ++deletedCount;
                    break;
                }
                case 2: {
                    ++newCount;
                    break;
                }
                case 3: {
                    ++modifiedCount;
                }
            }
        }
        this.m_deletedAttributes = new String[deletedCount];
        this.m_newAttributes = new String[newCount];
        this.m_modifiedAttributes = new String[modifiedCount];
        deletedCount = 0;
        newCount = 0;
        modifiedCount = 0;
        for (String attribute : set) {
            switch ((Integer)modHistory.get(attribute)) {
                case 1: {
                    this.m_deletedAttributes[deletedCount++] = attribute;
                    break;
                }
                case 2: {
                    this.m_newAttributes[newCount++] = attribute;
                    break;
                }
                case 3: {
                    this.m_modifiedAttributes[modifiedCount++] = attribute;
                }
            }
        }
    }

    public boolean emptyDelta() {
        return this.m_deletedAttributes.length == 0 && this.m_newAttributes.length == 0 && this.m_modifiedAttributes.length == 0;
    }

    public int estimateSize() {
        int i;
        int estimate = 64 + Util.estimateSize(this.m_typeName);
        if (this.m_deltaValues != null) {
            estimate += Util.estimateHashMapSize(this.m_deltaValues);
        }
        if (this.m_deletedAttributes != null) {
            for (i = 0; i < this.m_deletedAttributes.length; ++i) {
                estimate += Util.estimateSize(this.m_deletedAttributes[i]);
            }
        }
        if (this.m_modifiedAttributes != null) {
            for (i = 0; i < this.m_modifiedAttributes.length; ++i) {
                estimate += Util.estimateSize(this.m_modifiedAttributes[i]);
            }
        }
        if (this.m_newAttributes != null) {
            for (i = 0; i < this.m_newAttributes.length; ++i) {
                estimate += Util.estimateSize(this.m_newAttributes[i]);
            }
        }
        return estimate;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(3);
        s.writeObject(this.m_typeName);
        s.writeObject(this.m_deltaValues);
        s.writeObject(this.m_deletedAttributes);
        s.writeObject(this.m_modifiedAttributes);
        s.writeObject(this.m_newAttributes);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 3) {
            Util.throwSerialVersionMismatch(version, 3);
        }
        this.m_typeName = (String)s.readObject();
        this.m_deltaValues = (HashMap)s.readObject();
        this.m_deletedAttributes = (String[])s.readObject();
        this.m_modifiedAttributes = (String[])s.readObject();
        this.m_newAttributes = (String[])s.readObject();
    }

    @Override
    public boolean replaceReferences(boolean thisIsSystemAttributesDelta, IReplaceRef replaceSrvc) {
        Set keys = this.m_deltaValues.keySet();
        Iterator iter = keys.iterator();
        boolean retVal = true;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = this.m_deltaValues.get(key);
            if (thisIsSystemAttributesDelta && key.equals("SUPER_REFERENCE")) {
                try {
                    this.m_deltaValues.put(key, replaceSrvc.replace((String)value));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Error(e.toString());
                }
            }
            if (value instanceof ICanReplaceRef) {
                boolean ret = ((ICanReplaceRef)value).replaceReferences(key.equals("_MF_SYSTEM_ATTRIBUTES"), replaceSrvc);
                if (ret) continue;
                retVal = false;
                continue;
            }
            if (!(value instanceof Reference)) continue;
            Reference newRef = replaceSrvc.replace((Reference)value);
            if (newRef.getElementName().startsWith("/NO_STORAGE:")) {
                retVal = false;
            }
            this.m_deltaValues.put(key, newRef);
        }
        return retVal;
    }

    String getTypeName() {
        return this.m_typeName;
    }

    @Override
    public String[] getDeletedAttributesNames() {
        return this.m_deletedAttributes;
    }

    @Override
    public String[] getModifiedAttributesNames() {
        return this.m_modifiedAttributes;
    }

    @Override
    public String[] getNewAttributesNames() {
        return this.m_newAttributes;
    }

    @Override
    public Object getNewValue(String attributeName) throws NotModifiedAttException {
        Object value = this.m_deltaValues.get(attributeName);
        if (value == null) {
            throw new NotModifiedAttException();
        }
        return value;
    }

    Object getValue(String attributeName) {
        return this.m_deltaValues.get(attributeName);
    }

    void toAttributeSet(IAttributeSet attributeSet) throws Exception {
        int i;
        attributeSet.setBooleanAttribute("_MF_DELTA_OJECT_IMPL", Boolean.TRUE);
        attributeSet.setStringAttribute("TYPE_NAME", this.m_typeName);
        IAttributeList deletedAttributes = attributeSet.createAttributeList("DELETED_ATTRIBUTES");
        IAttributeList newAttributes = attributeSet.createAttributeList("NEW_ATTRIBUTES");
        IAttributeList modifiedAttributes = attributeSet.createAttributeList("MODIFIED_ATTRIBUTES");
        IAttributeSet deltaValues = attributeSet.createAttributeSet("DELTA_VALUES");
        for (i = 0; i < this.m_deletedAttributes.length; ++i) {
            deletedAttributes.addStringItem(this.m_deletedAttributes[i]);
        }
        for (i = 0; i < this.m_newAttributes.length; ++i) {
            newAttributes.addStringItem(this.m_newAttributes[i]);
        }
        for (i = 0; i < this.m_modifiedAttributes.length; ++i) {
            modifiedAttributes.addStringItem(this.m_modifiedAttributes[i]);
        }
        for (String key : this.m_deltaValues.keySet()) {
            IAttributeSet convertedValue;
            Object value = this.m_deltaValues.get(key);
            if (value instanceof IDeltaAttributeSet) {
                convertedValue = deltaValues.createAttributeSet(key);
                ((DeltaAttributeSet)value).toAttributeSet(convertedValue);
                continue;
            }
            if (value instanceof IDeltaAttributeList) {
                convertedValue = deltaValues.createAttributeSet(key);
                ((DeltaAttributeList)value).toAttributeSet(convertedValue);
                continue;
            }
            ((AttributeSet)deltaValues).setAttributeObject(key, value, false);
        }
    }

    void adjustToSubclassedModification(DeltaAttributeSet subModification) {
        HashMap newAttributes = this.createAttributeMap(this.m_newAttributes);
        HashMap modifiedAttributes = this.cloneModifiedAttributes();
        HashMap deletedAttributes = this.cloneDeletedAttributes();
        this.populateDeletedAttributesDeltaValues(deletedAttributes, modifiedAttributes, newAttributes, subModification);
        for (int i = 0; i < subModification.m_modifiedAttributes.length; ++i) {
            String attribute = subModification.m_modifiedAttributes[i];
            if (newAttributes.get(attribute) != null) {
                this.handleValue(attribute, subModification);
                continue;
            }
            if (modifiedAttributes.get(attribute) != null) {
                this.handleDeltaAttributeSetValue(attribute, subModification);
                continue;
            }
            modifiedAttributes.put(attribute, "");
            this.m_deltaValues.put(attribute, subModification.m_deltaValues.get(attribute));
        }
        this.populateAttributes(deletedAttributes, modifiedAttributes, newAttributes);
    }

    private void populateDeletedAttributesDeltaValues(HashMap deletedAttributes, HashMap modifiedAttributes, HashMap newAttributes, DeltaAttributeSet subModification) {
        String attribute;
        int i;
        for (i = 0; i < subModification.m_deletedAttributes.length; ++i) {
            attribute = subModification.m_deletedAttributes[i];
            newAttributes.remove(attribute);
            modifiedAttributes.remove(attribute);
            this.m_deltaValues.remove(attribute);
            deletedAttributes.put(attribute, "");
        }
        for (i = 0; i < subModification.m_newAttributes.length; ++i) {
            attribute = subModification.m_newAttributes[i];
            deletedAttributes.remove(attribute);
            newAttributes.put(attribute, "");
            this.m_deltaValues.put(attribute, subModification.m_deltaValues.get(attribute));
        }
    }

    private void populateAttributes(HashMap deletedAttributes, HashMap modifiedAttributes, HashMap newAttributes) {
        Iterator iterator = deletedAttributes.keySet().iterator();
        this.m_deletedAttributes = new String[deletedAttributes.size()];
        int j = 0;
        while (iterator.hasNext()) {
            this.m_deletedAttributes[j++] = (String)iterator.next();
        }
        iterator = modifiedAttributes.keySet().iterator();
        this.m_modifiedAttributes = new String[modifiedAttributes.size()];
        j = 0;
        while (iterator.hasNext()) {
            this.m_modifiedAttributes[j++] = (String)iterator.next();
        }
        iterator = newAttributes.keySet().iterator();
        this.m_newAttributes = new String[newAttributes.size()];
        j = 0;
        while (iterator.hasNext()) {
            this.m_newAttributes[j++] = (String)iterator.next();
        }
    }

    private void handleDeltaAttributeSetValue(String attribute, DeltaAttributeSet subModification) throws Error {
        Object newValue = subModification.m_deltaValues.get(attribute);
        Object oldValue = this.m_deltaValues.get(attribute);
        if (!(newValue instanceof DeltaAttributeSet)) {
            this.m_deltaValues.put(attribute, newValue);
        } else if (!(oldValue instanceof DeltaAttributeSet)) {
            try {
                ((AttributeSet)oldValue).applyDelta((DeltaAttributeSet)newValue);
            }
            catch (AttributeSetTypeException e) {
                throw new Error(e.toString());
            }
        } else {
            ((DeltaAttributeSet)oldValue).adjustToSubclassedModification((DeltaAttributeSet)newValue);
        }
    }

    private void handleValue(String attribute, DeltaAttributeSet subModification) throws Error {
        Object newValue = subModification.m_deltaValues.get(attribute);
        if (!(newValue instanceof DeltaAttributeSet)) {
            this.m_deltaValues.put(attribute, newValue);
        } else {
            AttributeSet original = (AttributeSet)this.m_deltaValues.get(attribute);
            try {
                original.applyDelta((DeltaAttributeSet)newValue);
            }
            catch (AttributeSetTypeException e) {
                throw new Error(e.toString());
            }
        }
    }

    void adjustToSuperclassModification(DeltaAttributeSet superModification) throws CannotAdjustToSuperModificationException {
        HashMap deletedAttributes = this.cloneDeletedAttributes();
        this.populateAttributes(deletedAttributes, superModification);
        for (int i = 0; i < superModification.m_modifiedAttributes.length; ++i) {
            Object thisDeltaNewValue = this.m_deltaValues.get(superModification.m_modifiedAttributes[i]);
            Object superDeltaNewValue = superModification.m_deltaValues.get(superModification.m_modifiedAttributes[i]);
            if (thisDeltaNewValue == null || !(thisDeltaNewValue instanceof DeltaAttributeSet)) continue;
            if (thisDeltaNewValue instanceof DeltaAttributeSet && !(superDeltaNewValue instanceof DeltaAttributeSet)) {
                throw new CannotAdjustToSuperModificationException(superModification.m_modifiedAttributes[i]);
            }
            this.validateAndAdjustData(i, superDeltaNewValue, superModification, thisDeltaNewValue);
        }
    }

    private void populateAttributes(HashMap deletedAttributes, DeltaAttributeSet superModification) {
        HashMap modifiedAttributes = this.cloneModifiedAttributes();
        for (int i = 0; i < superModification.m_deletedAttributes.length; ++i) {
            String removedAttribute = superModification.m_deletedAttributes[i];
            deletedAttributes.remove(removedAttribute);
            modifiedAttributes.remove(removedAttribute);
        }
        Iterator iterator = deletedAttributes.keySet().iterator();
        this.m_deletedAttributes = new String[deletedAttributes.size()];
        int j = 0;
        while (iterator.hasNext()) {
            this.m_deletedAttributes[j++] = (String)iterator.next();
        }
        iterator = modifiedAttributes.keySet().iterator();
        this.m_modifiedAttributes = new String[modifiedAttributes.size()];
        j = 0;
        while (iterator.hasNext()) {
            this.m_modifiedAttributes[j++] = (String)iterator.next();
        }
    }

    private void validateAndAdjustData(int i, Object superDeltaNewValue, DeltaAttributeSet superModification, Object thisDeltaNewValue) throws CannotAdjustToSuperModificationException, Error {
        if (!(thisDeltaNewValue instanceof DeltaAttributeSet) || !(superDeltaNewValue instanceof DeltaAttributeSet)) {
            throw new Error();
        }
        try {
            ((DeltaAttributeSet)thisDeltaNewValue).adjustToSuperclassModification((DeltaAttributeSet)superDeltaNewValue);
        }
        catch (CannotAdjustToSuperModificationException e) {
            throw new CannotAdjustToSuperModificationException(superModification.m_modifiedAttributes[i] + "|" + e.getFailingAttribute());
        }
    }

    private HashMap cloneDeletedAttributes() {
        HashMap deletedAttributes = this.createAttributeMap(this.m_deletedAttributes);
        return deletedAttributes;
    }

    private HashMap cloneModifiedAttributes() {
        HashMap modifiedAttributes = this.createAttributeMap(this.m_modifiedAttributes);
        return modifiedAttributes;
    }

    private HashMap createAttributeMap(String[] m_newAttributes) {
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        for (int i = 0; i < m_newAttributes.length; ++i) {
            newAttributes.put(m_newAttributes[i], "");
        }
        return newAttributes;
    }

    void revertToTemplate(AttributeName[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            this.revertToTemplate(attributes[i]);
        }
    }

    void revertToTemplate(AttributeName attribute) {
        this.m_deletedAttributes = this.revertInternal(this.m_deletedAttributes, attribute);
        this.m_modifiedAttributes = this.revertInternal(this.m_modifiedAttributes, attribute);
        this.m_newAttributes = this.revertInternal(this.m_newAttributes, attribute);
    }

    String[] revertInternal(String[] modArray, AttributeName attrName) {
        String[] newArray = (String[])modArray.clone();
        String firstComponent = (String)attrName.getComponent(0);
        Object value = this.getValue(firstComponent);
        for (int i = 0; i < modArray.length; ++i) {
            if (!modArray[i].equals(firstComponent)) continue;
            if (value != null && value instanceof IDelta && attrName.getComponentCount() > 1) {
                newArray = this.createAttributeAndRetrieveModification(attrName, firstComponent, i, modArray, newArray, value);
                continue;
            }
            newArray = this.removeModification(modArray, i);
            this.m_deltaValues.remove(firstComponent);
        }
        return newArray;
    }

    private String[] createAttributeAndRetrieveModification(AttributeName attrName, String firstComponent, int i, String[] modArray, String[] newArrayParam, Object value) {
        String[] newArray = newArrayParam;
        AttributeName subAttr = new AttributeName((String)attrName.getComponent(1));
        for (int m = 2; m < attrName.getComponentCount(); ++m) {
            subAttr.setNextComponent((String)attrName.getComponent(m));
        }
        ((DeltaAttributeSet)value).revertToTemplate(subAttr);
        if (((DeltaAttributeSet)value).getDeletedAttributesNames().length == 0 && ((DeltaAttributeSet)value).getNewAttributesNames().length == 0 && ((DeltaAttributeSet)value).getModifiedAttributesNames().length == 0) {
            newArray = this.removeModification(modArray, i);
            this.m_deltaValues.remove(firstComponent);
        }
        return newArray;
    }

    String[] removeModification(String[] modArray, int removeIndex) {
        Vector<String> newAttrs = new Vector<String>(modArray.length);
        for (int j = 0; j < modArray.length; ++j) {
            if (j == removeIndex) continue;
            newAttrs.add(modArray[j]);
        }
        String[] newArray = new String[newAttrs.size()];
        newAttrs.toArray(newArray);
        return newArray;
    }

    boolean properForSubclassing() {
        for (Object value : this.m_deltaValues.values()) {
            if (value instanceof DeltaAttributeList) {
                return false;
            }
            if (!(value instanceof DeltaAttributeSet) || ((DeltaAttributeSet)value).properForSubclassing()) continue;
            return false;
        }
        return true;
    }

    boolean inSuperElement(AttributeName name) {
        Object newValue = this.findComponentNewValue(name);
        if (newValue == null) {
            return true;
        }
        if (name.getComponentCount() == 1) {
            return false;
        }
        if (newValue instanceof AttributeSet || newValue instanceof AttributeList) {
            return false;
        }
        return ((DeltaAttributeSet)newValue).inSuperElement(com.sonicsw.mf.common.config.query.impl.Util.removeFirstComponent(name));
    }

    String[] getDeletedAttributes(AttributeName name) {
        if (name.getComponentCount() == 0) {
            return this.getDeletedAttributes();
        }
        Object newValue = this.findComponentNewValue(name);
        if (newValue == null) {
            return new String[0];
        }
        if (newValue instanceof AttributeSet || newValue instanceof AttributeList) {
            return null;
        }
        return ((DeltaAttributeSet)newValue).getDeletedAttributes(com.sonicsw.mf.common.config.query.impl.Util.removeFirstComponent(name));
    }

    private Object findComponentNewValue(AttributeName name) {
        String firstComponent = (String)name.getComponent(0);
        Object newValue = null;
        try {
            newValue = this.getNewValue(firstComponent);
        }
        catch (NotModifiedAttException notModifiedAttException) {
            // empty catch block
        }
        return newValue;
    }

    private String[] getDeletedAttributes() {
        String[] deletedAttributes = new String[this.m_deletedAttributes.length];
        System.arraycopy(this.m_deletedAttributes, 0, deletedAttributes, 0, this.m_deletedAttributes.length);
        return deletedAttributes;
    }
}

