/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.xml;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.xml.ElementBuilder;
import com.sonicsw.mf.common.xml.XMLStringWriter;
import java.util.HashMap;

public class ElementListBuilder {
    private IDirElement[] m_elements;
    XMLStringWriter m_xmlWriter = null;
    IDirectoryAdminService m_dirService;

    public ElementListBuilder(IDirElement[] elements) {
        this.m_elements = elements;
        this.m_xmlWriter = new XMLStringWriter();
    }

    public void setDirectoryService(IDirectoryAdminService dirService) {
        this.m_dirService = dirService;
    }

    public void init() throws DirectoryServiceException {
        if (this.m_dirService == null) {
            return;
        }
        this.m_xmlWriter.setProcInstruction("1.0", "UTF-8");
        this.createDomainElement();
    }

    private void createDomainElement() throws DirectoryServiceException {
        HashMap<String, String> attrPair = new HashMap<String, String>();
        attrPair.put("xmlns", "http://www.sonicsw.com/mf");
        attrPair.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        attrPair.put("xsi:schemaLocation", "http://www.sonicsw.com/mf MFConfigurationElements.xsd");
        attrPair.put("name", this.m_dirService.getDomain());
        this.m_xmlWriter.startElement("Domain", attrPair, false);
        this.processElements();
        this.m_xmlWriter.endElement("Domain");
    }

    private void processElements() throws DirectoryServiceException {
        if (this.m_elements != null && this.m_elements.length > 0) {
            for (int i = 0; i < this.m_elements.length; ++i) {
                IDirElement el = this.m_elements[i];
                ElementBuilder builder = new ElementBuilder(el, this.m_xmlWriter);
                builder.setDirectoryService(this.m_dirService);
                builder.init();
            }
        }
    }

    public String getXMLString() {
        return this.m_xmlWriter.getXMLString().toString();
    }
}

