/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common;

import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFProxyException;
import com.sonicsw.mf.common.MFProxyRuntimeException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class MFRuntimeException
extends RuntimeException
implements Serializable {
    private static final long serialVersionUID = 8192287077613976467L;
    private static final short m_serialVersion = 0;
    private String m_message;

    public MFRuntimeException() {
    }

    public MFRuntimeException(String message) {
        this.m_message = message;
    }

    public MFRuntimeException(String message, Throwable cause) {
        super(message, cause);
        this.m_message = message;
    }

    @Override
    public String getMessage() {
        return this.m_message;
    }

    public Exception getLinkedException() {
        Throwable cause = super.getCause();
        if (cause == null) {
            return null;
        }
        if (cause instanceof MFProxyException) {
            return (Exception)cause.getCause();
        }
        return (Exception)cause;
    }

    public void setLinkedException(Exception e) {
        if (e == null) {
            return;
        }
        super.initCause(e instanceof MFException || e instanceof MFRuntimeException ? e : new MFProxyRuntimeException(e));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(3);
        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(0));
        stream.writeUTF("message");
        stream.writeObject(this.m_message);
        stream.writeUTF("linked");
        stream.writeObject(super.getCause());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int numValues = stream.readInt();
        HashMap<String, Object> map = new HashMap<String, Object>(numValues);
        for (int i = 0; i < numValues; ++i) {
            map.put(stream.readUTF(), stream.readObject());
        }
        switch ((Short)map.get("serialVersion")) {
            default: 
        }
        try {
            this.m_message = (String)map.get("message");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            super.initCause((MFProxyRuntimeException)map.get("linked"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

