/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IAttributeSetType;
import com.sonicsw.mf.common.config.ITypeCollection;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.impl.Util;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class MergeUtil {
    public static void mergeModifications(IDirElement originalElement, IDirElement modifiedElement) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        MergeUtil.mergeModifications(originalElement, modifiedElement, false);
    }

    public static void mergeModifications(IDirElement originalElement, IDirElement modifiedElement, boolean sparseMode) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        IAttributeSet modifiedElements = modifiedElement.getAttributes();
        IAttributeSet originalElements = originalElement.getAttributes();
        MergeUtil.mergeAddAndSet(originalElements, modifiedElements);
        if (!sparseMode) {
            MergeUtil.deleteDeletedElements(originalElements, modifiedElements);
        }
    }

    private static void deleteDeletedElements(IAttributeSet original, IAttributeSet modified) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        HashMap map = original.getAttributes();
        Set keys = map.keySet();
        for (String key : keys) {
            if (key.equals("_MF_SYSTEM_ATTRIBUTES")) continue;
            Object modifiedValue = modified.getAttribute(key);
            Object originalValue = original.getAttribute(key);
            if (modifiedValue == null) {
                original.deleteAttribute(key);
                continue;
            }
            if (!(modifiedValue instanceof IAttributeSet)) continue;
            MergeUtil.deleteDeletedElements((IAttributeSet)originalValue, (IAttributeSet)modifiedValue);
        }
    }

    public static void mergeAddAndSet(IAttributeSet original, IAttributeSet modified) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        HashMap map = modified.getAttributes();
        Set keys = map.keySet();
        for (String key : keys) {
            IAttributeList nlist;
            IAttributeList mlist;
            IAttributeSet nset;
            IAttributeSet mset;
            Object modifiedValue = map.get(key);
            Object originalValue = original.getAttribute(key);
            if (originalValue == null) {
                if (modifiedValue instanceof IAttributeSet) {
                    mset = (IAttributeSet)modifiedValue;
                    nset = MergeUtil.createNewSet(key, original, mset, original.getAttributeSetType(mset.getTypeName()));
                    MergeUtil.setAttributeSet(nset, mset);
                    continue;
                }
                if (modifiedValue instanceof IAttributeList) {
                    mlist = (IAttributeList)modifiedValue;
                    nlist = MergeUtil.createNewList(key, original, mlist);
                    MergeUtil.setAttributeList(nlist, mlist);
                    continue;
                }
                original.setObjectAttribute(key, modifiedValue);
                continue;
            }
            if (modifiedValue instanceof IAttributeSet) {
                if (originalValue instanceof IAttributeSet) {
                    if (((ITypeCollection)originalValue).typesEqual((ITypeCollection)modifiedValue)) {
                        MergeUtil.mergeAddAndSet((IAttributeSet)originalValue, (IAttributeSet)modifiedValue);
                        continue;
                    }
                    original.deleteAttribute(key);
                    mset = (IAttributeSet)modifiedValue;
                    nset = MergeUtil.createNewSet(key, original, mset, original.getAttributeSetType(mset.getTypeName()));
                    MergeUtil.setAttributeSet(nset, mset);
                    continue;
                }
                original.deleteAttribute(key);
                mset = (IAttributeSet)modifiedValue;
                nset = MergeUtil.createNewSet(key, original, mset, original.getAttributeSetType(mset.getTypeName()));
                MergeUtil.setAttributeSet(nset, mset);
                continue;
            }
            if (modifiedValue instanceof IAttributeList) {
                if (originalValue instanceof IAttributeList) {
                    if (MergeUtil.isEqual((IAttributeList)modifiedValue, (IAttributeList)originalValue)) continue;
                    IAttributeList ml = (IAttributeList)modifiedValue;
                    IAttributeList ol = MergeUtil.createNewList(key, original, ml);
                    MergeUtil.setAttributeList(ol, ml);
                    continue;
                }
                original.deleteAttribute(key);
                mlist = (IAttributeList)modifiedValue;
                nlist = MergeUtil.createNewList(key, original, mlist);
                MergeUtil.setAttributeList(nlist, mlist);
                continue;
            }
            original.setObjectAttribute(key, modifiedValue);
        }
        String[] markedForDeletion = modified.mergeUtilHint_getAttributesMarkedDeleted();
        for (int i = 0; i < markedForDeletion.length; ++i) {
            original.deleteAttribute(markedForDeletion[i]);
        }
    }

    private static boolean isEqual(IAttributeList original, IAttributeList modified) {
        if (!original.typesEqual(modified)) {
            return false;
        }
        ArrayList originalList = original.getItems();
        ArrayList modifiedList = modified.getItems();
        int originalSize = originalList.size();
        if (originalSize != modifiedList.size()) {
            return false;
        }
        for (int count = 0; count < originalSize; ++count) {
            Object modifiedValue;
            Object originalValue = originalList.get(count);
            if (MergeUtil.equalHelper(originalValue, modifiedValue = modifiedList.get(count))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(IAttributeSet original, IAttributeSet modified) {
        if (!original.typesEqual(modified)) {
            return false;
        }
        String originalTypeName = original.getTypeName();
        String modifiedTypeName = modified.getTypeName();
        if (originalTypeName == null ? modifiedTypeName != null : (modifiedTypeName == null ? originalTypeName != null : !originalTypeName.equals(modifiedTypeName))) {
            return false;
        }
        HashMap map = modified.getAttributes();
        Set keys = map.keySet();
        for (String key : keys) {
            Object modifiedValue = map.get(key);
            Object originalValue = original.getAttribute(key);
            if (originalValue == null) {
                return false;
            }
            if (MergeUtil.equalHelper(originalValue, modifiedValue)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalHelper(Object originalValue, Object modifiedValue) {
        if (modifiedValue instanceof IAttributeSet) {
            if (originalValue instanceof IAttributeSet) {
                return MergeUtil.isEqual((IAttributeSet)originalValue, (IAttributeSet)modifiedValue);
            }
            return false;
        }
        if (modifiedValue instanceof IAttributeList) {
            if (originalValue instanceof IAttributeList) {
                return MergeUtil.isEqual((IAttributeList)modifiedValue, (IAttributeList)originalValue);
            }
            return false;
        }
        return Util.atomicAndEqual(originalValue, modifiedValue);
    }

    private static void setAttributeSet(IAttributeSet newSet, IAttributeSet modifiedSet) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        HashMap map = modifiedSet.getAttributes();
        Set keys = map.keySet();
        for (String key : keys) {
            Object value = modifiedSet.getAttribute(key);
            if (value instanceof IAttributeSet) {
                IAttributeSet mset = (IAttributeSet)value;
                IAttributeSet nset = MergeUtil.createNewSet(key, newSet, (IAttributeSet)value, newSet.getAttributeSetType(mset.getTypeName()));
                MergeUtil.setAttributeSet(nset, mset);
                continue;
            }
            if (value instanceof IAttributeList) {
                IAttributeList mlist = (IAttributeList)value;
                IAttributeList nlist = MergeUtil.createNewList(key, newSet, mlist);
                MergeUtil.setAttributeList(nlist, mlist);
                continue;
            }
            newSet.setObjectAttribute(key, value);
        }
    }

    private static void setAttributeList(IAttributeList newList, IAttributeList modifiedList) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        ArrayList list = modifiedList.getItems();
        int size = list.size();
        for (int count = 0; count < list.size(); ++count) {
            Object value = list.get(count);
            if (value instanceof IAttributeSet) {
                IAttributeSet mset = (IAttributeSet)value;
                IAttributeSet nset = MergeUtil.createNewSet(newList, mset, newList.getAttributeSetType(mset.getTypeName()));
                MergeUtil.setAttributeSet(nset, mset);
                continue;
            }
            if (value instanceof IAttributeList) {
                IAttributeList mlist = (IAttributeList)value;
                IAttributeList nlist = MergeUtil.createNewList(newList, mlist);
                MergeUtil.setAttributeList(nlist, mlist);
                continue;
            }
            newList.addObjectItem(value);
        }
    }

    private static IAttributeList createNewList(String key, IAttributeSet newSet, IAttributeList mlist) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        IAttributeList nlist = newSet.createAttributeList(key);
        return nlist;
    }

    private static IAttributeList createNewList(IAttributeList newList, IAttributeList mlist) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        IAttributeList nlist = newList.addNewAttributeListItem();
        return nlist;
    }

    private static IAttributeSet createNewSet(String key, IAttributeSet newSet, IAttributeSet mset, IAttributeSetType type) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        IAttributeSet nset = null;
        nset = newSet.createAttributeSet(key, type);
        MergeUtil.createNewSetType(nset, mset);
        return nset;
    }

    private static IAttributeSet createNewSet(IAttributeList newList, IAttributeSet mset, IAttributeSetType type) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        IAttributeSet nset = null;
        nset = newList.addNewAttributeSetItem(type);
        MergeUtil.createNewSetType(nset, mset);
        return nset;
    }

    private static void createNewSetType(ITypeCollection newCollection, ITypeCollection modifiedCollection) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        String[] typeNames = modifiedCollection.getAllTypeNames();
        for (int count = typeNames.length - 1; count >= 0; --count) {
            IAttributeSetType nType = newCollection.createAttributeSetType(typeNames[count]);
            IAttributeSetType mType = modifiedCollection.getAttributeSetType(typeNames[count]);
            String[] typeTypeNames = mType.getAttributeNames();
            for (int ttnCount = typeTypeNames.length - 1; ttnCount >= 0; --ttnCount) {
                nType.addAttributeName(typeTypeNames[ttnCount]);
            }
        }
    }
}

