/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.query.impl;

import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeMetaData;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.impl.Util;
import com.sonicsw.mf.common.config.query.AttributeFromTemplateExpression;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.BooleanExpression;
import com.sonicsw.mf.common.config.query.ContainsExpression;
import com.sonicsw.mf.common.config.query.EqualExpression;
import com.sonicsw.mf.common.config.query.ExistsExpression;
import com.sonicsw.mf.common.config.query.IDualOperandExpression;
import com.sonicsw.mf.common.config.query.ListContainsExpression;
import com.sonicsw.mf.common.config.query.ListItemStartsWithExpression;
import com.sonicsw.mf.common.config.query.NotEqualExpression;
import com.sonicsw.mf.common.config.query.StartsWithExpression;
import com.sonicsw.mf.common.config.query.Where;

public final class ElementEvaluation {
    public static boolean evaluate(IElement element, Where where) {
        BooleanExpression[] booleanExpressions = where.getAndChain();
        for (int i = 0; i < booleanExpressions.length; ++i) {
            boolean eqOperation;
            IDualOperandExpression expression = (IDualOperandExpression)((Object)booleanExpressions[i]);
            AttributeName attName = (AttributeName)expression.getFirstOperand();
            Object expressionValue = expression.getSecondOperand();
            Object elementValue = element.getAttribute(attName);
            boolean bl = eqOperation = expression instanceof EqualExpression || expression instanceof NotEqualExpression;
            if (expression instanceof StartsWithExpression && !Util.startsWith(true, elementValue, expressionValue)) {
                return false;
            }
            if (expression instanceof ExistsExpression && elementValue == null) {
                return false;
            }
            if (expression instanceof ListContainsExpression && !ElementEvaluation.listContains(elementValue, expressionValue)) {
                return false;
            }
            if (expression instanceof ListItemStartsWithExpression && !ElementEvaluation.listItemStartsWith(elementValue, expressionValue)) {
                return false;
            }
            if (eqOperation && !ElementEvaluation.evaluateEquality(expression, elementValue, expressionValue)) {
                return false;
            }
            if (expression instanceof AttributeFromTemplateExpression && !ElementEvaluation.fromTemplate(element, attName, (Boolean)expressionValue)) {
                return false;
            }
            if (!(expression instanceof ContainsExpression) || ((String)elementValue).indexOf((String)expressionValue) != -1) continue;
            return false;
        }
        return true;
    }

    private static boolean fromTemplate(IElement element, AttributeName attName, boolean isFromTemplate) {
        AttributeName parentName = new AttributeName();
        int numComponents = attName.getComponentCount();
        for (int i = 0; i < numComponents - 1; ++i) {
            Object component = attName.getComponent(i);
            if (component instanceof String) {
                parentName.setNextComponent((String)component);
                continue;
            }
            parentName.setNextComponent((Integer)component);
        }
        Object baseName = attName.getComponent(numComponents - 1);
        Object parent = element.getAttribute(parentName);
        IAttributeMetaData metaData = null;
        try {
            if (parent instanceof IAttributeSet) {
                metaData = ((IAttributeSet)parent).getAttributeMetaData((String)baseName);
            } else if (parent instanceof IAttributeList) {
                metaData = ((IAttributeList)parent).getItemMetaData((Integer)baseName);
            }
            if (metaData == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return isFromTemplate ? metaData.isFromTemplate() : !metaData.isFromTemplate();
    }

    private static boolean evaluateEquality(IDualOperandExpression expression, Object elementValue, Object expressionValue) {
        boolean eqOperation = expression instanceof EqualExpression;
        if (expressionValue == null && elementValue == null) {
            if (!eqOperation) {
                return false;
            }
        } else if (expressionValue == null || elementValue == null) {
            if (eqOperation) {
                return false;
            }
        } else {
            boolean isEqual = Util.atomicAndEqual(expressionValue, elementValue);
            if (isEqual && !eqOperation) {
                return false;
            }
            if (!isEqual && eqOperation) {
                return false;
            }
        }
        return true;
    }

    private static boolean listContains(Object listObject, Object value) {
        block5: {
            block4: {
                if (value == null) {
                    return false;
                }
                if (!(listObject instanceof IAttributeList)) break block4;
                if (value == null) {
                    return false;
                }
                IAttributeList list = (IAttributeList)listObject;
                for (int i = 0; i < list.getCount(); ++i) {
                    if (!Util.atomicAndEqual(value, list.getItem(i))) continue;
                    return true;
                }
                break block5;
            }
            if (!(listObject instanceof IAttributeSet)) break block5;
            IAttributeSet set = (IAttributeSet)listObject;
            for (Object key : set.getAttributes().keySet()) {
                if (!Util.atomicAndEqual(value, key)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean listItemStartsWith(Object listObject, Object prefix) {
        if (!(listObject instanceof IAttributeList)) {
            return false;
        }
        if (prefix == null) {
            return false;
        }
        IAttributeList list = (IAttributeList)listObject;
        for (int i = 0; i < list.getCount(); ++i) {
            if (!Util.startsWith(true, list.getItem(i), prefix)) continue;
            return true;
        }
        return false;
    }
}

