/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.metrics.impl;

import com.sonicsw.mf.common.metrics.IHistoricalMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.impl.Metric;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;

public final class HistoricalMetric
extends Metric
implements IHistoricalMetric,
Serializable {
    private static final long serialVersionUID = -8018080999357982594L;
    private static final short m_serialVersion = 0;
    private String m_source;
    private String m_localizedTimestamp;
    private static final short SOURCE_FIELD = 0;
    private static final short ID_FIELD = 1;
    private static final short VALUE_FIELD = 2;
    private static final short CURRENCY_FIELD = 3;

    public HistoricalMetric(String source, IMetricIdentity id, long value, long currencyTimestamp) {
        super(id, value, currencyTimestamp);
        this.m_source = source;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
        this.m_localizedTimestamp = dateFormat.format(currencyTimestamp);
    }

    HistoricalMetric() {
    }

    @Override
    public String getSource() {
        return this.m_source;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        int fieldCount = 4;
        stream.writeShort(fieldCount);
        stream.writeShort(0);
        stream.writeShort(0);
        stream.writeObject(this.m_source);
        stream.writeShort(1);
        stream.writeObject(super.getMetricIdentity().getNameComponents());
        stream.writeShort(2);
        stream.writeLong(super.getValue());
        stream.writeShort(3);
        stream.writeLong(super.getCurrencyTimestamp());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int numFields = stream.readShort();
        short serialVer = stream.readShort();
        for (int i = 0; i < numFields; ++i) {
            short field = stream.readShort();
            switch (serialVer) {
                default: 
            }
            if (field == 0) {
                this.m_source = (String)stream.readObject();
                continue;
            }
            if (field == 1) {
                this.m_id = MetricsFactory.createMetricIdentity((String[])stream.readObject());
                continue;
            }
            if (field == 2) {
                this.m_value = stream.readLong();
                continue;
            }
            if (field != 3) continue;
            this.m_currencyTimestamp = stream.readLong();
        }
    }

    @Override
    public String getLocalizedTimestamp() {
        return this.m_localizedTimestamp;
    }
}

