/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.view.impl;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.view.IFolder;
import com.sonicsw.mf.common.view.ILink;
import com.sonicsw.mf.common.view.IViewElement;
import com.sonicsw.mf.common.view.ViewException;
import java.util.HashMap;

public final class StorageToLogical {
    private HashMap m_root = new HashMap();

    public static void main(String[] args) throws Exception {
        StorageToLogical st = new StorageToLogical();
        st.setElement(new EntityName("/a1/b2/E1"), "xE1");
        st.setElement(new EntityName("/a1/b2/E2"), "xE2");
        st.setElement(new EntityName("/a1/b2/E3"), "xE3");
        st.setElement(new EntityName("/a1/b2/c3/E3"), "xcE3");
        HashMap map = st.getMap();
        for (String name : map.keySet()) {
            System.out.println("MAP PAIR " + name + " " + map.get(name));
        }
        System.out.println(st.getElementLogicalName(new EntityName("/a1/b2/E1")));
        System.out.println(st.getElementLogicalName(new EntityName("/a1/b2/E2")));
        System.out.println(st.getElementLogicalName(new EntityName("/a1/b2/E3")));
        System.out.println(st.getElementLogicalName(new EntityName("/a1/b2/c3/E3")));
        st.setElement(new EntityName("/a1/b2/E1"), "yE1");
        st.setElement(new EntityName("/a1/b2/E2"), "yE2");
        st.setElement(new EntityName("/a1/b2/E3"), "yE3");
        st.setElement(new EntityName("/a1/b2/c3/E3"), "ycE3");
        System.out.println(st.getElementLogicalName(new EntityName("/a1/b2/E1")));
        System.out.println(st.getElementLogicalName(new EntityName("/a1/b2/E2")));
        System.out.println(st.getElementLogicalName(new EntityName("/a1/b2/E3")));
        System.out.println(st.getElementLogicalName(new EntityName("/a1/b2/c3/E3")));
        st.setComplex(new EntityName("/a1/domains/0"), "/l/m/n");
        System.out.println(st.getElementLogicalName(new EntityName("/a1/domains/0/descriptor")));
        System.out.println(st.getElementLogicalName(new EntityName("/a1/domains/0/_MFUsers/udi1")));
        st.setComplex(new EntityName("/a1/domains/0"), "/r/s");
        System.out.println(st.getElementLogicalName(new EntityName("/a1/domains/0/descriptor")));
        System.out.println(st.getElementLogicalName(new EntityName("/a1/domains/0/_MFUsers/udi1")));
        st.delete(new EntityName("/a1/domains/0"));
        System.out.println(st.getElementLogicalName(new EntityName("/a1/domains/0/descriptor")));
        System.out.println(st.getElementLogicalName(new EntityName("/a1/domains/0/_MFUsers/udi1")));
    }

    HashMap getMap() {
        HashMap map = new HashMap();
        this.getMap(this.m_root, "", map);
        return map;
    }

    private void getMap(HashMap dir, String dirName, HashMap result) {
        for (String name : dir.keySet()) {
            Object value = dir.get(name);
            if (value instanceof String) {
                result.put(dirName + "/" + name, value);
                continue;
            }
            if (!(value instanceof HashMap)) continue;
            this.getMap((HashMap)value, dirName + "/" + name, result);
        }
    }

    public void updateFromView(IFolder folder, String folderName1) throws ViewException {
        try {
            String folderName = folderName1;
            if (folderName1.equals("/")) {
                folderName = "";
            }
            String[] kids = folder.list();
            for (int i = 0; i < kids.length; ++i) {
                String kidsName = folderName + "/" + kids[i];
                IViewElement viewElement = folder.getViewElement(kids[i]);
                if (viewElement instanceof IFolder) {
                    this.updateFromView((IFolder)viewElement, kidsName);
                    continue;
                }
                String linkedObject = ((ILink)viewElement).getLinkedObjectName();
                if (((ILink)viewElement).isComplex()) {
                    this.setComplex(new EntityName(linkedObject).getParentEntity(), kidsName);
                    continue;
                }
                this.setElement(new EntityName(linkedObject), kidsName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ViewException(e.toString(), e);
        }
    }

    public void deleteFromView(IFolder folder) throws ViewException {
        try {
            String[] kids = folder.list();
            for (int i = 0; i < kids.length; ++i) {
                IViewElement viewElement = folder.getViewElement(kids[i]);
                if (viewElement instanceof IFolder) {
                    this.deleteFromView((IFolder)viewElement);
                    continue;
                }
                ILink link = (ILink)viewElement;
                String linkedObject = link.getLinkedObjectName();
                if (link.isComplex()) {
                    this.delete(new EntityName(linkedObject).getParentEntity());
                    continue;
                }
                this.delete(new EntityName(linkedObject));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ViewException(e.toString(), e);
        }
    }

    public void setElement(EntityName elementName, String logicalName) throws ViewException {
        HashMap parentDir = this.getParentDir(elementName, true, true);
        if (parentDir != null) {
            parentDir.put(elementName.getBaseName(), logicalName);
        }
    }

    public void setComplex(EntityName dirName, String logicalName) throws ViewException {
        HashMap parentDir = this.getParentDir(dirName, false, true);
        parentDir.put(dirName.getBaseName(), new ComplextConfig(logicalName));
    }

    public String getElementLogicalName(EntityName storageName) throws ViewException {
        String[] components = storageName.getNameComponents();
        HashMap currentDir = this.m_root;
        for (int i = 0; i < components.length; ++i) {
            Object nextLevel = currentDir.get(components[i]);
            if (nextLevel == null) {
                return null;
            }
            if (nextLevel instanceof ComplextConfig) {
                String logicalName = ((ComplextConfig)nextLevel).m_logicalName;
                String subDir = "";
                if (i + 1 == components.length) {
                    throw new ViewException(storageName.getName() + " is a complex directory, not an element.");
                }
                for (int j = i + 1; j < components.length; ++j) {
                    String compName = components[j];
                    if (j + 1 == components.length && compName.equals(components[i])) {
                        try {
                            compName = new EntityName(logicalName).getBaseName();
                        }
                        catch (ConfigException e) {
                            e.printStackTrace();
                            throw new Error(e.toString(), e);
                        }
                    }
                    subDir = subDir + "/" + compName;
                }
                return logicalName + subDir;
            }
            if (nextLevel instanceof String) {
                if (i + 1 != components.length) {
                    throw new ViewException("Not parent directory for " + storageName.getName());
                }
                return (String)nextLevel;
            }
            if (!(nextLevel instanceof HashMap)) continue;
            if (i + 1 == components.length) {
                throw new ViewException(storageName.getName() + " is a directory, not an element.");
            }
            currentDir = (HashMap)nextLevel;
        }
        throw new Error("Should never get here");
    }

    public void delete(EntityName storageName) throws ViewException {
        HashMap parentDir = this.getParentDir(storageName, true, false);
        if (parentDir != null) {
            EntityName parentEntity;
            parentDir.remove(storageName.getBaseName());
            if (parentDir.isEmpty() && !(parentEntity = storageName.getParentEntity()).isRoot()) {
                this.delete(parentEntity);
            }
        }
    }

    private HashMap getParentDir(EntityName storageName, boolean forElement, boolean ensureExistence) throws ViewException {
        String[] parentComponents = storageName.getParentComponents();
        HashMap currentDir = this.m_root;
        for (int i = 0; i < parentComponents.length; ++i) {
            Object nextLevel = currentDir.get(parentComponents[i]);
            if (nextLevel != null && nextLevel instanceof ComplextConfig) {
                if (!forElement) {
                    throw new ViewException("Do not support nested complex configuration.");
                }
                return null;
            }
            HashMap nextDir = (HashMap)nextLevel;
            if (nextDir == null) {
                if (ensureExistence) {
                    nextDir = new HashMap();
                    currentDir.put(parentComponents[i], nextDir);
                } else {
                    return null;
                }
            }
            currentDir = nextDir;
        }
        return currentDir;
    }

    private class ComplextConfig {
        String m_logicalName;

        ComplextConfig(String logicalName) {
            this.m_logicalName = logicalName;
        }
    }
}

