/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;

public class LoaderInputStream
extends ObjectInputStream {
    private ClassLoader loader;

    public LoaderInputStream(InputStream in, ClassLoader loader) throws IOException {
        super(in);
        this.loader = loader;
    }

    protected Class resolveClass(ObjectStreamClass osClass) throws IOException, ClassNotFoundException {
        Class<?> cls = null;
        try {
            if (this.loader == null) {
                cls = super.resolveClass(osClass);
            } else {
                String classname = osClass.getName();
                int i = 0;
                if (classname.charAt(i++) == '[') {
                    Class<?> clazz;
                    while (classname.charAt(i) == '[') {
                        ++i;
                    }
                    if (classname.charAt(i) == 'L') {
                        clazz = this.loader.loadClass(classname.substring(i + 1, classname.length() - 1));
                    } else {
                        if (classname.length() != i + 1) {
                            throw new ClassNotFoundException(classname);
                        }
                        clazz = this.primitiveType(classname.charAt(i));
                    }
                    int[] dimensions = new int[i];
                    for (int j = 0; j < i; ++j) {
                        dimensions[j] = 0;
                    }
                    cls = Array.newInstance(clazz, dimensions).getClass();
                } else {
                    cls = this.loader.loadClass(classname);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Unable to resolve class " + osClass.getName(), cnfe);
        }
        return cls;
    }

    private Class primitiveType(char c) {
        switch (c) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }
}

