/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.metrics.impl;

import com.sonicsw.mf.common.metrics.IAggregateMetric;
import com.sonicsw.mf.common.metrics.IAggregateMetricsData;
import com.sonicsw.mf.common.metrics.IAlert;
import com.sonicsw.mf.common.metrics.IHistoricalMetric;
import com.sonicsw.mf.common.metrics.IHistoricalMetricsData;
import com.sonicsw.mf.common.metrics.IMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricsData;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.impl.AggregateMetric;
import com.sonicsw.mf.common.metrics.impl.Metric;
import com.sonicsw.mf.common.metrics.impl.MetricIdentity;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class MetricsData
implements IMetricsData,
IHistoricalMetricsData,
IAggregateMetricsData,
Serializable {
    private static final long serialVersionUID = 3480759768086297444L;
    private static final short m_serialVersion = 0;
    private static final short NORMAL_TYPES = 0;
    private static final short HISTORICAL_TYPES = 1;
    private static final short AGGREGATE_TYPES = 2;
    private short m_metricTypes = 0;
    private long m_timestamp;
    private Object[] m_metrics;
    private static final short TIMESTAMP_FIELD = 0;
    private static final short TYPES_FIELD = 1;
    private static final short METRIC_COUNT = 2;
    private static final short ID_NAME_FIELD = 3;
    private static final short ID_HASH_FIELD = 4;
    private static final short VALUE_FIELD = 5;
    private static final short CURRENCY_FIELD = 6;
    private static final short SOURCE_FIELD = 7;
    private static final short SOURCES_FIELD = 8;
    private static final short TRIGGERED_ALERTS_FIELD = 9;
    private static final short VALUES_FIELD = 10;

    public MetricsData() {
    }

    public MetricsData(IMetric[] metrics, long currencyTimestamp) {
        if (metrics == null) {
            throw new IllegalArgumentException("Metrics array cannot be null.");
        }
        if (metrics instanceof IHistoricalMetric[]) {
            this.m_metricTypes = 1;
        } else if (metrics instanceof IAggregateMetric[]) {
            this.m_metricTypes = (short)2;
        }
        this.m_timestamp = currencyTimestamp;
        this.m_metrics = metrics;
    }

    public MetricsData(IAggregateMetric[] metrics, long currencyTimestamp) {
        if (metrics == null) {
            throw new IllegalArgumentException("Metrics array cannot be null.");
        }
        this.m_metricTypes = (short)2;
        this.m_timestamp = currencyTimestamp;
        this.m_metrics = metrics;
    }

    @Override
    public long getCurrencyTimestamp() {
        if (this.m_metricTypes == 1) {
            throw new IllegalStateException("Not supported for historic metrics.");
        }
        return this.m_timestamp;
    }

    @Override
    public IMetric[] getMetrics() {
        if (this.m_metricTypes != 0) {
            throw new IllegalStateException("Not supported for other than normal metrics.");
        }
        return (IMetric[])this.m_metrics;
    }

    @Override
    public IHistoricalMetric[] getHistoricalMetrics() {
        if (this.m_metricTypes != 1) {
            throw new IllegalStateException("Not supported for non-historic metrics.");
        }
        IHistoricalMetric[] historicalMetrics = new IHistoricalMetric[this.m_metrics.length];
        System.arraycopy(this.m_metrics, 0, historicalMetrics, 0, this.m_metrics.length);
        return historicalMetrics;
    }

    @Override
    public IAggregateMetric[] getAggregateMetrics() {
        if (this.m_metricTypes != 2) {
            throw new IllegalStateException("Not supported for non-aggregate metrics.");
        }
        IAggregateMetric[] aggregateMetrics = new IAggregateMetric[this.m_metrics.length];
        System.arraycopy(this.m_metrics, 0, aggregateMetrics, 0, this.m_metrics.length);
        return aggregateMetrics;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        int fieldCount = 3;
        stream.writeShort(fieldCount);
        stream.writeShort(0);
        stream.writeShort(1);
        stream.writeShort(this.m_metricTypes);
        stream.writeShort(0);
        stream.writeLong(this.m_timestamp);
        stream.writeShort(2);
        stream.writeInt(this.m_metrics.length);
        for (int i = 0; i < this.m_metrics.length; ++i) {
            IMetricIdentity id = this.m_metricTypes == 2 ? ((IAggregateMetric)this.m_metrics[i]).getMetricIdentity() : ((IMetric)this.m_metrics[i]).getMetricIdentity();
            long hash = ((MetricIdentity)id).getHash();
            short perMetricFieldCount = (short)(hash == 0L ? 3 : 4);
            if (this.m_metricTypes > 0) {
                perMetricFieldCount = (short)(perMetricFieldCount + 1);
            }
            IAlert[] trigAlerts = null;
            if (this.m_metricTypes != 2 && (trigAlerts = ((IMetric)this.m_metrics[i]).getTriggeredAlerts()) != null) {
                perMetricFieldCount = (short)(perMetricFieldCount + 1);
            }
            stream.writeShort(perMetricFieldCount);
            stream.writeShort(3);
            stream.writeObject(id.getNameComponents());
            if (hash != 0L) {
                stream.writeShort(4);
                stream.writeLong(hash);
            }
            if (this.m_metricTypes == 2) {
                stream.writeShort(10);
                long[] values = ((IAggregateMetric)this.m_metrics[i]).getValues();
                stream.writeShort(values.length);
                for (int j = 0; j < values.length; ++j) {
                    stream.writeLong(values[j]);
                }
            } else {
                stream.writeShort(5);
                stream.writeLong(((IMetric)this.m_metrics[i]).getValue());
            }
            stream.writeShort(6);
            stream.writeLong(this.m_metricTypes == 2 ? ((IAggregateMetric)this.m_metrics[i]).getCurrencyTimestamp() : ((IMetric)this.m_metrics[i]).getCurrencyTimestamp());
            if (trigAlerts != null) {
                stream.writeShort(9);
                stream.writeInt(trigAlerts.length);
                for (int a = 0; a < trigAlerts.length; ++a) {
                    stream.writeLong(trigAlerts[a].getThresholdValue());
                    stream.writeBoolean(trigAlerts[a].isHighThreshold());
                }
            }
            if (this.m_metricTypes == 1) {
                stream.writeShort(7);
                stream.writeUTF(((IHistoricalMetric)this.m_metrics[i]).getSource());
            }
            if (this.m_metricTypes != 2) continue;
            stream.writeShort(8);
            stream.writeObject(((IAggregateMetric)this.m_metrics[i]).getSources());
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int numFields = stream.readShort();
        short serialVer = stream.readShort();
        for (int i = 0; i < numFields; ++i) {
            short field = stream.readShort();
            switch (serialVer) {
                default: 
            }
            if (field == 0) {
                this.m_timestamp = stream.readLong();
            }
            if (field == 1) {
                this.m_metricTypes = stream.readShort();
                continue;
            }
            if (field != 2) continue;
            int count = stream.readInt();
            this.m_metrics = this.m_metricTypes == 2 ? new AggregateMetric[count] : new Metric[count];
            for (int j = 0; j < count; ++j) {
                int a;
                String[] nameComponents = null;
                long hash = 0L;
                long value = 0L;
                long[] values = null;
                long currencyTimestamp = 0L;
                long[] trigAlertsThresholds = null;
                boolean[] trigAlertsHiLo = null;
                String source = null;
                String[] sources = null;
                int numSubFields = stream.readShort();
                for (int k = 0; k < numSubFields; ++k) {
                    field = stream.readShort();
                    if (field == 3) {
                        nameComponents = (String[])stream.readObject();
                        continue;
                    }
                    if (field == 4) {
                        hash = stream.readLong();
                        continue;
                    }
                    if (field == 5) {
                        value = stream.readLong();
                        continue;
                    }
                    if (field == 10) {
                        values = new long[stream.readShort()];
                        for (int l = 0; l < values.length; ++l) {
                            values[l] = stream.readLong();
                        }
                        continue;
                    }
                    if (field == 6) {
                        currencyTimestamp = stream.readLong();
                        continue;
                    }
                    if (field == 9) {
                        int numAlerts = stream.readInt();
                        trigAlertsThresholds = new long[numAlerts];
                        trigAlertsHiLo = new boolean[numAlerts];
                        for (a = 0; a < numAlerts; ++a) {
                            trigAlertsThresholds[a] = stream.readLong();
                            trigAlertsHiLo[a] = stream.readBoolean();
                        }
                        continue;
                    }
                    if (field == 7) {
                        source = stream.readUTF();
                        continue;
                    }
                    if (field != 8) continue;
                    sources = (String[])stream.readObject();
                }
                IMetricIdentity id = MetricsFactory.createMetricIdentity(nameComponents);
                ((MetricIdentity)id).setHash(hash);
                if (this.m_metricTypes == 2) {
                    this.m_metrics[j] = MetricsFactory.createMetric(sources, id, values, currencyTimestamp);
                    continue;
                }
                this.m_metrics[j] = MetricsFactory.createMetric(id, value, currencyTimestamp);
                if (trigAlertsThresholds != null) {
                    IAlert[] trigAlerts = new IAlert[trigAlertsThresholds.length];
                    for (a = 0; a < trigAlertsThresholds.length; ++a) {
                        trigAlerts[a] = MetricsFactory.createAlert(id, trigAlertsHiLo[a], trigAlertsThresholds[a]);
                    }
                    ((Metric)this.m_metrics[j]).setTriggeredAlerts(trigAlerts);
                }
                if (this.m_metricTypes != 1) continue;
                this.m_metrics[j] = MetricsFactory.createMetric(source, (IMetric)this.m_metrics[j]);
            }
        }
    }
}

