/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.INamedPayload;
import com.sonicsw.mf.common.config.NameMapperPathException;
import com.sonicsw.mf.common.config.impl.EntityName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class NameMapper {
    MapperNode m_root = new MapperNode();

    public static void main(String[] args) throws Exception {
        int i;
        NameMapper mapper = new NameMapper();
        EntityName E1 = new EntityName("/a1/b1/l1");
        EntityName E2 = new EntityName("/a1/b1/l2");
        EntityName E3 = new EntityName("/a1/b2/l3");
        EntityName oldEr = new EntityName("/a1");
        EntityName newEr = new EntityName("/x1");
        mapper.set(E1, "V1");
        mapper.set(E2, "V2");
        mapper.set(E3, "V3");
        System.out.println(mapper.get(E1));
        System.out.println(mapper.get(E2));
        System.out.println(mapper.get(E3));
        NamedPayLoad[] fullList = mapper.scan(new EntityName("/a1/b1"));
        for (int i2 = 0; i2 < fullList.length; ++i2) {
            System.out.println(fullList[i2]);
        }
        System.out.println();
        NamedPayLoad[] renamedList = mapper.rename(oldEr, newEr);
        for (i = 0; i < renamedList.length; ++i) {
            System.out.println(renamedList[i]);
        }
        System.out.println();
        System.out.println("REMOVE: " + ((INamedPayload[])mapper.remove(new EntityName("/x1/b1/l1")))[0]);
        System.out.println();
        fullList = mapper.scan(new EntityName("/"));
        for (i = 0; i < fullList.length; ++i) {
            System.out.println(fullList[i]);
        }
        System.out.println();
        System.out.println("REMOVE: " + ((INamedPayload[])mapper.remove(new EntityName("/x1/b1/l2")))[0]);
        System.out.println();
        fullList = mapper.scan(new EntityName("/"));
        for (i = 0; i < fullList.length; ++i) {
            System.out.println(fullList[i]);
        }
        System.out.println();
        System.out.println("REMOVE: " + ((INamedPayload[])mapper.remove(new EntityName("/x1/b2/l3")))[0]);
        System.out.println();
        fullList = mapper.scan(new EntityName("/"));
        for (i = 0; i < fullList.length; ++i) {
            System.out.println(fullList[i]);
        }
        System.out.println();
        E1 = new EntityName("/a1/b1/l1");
        E2 = new EntityName("/a1/b1/l2");
        E3 = new EntityName("/a2/b2/l3");
        mapper.set(E1, "V1");
        mapper.set(E2, "V2");
        mapper.set(E3, "V3");
        System.out.println(mapper.get(E1));
        System.out.println(mapper.get(E2));
        System.out.println(mapper.get(E3));
        System.out.println();
        fullList = mapper.scan(new EntityName("/"));
        for (i = 0; i < fullList.length; ++i) {
            System.out.println(fullList[i]);
        }
        System.out.println();
        oldEr = new EntityName("/a1/b1/l1");
        newEr = new EntityName("/a1/b1/x1");
        renamedList = mapper.rename(oldEr, newEr);
        for (i = 0; i < renamedList.length; ++i) {
            System.out.println("RENAMED: " + renamedList[i]);
        }
        System.out.println();
        renamedList = mapper.remove(new EntityName("/a1/b1"));
        for (i = 0; i < renamedList.length; ++i) {
            System.out.println("REMOVED ITEM: " + renamedList[i]);
        }
        System.out.println();
        fullList = mapper.scan(new EntityName("/"));
        for (i = 0; i < fullList.length; ++i) {
            System.out.println("NAME: " + fullList[i].getName() + " PAYLOAD: " + fullList[i].getPayload());
        }
    }

    public void set(EntityName name, Object payLoad) {
        this.getParent(name, true).put(name.getBaseName().toLowerCase(), payLoad);
    }

    public Object get(EntityName name) {
        if (name.isRoot()) {
            return this.m_root;
        }
        MapperNode parent = this.getParent(name, false);
        if (parent != null) {
            return parent.get(name.getBaseName().toLowerCase());
        }
        return null;
    }

    public Object getPrefix(EntityName name) {
        if (name.isRoot()) {
            return null;
        }
        MapperNode currentNode = this.m_root;
        String[] nameComponents = name.getNameComponents();
        for (int i = 0; i < nameComponents.length; ++i) {
            if ((currentNode = currentNode.get(nameComponents[i].toLowerCase())) == null) {
                return null;
            }
            if (currentNode instanceof MapperNode) continue;
            return currentNode;
        }
        return null;
    }

    public NamedPayLoad[] remove(EntityName name) {
        NamedPayLoad[] result = this.scan(name);
        this.removeInternal(name);
        return result;
    }

    private Object removeInternal(EntityName name) {
        EntityName parentName;
        MapperNode parent = this.getParent(name, false);
        if (parent == null) {
            return null;
        }
        Object result = parent.remove(name.getBaseName().toLowerCase());
        if (parent.isEmpty() && !(parentName = name.getParentEntity()).isRoot()) {
            this.removeInternal(parentName);
        }
        return result;
    }

    public NamedPayLoad[] rename(EntityName oldName, EntityName newName) {
        Object renamedObject = this.removeInternal(oldName);
        if (renamedObject == null) {
            return null;
        }
        this.set(newName, renamedObject);
        return this.scan(newName);
    }

    public NamedPayLoad[] scan(EntityName nodeName) {
        ArrayList<NamedPayLoad> namedPayLoads = new ArrayList<NamedPayLoad>();
        this.scan(nodeName, this.get(nodeName), namedPayLoads);
        NamedPayLoad[] result = new NamedPayLoad[namedPayLoads.size()];
        namedPayLoads.toArray(result);
        return result;
    }

    private void scan(EntityName name, Object nodeObject, ArrayList<NamedPayLoad> namedPayLoads) {
        if (nodeObject == null) {
            return;
        }
        if (!(nodeObject instanceof MapperNode)) {
            namedPayLoads.add(new NamedPayLoad(name, nodeObject));
        } else {
            MapperNode node = (MapperNode)nodeObject;
            for (Map.Entry entry : node.entrySet()) {
                String baseName = (String)entry.getKey();
                this.scan(name.createChild(baseName), entry.getValue(), namedPayLoads);
            }
        }
    }

    private MapperNode getParent(EntityName name, boolean ensureExistence) {
        String[] parentComponents = name.getParentComponents();
        String triedPath = "";
        MapperNode currentDir = this.m_root;
        for (int i = 0; i < parentComponents.length; ++i) {
            Object nextLevel = currentDir.get(parentComponents[i].toLowerCase());
            triedPath = triedPath + "/" + parentComponents[i];
            if (nextLevel != null && !(nextLevel instanceof MapperNode)) {
                throw new NameMapperPathException(name + " is illegal", triedPath, nextLevel);
            }
            MapperNode nextDir = (MapperNode)nextLevel;
            if (nextDir == null) {
                if (ensureExistence) {
                    nextDir = new MapperNode();
                    currentDir.put(parentComponents[i].toLowerCase(), nextDir);
                } else {
                    return null;
                }
            }
            currentDir = nextDir;
        }
        return currentDir;
    }

    private static final class MapperNode
    extends HashMap<String, Object> {
        private MapperNode() {
        }
    }

    public static final class NamedPayLoad
    implements INamedPayload {
        EntityName m_name;
        Object m_payload;

        NamedPayLoad(EntityName name, Object payload) {
            this.m_name = name;
            this.m_payload = payload;
        }

        public String toString() {
            return this.m_name + " " + this.m_payload;
        }

        @Override
        public String getName() {
            return this.m_name.getName();
        }

        @Override
        public Object getPayload() {
            return this.m_payload;
        }
    }
}

