/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.impl.AttributeSetType;
import com.sonicsw.mf.common.config.impl.IDictionary;
import com.sonicsw.mf.common.config.impl.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

final class TypedAttSet
implements IDictionary,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 3;
    private Object[] m_values;
    private AttributeSetType m_type;

    TypedAttSet(AttributeSetType type) {
        this.m_type = type;
        this.m_values = null;
    }

    @Override
    public int estimateSize() {
        int estimate = 32;
        if (this.m_values == null) {
            return estimate;
        }
        for (int i = 0; i < this.m_values.length; ++i) {
            estimate += Util.estimateSize(this.m_values[i]);
        }
        return estimate;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(3);
        s.writeObject(this.m_values);
        s.writeObject(this.m_type);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 3) {
            Util.throwSerialVersionMismatch(version, 3);
        }
        this.m_values = (Object[])s.readObject();
        this.m_type = (AttributeSetType)s.readObject();
    }

    private int getIndex(String attName) throws AttributeSetTypeException {
        Integer index = (Integer)this.m_type.get(attName);
        if (index == null) {
            throw new AttributeSetTypeException(attName, this.m_type.getName());
        }
        return index;
    }

    void setValues(Object[] values) {
        this.m_values = values;
    }

    String getTypeName() {
        return this.m_type.getName();
    }

    @Override
    public int size() {
        return this.m_type.size();
    }

    @Override
    public Object get(String attName) throws AttributeSetTypeException {
        return this.m_values[this.getIndex(attName)];
    }

    @Override
    public String[] attributes() {
        return this.m_type.getAttributeNames();
    }

    @Override
    public Object[] values() {
        return this.m_values;
    }

    @Override
    public Object put(String attName, Object value) throws AttributeSetTypeException {
        int index = this.getIndex(attName);
        Object oldValue = this.m_values[index];
        this.m_values[index] = value;
        return oldValue;
    }

    @Override
    public Object remove(String attName) throws AttributeSetTypeException {
        int index = this.getIndex(attName);
        Object oldValue = this.m_values[index];
        this.m_values[index] = null;
        return oldValue;
    }

    @Override
    public void delete() {
        this.m_type.removeTypedSet(this);
    }
}

