/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.xml;

import java.util.HashMap;

public class XMLStringWriter {
    private static final String NEWLINE = System.getProperty("line.separator");
    int m_tabCounter = 0;
    StringBuffer m_strBuffer = new StringBuffer();
    static String TAB = "  ";

    protected StringBuffer getXMLString() {
        return this.m_strBuffer;
    }

    protected void setTabCounter() {
        ++this.m_tabCounter;
    }

    protected void resetTabCounter() {
        --this.m_tabCounter;
    }

    protected void setProcInstruction(String version, String encode) {
        this.m_strBuffer.append("<?xml version=");
        this.m_strBuffer.append("\"" + version + "\"");
        this.m_strBuffer.append(" encoding=\"" + encode + "\"?>");
    }

    protected void startElement(String elementName, HashMap attrPair, boolean emptyElement) {
        this.m_strBuffer.append(NEWLINE);
        this.addTabs();
        this.m_strBuffer.append("<" + elementName);
        if (attrPair == null) {
            this.appendGreaterThenSign(emptyElement);
        } else {
            for (String name : attrPair.keySet()) {
                this.m_strBuffer.append(" ");
                this.m_strBuffer.append(name + "=\"" + attrPair.get(name) + "\"");
            }
            this.appendGreaterThenSign(emptyElement);
        }
    }

    private void appendGreaterThenSign(boolean emptyElement) {
        if (!emptyElement) {
            this.m_strBuffer.append(">");
        }
    }

    protected void endElement(String elementName) {
        if (elementName == null) {
            this.m_strBuffer.append(" />");
        } else {
            this.m_strBuffer.append(NEWLINE);
            this.addTabs();
            this.m_strBuffer.append("</" + elementName + ">");
        }
    }

    protected boolean isMarkup(String value) {
        boolean flag = false;
        if (value.indexOf("<") != -1 || value.indexOf("&") != -1) {
            flag = true;
        } else if (value.indexOf("'") != -1 || value.indexOf("\"") != -1) {
            flag = true;
        }
        return flag;
    }

    protected void createCDATA(String value) {
        this.m_strBuffer.append("<![CDATA[");
        String tmp = XMLStringWriter.replaceAll(value, "<![CDATA[", "<![_MF_CDATA[");
        String data = XMLStringWriter.replaceAll(tmp, "]]>", "]_MF_]>");
        this.m_strBuffer.append(data);
        this.m_strBuffer.append("]]>");
    }

    private void addTabs() {
        for (int i = 0; i < this.m_tabCounter; ++i) {
            this.m_strBuffer.append(TAB);
        }
    }

    static String replaceAll(String src, String oldString, String newString) {
        StringBuffer result = new StringBuffer(oldString.length());
        int index = 0;
        while (index < src.length()) {
            String nextChunk;
            int replacePosition = src.indexOf(oldString, index);
            if (replacePosition == -1) {
                nextChunk = src.substring(index);
                result.append(nextChunk);
                index += nextChunk.length();
                continue;
            }
            nextChunk = src.substring(index, replacePosition);
            result.append(nextChunk);
            result.append(newString);
            index = replacePosition + oldString.length();
        }
        return result.toString();
    }
}

