/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.common.IDSTransaction;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.upgrade.IMigrationProcess;
import com.sonicsw.mf.common.config.upgrade.IVersionedConfigUpgrade;
import com.sonicsw.mf.common.config.upgrade.UpgradeEnv;
import com.sonicsw.mf.common.config.upgrade.UpgradeRegistry;
import com.sonicsw.mf.common.config.upgrade.Utils;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;

public class TypedConfigUpgrade
implements IMigrationProcess {
    UpgradeEnv m_upgradeEnv = null;
    Utils m_utils = null;
    private static String CONFIG_TYPE_DIRECTORY = "/mx/configTypes/";
    private static String INITIAL_VALUES_ATTR = "initialValues";
    private Class[] UPGRADE_METHOD_SIGNATURE = new Class[]{IDirElement.class, UpgradeEnv.class};

    public TypedConfigUpgrade(UpgradeEnv env) {
        this.m_upgradeEnv = env;
        this.m_utils = this.m_upgradeEnv.getUtils();
    }

    private String doVersionedUpgrade(IDirElement el, String releaseVersion, String type) throws Exception {
        IVersionedConfigUpgrade upgrade = UpgradeRegistry.getConfigUpgrade(releaseVersion);
        if (upgrade == null) {
            throw new Exception("Unable to find a config upgrade method for type" + type + " for version " + releaseVersion);
        }
        Method upgradeMethod = upgrade.getClass().getMethod("upgrade" + type, this.UPGRADE_METHOD_SIGNATURE);
        String message = (String)upgradeMethod.invoke((Object)upgrade, el, this.m_upgradeEnv);
        if (!upgrade.getUpgradedReleaseVersion().equals("109")) {
            message = Utils.addToUpgradeMessage(message, this.doVersionedUpgrade(el, upgrade.getUpgradedReleaseVersion(), type));
        }
        return message;
    }

    public String upgradeMF_AGENT_MANAGER(IDirElement AM) throws Exception {
        String relVersion = AM.getIdentity().getReleaseVersion();
        String returnVal = this.doVersionedUpgrade(AM, relVersion, "MF_AGENT_MANAGER");
        this.setArchiveName(AM, "ARCHIVE_NAME", "MF/14.0/MFmanager.car");
        return this.updateFSElementAndFixProductAndReleaseVersion(AM, returnVal);
    }

    public String upgradeMF_BACKUP_DIRECTORY_SERVICE(IDirElement backup) throws Exception {
        String relVersion = backup.getIdentity().getReleaseVersion();
        String returnVal = null;
        if (!relVersion.equals("109")) {
            returnVal = this.doVersionedUpgrade(backup, relVersion, "MF_BACKUP_DIRECTORY_SERVICE");
        }
        String containerName = (String)this.m_upgradeEnv.getProp("container.name");
        String enteredHostDir = null;
        if (containerName != null) {
            enteredHostDir = (String)this.m_upgradeEnv.getContainerProp(containerName, "host.directory");
        }
        this.fixHostDirectoryUpdateFSElement(enteredHostDir, backup);
        if (!relVersion.equals("109")) {
            this.m_utils.fixProductAndReleaseVersion(backup.getIdentity().getName());
        }
        return returnVal;
    }

    public String upgradeMF_DIRECTORY_SERVICE(IDirElement DS) throws Exception {
        Reference replRef;
        String relVersion = DS.getIdentity().getReleaseVersion();
        String returnVal = this.doVersionedUpgrade(DS, relVersion, "MF_DIRECTORY_SERVICE");
        String dsHostProp = (String)this.m_upgradeEnv.getProp("ds.working.dir");
        this.fixHostDirectoryUpdateFSElement(dsHostProp, DS);
        this.m_utils.fixProductAndReleaseVersion(DS.getIdentity().getName());
        IAttributeSet configRefs = (IAttributeSet)DS.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES");
        if (configRefs != null && (replRef = (Reference)configRefs.getAttribute("REPLICATION_CONNECTIONS_ELEMENT_REF")) != null) {
            this.m_utils.fixProductAndReleaseVersion(replRef.getElementName());
        }
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("Done upgrading MF_DIRECTORY_SERVICE " + DS.getIdentity().getName());
        }
        return returnVal;
    }

    private void fixHostDirectoryUpdateFSElement(String dsHostProp, IDirElement DS) throws Exception {
        if (dsHostProp != null) {
            this.m_utils.fixHOST_DIRECTORY(DS, dsHostProp);
        }
        this.m_upgradeEnv.dsFileSystem.updateFSElement((IDeltaDirElement)DS.doneUpdate());
    }

    public String upgradeMF_CONTAINER(IDirElement container) throws Exception {
        IElementIdentity id = container.getIdentity();
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("TypedConfigUpgrade.upgradeMF_CONTAINER upgrading " + id.getName());
        }
        if (id.getReleaseVersion().equals("109")) {
            this.upgradeContainerPaths(container);
            this.m_upgradeEnv.dsFileSystem.updateFSElement((IDeltaDirElement)container.doneUpdate());
            return null;
        }
        if (container.isTemplate()) {
            String[] instanceNames = container.getSubclassedList();
            for (int i = 0; i < instanceNames.length; ++i) {
                this.upgradeMF_CONTAINER(this.m_upgradeEnv.dsFileSystem.getFSElement(instanceNames[i], true, true));
            }
        }
        String relVersion = container.getIdentity().getReleaseVersion();
        String message = this.doVersionedUpgrade(container, relVersion, "MF_CONTAINER");
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("TypedConfigUpgrade.upgradeMF_CONTAINER ID after doVersionedUpgrade " + container.getIdentity().getName());
        }
        this.upgradeContainerPaths(container);
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("TypedConfigUpgrade.upgradeMF_CONTAINER ID after upgradeContainerPaths " + container.getIdentity().getName());
        }
        this.setArchiveName(container, "ARCHIVE_NAME", "MF/14.0/MFcontainer.car");
        this.setArchiveName(container, "ACTIONAL_SDK_ARCHIVE_NAME", "MF/14.0/actional-sdk.jar");
        this.setArchiveName(container, "ACTIONAL_PLUGMAKER_ARCHIVE_NAME", "MF/14.0/actional-plugmaker.jar");
        message = Utils.addToUpgradeMessage(message, this.setArchiveSearchPath(container, "sonicfs:///Archives"));
        this.checkCLI(container);
        this.m_upgradeEnv.dsFileSystem.updateFSElement((IDeltaDirElement)container.doneUpdate());
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("TypedConfigUpgrade.upgradeMF_CONTAINER ID after updateFSElement " + container.getIdentity().getName());
        }
        this.m_utils.fixProductAndReleaseVersion(container.getIdentity().getName());
        return message;
    }

    public String upgradeMF_ACTIVATION_DAEMON(IDirElement daemon) throws Exception {
        if (daemon.isTemplate()) {
            String[] instanceNames = daemon.getSubclassedList();
            for (int i = 0; i < instanceNames.length; ++i) {
                this.upgradeMF_ACTIVATION_DAEMON(this.m_upgradeEnv.dsFileSystem.getFSElement(instanceNames[i], true, true));
            }
        }
        String relVersion = daemon.getIdentity().getReleaseVersion();
        String message = this.doVersionedUpgrade(daemon, relVersion, "MF_ACTIVATION_DAEMON");
        if (daemon.getSuperElementName() == null) {
            this.setArchiveName(daemon, "ARCHIVE_NAME", "MF/14.0/MFdaemon.car");
        }
        return this.updateFSElementAndFixProductAndReleaseVersion(daemon, message);
    }

    public String upgradeMF_COLLECTION_MONITOR(IDirElement monitor) throws Exception {
        String relVersion = monitor.getIdentity().getReleaseVersion();
        String message = this.doVersionedUpgrade(monitor, relVersion, "MF_COLLECTION_MONITOR");
        this.setArchiveName(monitor, "ARCHIVE_NAME", "MF/14.0/MFmonitor.car");
        return this.updateFSElementAndFixProductAndReleaseVersion(monitor, message);
    }

    public String upgradeMQ_CLUSTER(IDirElement cluster) throws Exception {
        if (cluster.getIdentity().getReleaseVersion().equals("109")) {
            return null;
        }
        if (cluster.isTemplate()) {
            String[] instanceNames = cluster.getSubclassedList();
            for (int i = 0; i < instanceNames.length; ++i) {
                this.upgradeMQ_CLUSTER(this.m_upgradeEnv.dsFileSystem.getFSElement(instanceNames[i], true, true));
            }
        }
        String relVersion = cluster.getIdentity().getReleaseVersion();
        String message = this.doVersionedUpgrade(cluster, relVersion, "MQ_CLUSTER");
        this.m_upgradeEnv.dsFileSystem.updateFSElement((IDeltaDirElement)cluster.doneUpdate());
        this.upgradeClusterVersions(cluster);
        return message;
    }

    public String upgradeMQ_BROKER(IDirElement broker) throws Exception {
        IElementIdentity id = broker.getIdentity();
        String relVersion = id.getReleaseVersion();
        if (relVersion.equals("109")) {
            IDSTransaction transaction = this.m_upgradeEnv.dsFileSystem.createTransaction();
            this.m_utils.upgradeBrokerAndDBPaths(broker);
            transaction.addUpdateElement((IDeltaDirElement)broker.doneUpdate());
            this.m_upgradeEnv.dsFileSystem.executeTransaction(transaction);
            return null;
        }
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("ConfigUpgrade.upgradeBrokerInstance, broker == " + broker.getIdentity().getName());
        }
        if (broker.isTemplate()) {
            String[] instanceNames = broker.getSubclassedList();
            for (int i = 0; i < instanceNames.length; ++i) {
                this.upgradeMQ_BROKER(this.m_upgradeEnv.dsFileSystem.getFSElement(instanceNames[i], true, true));
            }
        }
        IDSTransaction transaction = this.m_upgradeEnv.dsFileSystem.createTransaction();
        String message = this.doVersionedUpgrade(broker, relVersion, "MQ_BROKER");
        this.upgradeBrokerPaths(broker);
        IAttributeSet topSet = broker.getAttributes();
        IAttributeSet prodInfo = (IAttributeSet)topSet.getAttribute("PRODUCT_INFORMATION");
        if (prodInfo != null && !prodInfo.getAttributeMetaData("CONTROL_NUMBER").isFromTemplate()) {
            prodInfo.setStringAttribute("CONTROL_NUMBER", (String)this.m_upgradeEnv.getProp("sonic.mq.controlNumber"));
            if (this.m_upgradeEnv.isDEBUG()) {
                System.out.println("Changed the broker control number to " + this.m_upgradeEnv.getProp("sonic.mq.controlNumber"));
            }
        }
        if (broker.getSuperElementName() == null) {
            this.printName(broker);
            this.setArchiveName(broker, "ARCHIVE_NAME", "MQ/14.0/MQbroker.car");
        }
        transaction.addUpdateElement((IDeltaDirElement)broker.doneUpdate());
        this.m_upgradeEnv.dsFileSystem.executeTransaction(transaction);
        String clusterID = this.findCluster(broker);
        if (clusterID != null) {
            IDirElement clusterEl = this.m_upgradeEnv.dsFileSystem.getFSElement(clusterID, true);
            this.upgradeMQ_CLUSTER(clusterEl);
        }
        this.upgradeBrokerVersions(broker);
        return message;
    }

    public String upgradeMF_LOGGER(IDirElement logger) throws Exception {
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("ConfigUpgrade.upgradeLoggerConfig, logger == " + logger.getIdentity().getName());
        }
        if (logger.isTemplate()) {
            String[] instanceNames = logger.getSubclassedList();
            for (int i = 0; i < instanceNames.length; ++i) {
                this.upgradeMF_LOGGER(this.m_upgradeEnv.dsFileSystem.getFSElement(instanceNames[i], true, true));
            }
        }
        String relVersion = logger.getIdentity().getReleaseVersion();
        String message = this.doVersionedUpgrade(logger, relVersion, "MF_LOGGER");
        if (logger.getSuperElementName() == null) {
            this.printName(logger);
            this.setArchiveName(logger, "ARCHIVE_NAME", "MF/14.0/MFlogger.car");
        }
        return this.updateFSElementAndFixProductAndReleaseVersion(logger, message);
    }

    private void printName(IDirElement broker) {
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("Super element name for " + broker.getIdentity().getName() + " was null");
        }
    }

    public String upgradeXQ_CONTAINER(IDirElement XQContainer) throws Exception {
        this.fixProductVersion(XQContainer.getIdentity().getName());
        IAttributeSet topSet = XQContainer.getAttributes();
        topSet.setStringAttribute("ARCHIVE_NAME", "ESB/14.0/ESBcontainer.car");
        this.m_upgradeEnv.dsFileSystem.updateFSElement((IDeltaDirElement)XQContainer.doneUpdate());
        String storageXQName = this.m_upgradeEnv.dsFileSystem.logicalToStorage(XQContainer.getIdentity().getName());
        IDirElement xqContainer = this.m_upgradeEnv.dsAdmin.getElement(storageXQName, false);
        IAttributeSet servicesSet = (IAttributeSet)xqContainer.getAttributes().getAttribute("services");
        if (servicesSet != null) {
            HashMap servicesMap = servicesSet.getAttributes();
            Collection servicesMaps = servicesMap.values();
            for (IAttributeSet serviceSet : servicesMaps) {
                String serviceType;
                String serviceName = (String)serviceSet.getAttribute("service_ref");
                IDirElement serviceEl = this.m_upgradeEnv.dsAdmin.getElement("/xqServices/" + serviceName, true);
                if (serviceEl == null || !(serviceType = (String)serviceEl.getAttributes().getAttribute("type_ref")).equals("DatabaseServiceType")) continue;
                IAttributeSet params = (IAttributeSet)serviceEl.getAttributes().getAttribute("params");
                params.deleteAttribute("controlNumber");
                this.m_upgradeEnv.dsAdmin.setElement(serviceEl.doneUpdate(), null);
            }
        }
        return null;
    }

    public String upgradeMF_HOST_MANAGER(IDirElement hostManager) throws Exception {
        if (hostManager.getIdentity().getReleaseVersion().equals("109")) {
            return null;
        }
        String relVersion = hostManager.getIdentity().getReleaseVersion();
        String message = this.doVersionedUpgrade(hostManager, relVersion, "MF_HOST_MANAGER");
        this.setArchiveName(hostManager, "ARCHIVE_NAME", "MF/14.0/MFhostmanager.car");
        return this.updateFSElementAndFixProductAndReleaseVersion(hostManager, message);
    }

    private String updateFSElementAndFixProductAndReleaseVersion(IDirElement monitor, String message) throws Exception {
        this.m_upgradeEnv.dsFileSystem.updateFSElement((IDeltaDirElement)monitor.doneUpdate());
        this.m_utils.fixProductAndReleaseVersion(monitor.getIdentity().getName());
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void upgradeBrokerVersions(IDirElement broker) throws Exception {
        this.m_upgradeEnv.m_curTransaction = this.m_upgradeEnv.dsFileSystem.createTransaction();
        try {
            Reference acceptorConfigRef;
            String brokerLogicalName = broker.getIdentity().getName();
            brokerLogicalName = brokerLogicalName.substring(0, brokerLogicalName.lastIndexOf("/"));
            IAttributeSet topSet = broker.getAttributes();
            this.m_utils.fixProductAndReleaseVersion(broker.getIdentity().getName());
            IAttributeSet configRefs = this.findRouteListAndConfigVersions(topSet);
            this.upgradeProductVersionQueue(configRefs);
            Reference replicationsReference = (Reference)configRefs.getAttribute("REPLICATION_CONNECTIONS_ELEMENT_REF");
            if (replicationsReference != null && !configRefs.getAttributeMetaData("REPLICATION_CONNECTIONS_ELEMENT_REF").isFromTemplate()) {
                this.m_utils.fixProductAndReleaseVersion(replicationsReference.getElementName());
            }
            if ((acceptorConfigRef = (Reference)configRefs.getAttribute("ACCEPTOR_CONFIG_ELEMENT_REF")) != null && !configRefs.getAttributeMetaData("ACCEPTOR_CONFIG_ELEMENT_REF").isFromTemplate()) {
                IDirElement acceptorConfig = this.m_upgradeEnv.dsFileSystem.getFSElement(acceptorConfigRef.getElementName(), true, true);
                Vector acceptorVersionUpgrade = this.upgradeAcceptorConfig(acceptorConfig);
                for (int s = 0; s < acceptorVersionUpgrade.size(); ++s) {
                    IDirElement item = (IDirElement)acceptorVersionUpgrade.get(s);
                    this.m_utils.fixProductAndReleaseVersion(item.getIdentity().getName());
                }
            }
            this.upgradeProductVersionGlobalRouting(configRefs);
            this.m_upgradeEnv.dsFileSystem.executeTransaction(this.m_upgradeEnv.m_curTransaction);
        }
        finally {
            this.m_upgradeEnv.m_curTransaction = null;
        }
    }

    private Vector upgradeAcceptorConfig(IDirElement acceptorConfig) throws Exception {
        Vector<IDirElement> versionChange = new Vector<IDirElement>();
        versionChange.add(acceptorConfig);
        IAttributeSet acceptorsMap = (IAttributeSet)acceptorConfig.getAttributes().getAttribute("ACCEPTORS");
        HashMap acceptorsHMap = acceptorsMap.getAttributes();
        Collection acceptorsRefs = acceptorsHMap.values();
        for (Reference acceptorRef : acceptorsRefs) {
            IAttributeSet protocols;
            String acceptorName = acceptorRef.getElementName();
            IDirElement acceptorEl = this.m_upgradeEnv.dsFileSystem.getFSElement(acceptorName, true, true);
            if (this.m_upgradeEnv.isDEBUG()) {
                System.out.println("ConfigUpgrade.upgradeDirectURLS upgrading release version of " + acceptorName);
            }
            versionChange.add(acceptorEl);
            if (!acceptorEl.getIdentity().getType().equals("MQ_ACCEPTOR_DIRECT") || (protocols = (IAttributeSet)acceptorEl.getAttributes().getAttribute("PROTOCOLS")) == null) continue;
            HashMap protocolsHMap = protocols.getAttributes();
            Collection protocolsRefs = protocolsHMap.values();
            for (Reference protocolRef : protocolsRefs) {
                IDirElement protocolEl = this.m_upgradeEnv.dsFileSystem.getFSElement(protocolRef.getElementName(), true, true);
                this.printRefElementName(protocolRef);
                versionChange.add(protocolEl);
                IAttributeSet urlMap = (IAttributeSet)protocolEl.getAttributes().getAttribute("DIRECT_URL_MAP");
                if (urlMap == null) continue;
                HashMap urlsHMap = urlMap.getAttributes();
                Collection urlsRef = urlsHMap.values();
                for (Reference urlRef : urlsRef) {
                    IDirElement urlEl = this.m_upgradeEnv.dsFileSystem.getFSElement(urlRef.getElementName(), true);
                    this.printRefElementName(urlRef);
                    versionChange.add(urlEl);
                    if (urlEl.getAttributes().getAttribute("AUTHENTICATION") != null) continue;
                    if (this.m_upgradeEnv.isDEBUG()) {
                        System.out.println("ConfigUpgrade.upgradeAcceptorsElement adding AUTHENTICATION attribute set");
                    }
                    urlEl.getAttributes().createAttributeSet("AUTHENTICATION");
                    this.m_upgradeEnv.dsFileSystem.updateFSElement((IDeltaDirElement)urlEl.doneUpdate());
                }
            }
        }
        return versionChange;
    }

    private void printRefElementName(Reference urlRef) {
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("ConfigUpgrade.upgradeDirectURLS upgrading release version of " + urlRef.getElementName());
        }
    }

    private void setArchiveName(IDirElement el, String attributeName, String archiveName) throws Exception {
        IAttributeSet topSet = el.getAttributes();
        if (topSet.getAttributeMetaData(attributeName) == null || !topSet.getAttributeMetaData(attributeName).isFromTemplate()) {
            topSet.setStringAttribute(attributeName, archiveName);
        }
    }

    private String setArchiveSearchPath(IDirElement el, String archiveSearchPath) throws Exception {
        IAttributeSet topSet;
        String searchPathValue;
        IElementIdentity elID = el.getIdentity();
        String initialValue = this.getInitialValue(elID.getType(), elID.getReleaseVersion(), "ARCHIVE_SEARCH_PATH");
        if (initialValue.equals(searchPathValue = (String)(topSet = el.getAttributes()).getAttribute("ARCHIVE_SEARCH_PATH")) && !topSet.getAttributeMetaData("ARCHIVE_SEARCH_PATH").isFromTemplate()) {
            topSet.setStringAttribute("ARCHIVE_SEARCH_PATH", archiveSearchPath);
            return null;
        }
        return "The ARCHIVE_SEARCH_PATH of " + elID.getName() + " was set to the non default value of " + searchPathValue + " so it was not reset to the new default value of " + archiveSearchPath;
    }

    private void fixProductVersion(String viewName) throws Exception {
        this.m_utils.fixViewVersionsHelper(viewName, false);
        if (viewName.indexOf("_Default") > -1) {
            String parentFolder = viewName.substring(0, viewName.lastIndexOf("/"));
            this.m_utils.fixViewVersionsHelper(parentFolder, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeClusterVersions(IDirElement cluster) throws Exception {
        this.m_upgradeEnv.m_curTransaction = this.m_upgradeEnv.dsFileSystem.createTransaction();
        try {
            IAttributeSet topSet = cluster.getAttributes();
            this.m_utils.fixProductAndReleaseVersion(cluster.getIdentity().getName());
            IAttributeSet configRefs = this.findRouteListAndConfigVersions(topSet);
            this.upgradeProductVersionGlobalRouting(configRefs);
            this.upgradeProductVersionQueue(configRefs);
            this.m_upgradeEnv.dsFileSystem.executeTransaction(this.m_upgradeEnv.m_curTransaction);
        }
        finally {
            this.m_upgradeEnv.m_curTransaction = null;
        }
    }

    private IAttributeSet findRouteListAndConfigVersions(IAttributeSet topSet) throws Exception {
        IAttributeSet configRefs = (IAttributeSet)topSet.getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference routesRef = (Reference)configRefs.getAttribute("ROUTING_CONFIG_ELEMENT_REF");
        if (routesRef != null && !configRefs.getAttributeMetaData("ROUTING_CONFIG_ELEMENT_REF").isFromTemplate()) {
            IDirElement routesEl = this.m_upgradeEnv.dsFileSystem.getFSElement(routesRef.getElementName(), true, true);
            IAttributeSet routeList = (IAttributeSet)routesEl.getAttributes().getAttribute("ROUTES");
            if (routeList == null) {
                routeList = routesEl.getAttributes().createAttributeSet("ROUTES");
            }
            if (!routesEl.getAttributes().getAttributeMetaData("ROUTES").isFromTemplate()) {
                HashMap allRoutes = routeList.getAttributes();
                Collection routeElements = allRoutes.values();
                for (Reference route : routeElements) {
                    this.m_utils.fixProductAndReleaseVersion(route.getElementName());
                }
            }
            this.m_utils.fixProductAndReleaseVersion(routesEl.getIdentity().getName());
        }
        return configRefs;
    }

    private void upgradeProductVersionQueue(IAttributeSet configRefs) throws Exception {
        Reference queueReference = (Reference)configRefs.getAttribute("QUEUE_CONFIG_ELEMENT_REF");
        if (queueReference != null && !configRefs.getAttributeMetaData("QUEUE_CONFIG_ELEMENT_REF").isFromTemplate()) {
            this.m_utils.fixProductAndReleaseVersion(queueReference.getElementName());
        }
    }

    private void upgradeProductVersionGlobalRouting(IAttributeSet configRefs) throws Exception {
        Reference globalSubsRef = (Reference)configRefs.getAttribute("GLOBAL_SUBSCRIPTIONS_CONFIG_ELEMENT_REF");
        if (globalSubsRef != null && !configRefs.getAttributeMetaData("GLOBAL_SUBSCRIPTIONS_CONFIG_ELEMENT_REF").isFromTemplate()) {
            this.m_utils.fixProductAndReleaseVersion(globalSubsRef.getElementName());
        }
    }

    public String basicConfigUpgrade(IDirElement config) throws Exception {
        if (config.isTemplate()) {
            String[] instanceNames = config.getSubclassedList();
            for (int i = 0; i < instanceNames.length; ++i) {
                this.basicConfigUpgrade(this.m_upgradeEnv.dsFileSystem.getFSElement(instanceNames[i], true, true));
            }
        }
        this.m_utils.fixProductAndReleaseVersion(config.getIdentity().getName());
        return null;
    }

    void upgradeContainerPaths(IDirElement container) throws Exception {
        String containerName = (String)container.getAttributes().getAttribute("CONTAINER_NAME");
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("TypedConfigUpgrade.upgradeContainerPaths " + containerName);
        }
        String newCache = (String)this.m_upgradeEnv.getContainerProp(containerName, "cache.dir");
        String newLog = (String)this.m_upgradeEnv.getContainerProp(containerName, "log.dir");
        AttributeName cacheDirectory = new AttributeName("CACHE");
        cacheDirectory.setNextComponent("CACHE_DIRECTORY");
        if (newCache != null) {
            if (this.m_upgradeEnv.isDEBUG()) {
                System.out.println("TypedConfigUpgrade.upgradeContainerPaths " + containerName + " setting cache dir to " + newCache);
            }
            this.m_utils.fixPath(container.getAttributes(), cacheDirectory, newCache);
        }
        if (newLog != null) {
            if (this.m_upgradeEnv.isDEBUG()) {
                System.out.println("TypedConfigUpgrade.upgradeContainerPaths " + containerName + " setting log dir to " + newLog);
            }
            this.m_utils.fixPath(container.getAttributes(), new AttributeName("LOG_FILE"), newLog);
        }
    }

    void upgradeBrokerPaths(IDirElement broker) throws Exception {
        String containerName = (String)this.m_upgradeEnv.getProp("container.name");
        String sslCertChain = (String)this.m_upgradeEnv.getContainerProp(containerName, "ssl.certificate.chain");
        String certDir = (String)this.m_upgradeEnv.getContainerProp(containerName, "ssl.certificates.dir");
        IAttributeSet topSet = broker.getAttributes();
        AttributeName fixPath = new AttributeName("BROKER_SSL_PARAMETERS");
        fixPath.setNextComponent("SSL_CERTIFICATE_CHAIN");
        if (sslCertChain != null) {
            this.m_utils.fixPath(topSet, fixPath, sslCertChain);
        }
        fixPath = new AttributeName("BROKER_SSL_PARAMETERS");
        fixPath.setNextComponent("SSL_CA_CERTIFICATES_DIR");
        if (certDir != null) {
            this.m_utils.fixPath(topSet, fixPath, certDir);
        }
        this.m_utils.upgradeBrokerAndDBPaths(broker);
    }

    private void checkCLI(IDirElement container) throws ReadOnlyException, ConfigException {
        IAttributeSet topSet;
        Boolean cl;
        String DMElementName = (String)this.m_upgradeEnv.getProp("domain.manager.name");
        if (DMElementName != null && DMElementName.equals(container.getIdentity().getName()) && (cl = (Boolean)(topSet = container.getAttributes()).getAttribute("COMMAND_LINE")) != null && !cl.booleanValue()) {
            topSet.deleteAttribute("COMMAND_LINE");
        }
    }

    private String getInitialValue(String type, String version, String attributeName) throws DirectoryServiceException {
        IDirElement typeEl = this.m_upgradeEnv.dsAdmin.getElement(CONFIG_TYPE_DIRECTORY + version + '/' + type, false);
        IAttributeSet topSet = typeEl.getAttributes();
        String initialValues = (String)topSet.getAttribute(INITIAL_VALUES_ATTR);
        String attrValueBeginDelimiter = "<" + attributeName + ">";
        int delimiterPos = initialValues.indexOf(attrValueBeginDelimiter);
        int initialValueBegin = delimiterPos + attrValueBeginDelimiter.length();
        String attrValueEndDelimiter = "</" + attributeName + ">";
        int endDelimiterPos = initialValues.indexOf(attrValueEndDelimiter);
        String iValue = initialValues.substring(initialValueBegin, endDelimiterPos);
        return iValue;
    }

    private String findCluster(IDirElement broker) {
        IAttributeSet brokerReferences = (IAttributeSet)broker.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference clusterReference = (Reference)brokerReferences.getAttribute("CLUSTER_CONFIG_ELEMENT_REF");
        if (clusterReference != null) {
            return clusterReference.getElementName();
        }
        return null;
    }
}

