/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.metrics.manager.impl;

import com.sonicsw.mf.common.metrics.manager.IHistoricalStatistic;
import com.sonicsw.mf.common.metrics.manager.IMetricAnalyzer;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.impl.AbstractTimeBasedAnalyzer;
import com.sonicsw.mf.common.metrics.manager.impl.MetricsManager;
import com.sonicsw.mf.common.metrics.manager.impl.Statistic;

public class PeakRate
extends AbstractTimeBasedAnalyzer
implements IMetricAnalyzer {
    protected long m_factor;

    public PeakRate(MetricsManager metricsManager, long factor) {
        super(metricsManager);
        if (factor < 1L) {
            throw new IllegalArgumentException("Factor cannot be less than 1");
        }
        this.m_factor = factor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] evaluateValue(IStatistic statistic) {
        long[] value = new long[]{0L, statistic.getCurrencyTimestamp()};
        if (statistic instanceof IHistoricalStatistic) {
            long[] timeValues;
            long[] values;
            MetricsManager metricsManager = this.m_metricsManager;
            synchronized (metricsManager) {
                IStatistic iStatistic = statistic;
                synchronized (iStatistic) {
                    values = ((IHistoricalStatistic)statistic).getLastValues();
                }
                timeValues = this.m_metricsManager.m_elapsedCollectionTimeStatistic.getLastValues();
            }
            if (values != null) {
                int len = values.length;
                if (timeValues.length < len) {
                    len = timeValues.length;
                }
                for (int i = 0; i < len; ++i) {
                    long intervalRate = 0L;
                    long intervalTime = timeValues[i];
                    if (intervalTime > 0L) {
                        intervalRate = Math.round((double)values[i] * (double)this.m_factor / (double)intervalTime);
                    }
                    if (intervalRate <= value[0]) continue;
                    value[0] = intervalRate;
                }
            }
        } else {
            long elapsedTime;
            MetricsManager metricsManager = this.m_metricsManager;
            synchronized (metricsManager) {
                IStatistic iStatistic = statistic;
                synchronized (iStatistic) {
                    value[0] = statistic.getCurrentValue();
                    elapsedTime = System.currentTimeMillis() - ((Statistic)statistic).m_resetTimestamp;
                }
            }
            if (elapsedTime > 0L) {
                value[0] = Math.round((double)value[0] * (double)this.m_factor / (double)elapsedTime);
            }
        }
        return value;
    }
}

