/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.upgrade.ConfigurationDependencies;
import com.sonicsw.mf.common.config.upgrade.DomainManager;
import com.sonicsw.mf.common.config.upgrade.IMigrationProcess;
import com.sonicsw.mf.common.config.upgrade.TypedConfigUpgrade;
import com.sonicsw.mf.common.config.upgrade.UpgradeEnv;
import com.sonicsw.mf.common.config.upgrade.Utils;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.util.Container;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class ConfigUpgrade
implements IMigrationProcess {
    static ArrayList MQ_TYPES = new ArrayList(4);
    static ArrayList MF_TYPES = new ArrayList(8);
    UpgradeEnv m_upgradeEnv;
    DomainManager m_DMUpgrade = null;
    TypedConfigUpgrade m_configUpgrade = null;

    public ConfigUpgrade(IDirectoryFileSystemService dsFile, Properties env) {
        this.m_upgradeEnv = new UpgradeEnv(env);
        this.m_upgradeEnv.setDsAdmin((IDirectoryAdminService)((Object)dsFile));
        this.m_upgradeEnv.setDsFileSystem(dsFile);
        this.m_configUpgrade = new TypedConfigUpgrade(this.m_upgradeEnv);
    }

    public ConfigUpgrade(Properties env) {
        this.m_upgradeEnv = new UpgradeEnv(env);
    }

    public ConfigUpgrade(Properties upgradeProps, HashMap containerProps) {
        this.m_upgradeEnv = new UpgradeEnv(upgradeProps, containerProps);
    }

    public ConfigUpgrade(UpgradeEnv env) {
        this.m_upgradeEnv = env;
    }

    public void setConnection(IDirectoryFileSystemService dsFile) {
        this.m_upgradeEnv.setDsAdmin((IDirectoryAdminService)((Object)dsFile));
        this.m_upgradeEnv.setDsFileSystem(dsFile);
    }

    public String upgradeDM(IDirElement DMElement) throws Exception {
        this.m_DMUpgrade = new DomainManager();
        this.m_DMUpgrade.preConnectUpgrade(this.m_upgradeEnv);
        this.m_upgradeEnv.connectToNewPSEDirectoryService();
        this.m_DMUpgrade.upgrade(this.m_upgradeEnv);
        this.m_upgradeEnv.dsService.closeDS();
        this.m_upgradeEnv.connectToNewPSEDirectoryService();
        Vector components = this.m_upgradeEnv.m_utils.getContainerComponents(DMElement);
        components.add(DMElement.getIdentity().getName());
        this.populateUpgrade(DMElement);
        String message = this.upgradeConfigs(components);
        this.m_upgradeEnv.dsService.closeDS();
        return message;
    }

    public String upgradeContainer(String containerID) throws Exception {
        IDirElement container = this.m_upgradeEnv.dsFileSystem.getFSElement(containerID, false);
        this.populateUpgrade(container);
        Vector components = this.m_upgradeEnv.m_utils.getContainerComponents(container);
        components.add(containerID);
        return this.upgradeConfigs(components);
    }

    private void populateUpgrade(IDirElement container) {
        String containerName = (String)container.getAttributes().getAttribute("CONTAINER_NAME");
        this.m_upgradeEnv.putProp("container.name", containerName);
        this.m_configUpgrade = new TypedConfigUpgrade(this.m_upgradeEnv);
    }

    public static boolean isUpgradeSupported(String configType, String version) {
        if (UpgradeEnv.isDebugAll()) {
            System.err.println("ConfigUpgrade.isUpgradeSupported configType == " + configType + " version == " + version);
        }
        if (configType == null) {
            return false;
        }
        if (version == null) {
            return false;
        }
        if (MQ_TYPES.contains(configType) || MF_TYPES.contains(configType) || configType.equals("XQ_CONTAINER") || configType.equals("MF_LOGGER")) {
            Set productVersions = SUPPORTED_PRODUCT_VERSIONS.keySet();
            return productVersions.contains(version);
        }
        return false;
    }

    public String upgradeConfig(String configID) throws Exception {
        String message = null;
        IDirElement upgradeEl = null;
        if (this.m_upgradeEnv.isDEBUG()) {
            System.out.println("ConfigUpgrade.upgradeConfig, config == " + configID);
        }
        try {
            upgradeEl = this.m_upgradeEnv.dsFileSystem.getFSElement(configID, true, true);
        }
        catch (DirectoryServiceException directoryServiceException) {
            // empty catch block
        }
        if (upgradeEl == null) {
            try {
                upgradeEl = this.m_upgradeEnv.dsFileSystem.getFSElement(configID + "/_Default", true, true);
            }
            catch (DirectoryServiceException directoryServiceException) {
                // empty catch block
            }
        }
        if (upgradeEl != null) {
            boolean upgradeCurrent = false;
            String elType = upgradeEl.getIdentity().getType();
            if (!upgradeEl.getIdentity().getReleaseVersion().equals("109") || elType.equals("MQ_BROKER") || elType.equals("MQ_BACKUPBROKER") || elType.equals("MF_CONTAINER") || elType.equals("MF_BACKUP_DIRECTORY_SERVICE")) {
                if (elType.equals("MQ_BROKER") || elType.equals("MQ_BACKUPBROKER")) {
                    this.m_configUpgrade.upgradeMQ_BROKER(upgradeEl);
                } else if (elType.equals("MF_CONTAINER")) {
                    message = this.m_configUpgrade.upgradeMF_CONTAINER(upgradeEl);
                } else if (elType.equals("MF_ACTIVATION_DAEMON")) {
                    this.m_configUpgrade.upgradeMF_ACTIVATION_DAEMON(upgradeEl);
                } else if (elType.equals("MF_DIRECTORY_SERVICE")) {
                    this.m_configUpgrade.upgradeMF_DIRECTORY_SERVICE(upgradeEl);
                } else if (elType.equals("MF_BACKUP_DIRECTORY_SERVICE")) {
                    this.m_configUpgrade.upgradeMF_BACKUP_DIRECTORY_SERVICE(upgradeEl);
                } else if (elType.equals("MF_AGENT_MANAGER") || elType.equals("MF_BACKUP_AGENT_MANAGER")) {
                    this.m_configUpgrade.upgradeMF_AGENT_MANAGER(upgradeEl);
                } else if (elType.equals("MF_COLLECTION_MONITOR")) {
                    this.m_configUpgrade.upgradeMF_COLLECTION_MONITOR(upgradeEl);
                } else if (elType.equals("MQ_CLUSTER")) {
                    this.m_configUpgrade.upgradeMQ_CLUSTER(upgradeEl);
                } else if (elType.equals("XQ_CONTAINER")) {
                    this.m_configUpgrade.upgradeXQ_CONTAINER(upgradeEl);
                } else if (elType.equals("MF_LOGGER")) {
                    this.m_configUpgrade.upgradeMF_LOGGER(upgradeEl);
                } else if (elType.equals("MF_HOST_MANAGER")) {
                    this.m_configUpgrade.upgradeMF_HOST_MANAGER(upgradeEl);
                } else if (MF_TYPES.contains(elType) || MQ_TYPES.contains(elType)) {
                    this.m_configUpgrade.basicConfigUpgrade(upgradeEl);
                }
            }
        }
        return message;
    }

    public String upgradeConfigs(Vector configIDs) throws Exception {
        Vector<String> weededConfigList = new Vector<String>();
        Vector<String> clustersList = new Vector<String>();
        Vector<String> containerList = new Vector<String>();
        boolean createdDS = false;
        if (this.m_upgradeEnv.dsFileSystem == null) {
            this.m_upgradeEnv.connectToNewPSEDirectoryService();
            createdDS = true;
        }
        Iterator configsIt = configIDs.iterator();
        int dsIndex = 0;
        while (configsIt.hasNext()) {
            String upgradeConfigName;
            IDirElement el = null;
            String foundConfigName = upgradeConfigName = (String)configsIt.next();
            if (this.m_upgradeEnv.isDEBUG()) {
                System.out.println("Looking for element named " + upgradeConfigName);
            }
            try {
                el = this.m_upgradeEnv.dsFileSystem.getFSElement(upgradeConfigName, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (el == null) {
                try {
                    foundConfigName = upgradeConfigName + "/_Default";
                    if (this.m_upgradeEnv.isDEBUG()) {
                        System.out.println("Looking for element names " + upgradeConfigName + "/Default");
                    }
                    el = this.m_upgradeEnv.dsFileSystem.getFSElement(upgradeConfigName + "/_Default", false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (el != null) {
                if (el.getIdentity().getType().equals("MF_DIRECTORY_SERVICE")) {
                    String FTrole = (String)el.getAttributes().getAttribute("FAULT_TOLERANT_ROLE");
                    if (FTrole == null || FTrole.equals("PRIMARY")) {
                        weededConfigList.add(dsIndex, foundConfigName);
                    } else {
                        weededConfigList.add(foundConfigName);
                    }
                    ++dsIndex;
                    continue;
                }
                if (el.getSuperElementName() == null) {
                    if (el.getIdentity().getType().equals("MF_CONTAINER")) {
                        weededConfigList.add(dsIndex, foundConfigName);
                        containerList.add(foundConfigName);
                        continue;
                    }
                    if (el.getIdentity().getType().equals("MQ_CLUSTER")) {
                        clustersList.add(foundConfigName);
                        continue;
                    }
                    weededConfigList.add(foundConfigName);
                    continue;
                }
                if (!this.m_upgradeEnv.isDEBUG()) continue;
                System.out.println("**********Did not add " + upgradeConfigName + " to weededList");
                continue;
            }
            if (this.m_upgradeEnv.isDEBUG()) {
                System.out.println("***********Couldn't find element " + upgradeConfigName);
            }
            throw new Exception("ConfigUpgrade could not find configuration " + upgradeConfigName);
        }
        weededConfigList.addAll(clustersList);
        containerList.addAll(this.findClusterContainers(clustersList, weededConfigList));
        String upgradeMessage = null;
        for (String ID : containerList) {
            if (this.m_upgradeEnv.isDEBUG()) {
                System.out.println("ConfigUpgrade.upgradeConfigs stopping notifications for " + ID);
            }
            this.m_upgradeEnv.dsFileSystem.suspendChangeNotifications(ID, null);
        }
        for (String ID : weededConfigList) {
            try {
                upgradeMessage = Utils.addToUpgradeMessage(upgradeMessage, this.upgradeConfig(ID));
            }
            catch (Exception e) {
                DirectoryServiceException dirE = new DirectoryServiceException("Unable to upgrade " + ID);
                dirE.initCause(e);
                throw dirE;
            }
            finally {
                if (!createdDS) continue;
                this.m_upgradeEnv.dsService.closeDS();
            }
        }
        return upgradeMessage;
    }

    private static void generateContainerXml(String configID, String xmlFileLocation, IDirectoryAdminService dsAdmin) throws Exception {
        IDirElement containerEl = dsAdmin.getElement(configID, false);
        String xmlString = Container.exportContainerBootConfiguration(containerEl, dsAdmin.getDomain());
        FileOutputStream xmlFileStream = new FileOutputStream(xmlFileLocation);
        xmlFileStream.write(xmlString.getBytes());
        xmlFileStream.close();
    }

    private Vector findClusterContainers(Vector clustersList, Vector knownAlready) throws Exception {
        Vector<String> depContainers = new Vector<String>();
        ConfigurationDependencies dep = new ConfigurationDependencies(this.m_upgradeEnv);
        for (String clusterID : clustersList) {
            if (this.m_upgradeEnv.isDEBUG()) {
                System.out.println("** ConfigUpgrade.findClusterContainers called for " + clusterID);
            }
            Vector clusterDep = dep.findNotificationDependencies(clusterID, knownAlready);
            Iterator clusterDepIT = clusterDep.iterator();
            if (this.m_upgradeEnv.isDEBUG()) {
                System.out.println("** ConfigUpgrade.findClusterContainers done for " + clusterID);
            }
            while (clusterDepIT.hasNext()) {
                IElementIdentity depID = (IElementIdentity)clusterDepIT.next();
                String depType = depID.getType();
                if (!depType.equals("MF_CONTAINER")) continue;
                if (this.m_upgradeEnv.isDEBUG()) {
                    System.out.println("** " + depID.getName());
                }
                depContainers.add(depID.getName());
            }
        }
        return depContainers;
    }

    static {
        MQ_TYPES.add("MQ_BROKER");
        MQ_TYPES.add("MQ_BACKUPBROKER");
        MQ_TYPES.add("MQ_CLUSTER");
        MQ_TYPES.add("MQ_AUTHORIZATION_POLICY");
        MQ_TYPES.add("MQ_CERTIFICATES_STORE");
        MQ_TYPES.add("MQ_WS_PROTOCOL");
        MF_TYPES.add("MF_CONTAINER");
        MF_TYPES.add("MF_ACTIVATION_DAEMON");
        MF_TYPES.add("MF_AUTHENTICATION_DOMAIN");
        MF_TYPES.add("MF_CONTAINER_COLLECTION");
        MF_TYPES.add("MF_COMPONENT_COLLECTION");
        MF_TYPES.add("MF_COLLECTION_MONITOR");
        MF_TYPES.add("MF_AGENT_MANAGER");
        MF_TYPES.add("MF_BACKUP_AGENT_MANAGER");
        MF_TYPES.add("MF_DIRECTORY_SERVICE");
        MF_TYPES.add("MF_BACKUP_DIRECTORY_SERVICE");
        MF_TYPES.add("MF_LOGGER");
        MF_TYPES.add("MF_HOST_MANAGER");
    }
}

