/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.util;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.xml.ElementBuilder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class Container {
    public static final String SONICFS_PROTOCOL = "sonicfs:///";
    public static final String SONICHOME_PROTOCOL = "sonichome:///";
    private static final String CONNECTION_PREFIX = "Connection.";
    private static final String CENTRAL_CONNECTION_PREFIX = "CentralConnection.";
    private static final String CACHE_PASSWORD_ATTR = "CACHE_PASSWORD";
    private static final String CENTRAL_CONNECTION_SETUP_PROP = "CENTRAL_CONNECTION";
    private static Set xmlBootAttributes = new HashSet();
    private static Set iniBootAttributes;

    public static String exportContainerBootConfiguration(IElement containerConfigElement, String domainName) {
        try {
            return ElementBuilder.exportElement(Container.filterBootConfiguration(containerConfigElement, xmlBootAttributes), domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e.toString(), e);
        }
    }

    public static String exportContainerBootConfigurationToINI(IElement containerConfigElement) {
        try {
            Properties props = new Properties();
            Container.bootConfigurationToProp(containerConfigElement, props);
            Enumeration<Object> propItems = props.keys();
            StringBuffer sb = new StringBuffer();
            sb.append("");
            while (propItems.hasMoreElements()) {
                String key = (String)propItems.nextElement();
                String value = props.getProperty(key);
                if (value.length() == 0) continue;
                sb.append(key).append("=").append(value).append("\n");
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e.toString(), e);
        }
    }

    private static boolean containsCentralConnection(HashMap attributeTable) {
        for (String attributeName : attributeTable.keySet()) {
            if (!attributeName.equalsIgnoreCase(CENTRAL_CONNECTION_SETUP_PROP)) continue;
            return true;
        }
        return false;
    }

    public static void bootConfigurationToSetupProp(IElement containerConfigElement, Properties properties) {
        Container.configurationToPropInternal(containerConfigElement, properties, true);
    }

    public static void bootConfigurationToProp(IElement containerConfigElement, Properties props) {
        Container.configurationToPropInternal(containerConfigElement, props, false);
    }

    public static boolean iniFileAttribute(String attribute) {
        return iniBootAttributes.contains(attribute);
    }

    private static void configurationToPropInternal(IElement containerConfigElement, Properties props, boolean forSetup) {
        IElement filteredElement = Container.filterBootConfiguration(containerConfigElement, iniBootAttributes);
        IAttributeSet containerAttrs = filteredElement.getAttributes();
        HashMap attributeTable = containerAttrs.getAttributes();
        boolean hasCentral = Container.containsCentralConnection(attributeTable);
        Iterator iterator = attributeTable.keySet().iterator();
        boolean domainNamePresent = false;
        while (iterator.hasNext()) {
            Object value;
            String attributeName = (String)iterator.next();
            if (attributeName.equals("DOMAIN_NAME")) {
                domainNamePresent = true;
            }
            if ((value = attributeTable.get(attributeName)) == null) continue;
            if (attributeName.equalsIgnoreCase("CACHE")) {
                String cacheDir;
                IAttributeSet cacheAttrs = (IAttributeSet)value;
                String password = (String)cacheAttrs.getAttribute("PASSWORD");
                if (password != null) {
                    props.setProperty(CACHE_PASSWORD_ATTR, password);
                }
                if ((cacheDir = (String)cacheAttrs.getAttribute("CACHE_DIRECTORY")) == null) continue;
                props.setProperty("CACHE_DIRECTORY", cacheDir);
                continue;
            }
            if (attributeName.equalsIgnoreCase("CONNECTION") && !hasCentral) {
                Container.addConnectionAtts((IAttributeSet)value, props, CONNECTION_PREFIX, forSetup);
                continue;
            }
            if (attributeName.equalsIgnoreCase(CENTRAL_CONNECTION_SETUP_PROP)) {
                Container.addConnectionAtts((IAttributeSet)value, props, CENTRAL_CONNECTION_PREFIX, forSetup);
                continue;
            }
            props.setProperty(attributeName, value.toString());
        }
        if (forSetup && hasCentral) {
            props.setProperty(CENTRAL_CONNECTION_SETUP_PROP, "true");
        }
        if (!domainNamePresent) {
            props.setProperty("DOMAIN_NAME", "Domain1");
        }
    }

    private static void addConnectionAtts(IAttributeSet connAtts, Properties props, String prefixParam, boolean forSetup) {
        String prefix = prefixParam;
        if (forSetup) {
            prefix = "";
        }
        HashMap attributeTable = connAtts.getAttributes();
        Iterator iterator = attributeTable.keySet().iterator();
        boolean connectionUrlsPresent = false;
        while (iterator.hasNext()) {
            String attributeName = (String)iterator.next();
            if (attributeName.equalsIgnoreCase("ConnectionURLs")) {
                connectionUrlsPresent = true;
            }
            props.setProperty(prefix + attributeName, attributeTable.get(attributeName).toString());
        }
        if (!connectionUrlsPresent) {
            props.setProperty(prefix + "ConnectionURLs", "tcp://localhost:2506");
        }
    }

    private static IElement filterBootConfiguration(IElement containerConfigElement, Set bootAttributes) {
        try {
            IElement writableCopy = containerConfigElement.createWritableClone();
            IAttributeSet writableAttributes = writableCopy.getAttributes();
            IAttributeSet containerAttrs = containerConfigElement.getAttributes();
            HashMap attributeTable = containerAttrs.getAttributes();
            for (String attributeName : attributeTable.keySet()) {
                if (bootAttributes.contains(attributeName)) continue;
                writableAttributes.deleteAttribute(attributeName);
            }
            IAttributeSet connectionAttrs = (IAttributeSet)writableAttributes.getAttribute("CONNECTION");
            if (connectionAttrs != null && connectionAttrs.getAttribute("TRY_DS_AM_BACKUPS_ON_FAILURE") != null) {
                connectionAttrs.deleteAttribute("TRY_DS_AM_BACKUPS_ON_FAILURE");
            }
            return writableCopy;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e.toString(), e);
        }
    }

    public static IDeltaDirElement initializeNewContainer(IDirElement containerConfigElement, Hashtable defaultContainerParams, Hashtable defaultConnectionParams) throws Exception {
        String key;
        IAttributeSet containerAtts = containerConfigElement.getAttributes();
        IAttributeSet cacheAtts = (IAttributeSet)containerAtts.getAttribute("CACHE");
        IAttributeSet connectAtts = (IAttributeSet)containerAtts.getAttribute("CONNECTION");
        String cacheDir = (String)defaultContainerParams.remove("CACHE_DIRECTORY");
        String cachePassword = (String)defaultContainerParams.remove(CACHE_PASSWORD_ATTR);
        Enumeration keys = defaultContainerParams.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            containerAtts.setObjectAttribute(key, defaultContainerParams.get(key));
        }
        if (cacheDir != null) {
            cacheAtts.setStringAttribute("CACHE_DIRECTORY", cacheDir);
        }
        if (cachePassword != null) {
            cacheAtts.setStringAttribute("PASSWORD", cachePassword);
        }
        keys = defaultConnectionParams.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            connectAtts.setObjectAttribute(key, defaultConnectionParams.get(key));
        }
        return (IDeltaDirElement)containerConfigElement.doneUpdate();
    }

    private static void addAttributes(Set attributeSet) {
        attributeSet.add("CACHE");
        attributeSet.add("CONNECTION");
        attributeSet.add(CENTRAL_CONNECTION_SETUP_PROP);
    }

    static {
        xmlBootAttributes.add("CLASSNAME");
        xmlBootAttributes.add("DOMAIN_NAME");
        xmlBootAttributes.add("CONTAINER_NAME");
        xmlBootAttributes.add("HOSTS_DIRECTORY_SERVICE");
        xmlBootAttributes.add("COMMAND_LINE");
        Container.addAttributes(xmlBootAttributes);
        xmlBootAttributes.add("LOG_TO_CONSOLE");
        xmlBootAttributes.add("LOG_TO_FILE");
        xmlBootAttributes.add("LOG_FILE");
        xmlBootAttributes.add("LOG_FILE_SIZE_THRESHOLD");
        xmlBootAttributes.add("TRACE_MASK");
        iniBootAttributes = new HashSet();
        iniBootAttributes.add("DOMAIN_NAME");
        iniBootAttributes.add("HOSTS_DIRECTORY_SERVICE");
        Container.addAttributes(iniBootAttributes);
        iniBootAttributes.add("LOG_FILE");
        iniBootAttributes.add("TRACE_MASK");
    }
}

