/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.mgmtapi.runtime.impl;

import com.sonicsw.mf.common.runtime.IFileDescriptor;
import com.sonicsw.mf.common.runtime.IRemoteCallResult;
import com.sonicsw.mf.common.runtime.IRemoteExecResult;
import com.sonicsw.mf.common.runtime.impl.RemoteCallResult;
import com.sonicsw.mf.common.runtime.impl.RemoteCallResultWithData;
import com.sonicsw.mf.common.util.ZipSerializer;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mf.mgmtapi.runtime.IHostManagerProxy;
import com.sonicsw.mf.mgmtapi.runtime.ProxyRuntimeException;
import com.sonicsw.mf.mgmtapi.runtime.impl.AbstractProxy;
import com.sonicsw.mx.util.IEmptyArray;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import javax.management.ObjectName;

public final class HostManagerProxy
extends AbstractProxy
implements IHostManagerProxy {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String[] DOWNLOAD_FROM_DS_SIGNATURE = new String[]{String.class.getName(), String.class.getName(), Boolean.class.getName(), Boolean.class.getName()};
    private static final String[] PUT_FILE_SIGNATURE = new String[]{IEmptyArray.EMPTY_BYTE_ARRAY.getClass().getName(), String.class.getName(), Boolean.class.getName()};
    private static final String[] LIST_DIRECTORY_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] SETUP_CONTAINER_SIGNATURE = new String[]{Properties.class.getName(), String.class.getName()};
    private static final String[] HOME_SETUP_CONTAINER_SIGNATURE = new String[]{String.class.getName(), String.class.getName(), Properties.class.getName(), String.class.getName()};
    private static final String[] INSTALL_LAUNCHER_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] SETUP_FROM_CONFIG_CONTAINER_SIGNATURE = new String[]{String.class.getName(), Properties.class.getName(), String.class.getName()};
    private static final String[] LAUNCH_CONTAINER_SIGNATURE = new String[]{String.class.getName(), Boolean.class.getName()};
    private static final String[] LAUNCH_AT_OTHER_HOME_CONTAINER_SIGNATURE = new String[]{String.class.getName(), String.class.getName(), Boolean.class.getName()};
    private static final String[] REMOVE_CONTAINER_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] REMOTE_EXEC_SIGNATURE = new String[]{IEmptyArray.EMPTY_STRING_ARRAY.getClass().getName(), IEmptyArray.EMPTY_STRING_ARRAY.getClass().getName(), String.class.getName(), IEmptyArray.EMPTY_BYTE_ARRAY.getClass().getName()};
    private static final String[] GET_FILE_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] GET_ALL_HOSTNAMES_AND_IPS_SIGNATURE = new String[]{Boolean.class.getName()};
    private static final String[] DELETE_FILES_SIGNATURE = new String[]{String.class.getName(), Boolean.class.getName()};

    public HostManagerProxy(JMSConnectorClient connector, ObjectName jmxComponentName) {
        super(connector, jmxComponentName);
    }

    @Override
    public Properties getJVMProperties() {
        try {
            return (Properties)this.m_connector.invoke(this.m_objectName, "getJVMProperties", IEmptyArray.EMPTY_OBJECT_ARRAY, IEmptyArray.EMPTY_STRING_ARRAY);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public IRemoteCallResult downloadFileFromDS(String dsFilePath, String destinationFilePath, boolean rewriteIfExists, boolean expandZip) {
        try {
            return (IRemoteCallResult)this.m_connector.invoke(this.m_objectName, "downloadFileFromDS", new Object[]{dsFilePath, destinationFilePath, rewriteIfExists, expandZip}, DOWNLOAD_FROM_DS_SIGNATURE);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public IRemoteCallResult putFiles(String sourceFilePath, String destinationFilePath, boolean rewriteIfExists) {
        try {
            RemoteCallResultWithData result = this.fileToBytes(sourceFilePath);
            if (!result.isSuccessful()) {
                return result;
            }
            return (IRemoteCallResult)this.m_connector.invoke(this.m_objectName, "bytesToFile", new Object[]{(byte[])result.getData(), destinationFilePath, rewriteIfExists}, PUT_FILE_SIGNATURE);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public IFileDescriptor[] listDirectory(String directoryPath) {
        try {
            return (IFileDescriptor[])this.m_connector.invoke(this.m_objectName, "listDirectory", new Object[]{directoryPath}, LIST_DIRECTORY_SIGNATURE);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public IRemoteCallResult setupContainer(Properties properties, String INIEncryptionPassword) {
        try {
            return (IRemoteCallResult)this.m_connector.invoke(this.m_objectName, "setupContainer", new Object[]{properties, INIEncryptionPassword}, SETUP_CONTAINER_SIGNATURE);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public IRemoteCallResult setupContainer(String sonicHome, String launcherVersion, Properties properties, String INIEncryptionPassword) {
        try {
            return (IRemoteCallResult)this.m_connector.invoke(this.m_objectName, "setupContainer", new Object[]{sonicHome, launcherVersion, properties, INIEncryptionPassword}, HOME_SETUP_CONTAINER_SIGNATURE);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public IRemoteCallResult installLauncher(String targetSonicHome) {
        try {
            return (IRemoteCallResult)this.m_connector.invoke(this.m_objectName, "installLauncher", new Object[]{targetSonicHome}, INSTALL_LAUNCHER_SIGNATURE);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public IRemoteCallResult setupContainer(String containerDSPath, Properties properties, String INIEncryptionPassword) {
        try {
            return (IRemoteCallResult)this.m_connector.invoke(this.m_objectName, "setupContainer", new Object[]{containerDSPath, properties, INIEncryptionPassword}, SETUP_FROM_CONFIG_CONTAINER_SIGNATURE);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public IRemoteCallResult launchContainer(String containerName, boolean launchAsWindowsService) {
        try {
            return (IRemoteCallResult)this.m_connector.invoke(this.m_objectName, "launchContainer", new Object[]{containerName, launchAsWindowsService}, LAUNCH_CONTAINER_SIGNATURE);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public IRemoteCallResult launchContainer(String sonicHome, String containerName, boolean launchAsWindowsService) {
        try {
            return (IRemoteCallResult)this.m_connector.invoke(this.m_objectName, "launchContainer", new Object[]{sonicHome, containerName, launchAsWindowsService}, LAUNCH_AT_OTHER_HOME_CONTAINER_SIGNATURE);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public IRemoteCallResult removeContainer(String containerName) {
        try {
            return (IRemoteCallResult)this.m_connector.invoke(this.m_objectName, "removeContainer", new Object[]{containerName}, REMOVE_CONTAINER_SIGNATURE);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public IRemoteExecResult remoteExec(String[] cmdarray, String[] envp, String workDirPath, byte[] inputBytes) {
        try {
            return (IRemoteExecResult)this.m_connector.invoke(this.m_objectName, "remoteExec", new Object[]{cmdarray, envp, workDirPath, inputBytes}, REMOTE_EXEC_SIGNATURE);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public IRemoteCallResult getFiles(String srcFilePath, String destinationFilePath, boolean rewriteIfExists) {
        try {
            RemoteCallResultWithData result = (RemoteCallResultWithData)this.m_connector.invoke(this.m_objectName, "fileToBytes", new Object[]{srcFilePath}, GET_FILE_SIGNATURE);
            if (!result.isSuccessful()) {
                return result;
            }
            return this.bytesToFile((byte[])result.getData(), destinationFilePath, rewriteIfExists);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public String[] getAllHostnamesAndIPs(boolean _includeLoopback) {
        try {
            return (String[])this.m_connector.invoke(this.m_objectName, "getAllHostnamesAndIPs", new Object[]{_includeLoopback}, GET_ALL_HOSTNAMES_AND_IPS_SIGNATURE);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public void reload() {
        try {
            Object[] params = new Object[]{};
            String[] signature = new String[]{};
            this.m_connector.invoke(this.m_objectName, "reload", params, signature);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public void start() {
        try {
            Object[] params = new Object[]{};
            String[] signature = new String[]{};
            this.m_connector.invoke(this.m_objectName, "start", params, signature);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public void stop() {
        try {
            Object[] params = new Object[]{};
            String[] signature = new String[]{};
            this.m_connector.invoke(this.m_objectName, "stop", params, signature);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    @Override
    public IRemoteCallResult deleteFiles(String pathOfdirectoryOrFile, boolean deleteContent) {
        try {
            return (IRemoteCallResult)this.m_connector.invoke(this.m_objectName, "deleteFiles", new Object[]{pathOfdirectoryOrFile, deleteContent}, DELETE_FILES_SIGNATURE);
        }
        catch (Exception e) {
            throw new ProxyRuntimeException(e);
        }
    }

    private RemoteCallResultWithData fileToBytes(String srcFilePath) {
        try {
            File srcFile = new File(srcFilePath);
            if (!srcFile.exists()) {
                return new RemoteCallResultWithData(false, "com.sonicsw.mf.jmx.client.fileToBytes failed: " + srcFilePath + " does not exist", null);
            }
            byte[] zipBytes = new ZipSerializer(srcFile.getParentFile()).zipFileOrDir(srcFile.getName());
            return new RemoteCallResultWithData(true, null, zipBytes);
        }
        catch (Throwable t) {
            return new RemoteCallResultWithData(false, HostManagerProxy.printStackTrace(t, "com.sonicsw.mf.jmx.client.fileToBytes failed to zip \"" + srcFilePath + "\": "), null);
        }
    }

    private RemoteCallResult bytesToFile(byte[] src, String destinationFilePath, boolean rewriteIfExists) {
        try {
            File destinationFile = new File(destinationFilePath);
            if (destinationFile.exists() && !rewriteIfExists) {
                return new RemoteCallResult(false, "com.sonicsw.mf.jmx.client.bytesToFile failed: " + destinationFilePath + " already exists");
            }
            if (destinationFile.exists()) {
                this.deleteObsolete(destinationFile);
                if (destinationFile.exists()) {
                    return new RemoteCallResult(false, "com.sonicsw.mf.jmx.client.bytesToFile failed: Could not delete \"" + destinationFilePath + "\"");
                }
            }
            new ZipSerializer(destinationFile.getParentFile()).expandZipFromBytes(src, destinationFile.getName());
            return new RemoteCallResult(true, null);
        }
        catch (Throwable t) {
            return new RemoteCallResult(false, HostManagerProxy.printStackTrace(t, "com.sonicsw.mf.jmx.client.bytesToFile failed to unzip into \"" + destinationFilePath + "\": "));
        }
    }

    private void deleteObsolete(File fileToDelete) {
        if (fileToDelete.isDirectory()) {
            String[] files = fileToDelete.list();
            for (int i = 0; i < files.length; ++i) {
                this.deleteObsolete(new File(fileToDelete, files[i]));
            }
            fileToDelete.delete();
        } else {
            fileToDelete.delete();
        }
    }

    private static String printStackTrace(Throwable exception, String message) {
        StringBuffer buffer = new StringBuffer(message);
        buffer.append(NEWLINE);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out, true);
        exception.printStackTrace(writer);
        byte[] data = out.toByteArray();
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        buffer.append(new String(data));
        return buffer.toString();
    }
}

