/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.util;

import com.sonicsw.mf.common.dirconfig.IDirElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ZipUtils {
    private static final int DEFAULT_BUFFER_SIZE = 128;

    public static byte[] asZippedBytes(IDirElement[] elements) throws IOException {
        int expectedElementSize = 128;
        return ZipUtils.asZippedBytes((Serializable)elements, expectedElementSize * elements.length);
    }

    public static byte[] asZippedBytes(Serializable object) throws IOException {
        return ZipUtils.asZippedBytes(object, 128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] asZippedBytes(Serializable object, int buffersize) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(Math.max(128, buffersize));
        ObjectOutputStream objectStream = null;
        try (GZIPOutputStream zipStream = null;){
            zipStream = new GZIPOutputStream(byteStream);
            objectStream = new ObjectOutputStream(zipStream);
            objectStream.writeObject(object);
            zipStream.flush();
            zipStream.finish();
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDirElement[] fromZippedBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        IDirElement[] allElements = null;
        try (ObjectInputStream objectStream = null;){
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            GZIPInputStream zipStream = new GZIPInputStream(byteStream);
            objectStream = new ObjectInputStream(zipStream);
            IDirElement[] iDirElementArray = allElements = (IDirElement[])objectStream.readObject();
            return iDirElementArray;
        }
    }
}

