/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.metrics.manager.impl;

import com.sonicsw.mf.common.metrics.manager.ISampledStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatistic;

public class Statistic
implements IStatistic {
    public short m_updateMode;
    public boolean m_intervalMode;
    private boolean DEBUG = false;
    protected long m_currentUpdateValue;
    protected long m_currentMinMaxValue;
    protected long m_lastUpdateValue;
    protected long m_numUpdates;
    protected long m_currentIntervalValue;
    protected long m_lastIntervalValue;
    protected long m_currencyTimestamp = -1L;
    protected long m_lastCurrencyTimestamp = -1L;
    public long m_resetTimestamp = -1L;
    protected long m_initialValue = 0L;
    protected boolean m_isVirgin = true;
    protected static final long INVALID_TIME = -1L;
    String m_name;

    public Statistic(short updateMode, boolean intervalMode) {
        this.m_updateMode = updateMode;
        this.m_intervalMode = intervalMode;
        this.initializeStatistic();
    }

    @Override
    public synchronized long getCurrentValue() {
        if (this.m_updateMode == 5 || this.m_updateMode == 6) {
            return this.m_currentIntervalValue;
        }
        return this.m_currentUpdateValue;
    }

    @Override
    public synchronized long getLastValue() {
        return this.m_intervalMode ? this.m_currentIntervalValue - this.m_lastIntervalValue : this.m_currentIntervalValue;
    }

    @Override
    public long getLastUpdateCount() {
        return this.m_numUpdates;
    }

    @Override
    public synchronized long getCurrencyTimestamp() {
        if (this instanceof ISampledStatistic) {
            return this.m_currencyTimestamp;
        }
        return System.currentTimeMillis();
    }

    @Override
    public synchronized long getLastRefreshCycleDuration() {
        if (this.m_lastCurrencyTimestamp == -1L || this.m_currencyTimestamp == -1L) {
            return -1L;
        }
        return this.m_currencyTimestamp - this.m_lastCurrencyTimestamp;
    }

    @Override
    public synchronized void updateValue(long value) {
        ++this.m_numUpdates;
        long previousValue = this.m_lastUpdateValue;
        this.m_lastUpdateValue = value;
        switch (this.m_updateMode) {
            case 0: {
                this.m_currentUpdateValue = value;
                break;
            }
            case 1: {
                this.m_currentUpdateValue = value - previousValue;
                break;
            }
            case 2: {
                this.m_currentUpdateValue += value;
                break;
            }
            case 5: {
                this.m_currentUpdateValue += value;
                if (this.m_currentUpdateValue <= this.m_currentMinMaxValue) break;
                this.m_currentMinMaxValue = this.m_currentUpdateValue;
                break;
            }
            case 6: {
                this.m_currentUpdateValue += value;
                if (this.m_currentUpdateValue >= this.m_currentMinMaxValue) break;
                this.m_currentMinMaxValue = this.m_currentUpdateValue;
                break;
            }
            case 3: {
                if (value <= this.m_currentUpdateValue) break;
                this.m_currentUpdateValue = value;
                break;
            }
            case 4: {
                if (value >= this.m_currentUpdateValue) break;
                this.m_currentUpdateValue = value;
            }
        }
        this.m_isVirgin = false;
        if (this.DEBUG) {
            System.out.println(System.currentTimeMillis() + " (" + this + ") Updated value = " + value + " currentUpdateValue = " + this.m_currentUpdateValue + " count = " + this.m_numUpdates);
        }
    }

    @Override
    public synchronized void refresh() {
        if (this.DEBUG) {
            System.out.println(System.currentTimeMillis() + " (" + this + ") Refreshing Statistic - current value = " + this.m_currentUpdateValue);
        }
        this.m_lastIntervalValue = this.m_currentIntervalValue;
        switch (this.m_updateMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.m_currentIntervalValue = this.m_currentUpdateValue;
                break;
            }
            case 5: 
            case 6: {
                this.m_currentIntervalValue = this.m_currentMinMaxValue;
                this.m_currentMinMaxValue = this.m_currentUpdateValue;
            }
        }
        this.m_lastCurrencyTimestamp = this.m_currencyTimestamp;
        this.m_currencyTimestamp = System.currentTimeMillis();
        this.m_isVirgin = false;
    }

    private void initializeStatistic() {
        this.m_currentUpdateValue = this.m_lastUpdateValue = this.m_initialValue;
        this.m_numUpdates = 0L;
        this.m_currentIntervalValue = this.m_lastIntervalValue = this.m_currentUpdateValue;
        this.m_currencyTimestamp = -1L;
        this.m_lastCurrencyTimestamp = -1L;
        this.m_resetTimestamp = System.currentTimeMillis();
        this.m_isVirgin = true;
    }

    @Override
    public synchronized void reset() {
        this.initializeStatistic();
    }

    @Override
    public synchronized void setInitialValue(long value) {
        if (!this.m_isVirgin) {
            throw new IllegalStateException("Cannot reset initial value after usage.");
        }
        this.m_initialValue = value;
        this.reset();
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String toString() {
        return "Statistic@" + Integer.toHexString(this.hashCode()) + ": name=" + this.m_name + ", updateMode=" + this.m_updateMode + ", intervalMode=" + this.m_intervalMode;
    }
}

