/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.util;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeMetaData;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.ITriggerDSContext;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.FromDirectory;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import java.util.HashMap;
import java.util.Map;

public class ReferentialIntegrity {
    private static final String CONTAINERS_DIR = "/containers";

    public static void removeComponent(ITriggerDSContext ds, String configID) throws DirectoryServiceException {
        if (!ds.directoryExists(CONTAINERS_DIR)) {
            return;
        }
        IElementIdentity[] ids = ds.listElements(CONTAINERS_DIR);
        try {
            for (int i = 0; i < ids.length; ++i) {
                IAttributeMetaData compMeta;
                IDirElement containerConfig = ds.getElement(ids[i].getName());
                boolean elementModified = false;
                IAttributeSet containerAtts = containerConfig.getAttributes();
                String containerName = (String)containerAtts.getAttribute("CONTAINER_NAME");
                String domainName = (String)containerAtts.getAttribute("DOMAIN_NAME");
                IAttributeSet componentsAtt = (IAttributeSet)containerAtts.getAttribute("COMPONENTS");
                if (componentsAtt == null || (compMeta = containerAtts.getAttributeMetaData("COMPONENTS")).isFromTemplate()) continue;
                HashMap componentsTable = componentsAtt.getAttributes();
                for (String componentName : componentsTable.keySet()) {
                    IAttributeSet compDefinition = (IAttributeSet)componentsTable.get(componentName);
                    Reference configRef = (Reference)compDefinition.getAttribute("CONFIG_REF");
                    if (configRef == null || !configRef.getElementName().equals(configID)) continue;
                    elementModified = true;
                    componentsAtt.deleteAttribute(componentName);
                    ReferentialIntegrity.removeComponentFromComponentCollections(ds, new CanonicalName(domainName, containerName, componentName));
                    if (!componentName.equals("DIRECTORY SERVICE")) continue;
                    containerAtts.deleteAttribute("HOSTS_DIRECTORY_SERVICE");
                }
                if (!elementModified) continue;
                ds.setElement((IDeltaElement)containerConfig.doneUpdate());
            }
        }
        catch (ConfigException e) {
            e.printStackTrace();
            throw new Error(e.toString(), e);
        }
    }

    private static void removeComponentFromComponentCollections(ITriggerDSContext ds, CanonicalName componentName) throws DirectoryServiceException {
        if (!ds.directoryExists("/componentCollections")) {
            return;
        }
        try {
            AttributeName attrName = new AttributeName("COMPONENTS");
            FromDirectory f = new FromDirectory("/componentCollections");
            IDirElement[] elements = ds.getElements(new Query().setFrom(f), true);
            block2: for (int i = 0; i < elements.length; ++i) {
                IAttributeSet collectionAtts = elements[i].getAttributes();
                if (collectionAtts.getAttributeMetaData("COMPONENTS").isFromTemplate()) continue;
                IAttributeSet set = (IAttributeSet)collectionAtts.getAttribute("COMPONENTS");
                for (Map.Entry entry : set.getAttributes().entrySet()) {
                    IAttributeSet itemSet = (IAttributeSet)entry.getValue();
                    String id = (String)itemSet.getAttribute("COMPONENT_RUNTIME_ID");
                    if (!id.equals(componentName.getCanonicalName())) continue;
                    set.deleteAttribute((String)entry.getKey());
                    ds.setElement((IDeltaElement)elements[i].doneUpdate());
                    continue block2;
                }
            }
        }
        catch (ConfigException e) {
            e.printStackTrace();
            throw new Error(e.toString(), e);
        }
    }
}

