/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipSerializer {
    byte[] m_buffer = new byte[1024];
    File m_rootParent;

    public static void mainTestInMemory(String[] args) throws IOException {
        String fileToZip = args[0];
        ZipSerializer serializer = new ZipSerializer(new File("C:/test/testzip"));
        byte[] zipBytes = serializer.zipFileOrDir(args[0]);
        ZipSerializer unserializer = new ZipSerializer(new File("./dest"));
        unserializer.expandZipFromBytes(zipBytes, "newF");
    }

    public static void main(String[] args) throws IOException {
        String fileToUnZip = args[0];
        ZipSerializer serializer = new ZipSerializer(new File("."));
        serializer.expandZip(new File("C:/Sonic7.7/Archives/MF/7.7/MFcontainer.zip"), new File("C:/test/testzip/MFcontainer"));
    }

    public ZipSerializer(File rootParent) {
        this.m_rootParent = rootParent;
    }

    public byte[] zipFileOrDir(String fileOrDir) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        ZipOutputStream zos = new ZipOutputStream(bos);
        this.zipInternal(fileOrDir, zos);
        zos.close();
        return bos.toByteArray();
    }

    public void zipDir(File zipFile) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(zipFile));
        ZipOutputStream zos = new ZipOutputStream(bos);
        String[] fileList = this.m_rootParent.list();
        for (int i = 0; i < fileList.length; ++i) {
            this.zipInternal(fileList[i], zos);
        }
        zos.close();
        ((OutputStream)bos).close();
    }

    private void zipInternal(String fileOrDir, ZipOutputStream zos) throws IOException {
        File currentFile = new File(this.m_rootParent, fileOrDir);
        if (currentFile.isDirectory()) {
            zos.putNextEntry(new ZipEntry(fileOrDir + "/"));
            String[] subFiles = currentFile.list();
            for (int i = 0; i < subFiles.length; ++i) {
                this.zipInternal(fileOrDir + "/" + subFiles[i], zos);
            }
        } else {
            this.zipTheFile(fileOrDir, zos);
        }
    }

    private void zipTheFile(String subPath, ZipOutputStream zos) throws IOException {
        File inFile = new File(this.m_rootParent, subPath);
        FileInputStream fis = new FileInputStream(inFile);
        zos.putNextEntry(new ZipEntry(subPath));
        int bytesIn = 0;
        while ((bytesIn = fis.read(this.m_buffer)) != -1) {
            zos.write(this.m_buffer, 0, bytesIn);
        }
        fis.close();
    }

    public void expandZipFromBytes(byte[] zipBytes, String newRootName) throws IOException {
        if (!this.m_rootParent.exists() && !this.m_rootParent.mkdirs()) {
            throw new IOException(this.m_rootParent.getAbsolutePath() + " does not exist and cannot be created");
        }
        if (!this.m_rootParent.isDirectory()) {
            throw new IOException(this.m_rootParent.getAbsolutePath() + " is not a directory");
        }
        File tempZipFile = new File(this.m_rootParent, newRootName + "_tmp.zip");
        tempZipFile.delete();
        FileOutputStream fos = new FileOutputStream(tempZipFile);
        fos.write(zipBytes);
        fos.close();
        this.expandFromTempZip(tempZipFile, this.m_rootParent, newRootName);
        tempZipFile.delete();
    }

    private void expandFromTempZip(File zipDataFile, File destination, String newRootName) throws IOException {
        ZipFile zipFile = new ZipFile(zipDataFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File createdFile = new File(destination, ZipSerializer.replaceRoot(entry.getName(), newRootName));
            if (entry.isDirectory()) {
                if (createdFile.exists() || createdFile.mkdirs()) continue;
                throw new IOException("Could not create " + createdFile.getAbsolutePath());
            }
            this.createFile(zipFile.getInputStream(entry), createdFile);
        }
        zipFile.close();
    }

    public void expandZip(File zipDataFile, File destination) throws IOException {
        if (!destination.exists() && !destination.mkdirs()) {
            throw new IOException("Could not create " + destination.getAbsolutePath());
        }
        ZipFile zipFile = new ZipFile(zipDataFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            File preCreateParents;
            ZipEntry entry = entries.nextElement();
            File createdFile = new File(destination, entry.getName());
            File file = preCreateParents = entry.isDirectory() ? createdFile : createdFile.getParentFile();
            if (!preCreateParents.exists() && !preCreateParents.mkdirs()) {
                throw new IOException("Could not create " + preCreateParents.getAbsolutePath());
            }
            if (entry.isDirectory()) continue;
            this.createFile(zipFile.getInputStream(entry), createdFile);
        }
        zipFile.close();
    }

    private void createFile(InputStream stream0, File fileToCreate) throws IOException {
        int numRead;
        BufferedInputStream is = new BufferedInputStream(stream0, this.m_buffer.length);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(fileToCreate), this.m_buffer.length);
        while ((numRead = is.read(this.m_buffer)) > 0) {
            os.write(this.m_buffer, 0, numRead);
        }
        is.close();
        os.close();
    }

    private static String replaceRoot(String pathString, String newRoot) {
        File path = new File(pathString);
        String parent = path.getParent();
        if (parent == null) {
            return newRoot;
        }
        return new File(ZipSerializer.replaceRoot(parent, newRoot), path.getName()).getPath();
    }
}

