/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.jmx.remote.sonic;

import com.sonicsw.jmx.remote.sonic.SonicConnection;
import com.sonicsw.mf.jmx.client.IConnectionListener;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mx.util.URLUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;

public class SonicConnector
implements JMXConnector,
Serializable {
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final String DEFAULT_SERVER_IDENTITY = "Domain1.AGENT MANAGER";
    private static final long serialVersionUID = 0L;
    private JMXServiceURL m_jmxServiceURL;
    private String m_user = "";
    private String m_password = "";
    private boolean m_closed = false;
    private JMSConnectorClient m_jmsConnectorClient;
    private SonicConnection m_mBeanServerConnection;

    public SonicConnector(JMXServiceURL serviceURL) throws IOException {
        this(serviceURL, null);
    }

    public SonicConnector(JMXServiceURL serviceURL, Map environment) throws IOException {
        Object credentials;
        if (!serviceURL.getProtocol().startsWith("sonic+")) {
            throw new MalformedURLException("Protocol not supported: " + serviceURL.getProtocol());
        }
        this.m_jmxServiceURL = serviceURL;
        if (environment != null && (credentials = environment.get("jmx.remote.credentials")) != null) {
            if (credentials instanceof String[]) {
                this.m_user = ((String[])credentials)[0];
                this.m_password = ((String[])credentials)[1];
            } else {
                throw new IOException("Unsupported connector credentials type: " + credentials.getClass());
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.m_mBeanServerConnection != null) {
            this.m_jmsConnectorClient.disconnect();
            this.m_jmsConnectorClient = null;
            this.m_mBeanServerConnection = null;
        }
        this.m_closed = true;
    }

    @Override
    public synchronized void connect() throws IOException {
        this.connect((Map)null);
    }

    public synchronized void connect(Map environment) throws IOException {
        Object credentials;
        int port;
        if (this.m_closed) {
            throw new IOException("Connector has been closed");
        }
        if (this.m_mBeanServerConnection != null) {
            return;
        }
        Hashtable<String, String> sonicAddressProperties = new Hashtable<String, String>();
        String protocol = this.m_jmxServiceURL.getProtocol().substring(this.m_jmxServiceURL.getProtocol().indexOf("+") + 1);
        String host = this.m_jmxServiceURL.getHost();
        if (host == null || host.length() == 0) {
            host = "localhost";
        }
        if ((port = this.m_jmxServiceURL.getPort()) == 0) {
            port = 2506;
        }
        sonicAddressProperties.put("ConnectionURLs", URLUtil.buildUrlString(protocol, host, port));
        String user = this.m_user;
        String password = this.m_password;
        if (environment != null && (credentials = environment.get("jmx.remote.credentials")) != null) {
            if (credentials instanceof String[]) {
                user = ((String[])credentials)[0];
                password = ((String[])credentials)[1];
            } else {
                throw new IOException("Unsupported connector credentials type: " + credentials.getClass());
            }
        }
        sonicAddressProperties.put("DefaultUser", user);
        sonicAddressProperties.put("DefaultPassword", password);
        JMSConnectorAddress jmsConnectorAddress = new JMSConnectorAddress(sonicAddressProperties);
        String serverIdentity = this.m_jmxServiceURL.getURLPath();
        if (serverIdentity.length() > 0) {
            serverIdentity = serverIdentity.substring(1);
        }
        jmsConnectorAddress.setServerIdentity(serverIdentity.length() == 0 ? DEFAULT_SERVER_IDENTITY : serverIdentity);
        this.m_jmsConnectorClient = new JMSConnectorClient();
        try {
            this.m_jmsConnectorClient.connect(jmsConnectorAddress, 10000L);
            this.m_jmsConnectorClient.setConnectionListener(new ConnectionListener());
        }
        catch (Throwable e) {
            IOException io = new IOException("Failed to create MBean");
            io.initCause(e);
            throw io;
        }
        this.m_mBeanServerConnection = new SonicConnection(this.m_jmsConnectorClient);
    }

    @Override
    public String getConnectionId() throws IOException {
        if (this.m_closed) {
            throw new IOException("Connector has been closed");
        }
        SonicConnection mBeanServerConnection = this.getConnection();
        return mBeanServerConnection.toString();
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.getMBeanServerConnection(null);
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject arg0) throws IOException {
        SonicConnection mBeanServerConnection = this.getConnection();
        return mBeanServerConnection;
    }

    private SonicConnection getConnection() throws IOException {
        SonicConnection mBeanServerConnection = this.m_mBeanServerConnection;
        if (mBeanServerConnection == null) {
            throw new IOException("Connection has not been established");
        }
        return mBeanServerConnection;
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object handback) {
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object handback) throws ListenerNotFoundException {
    }

    private void notifyConnectionOpened() {
    }

    private void notifyConnectionClosed() {
    }

    private void notifyConnectionFailed() {
    }

    public void sendConnectionNotifsLost(Exception exception) {
    }

    private class ConnectionListener
    implements IConnectionListener {
        private ConnectionListener() {
        }

        @Override
        public void onDisconnect() {
            SonicConnector.this.sendConnectionNotifsLost(null);
        }

        @Override
        public void onFailure(Exception arg0) {
        }

        @Override
        public void onNotificationListenerRenewalFailure(Exception exception) {
            SonicConnector.this.sendConnectionNotifsLost(exception);
        }

        @Override
        public void onReconnect(String arg0) {
        }
    }
}

