/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.query.impl;

import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.IReplaceRef;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.BooleanExpression;
import com.sonicsw.mf.common.config.query.EqualExpression;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromElementList;
import com.sonicsw.mf.common.config.query.IDualOperandExpression;
import com.sonicsw.mf.common.config.query.ListContainsExpression;
import com.sonicsw.mf.common.config.query.NotEqualExpression;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.query.Where;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import java.util.ArrayList;

public final class ReferenceReplacer {
    public static Query replaceReferences(Query query, IReplaceRef replacer) {
        return new Query().setSelect(query.getSelect()).setFrom(ReferenceReplacer.repRef(query.getFrom(), replacer)).setWhere(ReferenceReplacer.repRef(query.getWhere(), replacer));
    }

    private static From repRef(From oldFrom, IReplaceRef replacer) {
        if (oldFrom == null) {
            return null;
        }
        if (oldFrom instanceof FromElementList) {
            String[] oldNames = ((FromElementList)oldFrom).getElementNames();
            ArrayList<String> newNames = new ArrayList<String>();
            for (int i = 0; i < oldNames.length; ++i) {
                try {
                    newNames.add(replacer.replace(oldNames[i]));
                    continue;
                }
                catch (VersionOutofSyncException versionOutofSyncException) {
                    // empty catch block
                }
            }
            String[] result = new String[newNames.size()];
            newNames.toArray(result);
            return new FromElementList(result);
        }
        return oldFrom;
    }

    private static Where repRef(Where oldWhere, IReplaceRef replacer) {
        if (oldWhere == null) {
            return null;
        }
        BooleanExpression[] oldAndChain = oldWhere.getAndChain();
        BooleanExpression[] newAndChain = new BooleanExpression[oldAndChain.length];
        for (int i = 0; i < oldAndChain.length; ++i) {
            IDualOperandExpression dualExpression = null;
            AttributeName attName = null;
            Reference newRef = null;
            if (oldAndChain[i] instanceof IDualOperandExpression) {
                dualExpression = (IDualOperandExpression)((Object)oldAndChain[i]);
            }
            if (dualExpression != null) {
                attName = (AttributeName)dualExpression.getFirstOperand();
                Object value = dualExpression.getSecondOperand();
                if (value instanceof Reference) {
                    newRef = replacer.replace((Reference)value);
                }
            }
            newAndChain[i] = oldAndChain[i] instanceof EqualExpression && newRef != null ? new EqualExpression(attName, newRef) : (oldAndChain[i] instanceof ListContainsExpression && newRef != null ? new ListContainsExpression(attName, newRef) : (oldAndChain[i] instanceof NotEqualExpression && newRef != null ? new NotEqualExpression(attName, newRef) : oldAndChain[i]));
        }
        return new Where(newAndChain);
    }
}

