/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.comm.ConnectTimeoutException;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.MFSecurityException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.upgrade.ConfigUpgrade;
import com.sonicsw.mf.common.config.upgrade.DirectoryService;
import com.sonicsw.mf.common.config.upgrade.IMigrationProcess;
import com.sonicsw.mf.common.config.upgrade.MigrationException;
import com.sonicsw.mf.common.config.upgrade.ShortcutCreator;
import com.sonicsw.mf.common.config.upgrade.Utils;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.runtime.IRemoteExecResult;
import com.sonicsw.mf.common.runtime.impl.ExecUtility;
import com.sonicsw.mf.common.runtime.impl.RemoteExecResult;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ContainerSetup;
import com.sonicsw.mf.framework.agent.ci.ILauncherContainerDriver;
import com.sonicsw.mf.framework.agent.ci.LauncherDriver;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.mgmtapi.runtime.ProxyRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.JMRuntimeException;

public final class Migrate
implements IMigrationProcess {
    private DirectoryService m_ds;
    private Properties m_migrateProps = new Properties();
    private Properties m_origProps = new Properties();
    private HashMap<String, HashMap<String, String>> m_containerProps = new HashMap();
    private IDirectoryFileSystemService m_fileSystemService;
    private String m_brokerCN;
    private Vector m_rootList = new Vector();
    private Vector m_upgradeList = new Vector();
    private Vector m_templateList = new Vector();
    private boolean m_isESBInstalled = false;
    private boolean m_isRDBMSInstalled = false;
    private String m_sonicHome = System.getProperty("sonic.home");
    private String m_archives = new File(this.m_sonicHome, "Archives").getCanonicalPath();
    private File m_esbOnDisk = new File(this.m_archives, "ESB/14.0/ESBcontainer.car");
    private File m_rdbmsOnDisk = new File(this.m_sonicHome, "DBService14.0/lib");
    private File m_wbOnDisk = new File(this.m_sonicHome, "Workbench14.0");
    private boolean m_isLoggerInstalled = false;
    private boolean m_debug = false;
    private IDirElement m_DMElement = null;
    private ConfigUpgrade m_configUpgrade = null;
    private File m_seedPropFile = new File("seedimports.properties");
    private File m_containersDir = null;
    private boolean m_restartDM = false;
    private HashMap<String, String> m_restartContainers = new HashMap();
    private boolean m_isWBUpgrade = System.getProperty("wb.upgrade", "false").equalsIgnoreCase("true");
    private int m_requestTimeout = 60;
    private static String UPGRADE_ERROR = "upgrade error";
    private static String UPGRADE_MESSAGE = "upgrade message";
    private String m_wbLocation = null;
    private static final Properties SONICSW_PROPS = new Properties();
    private static String m_OS = System.getProperty("os.name").toLowerCase();

    private static void printUsage(String errorMessage) {
        if (errorMessage != null) {
            System.out.println();
            System.out.println("  error: " + errorMessage);
            System.out.println();
        }
        System.out.println();
        System.out.println("*****************************  upgrade usage ****************************");
        System.out.println();
        System.out.println("Arguments to upgrade:");
        System.out.println();
        System.out.println("upgrade <properties file> [<old workbench location>]");
        System.out.println("or");
        System.out.println("upgrade -h|-help");
        System.out.println();
        System.out.println("where:");
        System.out.println();
        System.out.println("<properties file> is the file generated by calling the upgradeProps script. This argument is required.");
        System.out.println("<old workbench location> In a workbench upgrade, this is the location of the existing workbench. Optional, needed only if the workspace is to be migrated from the old installation to the new one, and both the old and new workbench contain Eclipse that Sonic installed.");
        System.out.println();
        System.out.println("upgrade -h|help will print this text.");
        System.out.println();
        System.out.println("**************************************************************************");
        System.exit(0);
    }

    /*
     * Exception decompiling
     */
    public static void main(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File retrieveValidateFile(String propFileName) {
        File propFile = new File(propFileName);
        if (!propFile.exists()) {
            Utils.printError(UPGRADE_ERROR, null, "File " + propFile + " does not exist");
            System.exit(-1);
        }
        if (!propFile.isFile()) {
            Utils.printError(UPGRADE_ERROR, null, "File " + propFile + " is not a file");
            System.exit(-1);
        }
        return propFile;
    }

    private static void validateFile(String wbLocation) {
        File srcEclipse;
        File wbFile = new File(wbLocation);
        if (!wbFile.exists()) {
            Utils.printError(UPGRADE_ERROR, null, "Directory " + wbLocation + " does not exist");
            System.exit(-1);
        }
        if (!wbFile.isDirectory()) {
            Utils.printError(UPGRADE_ERROR, null, wbLocation + " should be a directory, but it's a file");
            System.exit(-1);
        }
        if (!(srcEclipse = new File(wbFile, "eclipse")).exists()) {
            Utils.printError(UPGRADE_ERROR, null, wbLocation + " does not contain an eclipse installation. Modify or remove the workbench location argument and try again.");
            System.exit(-1);
        }
    }

    private static String populateMigrateRetrieveUpgradeMessage(Migrate migrate, String upgradeMessageParam) throws Exception {
        String upgradeMessage = upgradeMessageParam;
        if (migrate.m_restartContainers.size() > 0) {
            migrate.debug("Before restartRootContainers");
            migrate.restartRootContainers();
            migrate.debug("After restartRootContainers");
        } else {
            System.out.println("upgrade connecting to the domain...");
            migrate.connect(null);
            System.out.println("upgrade connecting to the domain...done");
            migrate.debug("About to readProps");
            migrate.readProps();
            migrate.debug("About to checkErrors");
            migrate.checkErrors();
            migrate.debug("About to doMigration");
            upgradeMessage = migrate.doMigration();
            migrate.debug("done");
        }
        migrate.debug("After if then else");
        return upgradeMessage;
    }

    private static String printUsageRetrieveLocation(String[] args, String propFileName) {
        if (propFileName.length() == 0) {
            Migrate.printUsage("You must provide a properties file to upgrade.");
        }
        if (propFileName.toLowerCase().startsWith("-h")) {
            Migrate.printUsage(null);
        }
        String wbLocation = null;
        if (args.length == 2 && args[1].length() > 0) {
            wbLocation = args[1];
        }
        return wbLocation;
    }

    private static void handleError(JMRuntimeException jmsE) {
        Throwable cause = jmsE.getCause();
        if (cause != null && cause instanceof ConnectTimeoutException) {
            Utils.printError(UPGRADE_ERROR, null, "The upgrade had a problem connecting to the domain manager. Check that your connection information is correct, and that the domain manager container is running");
        } else if (cause != null && cause instanceof MFSecurityException) {
            Utils.printError(UPGRADE_ERROR, null, "The connection attempt threw a security exception. Check that the specified username and password are correct.");
        } else {
            Utils.printError(UPGRADE_ERROR, jmsE, null);
        }
    }

    private static void handleError(Migrate migrate, String upgradeMessage) {
        if (upgradeMessage != null && upgradeMessage.length() > 0) {
            Utils.printError(UPGRADE_MESSAGE, null, upgradeMessage);
        }
        if (migrate != null) {
            try {
                migrate.disconnect();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void handleException(ProxyRuntimeException proxyE) {
        Throwable cause = proxyE.getCause();
        if (cause != null && cause instanceof InvokeTimeoutException) {
            Utils.printError(UPGRADE_ERROR, null, "The upgrade had a problem communicating with the domain manager. Revert to the state prior to this upgrade and try again. You might want to increase the request timeout through the property request.timeout in the properties file.");
        } else {
            Utils.printError(UPGRADE_ERROR, proxyE, null);
        }
    }

    private static void handleException(MigrationException migE, Migrate migrate) {
        if (migrate != null) {
            migrate.debug("In MigrationException");
        }
        Utils.printError(UPGRADE_ERROR, null, migE.getMessage() + System.getProperty("line.separator") + "Upgrade will not start");
    }

    private static String printUsageRetrievePropFileName(String[] args) {
        if (args.length < 1) {
            Migrate.printUsage("You must provide a properties file to upgrade.");
        }
        if (args.length > 2) {
            Migrate.printUsage(null);
        }
        String propFileName = args[0];
        return propFileName;
    }

    private void debug(String printThis) {
        if (this.m_debug) {
            System.out.println(printThis);
        }
    }

    Migrate(File propFile, String wbLocation) throws Exception {
        String rt;
        String debugBOOL;
        this.m_wbLocation = wbLocation;
        FileInputStream propStream = new FileInputStream(propFile);
        this.m_origProps.load(propStream);
        Enumeration<Object> keys = this.m_origProps.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)this.m_origProps.get(key);
            if (value.length() == 0) continue;
            this.m_migrateProps.put(key, value);
        }
        propStream.close();
        String url = this.m_migrateProps.getProperty("ds.url");
        String domainName = this.m_migrateProps.getProperty("ds.domain");
        if (domainName == null && url != null && url.toLowerCase().endsWith("xml")) {
            this.m_migrateProps.put("ds.domain", "Domain1");
        }
        if ((debugBOOL = this.m_migrateProps.getProperty("migrate.debug")) != null) {
            this.m_debug = new Boolean(this.m_migrateProps.getProperty("migrate.debug"));
        }
        if (this.m_debug) {
            System.setProperty("DebugAll.debug", "true");
        }
        if ((rt = this.m_migrateProps.getProperty("request.timeout")) != null) {
            try {
                this.m_requestTimeout = new Integer(rt);
            }
            catch (NumberFormatException noNum) {
                throw new MigrationException("Request timeout specified is not a number: " + rt);
            }
        }
        if (this.m_migrateProps.getProperty("restart.containers") != null) {
            this.parseRestartContainers();
        }
    }

    private void saveProps() throws IOException {
        FileOutputStream outStream = new FileOutputStream(this.m_seedPropFile);
        Properties seedingProps = new Properties();
        seedingProps.put("ds.domain", this.m_migrateProps.getProperty("ds.domain"));
        if (this.m_DMElement != null) {
            HashMap dmProps = this.getContainerProps(this.getContainerName(this.m_DMElement.getIdentity().getName()));
            String origRelVersion = (String)dmProps.get("RELEASE_VERSION");
            boolean dsMoved = origRelVersion != null && this.willMigrate(origRelVersion);
            this.populateProperties(dmProps, dsMoved, origRelVersion, seedingProps);
            this.populateConnectionProperties(seedingProps);
            this.populateAdditionalProperties(seedingProps);
        }
        this.storeData(outStream, seedingProps);
    }

    private void populateConnectionProperties(Properties seedingProps) {
        IAttributeSet connectionArgs = (IAttributeSet)this.m_DMElement.getAttributes().getAttribute("CONNECTION");
        String conUrl = (String)connectionArgs.getAttribute("ConnectionURLs");
        if (conUrl == null) {
            conUrl = "tcp://localhost:2506";
        }
        String conUser = (String)connectionArgs.getAttribute("DefaultUser");
        String conPwd = (String)connectionArgs.getAttribute("DefaultPassword");
        seedingProps.put("container.connectionURLs", conUrl);
        if (conUser != null && conUser.length() > 0) {
            seedingProps.put("container.defaultUser", conUser);
        }
        if (conPwd != null && conPwd.length() > 0) {
            seedingProps.put("container.defaultPassword", conPwd);
        }
    }

    private void populateProperties(HashMap<String, String> dmProps, boolean dsMoved, String origRelVersion, Properties seedingProps) {
        String dsHostPropValue = dsMoved ? this.m_migrateProps.getProperty("working.directory") : this.m_migrateProps.getProperty("ds.working.dir");
        seedingProps.put("ds.working.dir", dsHostPropValue);
        String username = this.m_migrateProps.getProperty("ds.username");
        if (username != null) {
            seedingProps.put("ds.username", this.m_migrateProps.getProperty("ds.username"));
        }
        seedingProps.put("ds.url", dsHostPropValue + "/ds.xml");
        String wd = dmProps.get("previous.working.directory");
        if (origRelVersion != null && origRelVersion.compareTo("104") >= 0 && wd != null) {
            seedingProps.put("previous.working.directory", wd);
        }
    }

    private void populateAdditionalProperties(Properties seedingProps) {
        if (this.m_migrateProps.getProperty("sonic.esb.controlNumber") != null) {
            seedingProps.put("esb.controlNumber", this.m_migrateProps.getProperty("sonic.esb.controlNumber"));
        }
        if (this.m_isWBUpgrade) {
            String brokerPath = this.m_migrateProps.getProperty("broker.path");
            brokerPath = brokerPath.substring(0, brokerPath.lastIndexOf(47));
            seedingProps.put("broker.path", brokerPath);
        }
        if (this.m_wbLocation != null) {
            seedingProps.put("saved.wb.location", this.m_wbLocation);
        }
    }

    private void storeData(FileOutputStream outStream, Properties seedingProps) throws IOException {
        this.addRestartContainersList(seedingProps);
        seedingProps.put("migrate.debug", this.m_migrateProps.getProperty("migrate.debug"));
        seedingProps.store(outStream, "Properties which will drive the seeing of product jars, cars and sample configurations, and the restart of MF containers");
        outStream.close();
    }

    private void readProps() throws Exception {
        this.populateRootListBrokerCNContainersDir();
        this.populateUpgradeAndTemplateList();
        this.updateInstalledState();
        this.validateLocationAndReadProps();
    }

    private void updateInstalledState() throws DirectoryServiceException {
        this.debug("finding out what's installed");
        this.debug("testing esb");
        if (this.m_fileSystemService.getFSElement("/Archives/ESB/14.0/ESBcontainer.car", false) != null) {
            this.m_isESBInstalled = true;
        } else if (this.m_esbOnDisk.exists()) {
            this.m_isESBInstalled = true;
        }
        this.debug("testing dbservice");
        if (this.m_fileSystemService.getFSElement("/System/DBService/14.0/lib/esb_rdbms.jar", false) != null) {
            this.m_isRDBMSInstalled = true;
        } else if (this.m_rdbmsOnDisk.exists()) {
            this.m_isRDBMSInstalled = true;
        }
    }

    private void populateUpgradeAndTemplateList() {
        String templateList;
        String upgradelist = this.m_migrateProps.getProperty("upgrade.list");
        if (upgradelist != null) {
            this.debug("readProps reading upgradeList ");
            StringTokenizer upgradeTokens = new StringTokenizer(upgradelist, ",", false);
            while (upgradeTokens.hasMoreTokens()) {
                String containerID = upgradeTokens.nextToken();
                this.debug("readProps read from upgradeList " + containerID);
                this.m_upgradeList.add(containerID);
            }
        }
        if ((templateList = this.m_migrateProps.getProperty("template.list")) != null) {
            this.debug("readProps reading templateList ");
            StringTokenizer templateTokens = new StringTokenizer(templateList, ",", false);
            while (templateTokens.hasMoreTokens()) {
                String elID = templateTokens.nextToken();
                this.debug("readProps read from tempalteList " + elID);
                this.m_templateList.add(elID);
            }
        }
    }

    private void populateRootListBrokerCNContainersDir() throws IOException {
        this.m_brokerCN = this.m_migrateProps.getProperty("sonic.mq.controlNumber");
        this.m_containersDir = ContainerSetup.findSonicContainersDir((File)new File(this.m_sonicHome));
        String rootlist = this.m_migrateProps.getProperty("root.list");
        this.debug("readProps rootlist == " + rootlist);
        if (rootlist != null) {
            StringTokenizer rootTokens = new StringTokenizer(rootlist, ",", false);
            while (rootTokens.hasMoreTokens()) {
                String containerID = rootTokens.nextToken();
                this.debug("readProps adding " + containerID + " to m_rootList");
                this.m_rootList.add(containerID);
            }
        }
    }

    private void validateLocationAndReadProps() throws Exception {
        if (this.m_wbLocation != null && !this.m_wbOnDisk.exists()) {
            throw new MigrationException("This installation does not contain a Workbench yet an old workbench directory was specified. Try again without the -wb argument");
        }
        this.readContainerProps();
    }

    private void connect(String urlParam) throws Exception {
        String url = urlParam;
        if (url == null) {
            url = this.m_migrateProps.getProperty("ds.url");
        }
        String username = this.m_migrateProps.getProperty("ds.username");
        String password = this.m_migrateProps.getProperty("ds.password");
        String node = this.m_migrateProps.getProperty("connection_node");
        String domain = this.m_migrateProps.getProperty("ds.domain");
        String conProps = this.m_migrateProps.getProperty("connection.system.properties");
        this.debug("connection.system.properties == " + conProps);
        if (conProps != null) {
            this.setConnectionProps(conProps);
        }
        this.m_ds = url.toLowerCase().endsWith(".xml") ? new DirectoryService(url, true) : new DirectoryService(url, username, password, domain, node, this.m_requestTimeout);
        this.m_fileSystemService = this.m_ds.getFileSystemService();
    }

    private void disconnect() throws Exception {
        if (this.m_ds != null) {
            this.m_ds.closeDS();
            this.m_ds = null;
            this.m_fileSystemService = null;
        }
    }

    private void setConnectionProps(String propsValue) throws Exception {
        if (propsValue == null) {
            this.debug("setConnectionProps, propsValue == null");
        } else if (propsValue.length() == 0) {
            this.debug("setConnectionProps, propsValue length == 0");
        }
        StringTokenizer tokenizer = new StringTokenizer(propsValue, ",=", false);
        if (tokenizer.hasMoreElements() && tokenizer.countTokens() % 2 != 0) {
            throw new MigrationException("Incorrect connection system property values detected; odd number of tokens in string " + propsValue);
        }
        while (tokenizer.hasMoreTokens()) {
            String prop = tokenizer.nextToken();
            String value = tokenizer.nextToken();
            this.debug("setConnectionProps prop " + prop + " value " + value);
            System.setProperty(prop, value);
        }
    }

    private void checkErrors() throws Exception {
        this.checkRootList();
        this.checkUpgradeList();
        this.checkContainerProperties();
    }

    private void checkRootList() throws Exception {
        Iterator rootIT = this.validateRootList();
        while (rootIT.hasNext()) {
            String containerID = (String)rootIT.next();
            IDirElement container = this.retrieveDirElement(containerID);
            HashMap<String, String> containerProps = this.retrieveContainerPropsMap(container, containerID);
            if (this.checkComponents(container, false, true)) {
                this.validateDMElement();
                this.checkAndPopulateMigrateProps(container, containerID, containerProps);
            }
            this.checkRootContainerPaths(container);
        }
        if (this.m_DMElement != null) {
            return;
        }
        if (this.m_DMElement == null) {
            this.retrieveValidateConfig();
        }
    }

    private HashMap<String, String> retrieveContainerPropsMap(IDirElement container, String containerID) throws Exception {
        boolean migrate;
        HashMap containerProps = this.getContainerProps(this.getContainerName(containerID));
        String relVersion = this.getVersion(container, containerProps);
        boolean bl = migrate = this.willMigrate(relVersion) || relVersion.equals("109");
        if (migrate) {
            String containerName = this.getContainerName(containerID);
            File containerWD = ContainerSetup.findContainerDir((File)this.m_containersDir, (String)this.m_migrateProps.getProperty("ds.domain"), (String)containerName);
            if (containerWD.exists()) {
                throw new Exception("The directory " + containerWD + " already exists and would be overwritten if we continue. Delete the directory and try again");
            }
        }
        return containerProps;
    }

    private void checkAndPopulateMigrateProps(IDirElement container, String containerID, HashMap<String, String> containerProps) throws Exception {
        if (this.isOnlineConnection() && ((DirectoryServiceProxy)this.m_fileSystemService).getDirectoryServiceReleaseVersion().startsWith("14.0")) {
            throw new MigrationException("You're connected to a running, upgraded domain manager and wish to upgrade another domain manager. You must connect to the domain specified by " + containerID + " in order to upgrade it");
        }
        this.m_DMElement = container;
        this.checkInstallProperties();
        this.m_migrateProps.put("broker.path", containerProps.get("broker.path"));
    }

    private Iterator validateRootList() throws MigrationException {
        String version;
        if (!this.m_rootList.isEmpty() && (version = this.findLauncherVersion()) == null) {
            throw new MigrationException("The upgrade could not find the container setup directories of the launcher. Check that your installation has a Launcher/14.0.x.x directory in it");
        }
        Iterator rootIT = this.m_rootList.iterator();
        return rootIT;
    }

    private void retrieveValidateConfig() throws Exception {
        Query typeQuery = new Query();
        FromElementType typeFrom = new FromElementType("MF_CONTAINER");
        typeQuery.setFrom(typeFrom);
        IDirElement[] configs = null;
        configs = this.m_fileSystemService.getFSElements(typeQuery, false);
        for (int i = 0; i < configs.length; ++i) {
            IDirElement container = configs[i];
            if (!this.checkComponents(container, true, false) || container.getIdentity().getReleaseVersion().equals("109")) continue;
            throw new MigrationException("Domain Manager container must be upgraded first and it must be in the root.list.");
        }
    }

    private IDirElement retrieveDirElement(String containerID) throws MigrationException, DirectoryServiceException {
        IDirElement container = this.m_fileSystemService.getFSElement(containerID, false);
        this.debug("found " + containerID + " in root.list");
        this.validateContainer(container, containerID);
        return container;
    }

    private void validateDMElement() throws MigrationException {
        if (this.m_DMElement != null) {
            throw new MigrationException("The upgrade tool can only upgrade one domain manager at a time. There are at least two containers with a directory service in the root.list. Put one back in the upgrade.list before running the upgrade, then run upgradeProps and upgrade for the second one");
        }
    }

    private void checkRootContainerPaths(IDirElement container) throws Exception {
        String containerName = (String)container.getAttributes().getAttribute("CONTAINER_NAME");
        File containerWD = ContainerSetup.findContainerDir((File)this.m_containersDir, (String)this.m_migrateProps.getProperty("ds.domain"), (String)containerName);
        HashMap<String, String> containerProps = this.m_containerProps.get(containerName);
        if (containerProps != null) {
            this.retrievePropertyFile(containerName, containerProps, containerWD);
        }
    }

    private void retrievePropertyFile(String containerName, HashMap containerProps, File containerWD) throws MigrationException {
        String prop = (String)containerProps.get("cache.dir");
        File propFile = null;
        if (prop != null && !this.testValidFile(propFile = Migrate.retrievePropFile(containerWD, prop))) {
            throw new MigrationException(prop + " is not a valid cache directory for " + containerName + " on this host.");
        }
        prop = (String)containerProps.get("log.dir");
        if (prop != null && !this.testValidFile(propFile = Migrate.retrievePropFile(containerWD, prop))) {
            throw new MigrationException(prop + " is not a valid container log file for " + containerName + " on this host.");
        }
    }

    private static File retrievePropFile(File containerWD, String prop) {
        File propFile = Migrate.retrieveAbsoluteFile(prop, containerWD);
        return propFile;
    }

    private boolean checkComponents(IDirElement container, boolean findDSOnly, boolean rootContainer) throws Exception {
        this.debug("checkComponents for " + container.getIdentity().getName());
        boolean containsDS = false;
        IAttributeSet compSet = (IAttributeSet)container.getAttributes().getAttribute("COMPONENTS");
        if (compSet != null) {
            HashMap componentsMap = compSet.getAttributes();
            Collection componentSets = componentsMap.values();
            for (IAttributeSet componentSet : componentSets) {
                Reference componentRef = (Reference)componentSet.getAttribute("CONFIG_REF");
                String componentID = componentRef.getElementName();
                this.debug("checkComponents component " + componentID);
                IElementIdentity compID = null;
                try {
                    compID = this.m_fileSystemService.getFSIdentity(componentID);
                }
                catch (Exception e) {
                    compID = this.m_fileSystemService.getFSIdentity(componentID + "/_Default");
                }
                if (compID.getType().equals("MF_DIRECTORY_SERVICE")) {
                    containsDS = true;
                }
                if (!findDSOnly) {
                    this.checkComponent(compID, container, rootContainer);
                }
                if (!containsDS || !findDSOnly) continue;
                return containsDS;
            }
        }
        return containsDS;
    }

    private void checkComponent(IElementIdentity compID, IDirElement container, boolean rootContainer) throws Exception {
        boolean migrate;
        String containerVersion = container.getIdentity().getReleaseVersion();
        String type = compID.getType();
        IElementIdentity containerID = container.getIdentity();
        HashMap containerProps = this.getContainerProps(this.getContainerName(containerID.getName()));
        String relVersion = (String)containerProps.get("RELEASE_VERSION");
        boolean bl = migrate = relVersion != null ? this.willMigrate(relVersion) : true;
        if (type.equals("XQ_CONTAINER") && !containerVersion.equals("109")) {
            this.checkXQContainer(compID);
        } else if (type.equals("MQ_BROKER") || type.equals("MQ_BACKUPBROKER")) {
            if (migrate) {
                this.checkBrokerComponent(compID, containerID);
            } else {
                containerProps.put("broker.path", compID.getName());
            }
        } else if (type.equals("MF_DIRECTORY_SERVICE")) {
            this.checkDSComponent(compID, container, rootContainer);
        } else if (type.equals("MF_BACKUP_DIRECTORY_SERVICE")) {
            this.checkBackupDSComponent(compID, containerID);
        }
    }

    private String checkWD(HashMap containerProps, String containerName) throws Exception {
        if (containerProps == null) {
            throw new MigrationException("previous.working.directory is required to migrate container " + containerName + " and was not specified.");
        }
        String prevWD = (String)containerProps.get("previous.working.directory");
        if (prevWD == null) {
            throw new MigrationException("previous.working.directory is required to migrate container " + containerName + " and was not specified.");
        }
        if (!new File(prevWD).isAbsolute()) {
            throw new MigrationException("An absolute value for previous.working.directory is required to migrate container " + containerName + " and was specified as a relative path: " + prevWD);
        }
        this.checkFileExists(prevWD, containerName);
        return prevWD;
    }

    private String checkLaunchContainer(HashMap containerProps, String containerName) throws Exception {
        if (containerProps == null) {
            throw new MigrationException("previous.working.directory is required to find the launchcontainer script for container " + containerName + " and was not specified.");
        }
        String prevWD = (String)containerProps.get("previous.working.directory");
        if (prevWD == null) {
            throw new MigrationException("previous.working.directory is required to find the launchcontainer script for container " + containerName + " and was not specified.");
        }
        if (!new File(prevWD).isAbsolute()) {
            throw new MigrationException("An absolute value for previous.working.directory is required for container " + containerName + " and was specified as a relative path: " + prevWD);
        }
        this.checkFileExists(prevWD, containerName);
        if (!new File(prevWD, "launchcontainer.bat").exists() && !new File(prevWD, "launchcontainer.sh").exists()) {
            throw new MigrationException("The container startup scripts are not found in the specified previous.working.directory property for container " + containerName + ": " + prevWD + ". The upgrade will not be able to restart the container");
        }
        return prevWD;
    }

    private void checkFileExists(String prevWD, String containerName) throws MigrationException {
        if (!new File(prevWD).exists()) {
            throw new MigrationException("The directory named by the previous.working.directory property for container " + containerName + " does not exist: " + prevWD);
        }
    }

    private void checkServices(String esbContainer, IAttributeSet services, IDirectoryAdminService dsAdmin) throws Exception {
        HashMap servicesMap = services.getAttributes();
        Collection servicesMaps = servicesMap.values();
        for (IAttributeSet serviceSet : servicesMaps) {
            String serviceName = (String)serviceSet.getAttribute("service_ref");
            IDirElement serviceEl = dsAdmin.getElement("/xqServices/" + serviceName, false);
            if (serviceEl == null) continue;
            String serviceType = (String)serviceEl.getAttributes().getAttribute("type_ref");
            if (serviceType.equals("DatabaseServiceType") && !this.m_isRDBMSInstalled) {
                throw new MigrationException("DBService has not been installed, so cannot proceed with the upgrade of " + esbContainer);
            }
            if (!serviceType.equals("XMLServiceType") && !serviceType.equals("OrchestrationServiceType") && !serviceType.equals("BPELServiceType") || this.m_isWBUpgrade) continue;
            throw new MigrationException("Services of type XMLServiceType, OrchestrationServiceType and BPELServiceType cannot be upgraded to 14.0, so " + esbContainer + " cannot be upgraded");
        }
    }

    private void readContainerProps() throws Exception {
        Enumeration<Object> propKeys = this.m_migrateProps.keys();
        while (propKeys.hasMoreElements()) {
            String key = (String)propKeys.nextElement();
            if (key.indexOf(".") <= -1) continue;
            String containerName = key.substring(0, key.indexOf("."));
            String containerPropName = key.substring(key.indexOf(".") + 1);
            this.debug("readContainerProps containerName == " + containerName + " containerPropName == " + containerPropName);
            this.validateAndAdd(containerName, containerPropName, key);
        }
    }

    private void validateAndAdd(String containerName, String containerPropName, String key) throws MigrationException {
        if (containerPropName.startsWith("central.connection") || containerPropName.equals("boot.file.password") || containerPropName.equals("cache.dir") || containerPropName.equals("log.dir") || containerPropName.equals("db.action") || containerPropName.equals("mqstore.db.connect") || containerPropName.equals("recovery.log.file") || containerPropName.equals("ssl.certificates.dir") || containerPropName.equals("ssl.certificate.chain") || containerPropName.equals("windows.service.name") || containerPropName.equals("previous.working.directory") || containerPropName.equals("host.directory")) {
            this.addPropertyData(containerName, containerPropName, key);
        }
    }

    private void addPropertyData(String containerName, String containerPropName, String key) throws MigrationException {
        HashMap containerProps = this.getContainerProps(containerName);
        String propValue = (String)this.m_migrateProps.get(key);
        if (propValue.indexOf("<containersDir>") > -1) {
            throw new MigrationException("The property " + key + " still contains the place holder " + "<containersDir>" + ".");
        }
        containerProps.put(containerPropName, this.m_migrateProps.get(key));
    }

    private void checkContainerProperties() throws Exception {
        this.debug("checkContainerProperties");
        for (String containerName : this.m_containerProps.keySet()) {
            String dbAction;
            File containerWD = ContainerSetup.findContainerDir((File)this.m_containersDir, (String)this.m_migrateProps.getProperty("ds.domain"), (String)containerName);
            HashMap<String, String> containerProps = this.m_containerProps.get(containerName);
            if (containerProps == null || (dbAction = containerProps.get("db.action")) == null || !"copy".equalsIgnoreCase(dbAction) && !"move".equalsIgnoreCase(dbAction)) continue;
            String dbConnect = containerProps.get("mqstore.db.connect");
            String logFile = this.getLogFile(containerName, containerProps, dbAction, dbConnect);
            this.retrieveAndCheckValidFile(containerName, containerWD, dbConnect);
            this.retrieveAndCheckLogFile(containerName, containerWD, logFile);
        }
    }

    private void retrieveAndCheckValidFile(String containerName, File containerWD, String dbConnect) throws MigrationException {
        try {
            File dbConnectFile = Migrate.retrieveAbsoluteFile(dbConnect, containerWD);
            if (!this.testValidFile(dbConnectFile)) {
                throw new MigrationException("mqstore.db.connect value " + dbConnect + " of " + containerName + " is invalid for upgrade.");
            }
        }
        catch (Exception e) {
            throw new MigrationException("mqstore.db.connect value " + dbConnect + " of " + containerName + " is invalid for upgrade.");
        }
    }

    private void retrieveAndCheckLogFile(String containerName, File containerWD, String logFile) throws MigrationException {
        try {
            File logFileDir = Migrate.retrieveAbsoluteFile(logFile, containerWD);
            if (!this.testValidFile(logFileDir)) {
                throw new MigrationException("recovery.log.file value " + logFile + " of " + containerName + " is invalid for upgrade.");
            }
        }
        catch (Exception e) {
            throw new MigrationException("recovery.log.file value " + logFile + " of " + containerName + " is invalid for upgrade.");
        }
    }

    private String getLogFile(String containerName, HashMap containerProps, String dbAction, String dbConnect) throws MigrationException {
        String logFile = (String)containerProps.get("recovery.log.file");
        if (dbConnect == null) {
            throw new MigrationException("db.action of " + dbAction + " was specified for container " + containerName + " but mqstore.db.connect value was not specified.");
        }
        if (logFile == null) {
            throw new MigrationException("db.action of " + dbAction + " was specified for container " + containerName + " but recvery.log.file was not specified.");
        }
        return logFile;
    }

    private boolean testValidFile(File test) {
        return test.exists() || test.mkdirs();
    }

    private void checkUpgradeList() throws Exception {
        this.debug("checkUpgradeList");
        for (String containerID : this.m_upgradeList) {
            IDirElement container = this.m_fileSystemService.getFSElement(containerID, false);
            this.validateContainer(container, containerID);
            HashMap containerProps = this.getContainerProps(this.getContainerName(containerID));
            String relVersion = this.getVersion(container, containerProps);
            this.checkComponents(container, false, false);
        }
    }

    private String getVersion(IDirElement container, HashMap<String, String> containerProps) {
        String relVersion = container.getIdentity().getReleaseVersion();
        if (!relVersion.equals("109")) {
            containerProps.put("RELEASE_VERSION", relVersion);
        }
        return relVersion;
    }

    private void validateContainer(IDirElement container, String containerID) throws MigrationException {
        if (container == null) {
            throw new MigrationException(containerID + " is not found in the DS");
        }
    }

    private String doMigration() throws Exception {
        this.processDomainManager();
        String message = this.performMigration();
        return this.getMessage(message);
    }

    private String performMigration() throws Exception {
        int containerIndex;
        this.m_configUpgrade.setConnection(this.m_fileSystemService);
        for (containerIndex = 0; containerIndex < this.m_rootList.size(); ++containerIndex) {
            this.m_fileSystemService.suspendChangeNotifications((String)this.m_rootList.get(containerIndex), null);
        }
        for (containerIndex = 0; containerIndex < this.m_upgradeList.size(); ++containerIndex) {
            this.m_fileSystemService.suspendChangeNotifications((String)this.m_upgradeList.get(containerIndex), null);
        }
        this.debug("doMigration about to call upgradeRootContainers");
        String message = this.upgradeRootContainers();
        message = Utils.addToUpgradeMessage(message, this.upgradeContainers());
        message = Utils.addToUpgradeMessage(message, this.upgradeTemplates());
        this.debug("doMigration about to call migrateRootContainers");
        this.migrateRootContainers();
        this.debug("doMigration about to call disconnect");
        this.disconnect();
        return message;
    }

    private void processDomainManager() throws Exception {
        this.m_configUpgrade = new ConfigUpgrade(this.m_migrateProps, this.m_containerProps);
        if (this.m_DMElement != null) {
            this.debug("doMigration about to call migrateDomainManager");
            String releaseVersion = this.m_DMElement.getIdentity().getReleaseVersion();
            this.migrateDomainManager();
            this.debug("doMigration call to migrateDomainManager done");
            this.m_ds = new DirectoryService((IDirElement)this.m_migrateProps.get("dm.ds.element"), null, this.m_migrateProps.getProperty("ds.working.dir"), this.willMigrate(releaseVersion));
            this.m_fileSystemService = this.m_ds.getFileSystemService();
        } else {
            this.connect(null);
        }
    }

    private String getMessage(String message) throws Exception {
        if (this.m_restartContainers.size() > 0 && !new File(this.m_archives).exists()) {
            this.restartRootContainers();
        } else if (new File(this.m_archives).exists()) {
            this.debug("doMigration calling saveProps");
            this.saveProps();
        }
        return message;
    }

    private void migrateDomainManager() throws Exception {
        String releaseVersion;
        this.debug("Migrating domain manager");
        if (this.isOnlineConnection()) {
            this.shutdownDM();
        }
        if (this.willMigrate(releaseVersion = this.m_DMElement.getIdentity().getReleaseVersion())) {
            this.copyDSStorage();
            this.debug("About to migrate broker DB");
            this.migrateDMBrokerDB();
        }
        this.m_migrateProps.put("ds.release.version", releaseVersion);
        this.upgradeDomainManager();
        this.m_ds = new DirectoryService((IDirElement)this.m_migrateProps.get("dm.ds.element"), null, this.m_migrateProps.getProperty("ds.working.dir"), this.willMigrate(releaseVersion));
        this.m_fileSystemService = this.m_ds.getFileSystemService();
        if (this.willMigrate(releaseVersion)) {
            File wd = this.setupDomainManager();
            this.m_migrateProps.setProperty("working.directory", wd.getCanonicalPath());
            String OS = System.getProperty("os.name").toLowerCase();
            if (OS.indexOf("windows") > -1) {
                this.createDMShortcuts(wd);
            }
        }
        this.fixLauncherJREForOldContainer(this.m_DMElement.getIdentity().getName(), releaseVersion);
        this.undoReadOnlyBackup();
        this.disconnect();
    }

    private void shutdownDM() throws Exception {
        String dmID = this.m_DMElement.getIdentity().getName();
        for (String containerID : this.m_rootList) {
            if (containerID.equals(dmID)) continue;
            this.shutdownContainer(containerID, true);
        }
        for (String containerID : this.m_upgradeList) {
            this.shutdownContainer(containerID, false);
        }
        this.setBackupReadOnly();
        this.m_restartDM = true;
        String containerObjectName = this.getAgentObjectName((String)this.m_DMElement.getAttributes().getAttribute("CONTAINER_NAME"));
        this.debug("domain manager object name == " + containerObjectName);
        System.out.println("upgrade shutting down domain manager container " + dmID + "...");
        this.m_ds.shutdownContainer(containerObjectName, 180000L);
        System.out.println("upgrade shutting down domain manager container " + dmID + "...done");
        this.m_ds = null;
    }

    private void copyDSStorage() throws Exception {
        String domainName = this.m_migrateProps.getProperty("ds.domain");
        String hostDirectory = (String)this.m_migrateProps.get("host.directory.src");
        File storageDir = new File(hostDirectory);
        String destinationDir = this.m_migrateProps.getProperty("ds.working.dir");
        File DSStorageDir = new File(storageDir, domainName);
        if (storageDir.equals(new File(destinationDir))) {
            return;
        }
        this.waitForDMToClose(DSStorageDir);
        System.out.println("upgrade copying DS storage from " + DSStorageDir.getCanonicalPath() + " to " + destinationDir + "/" + domainName + "...");
        Utils.copyAll(DSStorageDir, new File(destinationDir, domainName));
        System.out.println("upgrade copying DS storage from " + DSStorageDir.getCanonicalPath() + " to " + destinationDir + "/" + domainName + "...done");
    }

    private void waitForDMToClose(File DSStorage) throws Exception {
        File lockFile = new File(DSStorage, "data.odb/lock");
        while (lockFile.exists()) {
            this.debug("Waiting for DS lock file " + lockFile.getCanonicalPath() + " to be deleted");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException intE) {
                throw new Exception("Unable to wait for DS to close; aborting upgrade");
            }
        }
    }

    private void migrateDMBrokerDB() throws Exception {
        this.migrateBrokerDB(this.m_DMElement.getIdentity().getName(), true, true);
    }

    private void upgradeDomainManager() throws Exception {
        this.m_migrateProps.setProperty("domain.manager.name", this.m_DMElement.getIdentity().getName());
        System.out.println("upgrade upgrading the domain manager configuration and its components...");
        this.m_configUpgrade.upgradeDM(this.m_DMElement);
        System.out.println("upgrade upgrading the domain manager configuration and its components...done");
    }

    private File setupDomainManager() throws Exception {
        String containerName = (String)this.m_DMElement.getAttributes().getAttribute("CONTAINER_NAME");
        Properties non_config_Props = this.extractSetupProperties(containerName);
        HashMap<String, String> containerProps = this.m_containerProps.get(containerName);
        String version = this.findLauncherVersion();
        System.out.println("upgrade creating launch scripts and container working area for " + this.m_DMElement.getIdentity().getName() + "...");
        File wd = ContainerSetup.setupContainer((IDirectoryAdminService)this.m_ds.m_dsAdmin, (String)this.m_DMElement.getIdentity().getName(), (String)containerProps.get("ds.element.name"), (String)version, (String)this.m_sonicHome, (Properties)non_config_Props, (String)containerProps.get("boot.file.password"));
        System.out.println("upgrade creating launch scripts and container working area for " + this.m_DMElement.getIdentity().getName() + "...done");
        return wd;
    }

    private void fixLauncherJREForOldContainer(String containerID, String releaseVersionParam) throws Exception {
        String releaseVersion = this.getReleaseVersion(containerID, releaseVersionParam);
        if (releaseVersion.compareTo("104") > 0) {
            String OS = System.getProperty("os.name").toLowerCase();
            String containerName = this.getContainerName(containerID);
            String contWorkingDir = this.m_containersDir + File.separator + this.m_migrateProps.getProperty("ds.domain") + "." + containerName;
            Object scriptFile = null;
            FileWriter fw = null;
            String jreCommandStr = "SONIC_LAUNCHER_JRE=" + System.getProperty("sonicmq.jre");
            this.retrieveFile(OS, contWorkingDir, fw, jreCommandStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveFile(String OS, String contWorkingDir, FileWriter fwParam, String jreCommandStr) throws IOException {
        FileWriter fw = fwParam;
        File scriptFile = null;
        this.debug("jreCommandStr=" + jreCommandStr);
        try {
            if (OS.indexOf("windows") > -1) {
                this.debug("Sciprt File=" + contWorkingDir + File.separator + "set_launcher_jre.bat");
                scriptFile = new File(contWorkingDir + File.separator + "set_launcher_jre.bat");
                fw = this.retrieveFileWriter(fw, jreCommandStr, scriptFile);
            } else {
                fw = this.retrieveFileWriter(contWorkingDir, fw, jreCommandStr);
            }
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    private FileWriter retrieveFileWriter(String contWorkingDir, FileWriter fwParam, String jreCommandStr) throws IOException {
        FileWriter fw = fwParam;
        this.debug("Sciprt File=" + contWorkingDir + File.separator + "set_launcher_jre.sh");
        File scriptFile = new File(contWorkingDir + File.separator + "set_launcher_jre.sh");
        if (scriptFile != null && scriptFile.exists()) {
            fw = new FileWriter(scriptFile);
            StringBuilder stringBuilder = new StringBuilder("#!/bin/sh");
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(jreCommandStr);
            this.debug("New File Content=" + stringBuilder.toString());
            fw.write(stringBuilder.toString());
        }
        return fw;
    }

    private FileWriter retrieveFileWriter(FileWriter fwParam, String jreCommandStr, File scriptFile) throws IOException {
        FileWriter fw = fwParam;
        if (scriptFile != null && scriptFile.exists()) {
            fw = new FileWriter(scriptFile);
            this.debug("New File Content=set " + jreCommandStr);
            fw.write("set " + jreCommandStr);
        }
        return fw;
    }

    private String getReleaseVersion(String containerID, String releaseVersionParam) throws DirectoryServiceException {
        String releaseVersion = releaseVersionParam;
        IDirElement container = this.m_fileSystemService.getFSElement(containerID, false);
        if (releaseVersion == null) {
            releaseVersion = container.getIdentity().getReleaseVersion();
        }
        return releaseVersion;
    }

    private void createDMShortcuts(File wd) throws Exception {
        ShortcutCreator creator = new ShortcutCreator(this.m_debug);
        File sonicHome = new File(this.m_sonicHome);
        File sonicmqHome = new File(sonicHome, "MQ14.0");
        String programGroup = SONICSW_PROPS.getProperty("sonic.install.programGroup");
        if (programGroup != null) {
            File launchScriptFile = new File(wd, "launchcontainer.bat");
            File shutdownScriptFile = new File(wd, "shutdowncontainer.bat");
            if (!launchScriptFile.exists() || !shutdownScriptFile.exists()) {
                throw new MigrationException("Upgrade could not find the scripts for the domain manager; the container setup step did not finish successfully.");
            }
            File iconFile = new File(sonicmqHome, "bin/mq_container.ico");
            String iconFileName = !iconFile.exists() ? null : iconFile.getCanonicalPath();
            creator.createShortcut(launchScriptFile.getCanonicalPath(), programGroup, "Start Domain Manager", iconFileName, true);
            creator.createShortcut(shutdownScriptFile.getCanonicalPath(), programGroup, "Stop Domain Manager", iconFileName, true);
        }
    }

    private void undoReadOnlyBackup() throws Exception {
        String containerName = (String)this.m_DMElement.getAttributes().getAttribute("CONTAINER_NAME");
        HashMap props = this.getContainerProps(containerName);
        String dsID = (String)props.get("ds.element.name");
        IDirElement dsElement = this.m_fileSystemService.getFSElement(dsID, true);
        IAttributeSet dsTopSet = dsElement.getAttributes();
        IAttributeSet replParams = (IAttributeSet)dsTopSet.getAttribute("REPLICATION_PARAMETERS");
        if (replParams == null) {
            return;
        }
        replParams.setBooleanAttribute("BACKUP_FAILOVER_READ_ONLY", Boolean.FALSE);
        this.m_fileSystemService.updateFSElement((IDeltaDirElement)dsElement.doneUpdate());
    }

    private Properties extractSetupProperties(String containerName) {
        String WSName;
        Properties returnThis = new Properties();
        HashMap<String, String> containerProps = this.m_containerProps.get(containerName);
        if (containerProps != null && (WSName = containerProps.get("windows.service.name")) != null) {
            returnThis.setProperty("WINDOWS_SERVICE_NAME", WSName);
        }
        return returnThis;
    }

    private HashMap getContainerProps(String containerName) {
        HashMap<String, String> props = this.m_containerProps.get(containerName);
        if (props == null) {
            props = new HashMap();
            this.m_containerProps.put(containerName, props);
        }
        return props;
    }

    private void migrateRootContainers() throws Exception {
        for (String containerID : this.m_rootList) {
            boolean migrate;
            HashMap containerProps = this.getContainerProps(this.getContainerName(containerID));
            String relVersion = (String)containerProps.get("RELEASE_VERSION");
            this.debug("migrateRootContainers container " + containerID + " relVersion == " + relVersion);
            boolean bl = migrate = relVersion != null ? this.willMigrate(relVersion) : true;
            if (this.m_DMElement != null && containerID.equals(this.m_DMElement.getIdentity().getName())) continue;
            if (migrate) {
                this.debug("migrateRootContainers migrating " + containerID);
                this.migrateContainer(containerID);
                continue;
            }
            this.recycleContainer(containerID);
        }
    }

    private String upgradeRootContainers() throws Exception {
        String message = null;
        for (String containerID : this.m_rootList) {
            this.debug("upgradeRootContainers iterating over " + containerID);
            if (this.m_DMElement != null && containerID.equals(this.m_DMElement.getIdentity().getName())) continue;
            message = Utils.addToUpgradeMessage(message, this.upgradeContainer(containerID));
        }
        return message;
    }

    private void migrateContainer(String containerID) throws Exception {
        this.setupContainer(containerID);
        this.debug("migrateContainer about to call migrateBrokerDB for " + containerID);
        this.migrateBrokerDB(containerID, false, true);
    }

    private void setupContainer(String containerID) throws Exception {
        String containerName = this.getContainerName(containerID);
        Properties non_config_Props = this.extractSetupProperties(containerName);
        HashMap<String, String> containerProps = this.m_containerProps.get(containerName);
        this.debug("setupContainer " + containerID);
        boolean shutDownService = true;
        if (non_config_Props.get("WINDOWS_SERVICE_NAME") != null) {
            shutDownService = this.shutdownWService((String)non_config_Props.get("WINDOWS_SERVICE_NAME"), containerID);
            if (!shutDownService) {
                non_config_Props.remove("WINDOWS_SERVICE_NAME");
            }
        } else {
            this.shutdownContainer(containerID, true);
        }
        String dsElementPropValue = null;
        String bootFilePWD = null;
        if (containerProps != null) {
            dsElementPropValue = containerProps.get("ds.element.name");
            bootFilePWD = containerProps.get("boot.file.password");
        }
        System.out.println("upgrade creating launch scripts and container working area for " + containerID + "...");
        String version = this.findLauncherVersion();
        ContainerSetup.setupContainer((IDirectoryAdminService)this.m_ds.m_dsAdmin, (String)containerID, (String)dsElementPropValue, (String)version, (String)this.m_sonicHome, (Properties)non_config_Props, (String)bootFilePWD);
        System.out.println("upgrade creating launch scripts and container working area for " + containerID + "...done");
    }

    private void migrateBrokerDB(String containerID, boolean dm, boolean root) throws Exception {
        this.debug("Entering migrateBrokerDB for " + containerID);
        String containerName = this.getContainerName(containerID);
        HashMap<String, String> containerProps = this.m_containerProps.get(containerName);
        if (containerProps == null) {
            return;
        }
        String dbAction = containerProps.get("db.action");
        this.debug("migrateBrokerDB, action == " + dbAction);
        if (dbAction != null && ((dbAction = containerProps.get("db.action").toLowerCase()).equals("copy") || dbAction.equals("move"))) {
            if (this.m_fileSystemService != null && this.m_fileSystemService instanceof DirectoryServiceProxy) {
                String containerObjectName = this.getAgentObjectName(containerName);
                if (!dm && !root && this.pingContainer(containerObjectName)) {
                    System.out.println("upgrade shutting down " + containerID + " to copy/move its broker database...");
                    boolean shutdown = this.shutdownContainer(containerID, root);
                    if (shutdown) {
                        System.out.println("upgrade shutting down " + containerID + " to copy/move its broker database...done");
                    } else {
                        System.out.println("upgrade shutting down " + containerID + " to copy/move its broker database failed. Database and logs will not be copied");
                        return;
                    }
                }
                String containerInfo = this.m_restartContainers.get(containerID);
                String restartStatus = this.m_restartContainers.get(containerID);
                if (restartStatus != null && restartStatus.startsWith("ERROR")) {
                    System.out.println("upgrade shutting down " + containerID + " had failed earlier. Database and logs will not be copied");
                    return;
                }
            }
            this.retrieveAndMoveData(containerName, containerProps, dbAction);
        }
    }

    private void retrieveAndMoveData(String containerName, HashMap containerProps, String dbAction) throws IOException {
        File containerDir = ContainerSetup.findContainerDir((File)this.m_containersDir, (String)this.m_migrateProps.getProperty("ds.domain"), (String)containerName);
        String mqStore = (String)containerProps.get("mqstore.db.connect.src");
        String recoveryLog = (String)containerProps.get("recovery.log.file.src");
        File brokerDBDir = new File(mqStore);
        String mqStoreNew = (String)containerProps.get("mqstore.db.connect");
        File mqStoreNewFile = Migrate.retrieveAbsoluteFile(mqStoreNew, containerDir);
        System.out.println("upgrade copying broker DB from " + brokerDBDir.getCanonicalPath() + " to " + mqStoreNewFile.getCanonicalPath() + "...");
        File recoveryLogDir = this.retrieveRecoveryLogDir(brokerDBDir, containerDir, containerProps, mqStoreNewFile, recoveryLog);
        this.moveData(brokerDBDir, dbAction, recoveryLogDir);
    }

    private File retrieveRecoveryLogDir(File brokerDBDir, File containerDir, HashMap containerProps, File mqStoreNewFile, String recoveryLog) throws IOException {
        Utils.copyAll(brokerDBDir, mqStoreNewFile);
        System.out.println("upgrade copying broker DB from " + brokerDBDir.getCanonicalPath() + " to " + mqStoreNewFile.getCanonicalPath() + "...done");
        File recoveryLogDir = new File(recoveryLog);
        String logNew = (String)containerProps.get("recovery.log.file");
        File logNewFile = Migrate.retrieveAbsoluteFile(logNew, containerDir);
        System.out.println("upgrade copying broker log from " + recoveryLogDir.getCanonicalPath() + " to " + logNewFile.getCanonicalPath() + "...");
        Utils.copyAll(recoveryLogDir, logNewFile);
        System.out.println("upgrade copying broker log from " + recoveryLogDir.getCanonicalPath() + " to " + logNewFile.getCanonicalPath() + "...done");
        return recoveryLogDir;
    }

    private void moveData(File brokerDBDir, String dbAction, File recoveryLogDir) throws IOException {
        if (dbAction.equals("move")) {
            System.out.println("upgrade removing broker log from " + recoveryLogDir.getCanonicalPath() + "...");
            Utils.recursiveDeleteDirectory(recoveryLogDir);
            System.out.println("upgrade removing broker log from " + recoveryLogDir.getCanonicalPath() + "...done");
            System.out.println("upgrade removing broker database from " + brokerDBDir.getCanonicalPath() + "...");
            Utils.recursiveDeleteDirectory(brokerDBDir);
            System.out.println("upgrade removing broker database from " + brokerDBDir.getCanonicalPath() + "...done");
        }
    }

    private static File retrieveAbsoluteFile(String fileName, File containerDir) {
        File mqStoreNewFile = new File(fileName);
        if (!mqStoreNewFile.isAbsolute()) {
            mqStoreNewFile = new File(containerDir, fileName);
        }
        return mqStoreNewFile;
    }

    private String upgradeContainers() throws Exception {
        String message = null;
        for (String containerID : this.m_upgradeList) {
            this.debug("upgradeContainers iterating over " + containerID);
            message = Utils.addToUpgradeMessage(message, this.upgradeContainer(containerID));
            HashMap containerProps = this.getContainerProps(this.getContainerName(containerID));
            String relVersion = (String)containerProps.get("RELEASE_VERSION");
            boolean migrate = relVersion != null ? this.willMigrate(relVersion) : true;
            this.debug("upgradeContainers containerId " + containerID + " RELEASE_VERSION " + relVersion);
            if (!migrate) continue;
            this.migrateBrokerDB(containerID, false, false);
        }
        return message;
    }

    private String upgradeTemplates() throws Exception {
        String message = null;
        for (String elID : this.m_templateList) {
            this.debug("upgradeTemplates iterating over " + elID);
            message = Utils.addToUpgradeMessage(message, this.m_configUpgrade.upgradeConfig(elID));
        }
        return message;
    }

    private String upgradeContainer(String containerID) throws Exception {
        System.out.println("upgrade upgrading container configuration " + containerID + "...");
        this.fixLauncherJREForOldContainer(containerID, null);
        String message = this.m_configUpgrade.upgradeContainer(containerID);
        System.out.println("upgrade upgrading container configuration " + containerID + "...done");
        return message;
    }

    private void restartRootContainers() throws Exception {
        String ctWD;
        String mgmtUrls = this.m_migrateProps.getProperty("mgmt.connection.urls");
        if (mgmtUrls != null) {
            boolean connected = false;
            try {
                this.connect(mgmtUrls);
                connected = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (connected) {
                String backupDSContainerName = this.m_migrateProps.getProperty("backup.ds.container");
                String containerObjectName = this.getAgentObjectName(backupDSContainerName);
                System.out.println("upgrade shutting down your backup DM before restarting the upgraded primary DM...");
                this.m_ds.shutdownContainer(containerObjectName, 180000L);
                System.out.println("upgrade shutting down your backup DM before restarting the upgraded primary DM...done");
                this.m_ds = null;
            }
        }
        File sonicHome = (ctWD = this.m_migrateProps.getProperty("previous.working.directory")) == null ? new File(this.m_sonicHome) : new File(ctWD).getParentFile().getParentFile();
        LauncherDriver driver = new LauncherDriver(sonicHome.getCanonicalPath());
        File containersDir = ContainerSetup.findSonicContainersDir((File)sonicHome);
        String domainName = this.m_migrateProps.getProperty("ds.domain");
        for (String containerID : this.m_restartContainers.keySet()) {
            String containerName = this.getContainerName(containerID);
            String method = this.m_restartContainers.get(containerID);
            if (method.startsWith("ERROR")) continue;
            File containerDir = ContainerSetup.findContainerDir((File)containersDir, (String)domainName, (String)containerName);
            ILauncherContainerDriver containerDriver = driver.getContainer(containerDir.getCanonicalPath());
            String OS = System.getProperty("os.name").toLowerCase();
            if (OS.indexOf("windows") > -1) {
                if (method.startsWith("SERVICE")) {
                    System.out.println("upgrade launching " + containerID + " as a windows service...");
                    containerDriver.launchContainerAsWindowsService();
                    System.out.println("upgrade launching " + containerID + " as a windows service...done");
                    continue;
                }
                System.out.println("upgrade launching " + containerID + " using its launchcontainer script...");
                containerDriver.launchContainerWithBAT();
                System.out.println("upgrade launching " + containerID + " using its launchcontainer script...done");
                continue;
            }
            System.out.println("upgrade launching " + containerID + " using its launchcontainer script...");
            containerDriver.launchContainerWithSH();
            System.out.println("upgrade launching " + containerID + " using its launchcontainer script...done");
        }
        this.debug("restartRootContainers exiting");
    }

    private void parseRestartContainers() {
        String origValue = this.m_migrateProps.getProperty("restart.containers");
        StringTokenizer tokenizer = new StringTokenizer(origValue, ";", false);
        while (tokenizer.hasMoreTokens()) {
            String containerInfo = tokenizer.nextToken();
            String containerID = containerInfo.substring(0, containerInfo.indexOf(","));
            String startupType = containerInfo.substring(containerInfo.indexOf(",") + 1);
            this.m_restartContainers.put(containerID, startupType);
        }
    }

    private boolean shutdownContainer(String containerID, boolean root) throws Exception {
        Boolean result = this.isShutdown(containerID);
        if (result != null) {
            return result;
        }
        String dmID = this.m_DMElement == null ? null : this.m_DMElement.getIdentity().getName();
        String containerName = this.getContainerName(containerID);
        String containerObjectName = this.getAgentObjectName(containerName);
        if (!containerID.equals(dmID)) {
            HashMap containerProps = this.getContainerProps(containerName);
            String dbCopyAction = (String)containerProps.get("db.action");
            if ((root || dbCopyAction != null && (dbCopyAction.equals("COPY") || dbCopyAction.equals("MOVE"))) && this.pingContainer(containerObjectName)) {
                System.out.println("upgrade shutting down " + containerID + (root ? " (will get restarted later)" : "") + "...");
                return this.performShutdown(containerID, containerObjectName, containerProps, root);
            }
        }
        System.out.println("shutdowncontainer fell down to the end and returning false");
        return false;
    }

    private Boolean isShutdown(String containerID) {
        if (this.m_restartContainers.get(containerID) != null) {
            if (this.m_restartContainers.get(containerID).startsWith("ERROR")) {
                System.out.println("shutdownContainer found ERROR already, so returning false");
                return false;
            }
            return true;
        }
        if (this.m_fileSystemService == null || !(this.m_fileSystemService instanceof DirectoryServiceProxy)) {
            System.out.println("shutdownContainer doesn't have an instance of DirectorySErviceProxy");
            return false;
        }
        return null;
    }

    private boolean performShutdown(String containerID, String containerObjectName, HashMap containerProps, boolean root) throws Exception {
        boolean shutdown = this.m_ds.shutdownContainer(containerObjectName, 180000L);
        if (shutdown) {
            System.out.println("upgrade shutting down " + containerID + "...done");
            if (root) {
                String windowsService = (String)containerProps.get("windows.service.name");
                if (windowsService != null) {
                    this.m_restartContainers.put(containerID, "SERVICE");
                } else {
                    this.m_restartContainers.put(containerID, "COMMANDLINE");
                }
            }
            return true;
        }
        System.out.println("upgrade shutting down " + containerID + " failed. Container will not be restarted after the upgrade");
        this.m_restartContainers.put(containerID, "ERROR");
        return false;
    }

    private boolean pingContainer(String containerObjectName) throws Exception {
        this.debug("pinging " + containerObjectName);
        if (this.m_ds == null || !(this.m_fileSystemService instanceof DirectoryServiceProxy)) {
            this.debug("Container " + containerObjectName + " is not alive");
            return false;
        }
        return this.m_ds.pingContainer(containerObjectName);
    }

    private boolean shutdownWService(String serviceName, String containerID) throws IOException, DirectoryServiceException {
        String[] exeCmd = new String[]{"sc", "stop", serviceName};
        System.out.println("Calling sc stop service " + serviceName + "...");
        RemoteExecResult result = ExecUtility.exec(exeCmd, null, new File(".").getCanonicalPath(), null);
        Boolean debugResult = this.debugData(result, serviceName);
        if (debugResult != null) {
            return debugResult;
        }
        String wsResultText = ExecUtility.execResultOutputToString(result);
        int errorIndex = wsResultText.indexOf("FAILED");
        if (errorIndex == -1) {
            return this.waitAndExecute(containerID, exeCmd, serviceName);
        }
        if (wsResultText.indexOf("1060") > -1 || wsResultText.indexOf("1062") > -1) {
            System.out.println("Service was either not installed or already stopped, assuming container was not running, so new service " + serviceName + " will not be started");
            return true;
        }
        return this.printData(serviceName, wsResultText);
    }

    private boolean waitAndExecute(String containerID, String[] exeCmd, String serviceName) throws IOException {
        System.out.println("Waiting until service is really shutdown...");
        long originalTime = System.currentTimeMillis();
        long counter = 0L;
        boolean stopped = false;
        while (!stopped && counter < 180000L) {
            counter = this.getCounter(counter, originalTime);
            Boolean cmdResult = this.executeCommand(containerID, exeCmd, serviceName);
            if (cmdResult == null) continue;
            return cmdResult;
        }
        System.out.println("Tried to stop service " + serviceName + " for 3 minutes, but stop never finished, Windows service will not be installed");
        return false;
    }

    private Boolean executeCommand(String containerID, String[] exeCmd, String serviceName) throws IOException {
        RemoteExecResult secondTry = ExecUtility.exec(exeCmd, null, new File(".").getCanonicalPath(), null);
        String secondText = ExecUtility.execResultOutputToString(secondTry);
        if (secondText.indexOf("FAILED 1062") > -1) {
            System.out.println("Calling sc stop service " + serviceName + "...done");
            this.m_restartContainers.put(containerID, "SERVICE");
            return true;
        }
        if (secondText.indexOf("FAILED 1061") <= -1 && secondText.indexOf("FAILED") > -1) {
            return this.printData(serviceName, secondText);
        }
        return null;
    }

    private Boolean debugData(IRemoteExecResult result, String serviceName) {
        if (!result.isSuccessful()) {
            System.out.println("Tried to stop service " + serviceName + " but finished with an error " + result.getOutput() + "; windows service will not be installed");
            return false;
        }
        return null;
    }

    private long getCounter(long counterParam, long originalTime) {
        long counter = counterParam;
        try {
            Thread.sleep(5000L);
            counter = System.currentTimeMillis() - originalTime;
            System.out.println("Waiting until service is really shutdown...");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return counter;
    }

    private boolean printData(String serviceName, String wsResultText) {
        System.out.println("Tried to stop service " + serviceName + " but finished with an error: " + IContainer.NEWLINE + wsResultText + IContainer.NEWLINE + "Windows service will not be installed");
        return false;
    }

    private void setBackupReadOnly() throws Exception {
        String containerName = this.getContainerName(this.m_DMElement.getIdentity().getName());
        HashMap props = this.getContainerProps(containerName);
        String dsID = (String)props.get("ds.element.name");
        IDirElement dsElement = this.m_fileSystemService.getFSElement(dsID, true);
        IAttributeSet dsTopSet = dsElement.getAttributes();
        IAttributeSet refs = (IAttributeSet)dsTopSet.getAttribute("CONFIG_ELEMENT_REFERENCES");
        if (refs != null) {
            this.backupAndRestart(containerName, dsElement, dsTopSet, refs);
        }
    }

    private void backupAndRestart(String containerName, IDirElement dsElement, IAttributeSet dsTopSet, IAttributeSet refs) throws Exception {
        Reference backup = (Reference)refs.getAttribute("BACKUP_CONFIG_ELEMENT_REF");
        if (backup != null) {
            boolean backupIsRunning = false;
            String backupObjectName = null;
            ArrayList containerIds = Utils.findContainersForComponent(backup.getElementName(), this.m_fileSystemService);
            for (String backupCID : containerIds) {
                String backupCName = this.getContainerName(backupCID);
                backupObjectName = this.getAgentObjectName(backupCName);
                backupIsRunning = this.pingContainer(backupObjectName);
            }
            if (backupIsRunning) {
                IAttributeSet replParams = (IAttributeSet)dsTopSet.getAttribute("REPLICATION_PARAMETERS");
                if (replParams == null) {
                    replParams = dsTopSet.createAttributeSet("REPLICATION_PARAMETERS");
                }
                replParams.setBooleanAttribute("BACKUP_FAILOVER_READ_ONLY", Boolean.TRUE);
                this.m_fileSystemService.updateFSElement((IDeltaDirElement)dsElement.doneUpdate());
                System.out.println("upgrade restarting the backup DM after setting failover read only mode...");
                this.m_ds.restartContainer(backupObjectName, this.getAMObjectName(containerName));
                System.out.println("upgrade restarting the backup DM after setting failover read only mode...done");
            }
        }
    }

    private String getContainerName(String containerID) {
        return containerID.substring(containerID.lastIndexOf(47) + 1);
    }

    private String getAgentObjectName(String containerName) {
        return this.m_migrateProps.getProperty("ds.domain") + "." + containerName + ":ID=" + "AGENT";
    }

    private String getAMObjectName(String containerName) {
        return this.m_migrateProps.getProperty("ds.domain") + "." + "AGENT MANAGER" + ":ID=" + "AGENT MANAGER";
    }

    private void printWarning(String warning) {
        System.err.println();
        System.err.println("*****************************  Upgrade Message ************************");
        System.err.println();
        System.err.println(warning);
        System.err.println();
        System.err.println("***********************************************************************");
    }

    private boolean isOnlineConnection() throws Exception {
        return this.m_fileSystemService != null && this.m_fileSystemService instanceof DirectoryServiceProxy;
    }

    private String findLauncherVersion() {
        File sonicHome = new File(this.m_sonicHome);
        File launcherDir = new File(sonicHome, "Launcher");
        File[] subs = launcherDir.listFiles();
        for (int i = 0; i < subs.length; ++i) {
            File fileOrDir = subs[i];
            if (!fileOrDir.isDirectory() || !fileOrDir.getName().startsWith("14.0")) continue;
            return fileOrDir.getName();
        }
        return null;
    }

    private void checkXQContainer(IElementIdentity compID) throws Exception {
        String storageXQName;
        if (!this.m_isESBInstalled) {
            throw new MigrationException("ESB has not been installed so we cannot upgrade " + compID.getName());
        }
        IDirectoryAdminService dsAdmin = this.m_ds.getAdminService();
        IDirElement xqContainer = dsAdmin.getElement(storageXQName = this.m_fileSystemService.logicalToStorage(compID.getName()), false);
        IAttributeSet servicesSet = (IAttributeSet)xqContainer.getAttributes().getAttribute("services");
        if (servicesSet != null) {
            this.checkServices(compID.getName(), servicesSet, dsAdmin);
        }
    }

    private void checkBrokerComponent(IElementIdentity compID, IElementIdentity containerID) throws Exception {
        IDirElement brokerEl = this.validateAndRetrieveDirElement(compID);
        IAttributeSet DBParams = (IAttributeSet)brokerEl.getAttributes().getAttribute("BROKER_DATABASE_PARAMETERS");
        IAttributeSet logParam = (IAttributeSet)brokerEl.getAttributes().getAttribute("BROKER_RECOVERY_LOG_PARAMETERS");
        String containerName = containerID.getNameComponents()[containerID.getNameComponents().length - 1];
        HashMap containerProps = this.getContainerProps(containerName);
        String dbAction = (String)containerProps.get("db.action");
        if (dbAction == null) {
            return;
        }
        this.populateData(DBParams, brokerEl, containerName, containerProps, dbAction, logParam);
    }

    private void populateData(IAttributeSet DBParams, IDirElement brokerEl, String containerName, HashMap containerProps, String dbAction, IAttributeSet logParam) throws Exception {
        String mqStore = (String)DBParams.getAttribute("MQSTORE_DB_CONNECT");
        this.debug("Migrate.checkComponent broker's MQSTORE_DB_CONNECT == " + mqStore);
        String recoveryLog = (String)logParam.getAttribute("RECOVERY_LOG_PATH");
        mqStore = this.retrieveMqStore(mqStore, recoveryLog);
        if (recoveryLog == null || recoveryLog.length() == 0) {
            recoveryLog = "./log";
        }
        File mqStoreFile = new File(mqStore);
        File recoveryLogFile = new File(recoveryLog);
        if (!mqStoreFile.isAbsolute() || !recoveryLogFile.isAbsolute()) {
            String prevWD = this.checkWD(containerProps, containerName);
            mqStoreFile = this.validateAndRetrieveMqStoreFile(brokerEl, containerName, mqStore, mqStoreFile, prevWD);
            recoveryLogFile = this.validateAndRetrieveRecoveryLogFile(brokerEl, containerName, prevWD, recoveryLog, recoveryLogFile);
        }
        this.populateContainerProps(brokerEl, containerProps, dbAction, mqStoreFile, recoveryLogFile);
    }

    private File validateAndRetrieveRecoveryLogFile(IDirElement brokerEl, String containerName, String prevWD, String recoveryLog, File recoveryLogFileParam) throws MigrationException, IOException {
        File recoveryLogFile = recoveryLogFileParam;
        if (!recoveryLogFile.isAbsolute() && !(recoveryLogFile = new File(prevWD, recoveryLog)).exists()) {
            throw new MigrationException("The source recovery log file location of broker component " + brokerEl.getIdentity().getName() + " has a value of " + recoveryLogFile.getCanonicalPath() + ". This path cannot be found. Double check the setting of previous.working.directory for container " + containerName);
        }
        return recoveryLogFile;
    }

    private File validateAndRetrieveMqStoreFile(IDirElement brokerEl, String containerName, String mqStore, File mqStoreFileParam, String prevWD) throws MigrationException, IOException {
        File mqStoreFile = mqStoreFileParam;
        if (!mqStoreFile.isAbsolute() && !(mqStoreFile = new File(prevWD, mqStore)).exists()) {
            throw new MigrationException("The source broker database directory of broker component " + brokerEl.getIdentity().getName() + " has been computed to be " + mqStoreFile.getCanonicalPath() + ". This path cannot be found. Double check the setting of previous.working.directory for container " + containerName);
        }
        return mqStoreFile;
    }

    private IDirElement validateAndRetrieveDirElement(IElementIdentity compID) throws MigrationException, DirectoryServiceException {
        String relVersion = compID.getReleaseVersion();
        String type = compID.getType();
        if (type.equals("MQ_BROKER") && this.m_brokerCN == null && !relVersion.equals("109")) {
            throw new MigrationException("Broker control code is not known, so cannot proceed with the upgrade of " + compID.getName());
        }
        IDirElement brokerEl = this.m_fileSystemService.getFSElement(compID.getName(), false);
        return brokerEl;
    }

    private void populateContainerProps(IDirElement brokerEl, HashMap containerProps, String dbAction, File mqStoreFile, File recoveryLogFile) throws IOException {
        containerProps.put("mqstore.db.connect.src", mqStoreFile.getCanonicalPath());
        containerProps.put("recovery.log.file.src", recoveryLogFile.getCanonicalPath());
        containerProps.put("broker.path", brokerEl.getIdentity().getName());
        if (dbAction.equals("LEAVE")) {
            containerProps.put("mqstore.db.connect", mqStoreFile.getCanonicalPath());
            containerProps.put("recovery.log.file", recoveryLogFile.getCanonicalPath());
        }
    }

    private String retrieveMqStore(String mqStoreParam, String recoveryLog) {
        String mqStore = mqStoreParam;
        this.debug("Migrate.checkComponent broker's RECOVERY_LOG_PATH == " + recoveryLog);
        if (mqStore == null || mqStore.length() == 0) {
            mqStore = "./SonicMQStore";
        }
        return mqStore;
    }

    private void checkDSComponent(IElementIdentity compID, IDirElement container, boolean rootContainer) throws Exception {
        IElementIdentity containerID = container.getIdentity();
        String containerName = containerID.getNameComponents()[containerID.getNameComponents().length - 1];
        HashMap containerProps = this.getContainerProps(containerName);
        IDirElement dsEl = this.m_fileSystemService.getFSElement(compID.getName(), false);
        String hostDir = (String)dsEl.getAttributes().getAttribute("HOST_DIRECTORY");
        String domainName = this.m_migrateProps.getProperty("ds.domain");
        if (rootContainer) {
            containerProps.put("ds.element.name", compID.getName());
            this.m_migrateProps.put("dm.ds.element", dsEl);
            File hostDirFile = this.populateHostFile(compID, containerName, containerProps, domainName, hostDir);
            File newDSStorageFile = this.retrieveDSStorageFile(compID, containerName, containerProps, hostDirFile);
            this.populateDomainDir(hostDirFile, newDSStorageFile);
        }
    }

    private File populateHostFile(IElementIdentity compID, String containerName, HashMap containerProps, String domainName, String hostDirParam) throws Exception {
        File hostDirFile;
        String hostDir = hostDirParam;
        if (hostDir == null || hostDir.length() == 0) {
            hostDir = ".";
        }
        if (!(hostDirFile = new File(hostDir)).isAbsolute()) {
            String prevWD = this.checkWD(containerProps, containerName);
            hostDirFile = new File(prevWD, hostDir);
        }
        if (!this.willMigrate(compID.getReleaseVersion())) {
            this.checkLaunchContainer(containerProps, containerName);
        }
        this.debug("checkDSComponent setting DSHOSTSRCPROP to " + hostDirFile.getCanonicalPath());
        if (!new File(hostDirFile, domainName).exists()) {
            throw new MigrationException("The directory service storage cannot be found in " + hostDirFile.getCanonicalPath());
        }
        this.m_migrateProps.put("host.directory.src", hostDirFile.getCanonicalPath());
        return hostDirFile;
    }

    private void populateDomainDir(File hostDirFile, File newDSStorageFile) throws MigrationException, IOException {
        File newDomainDir = new File(newDSStorageFile, this.m_migrateProps.getProperty("ds.domain"));
        if (!hostDirFile.equals(newDSStorageFile) && newDomainDir.exists() && newDomainDir.list().length > 0) {
            throw new MigrationException("There are files in the new storage area " + newDomainDir.getCanonicalPath() + " for the directory service. Remove these files and restart the upgrade.");
        }
    }

    private File retrieveDSStorageFile(IElementIdentity compID, String containerName, HashMap containerProps, File hostDirFile) throws MigrationException, IOException {
        File newDSStorageFile = null;
        if (this.willMigrate(compID.getReleaseVersion())) {
            newDSStorageFile = this.checkNewDSHostProp(containerProps, containerName);
        }
        if (newDSStorageFile == null) {
            this.debug("checkDSComponent setting DSHOSTPROP to " + hostDirFile.getCanonicalPath());
            this.m_migrateProps.put("ds.working.dir", hostDirFile.getCanonicalPath());
            newDSStorageFile = hostDirFile;
        }
        return newDSStorageFile;
    }

    private void checkBackupDSComponent(IElementIdentity compID, IElementIdentity containerID) throws Exception {
        String containerName = containerID.getNameComponents()[containerID.getNameComponents().length - 1];
        HashMap containerProps = this.getContainerProps(containerName);
        containerProps.put("ds.element.name", compID.getName());
        if (this.m_DMElement != null) {
            String urls = (String)((IAttributeSet)this.m_DMElement.getAttributes().getAttribute("CONNECTION")).getAttribute("ConnectionURLs");
            this.m_migrateProps.put("mgmt.connection.urls", urls);
            this.m_migrateProps.put("backup.ds.container", containerName);
        }
    }

    private void addRestartContainersList(Properties seedingProps) {
        int restartSize = this.m_restartContainers.size();
        String restartString = "";
        if (this.m_restartDM || restartSize > 0) {
            if (this.m_restartDM) {
                restartString = restartString + this.m_DMElement.getIdentity().getName() + ",";
                HashMap dmProps = this.getContainerProps((String)this.m_DMElement.getAttributes().getAttribute("CONTAINER_NAME"));
                String windowsService = (String)dmProps.get("windows.service.name");
                restartString = windowsService != null ? restartString + "SERVICE" : restartString + "COMMANDLINE";
            }
            if (restartSize > 0) {
                for (String id : this.m_restartContainers.keySet()) {
                    String method;
                    if (restartString.length() > 0) {
                        restartString = restartString + ";";
                    }
                    if ((method = this.m_restartContainers.get(id)).startsWith("ERROR")) continue;
                    restartString = restartString + id + "," + method;
                }
            }
            seedingProps.put("restart.containers", restartString);
            String mgmtUrls = null;
            if (this.m_restartDM && (mgmtUrls = this.m_migrateProps.getProperty("mgmt.connection.urls")) != null) {
                String backupDSContainer;
                IAttributeSet connectionProps = (IAttributeSet)this.m_DMElement.getAttributes().getAttribute("CONNECTION");
                String username = null;
                String password = null;
                String node = null;
                String domain = null;
                String conProps = null;
                if (connectionProps != null) {
                    username = (String)connectionProps.getAttribute("DefaultUser");
                    if (username == null || username.length() == 0) {
                        username = "Administrator";
                    }
                    password = (String)connectionProps.getAttribute("DefaultPassword");
                    node = (String)connectionProps.getAttribute("MANAGEMENT_NODE");
                    domain = this.m_migrateProps.getProperty("ds.domain");
                    conProps = this.m_migrateProps.getProperty("connection.system.properties");
                }
                seedingProps.put("mgmt.connection.urls", mgmtUrls);
                if (username != null) {
                    seedingProps.put("ds.username", username);
                }
                if (password != null) {
                    seedingProps.put("ds.password", password);
                }
                if (node != null) {
                    seedingProps.put("connection_node", node);
                }
                seedingProps.put("ds.domain", domain);
                if (conProps != null) {
                    seedingProps.put("connection.system.properties", conProps);
                }
                if ((backupDSContainer = this.m_migrateProps.getProperty("backup.ds.container")) != null) {
                    seedingProps.put("backup.ds.container", backupDSContainer);
                }
            }
        }
    }

    private void checkInstallProperties() throws MigrationException, FileNotFoundException, IOException {
        File sonicHome = new File(this.m_sonicHome);
        File sonicswPropertiesFile = new File(sonicHome, "sonicsw.properties");
        if (!sonicswPropertiesFile.exists()) {
            throw new MigrationException("Could not find the sonicsw.properties files required to create shortcuts. Something went wrong during the installation.");
        }
        FileInputStream propsStream = new FileInputStream(sonicswPropertiesFile);
        SONICSW_PROPS.load(propsStream);
        propsStream.close();
        if (this.m_wbLocation != null) {
            String wbInstalled = SONICSW_PROPS.getProperty("sonic.wb.installed");
            if (wbInstalled == null || !wbInstalled.equals("true")) {
                throw new MigrationException("The workbench location argument cannot be used if a workbench has not been installed. Remove the argument and try again.");
            }
            String eclipseInstalled = SONICSW_PROPS.getProperty("sonic.iw.14.0.eclipse.choice");
            if (eclipseInstalled == null || !eclipseInstalled.equals("NEW")) {
                throw new MigrationException("The workbench location argument cannot be used if eclipse is not installed with the workbench. Remove the argument and try again.");
            }
        }
    }

    private File checkNewDSHostProp(HashMap containerProps, String containerName) throws MigrationException, IOException {
        String domainName = this.m_migrateProps.getProperty("ds.domain");
        File containers = ContainerSetup.findSonicContainersDir((File)new File(this.m_sonicHome));
        File containerDir = ContainerSetup.findContainerDir((File)containers, (String)domainName, (String)containerName);
        File destinationDir = null;
        String enteredDSHost = (String)containerProps.get("host.directory");
        File enteredDir = null;
        if (enteredDSHost != null) {
            enteredDir = new File(enteredDSHost);
            destinationDir = enteredDir.isAbsolute() ? enteredDir : new File(containerDir, enteredDSHost);
            this.checkDirectory(destinationDir, containerName + "." + "ds.working.dir");
            this.debug("checkNewDSHostProp setting DSHOSTPROP to " + destinationDir.getCanonicalPath());
            this.m_migrateProps.put("ds.working.dir", destinationDir.getCanonicalPath());
            return destinationDir;
        }
        return null;
    }

    private void checkDirectory(File destinationDir, String propertyName) throws MigrationException, IOException {
        if (destinationDir == null) {
            return;
        }
        if (destinationDir.exists()) {
            if (destinationDir.isFile()) {
                throw new MigrationException(destinationDir.getCanonicalPath() + " is an existing file and cannot be used as a directory for " + propertyName);
            }
            if (!destinationDir.canWrite()) {
                throw new MigrationException("The upgrade is not able to write to the directory " + destinationDir.getCanonicalPath() + " specified in " + propertyName + ".");
            }
        } else {
            if (destinationDir.getParentFile() == null) {
                throw new MigrationException("Drive accessed by " + destinationDir + " does not exist");
            }
            this.checkDirectory(destinationDir.getParentFile(), propertyName);
        }
    }

    private boolean willMigrate(String releaseVersion) {
        return releaseVersion.compareTo("104") < 0;
    }

    private void recycleContainer(String containerID) throws Exception {
        String cName = this.getContainerName(containerID);
        String cObjectName = this.getAgentObjectName(cName);
        if (this.pingContainer(cObjectName)) {
            System.out.println("upgrade restarting " + cObjectName + "...");
            this.m_ds.restartContainer(cObjectName, this.getAMObjectName(cName));
            System.out.println("upgrade restarting " + cObjectName + "...done");
        }
    }
}

