/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.logging.Logger;

public class LockFile {
    private final File m_lockFile;
    private RandomAccessFile m_raf;
    private FileLock m_fileLock;
    private static final Logger log = Logger.getLogger(LockFile.class.getName());

    public LockFile(String path) {
        this.m_lockFile = new File(path);
    }

    public synchronized boolean lock() {
        if (this.m_raf != null) {
            return true;
        }
        try {
            this.m_raf = new RandomAccessFile(this.m_lockFile, "rw");
            this.m_fileLock = this.m_raf.getChannel().tryLock();
            boolean bl = this.m_fileLock != null;
            return bl;
        }
        catch (IOException | OverlappingFileLockException e) {
            log.warning("Unable to lock file: " + this.m_lockFile.getAbsolutePath());
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.m_fileLock == null) {
                this.cleanup();
            }
        }
    }

    public synchronized void unlock() {
        try {
            this.cleanup();
        }
        finally {
            this.m_lockFile.delete();
        }
    }

    private void cleanup() {
        try {
            if (this.m_fileLock != null) {
                this.m_fileLock.release();
            }
        }
        catch (IOException e) {
            log.warning("Unable to release lock: " + this.m_lockFile.getAbsolutePath());
        }
        finally {
            try {
                if (this.m_raf != null) {
                    this.m_raf.close();
                    this.m_raf = null;
                }
            }
            catch (IOException iOException) {}
            this.m_fileLock = null;
        }
    }
}

