/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.xml;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IAttributeSetType;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.xml.ByteStringConverter;
import com.sonicsw.mf.common.xml.XMLStringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

public class ElementBuilder {
    IDirElement m_configElement = null;
    XMLStringWriter m_xmlWriter = null;
    IDirectoryAdminService m_dirService = null;
    String m_elmntName = null;
    String m_domainName = null;
    boolean isDSRequired = false;

    public ElementBuilder(String elmntName, XMLStringWriter writer) {
        this.m_elmntName = elmntName;
        this.m_xmlWriter = writer;
        this.isDSRequired = true;
    }

    public ElementBuilder(IDirElement configElement, XMLStringWriter writer) {
        this.m_configElement = configElement;
        this.m_xmlWriter = writer;
        this.isDSRequired = true;
    }

    public ElementBuilder(IElement element, String domainName) {
        this.m_configElement = (IDirElement)element;
        this.m_domainName = domainName;
    }

    public static String exportElement(IElement element, String domainName) throws DirectoryServiceException {
        ElementBuilder elementBuilder = new ElementBuilder(element, domainName);
        elementBuilder.init();
        return elementBuilder.getXMLString();
    }

    public void setDirectoryService(IDirectoryAdminService dirService) {
        this.m_dirService = dirService;
    }

    private void checkDSElement() throws DirectoryServiceException {
        String hostDir;
        if (this.m_configElement != null && (this.m_configElement.getIdentity().getType().equals("MF_DIRECTORY_SERVICE") || this.m_configElement.getIdentity().getType().equals("MF_BACKUP_DIRECTORY_SERVICE")) && ((hostDir = (String)this.m_configElement.getAttributes().getAttribute("HOST_DIRECTORY")) == null || hostDir.length() == 0)) {
            this.m_configElement = (IDirElement)this.m_configElement.createWritableClone();
            try {
                this.m_configElement.getAttributes().setStringAttribute("HOST_DIRECTORY", ".");
            }
            catch (ConfigException e) {
                throw new DirectoryServiceException(e.toString(), e);
            }
        }
    }

    public void init() throws DirectoryServiceException {
        if (this.isDSRequired) {
            if (this.m_dirService == null) {
                return;
            }
            if (this.m_configElement == null) {
                this.m_configElement = this.m_dirService.getElement(this.m_elmntName, false);
            }
            this.m_domainName = this.m_dirService.getDomain();
        }
        this.checkDSElement();
        if (this.m_xmlWriter != null) {
            this.createConfigElement();
        } else {
            this.m_xmlWriter = new XMLStringWriter();
            this.m_xmlWriter.setProcInstruction("1.0", "UTF-8");
            this.createDomainElement();
        }
    }

    public String getXMLString() {
        return this.m_xmlWriter.getXMLString().toString();
    }

    private void createDomainElement() {
        HashMap<String, String> attrPair = new HashMap<String, String>();
        attrPair.put("xmlns", "http://www.sonicsw.com/mf");
        attrPair.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        attrPair.put("xsi:schemaLocation", "http://www.sonicsw.com/mf MFConfigurationElements.xsd");
        attrPair.put("name", this.m_domainName);
        this.m_xmlWriter.startElement("Domain", attrPair, false);
        this.createConfigElement();
        this.m_xmlWriter.endElement("Domain");
    }

    private void createConfigElement() {
        this.m_xmlWriter.setTabCounter();
        this.m_xmlWriter.startElement("ConfigElement", null, false);
        this.createElementID();
        this.processConfigElemAttribs();
        this.m_xmlWriter.endElement("ConfigElement");
        this.m_xmlWriter.resetTabCounter();
    }

    private void createElementID() {
        this.m_xmlWriter.setTabCounter();
        HashMap<String, Object> attrPair = new HashMap<String, Object>();
        IElementIdentity identity = this.m_configElement.getIdentity();
        attrPair.put("name", identity.getName());
        attrPair.put("version", new Long(identity.getVersion()));
        attrPair.put("releaseVersion", identity.getReleaseVersion());
        attrPair.put("creationTimestamp", new Long(identity.getCreationTimestamp()));
        String type = identity.getType();
        if (type != null) {
            attrPair.put("type", type);
        }
        this.m_xmlWriter.startElement("ElementID", attrPair, true);
        this.m_xmlWriter.endElement(null);
        this.m_xmlWriter.resetTabCounter();
    }

    private void processConfigElemAttribs() {
        IAttributeSet elementAttributes = this.m_configElement.getAttributes();
        this.m_xmlWriter.setTabCounter();
        this.addAttributeSetElement(null, null, elementAttributes);
        this.traverse(elementAttributes.getAttributes());
        this.m_xmlWriter.endElement("AttributeSet");
        this.m_xmlWriter.resetTabCounter();
    }

    private void traverse(Object collection) {
        Object item = null;
        String name2 = null;
        Object type = null;
        this.m_xmlWriter.setTabCounter();
        if (collection instanceof HashMap) {
            Set set = ((HashMap)collection).keySet();
            for (String name2 : set) {
                item = ((HashMap)collection).get(name2);
                this.traverseItems(item, name2);
            }
        } else if (collection instanceof ArrayList) {
            for (int i = 0; i < ((ArrayList)collection).size(); ++i) {
                item = ((ArrayList)collection).get(i);
                this.traverseItems(item, name2);
            }
        }
        this.m_xmlWriter.resetTabCounter();
    }

    private void traverseItems(Object item, String name) {
        if (item instanceof IAttributeSet) {
            this.addAttributeSetElement(name, ((IAttributeSet)item).getTypeName(), item);
            this.traverse(((IAttributeSet)item).getAttributes());
            this.m_xmlWriter.endElement("AttributeSet");
        } else if (item instanceof IAttributeList) {
            this.addAttributeListElement(name, item);
            this.traverse(((IAttributeList)item).getItems());
            this.m_xmlWriter.endElement("AttributeList");
        } else {
            this.processJavaPrimitives(item, name);
        }
    }

    private void processJavaPrimitives(Object attr, String name) {
        HashMap attrPair = new HashMap();
        if (attr instanceof String) {
            this.addJavaObject(name, (String)attr, "string");
        } else if (attr instanceof Integer) {
            this.addJavaObject(name, ((Integer)attr).toString(), "integer");
        } else if (attr instanceof Long) {
            this.addJavaObject(name, ((Long)attr).toString(), "long");
        } else if (attr instanceof Boolean) {
            this.addJavaObject(name, ((Boolean)attr).toString(), "boolean");
        } else if (attr instanceof Date) {
            this.addJavaObject(name, ((Date)attr).toString(), "date");
        } else if (attr instanceof BigDecimal) {
            this.addJavaObject(name, ((BigDecimal)attr).toString(), "bigdecimal");
        } else if (attr instanceof Reference) {
            this.addJavaObject(name, ((Reference)attr).getElementName(), "reference");
        } else if (attr instanceof byte[]) {
            String encodedString = ByteStringConverter.getStringFromBytes((byte[])attr);
            this.addJavaObject(name, encodedString, "bytes");
        }
    }

    private void addAttributeSetElement(String name, String Type2, Object item) {
        HashMap<String, String> attrPair = null;
        if (Type2 != null) {
            attrPair = new HashMap<String, String>();
            attrPair.put("type", Type2);
        }
        this.m_xmlWriter.startElement("AttributeSet", attrPair, false);
        this.addNameToElement(name);
        String[] types = ((IAttributeSet)item).getAllTypeNames();
        for (int i = 0; i < types.length; ++i) {
            this.addAttributeSetType(((IAttributeSet)item).getAttributeSetType(types[i]), types[i]);
        }
    }

    private void addAttributeListElement(String name, Object item) {
        this.m_xmlWriter.startElement("AttributeList", null, false);
        this.addNameToElement(name);
        String[] types = ((IAttributeList)item).getAllTypeNames();
        for (int i = 0; i < types.length; ++i) {
            this.addAttributeSetType(((IAttributeList)item).getAttributeSetType(types[i]), types[i]);
        }
    }

    private void addNameToElement(String name) {
        if (name != null) {
            this.addAttributeNameElement(name);
        }
    }

    private void addAttributeSetType(Object setType, String name) {
        HashMap<String, String> attrPair = null;
        if (name != null) {
            attrPair = new HashMap<String, String>();
            attrPair.put("name", name);
        }
        this.m_xmlWriter.setTabCounter();
        this.m_xmlWriter.startElement("AttributeSetType", attrPair, false);
        String[] attrList = ((IAttributeSetType)setType).getAttributeNames();
        for (int i = 0; i < attrList.length; ++i) {
            this.addAttributeNameElement(attrList[i]);
        }
        this.m_xmlWriter.endElement("AttributeSetType");
        this.m_xmlWriter.resetTabCounter();
    }

    private void addAttributeNameElement(String Name2) {
        this.m_xmlWriter.setTabCounter();
        HashMap<String, String> attrPair = new HashMap<String, String>();
        attrPair.put("name", Name2);
        this.m_xmlWriter.startElement("AttributeName", attrPair, true);
        this.m_xmlWriter.endElement(null);
        this.m_xmlWriter.resetTabCounter();
    }

    private void addJavaObject(String name, String value, String type) {
        String elementName;
        boolean emptyTag = true;
        String markupValue = null;
        HashMap<String, String> attrPair = new HashMap<String, String>();
        if (name != null) {
            attrPair.put("name", name);
            elementName = "Attribute";
        } else {
            elementName = "ListItem";
        }
        if (type.equalsIgnoreCase("string") && this.m_xmlWriter.isMarkup(value)) {
            markupValue = value;
            attrPair.put("type", type);
            emptyTag = false;
        } else {
            attrPair.put("value", value);
            attrPair.put("type", type);
        }
        this.m_xmlWriter.startElement(elementName, attrPair, emptyTag);
        if (!emptyTag) {
            this.m_xmlWriter.createCDATA(markupValue);
            this.m_xmlWriter.endElement(elementName);
        } else {
            this.m_xmlWriter.endElement(null);
        }
    }
}

