/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.jmx.client;

import com.sonicsw.mf.comm.INotificationListener;
import com.sonicsw.mf.comm.jms.ConnectorClient;
import com.sonicsw.mf.comm.jms.DurableConnector;
import com.sonicsw.mf.common.IConsumer;
import com.sonicsw.mf.common.runtime.INotification;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public final class NotificationListenerDelegate
implements INotificationListener,
NotificationListener,
Serializable {
    private static final long serialVersionUID = 8484344976480223320L;
    private static final short m_serialVersion = 0;
    private ConnectorClient m_connector;
    private NotificationListener m_listener;
    private IConsumer m_consumer;
    public String m_destination;
    public int m_listenerHash;
    private long m_notificationSubscriptionTimeout = DurableConnector.DURABLE_SUBSCRIPTION_TTL;
    private HashMap m_LocalToRemoteHandbacks = new HashMap();
    private HashMap m_filterToRemoteHandbacks = new HashMap();

    public NotificationListenerDelegate() {
    }

    NotificationListenerDelegate(ConnectorClient connector, NotificationListener listener) {
        this.m_connector = connector;
        this.m_listener = listener;
        this.m_consumer = this.m_connector.addDirectedNotificationListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String addSubscription(NotificationFilter filter, Object handback) {
        String remoteHandback = null;
        HashMap hashMap = this.m_filterToRemoteHandbacks;
        synchronized (hashMap) {
            ArrayList<String> remoteHandbacks;
            remoteHandback = (String)this.m_LocalToRemoteHandbacks.get(handback);
            if (remoteHandback == null) {
                remoteHandback = new VMID().toString();
                this.m_LocalToRemoteHandbacks.put(handback, remoteHandback);
            }
            if ((remoteHandbacks = (ArrayList<String>)this.m_filterToRemoteHandbacks.get(filter)) == null) {
                remoteHandbacks = new ArrayList<String>();
                this.m_filterToRemoteHandbacks.put(filter, remoteHandbacks);
            }
            if (!remoteHandbacks.contains(remoteHandback)) {
                remoteHandbacks.add(remoteHandback);
            }
        }
        return remoteHandback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String removeSubscription(NotificationFilter filter, Object handback) {
        String remoteHandback = null;
        HashMap hashMap = this.m_filterToRemoteHandbacks;
        synchronized (hashMap) {
            Object remoteHandbacks;
            remoteHandback = (String)this.m_LocalToRemoteHandbacks.get(handback);
            if (remoteHandback == null) {
                return null;
            }
            int handbackUsageCount = 0;
            Iterator iterator = this.m_filterToRemoteHandbacks.values().iterator();
            while (iterator.hasNext()) {
                remoteHandbacks = ((ArrayList)iterator.next()).iterator();
                while (remoteHandbacks.hasNext()) {
                    if (remoteHandbacks.next().equals(remoteHandback)) {
                        ++handbackUsageCount;
                    }
                    if (handbackUsageCount <= 1) continue;
                }
                if (handbackUsageCount <= true) continue;
                break;
            }
            if ((remoteHandbacks = (ArrayList)this.m_filterToRemoteHandbacks.get(filter)) == null) {
                return null;
            }
            ((ArrayList)remoteHandbacks).remove(remoteHandback);
            if (((ArrayList)remoteHandbacks).isEmpty()) {
                this.m_filterToRemoteHandbacks.remove(filter);
            }
            if (handbackUsageCount == 1) {
                this.m_LocalToRemoteHandbacks.remove(handback);
            }
        }
        return remoteHandback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList getSubscriptionRenewalPairs() {
        ArrayList<Object[]> subscriptionRenewalPairs = new ArrayList<Object[]>();
        HashMap hashMap = this.m_filterToRemoteHandbacks;
        synchronized (hashMap) {
            for (Map.Entry entry : this.m_filterToRemoteHandbacks.entrySet()) {
                NotificationFilter filter = (NotificationFilter)entry.getKey();
                Iterator remoteHandbacks = ((ArrayList)entry.getValue()).iterator();
                while (remoteHandbacks.hasNext()) {
                    subscriptionRenewalPairs.add(new Object[]{filter, remoteHandbacks.next()});
                }
            }
        }
        return subscriptionRenewalPairs;
    }

    public void setNotificationSubscriptionTimeout(long timeout) {
        this.m_notificationSubscriptionTimeout = timeout;
    }

    public long getNotificationSubscriptionTimeout() {
        return this.m_notificationSubscriptionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object handbackParam) {
        char[] chars;
        Object handback = handbackParam;
        Object remoteHandback = null;
        Object localHandback = null;
        if (handback instanceof String && ((String)handback).charAt(0) == '\b' && ((String)handback).charAt(1) == '\b' && (chars = ((String)handback).toCharArray()).length > 4 && chars[chars.length - 1] != '\b') {
            int i;
            for (i = 3; i < chars.length && chars[i] != '\b'; ++i) {
            }
            if (chars[i] == '\b') {
                handback = String.valueOf(chars, ++i, chars.length - i);
            }
        }
        HashMap hashMap = this.m_filterToRemoteHandbacks;
        synchronized (hashMap) {
            for (Map.Entry entry : this.m_LocalToRemoteHandbacks.entrySet()) {
                if (!entry.getValue().equals(handback)) continue;
                remoteHandback = entry.getValue();
                localHandback = entry.getKey();
                break;
            }
        }
        if (remoteHandback != null) {
            this.m_listener.handleNotification(notification, localHandback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.m_filterToRemoteHandbacks != null) {
            HashMap hashMap = this.m_filterToRemoteHandbacks;
            synchronized (hashMap) {
                this.m_LocalToRemoteHandbacks.clear();
                this.m_filterToRemoteHandbacks.clear();
            }
        }
        this.m_consumer.close();
    }

    @Override
    public String getListenerType() {
        return "jmx";
    }

    @Override
    public void handleNotification(INotification notification, Object handback) {
        this.handleNotification((Notification)((Object)notification), handback);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(4);
        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(0));
        stream.writeUTF("destination");
        if (this.m_destination != null) {
            stream.writeObject(this.m_destination);
        } else {
            stream.writeObject(this.m_connector.getReplyTo());
        }
        stream.writeUTF("listenerHash");
        stream.writeObject(new Integer(this.m_listenerHash == 0 ? this.hashCode() : this.m_listenerHash));
        stream.writeUTF("notificationSubscriptionTimeout");
        stream.writeObject(new Long(this.m_notificationSubscriptionTimeout));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int count = stream.readInt();
        HashMap<String, Object> map = new HashMap<String, Object>(count);
        for (int i = 0; i < count; ++i) {
            String key = stream.readUTF();
            Object value = stream.readObject();
            map.put(key, value);
        }
        short serialVersion = (Short)map.get("serialVersion");
        switch (serialVersion) {
            default: 
        }
        try {
            this.m_destination = (String)map.get("destination");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_listenerHash = (Integer)map.get("listenerHash");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_notificationSubscriptionTimeout = (Long)map.get("notificationSubscriptionTimeout");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

